/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (uvec2(38u, 35u) != uvec2(38u, 35u)) => false
 * (uvec2(38u, 35u) != uvec2(64u, 9u)) => true
 * (uvec2(64u, 9u) != uvec2(38u, 35u)) => true
 * (uvec2(64u, 9u) != uvec2(64u, 9u)) => false
 */
#version 130

void main()
{
  float[(uvec2(38u, 35u) != uvec2(38u, 35u)) == false ? 1 : -1] array0;
  float[(uvec2(38u, 35u) != uvec2(64u, 9u)) == true ? 1 : -1] array1;
  float[(uvec2(64u, 9u) != uvec2(38u, 35u)) == true ? 1 : -1] array2;
  float[(uvec2(64u, 9u) != uvec2(64u, 9u)) == false ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
