/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.profile;

import dotty.tools.dotc.profile.ExtendedThreadMxBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;

class SunThreadMxBean
extends ExtendedThreadMxBean {
    private final ThreadMXBean real;
    private final Method getThreadUserTimeMethod;
    private final Method isThreadAllocatedMemoryEnabledMethod;
    private final Method setThreadAllocatedMemoryEnabledMethod;
    private final Method getThreadAllocatedBytesMethod1;
    private final Method getThreadAllocatedBytesMethod2;
    private final Method isThreadAllocatedMemorySupportedMethod;
    private final Method getThreadCpuTimeMethod;

    public SunThreadMxBean(ThreadMXBean threadMXBean) {
        super(threadMXBean);
        this.real = threadMXBean;
        try {
            Class<?> clazz = Class.forName("com.sun.management.ThreadMXBean");
            this.getThreadUserTimeMethod = clazz.getMethod("getThreadUserTime", long[].class);
            this.isThreadAllocatedMemoryEnabledMethod = clazz.getMethod("isThreadAllocatedMemoryEnabled", new Class[0]);
            this.setThreadAllocatedMemoryEnabledMethod = clazz.getMethod("setThreadAllocatedMemoryEnabled", Boolean.TYPE);
            this.getThreadAllocatedBytesMethod1 = clazz.getMethod("getThreadAllocatedBytes", Long.TYPE);
            this.getThreadAllocatedBytesMethod2 = clazz.getMethod("getThreadAllocatedBytes", long[].class);
            this.isThreadAllocatedMemorySupportedMethod = clazz.getMethod("isThreadAllocatedMemorySupported", new Class[0]);
            this.getThreadCpuTimeMethod = clazz.getMethod("getThreadCpuTime", long[].class);
            this.getThreadUserTimeMethod.setAccessible(true);
            this.isThreadAllocatedMemoryEnabledMethod.setAccessible(true);
            this.setThreadAllocatedMemoryEnabledMethod.setAccessible(true);
            this.getThreadAllocatedBytesMethod1.setAccessible(true);
            this.getThreadAllocatedBytesMethod2.setAccessible(true);
            this.isThreadAllocatedMemorySupportedMethod.setAccessible(true);
            this.getThreadCpuTimeMethod.setAccessible(true);
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    public boolean isExtended() {
        return true;
    }

    @Override
    public long[] getThreadUserTime(long[] lArray) throws Exception {
        return (long[])this.getThreadUserTimeMethod.invoke((Object)this.real, new Object[]{lArray});
    }

    @Override
    public boolean isThreadAllocatedMemoryEnabled() throws Exception {
        return (Boolean)this.isThreadAllocatedMemoryEnabledMethod.invoke((Object)this.real, new Object[0]);
    }

    @Override
    public void setThreadAllocatedMemoryEnabled(boolean bl) throws Exception {
        this.setThreadAllocatedMemoryEnabledMethod.invoke((Object)this.real, bl);
    }

    @Override
    public long getThreadAllocatedBytes(long l) throws Exception {
        return (Long)this.getThreadAllocatedBytesMethod1.invoke((Object)this.real, l);
    }

    @Override
    public long[] getThreadAllocatedBytes(long[] lArray) throws Exception {
        return (long[])this.getThreadAllocatedBytesMethod2.invoke((Object)this.real, new Object[]{lArray});
    }

    @Override
    public boolean isThreadAllocatedMemorySupported() throws Exception {
        return (Boolean)this.isThreadAllocatedMemorySupportedMethod.invoke((Object)this.real, new Object[0]);
    }

    @Override
    public long[] getThreadCpuTime(long[] lArray) throws Exception {
        return (long[])this.getThreadCpuTimeMethod.invoke((Object)this.real, new Object[]{lArray});
    }
}

