/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.lucene.index.QueryTimeout;
import org.apache.solr.common.SolrException;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.CpuAllowedLimit;
import org.apache.solr.search.MemAllowedLimit;
import org.apache.solr.search.QueryLimit;
import org.apache.solr.search.QueryLimitsExceededException;
import org.apache.solr.search.TimeAllowedLimit;
import org.apache.solr.util.TestInjection;

public class QueryLimits
implements QueryTimeout {
    public static final String UNLIMITED = "This request is unlimited.";
    private final List<QueryLimit> limits = new ArrayList<QueryLimit>(3);
    public static QueryLimits NONE = new QueryLimits();
    private final SolrQueryResponse rsp;
    private final boolean allowPartialResults;
    private volatile boolean limitsTripped = false;

    private QueryLimits() {
        this(null, null);
    }

    public QueryLimits(SolrQueryRequest req, SolrQueryResponse rsp) {
        this.rsp = rsp;
        boolean bl = this.allowPartialResults = req == null || SolrQueryRequest.allowPartialResults(req.getParams());
        if (req != null) {
            if (TimeAllowedLimit.hasTimeLimit(req)) {
                this.limits.add(new TimeAllowedLimit(req));
            }
            if (CpuAllowedLimit.hasCpuLimit(req)) {
                this.limits.add(new CpuAllowedLimit(req));
            }
            if (MemAllowedLimit.hasMemLimit(req)) {
                this.limits.add(new MemAllowedLimit(req));
            }
        }
        if (TestInjection.queryTimeout != null) {
            this.limits.add(TestInjection.queryTimeout);
        }
    }

    public boolean shouldExit() {
        if (this.limitsTripped) {
            return true;
        }
        for (QueryTimeout queryTimeout : this.limits) {
            if (!queryTimeout.shouldExit()) continue;
            this.limitsTripped = true;
            break;
        }
        return this.limitsTripped;
    }

    public String formatExceptionMessage(String label) {
        return "Limits exceeded!" + (String)(label != null ? " (" + label + ")" : "") + ": " + this.limitStatusMessage();
    }

    public boolean maybeExitWithPartialResults(Supplier<String> label) throws QueryLimitsExceededException {
        if (this.isLimitsEnabled() && this.shouldExit()) {
            if (this.allowPartialResults) {
                if (this.rsp != null) {
                    SolrRequestInfo requestInfo = SolrRequestInfo.getRequestInfo();
                    if (requestInfo == null) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No request active, but attempting to exit with partial results?");
                    }
                    this.rsp.setPartialResults(requestInfo.getReq());
                    if (this.rsp.getResponseHeader().get("partialResultsDetails") == null) {
                        this.rsp.addPartialResponseDetail(this.formatExceptionMessage(label.get()));
                    }
                }
                return true;
            }
            throw new QueryLimitsExceededException(this.formatExceptionMessage(label.get()));
        }
        return false;
    }

    public boolean maybeExitWithPartialResults(String label) throws QueryLimitsExceededException {
        return this.maybeExitWithPartialResults(() -> label);
    }

    public String limitStatusMessage() {
        if (this.limits.isEmpty()) {
            return UNLIMITED;
        }
        StringBuilder sb = new StringBuilder("Query limits: ");
        for (QueryTimeout queryTimeout : this.limits) {
            sb.append("[");
            sb.append(queryTimeout.getClass().getSimpleName());
            sb.append(":");
            sb.append(queryTimeout.shouldExit() ? "LIMIT EXCEEDED" : "within limit");
            sb.append("]");
        }
        return sb.toString();
    }

    public Optional<Object> currentLimitValueFor(Class<? extends QueryLimit> limitClass) {
        for (QueryLimit limit : this.limits) {
            if (!limit.getClass().isAssignableFrom(limitClass)) continue;
            return Optional.of(limit.currentValue());
        }
        return Optional.empty();
    }

    public boolean isLimitsEnabled() {
        return !this.limits.isEmpty();
    }

    public static QueryLimits getCurrentLimits() {
        SolrRequestInfo info = SolrRequestInfo.getRequestInfo();
        return info != null ? info.getLimits() : NONE;
    }
}

