/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature;

import java.util.Optional;
import org.apache.sis.feature.AbstractAttribute;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.Features;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.util.Static;
import org.apache.sis.util.iso.Names;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.GenericName;
import org.opengis.util.LocalName;
import org.opengis.util.ScopedName;

public final class AttributeConvention
extends Static {
    private static final LocalName SCOPE = Names.createLocalName("Apache", null, "sis");
    public static final ScopedName IDENTIFIER_PROPERTY = Names.createScopedName((GenericName)SCOPE, null, "identifier");
    public static final ScopedName GEOMETRY_PROPERTY = Names.createScopedName((GenericName)SCOPE, null, "geometry");
    public static final ScopedName ENVELOPE_PROPERTY = Names.createScopedName((GenericName)SCOPE, null, "envelope");
    public static final ScopedName CRS_CHARACTERISTIC = Names.createScopedName((GenericName)SCOPE, null, "crs");
    public static final ScopedName UNIT_CHARACTERISTIC = Names.createScopedName((GenericName)SCOPE, null, "unit");
    public static final ScopedName MAXIMAL_LENGTH_CHARACTERISTIC = Names.createScopedName((GenericName)SCOPE, null, "maximalLength");
    public static final GenericName VALID_VALUES_CHARACTERISTIC = Names.createScopedName((GenericName)SCOPE, null, "validValues");
    public static final String IDENTIFIER = "sis:identifier";
    public static final String GEOMETRY = "sis:geometry";
    public static final String ENVELOPE = "sis:envelope";
    public static final String CRS = "sis:crs";
    public static final String UNIT = "sis:unit";
    public static final String MAXIMAL_LENGTH = "sis:maximalLength";

    private AttributeConvention() {
    }

    public static boolean contains(GenericName genericName) {
        while (genericName instanceof ScopedName) {
            if (SCOPE.equals((Object)((ScopedName)genericName).path())) {
                return true;
            }
            genericName = ((ScopedName)genericName).tail();
        }
        return false;
    }

    public static boolean hasIdentifier(DefaultFeatureType defaultFeatureType) {
        if (defaultFeatureType != null) {
            try {
                return defaultFeatureType.getProperty(IDENTIFIER) != null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isGeometryAttribute(AbstractIdentifiedType abstractIdentifiedType) {
        Optional<DefaultAttributeType<?>> optional = Features.toAttribute(abstractIdentifiedType);
        return optional.isPresent() && Geometries.isKnownType(optional.get().getValueClass());
    }

    public static boolean characterizedByCRS(AbstractIdentifiedType abstractIdentifiedType) {
        return AttributeConvention.hasCharacteristic(abstractIdentifiedType, CRS, CoordinateReferenceSystem.class);
    }

    public static CoordinateReferenceSystem getCRSCharacteristic(Object object) {
        return (CoordinateReferenceSystem)AttributeConvention.getCharacteristic(object, CRS);
    }

    public static CoordinateReferenceSystem getCRSCharacteristic(DefaultFeatureType defaultFeatureType, AbstractIdentifiedType abstractIdentifiedType) {
        return (CoordinateReferenceSystem)AttributeConvention.getCharacteristic(defaultFeatureType, abstractIdentifiedType, CRS);
    }

    public static boolean characterizedByMaximalLength(AbstractIdentifiedType abstractIdentifiedType) {
        return AttributeConvention.hasCharacteristic(abstractIdentifiedType, MAXIMAL_LENGTH, Integer.class);
    }

    public static Integer getMaximalLengthCharacteristic(Object object) {
        return (Integer)AttributeConvention.getCharacteristic(object, MAXIMAL_LENGTH);
    }

    public static Integer getMaximalLengthCharacteristic(DefaultFeatureType defaultFeatureType, AbstractIdentifiedType abstractIdentifiedType) {
        return (Integer)AttributeConvention.getCharacteristic(defaultFeatureType, abstractIdentifiedType, MAXIMAL_LENGTH);
    }

    private static boolean hasCharacteristic(AbstractIdentifiedType abstractIdentifiedType, String string, Class<?> clazz) {
        DefaultAttributeType<?> defaultAttributeType;
        Optional<DefaultAttributeType<?>> optional = Features.toAttribute(abstractIdentifiedType);
        if (optional.isPresent() && (defaultAttributeType = optional.get().characteristics().get(string)) != null) {
            return clazz.isAssignableFrom(defaultAttributeType.getValueClass());
        }
        return false;
    }

    private static Object getCharacteristic(Object object, String string) {
        if (object instanceof AbstractAttribute) {
            Object object2;
            AbstractAttribute<?> abstractAttribute = ((AbstractAttribute)object).characteristics().get(string);
            if (abstractAttribute != null && (object2 = abstractAttribute.getValue()) != null) {
                return object2;
            }
            object2 = ((AbstractAttribute)object).getType().characteristics().get(string);
            if (object2 != null) {
                return ((DefaultAttributeType)object2).getDefaultValue();
            }
        }
        return null;
    }

    private static Object getCharacteristic(DefaultFeatureType defaultFeatureType, AbstractIdentifiedType abstractIdentifiedType, String string) {
        DefaultAttributeType<?> defaultAttributeType;
        Optional<String> optional = Features.getLinkTarget(abstractIdentifiedType);
        if (optional.isPresent() && defaultFeatureType != null) {
            abstractIdentifiedType = defaultFeatureType.getProperty(optional.get());
        }
        if (abstractIdentifiedType instanceof DefaultAttributeType && (defaultAttributeType = ((DefaultAttributeType)abstractIdentifiedType).characteristics().get(string)) != null) {
            return defaultAttributeType.getDefaultValue();
        }
        return null;
    }
}

