/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.ltr.search;

import java.io.IOException;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Rescorer;
import org.apache.solr.ltr.LTRRescorer;
import org.apache.solr.ltr.LTRScoringQuery;
import org.apache.solr.search.AbstractReRankQuery;
import org.apache.solr.search.RankQuery;

public class LTRQuery
extends AbstractReRankQuery {
    private static final Query defaultQuery = new MatchAllDocsQuery();
    private final LTRScoringQuery scoringQuery;

    public LTRQuery(LTRScoringQuery scoringQuery, int reRankDocs) {
        this(scoringQuery, reRankDocs, new LTRRescorer(scoringQuery));
    }

    protected LTRQuery(LTRScoringQuery scoringQuery, int reRankDocs, LTRRescorer rescorer) {
        super(defaultQuery, reRankDocs, (Rescorer)rescorer);
        this.scoringQuery = scoringQuery;
    }

    public int hashCode() {
        return 31 * this.classHash() + (this.mainQuery.hashCode() + this.scoringQuery.hashCode() + this.reRankDocs);
    }

    public boolean equals(Object o) {
        return this.sameClassAs(o) && this.equalsTo((LTRQuery)((Object)((Object)((Object)this)).getClass().cast(o)));
    }

    private boolean equalsTo(LTRQuery other) {
        return this.mainQuery.equals((Object)other.mainQuery) && this.scoringQuery.equals((Object)other.scoringQuery) && this.reRankDocs == other.reRankDocs;
    }

    public RankQuery wrap(Query _mainQuery) {
        super.wrap(_mainQuery);
        if (this.scoringQuery != null) {
            this.scoringQuery.setOriginalQuery(_mainQuery);
        }
        return this;
    }

    public String toString(String field) {
        return "{!ltr mainQuery='" + this.mainQuery.toString() + "' scoringQuery='" + this.scoringQuery.toString() + "' reRankDocs=" + this.reRankDocs + "}";
    }

    protected Query rewrite(Query rewrittenMainQuery) throws IOException {
        return new LTRQuery(this.scoringQuery, this.reRankDocs).wrap(rewrittenMainQuery);
    }
}

