/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.network.RequestChannel;
import kafka.raft.RaftManager;
import kafka.server.ApiRequestHandler;
import kafka.server.ApiVersionManager;
import kafka.server.RequestLocal;
import kafka.utils.Logging;
import kafka.utils.NotNothing$;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.message.BeginQuorumEpochResponseData;
import org.apache.kafka.common.message.EndQuorumEpochResponseData;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.FetchSnapshotResponseData;
import org.apache.kafka.common.message.VoteResponseData;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.BeginQuorumEpochResponse;
import org.apache.kafka.common.requests.EndQuorumEpochResponse;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.FetchSnapshotResponse;
import org.apache.kafka.common.requests.VoteResponse;
import org.apache.kafka.common.utils.Time;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u00055b\u0001\u0002\b\u0010\u0001QA\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\tu\u0001\u0011\t\u0011)A\u0005w!A\u0011\t\u0001B\u0001B\u0003%!\t\u0003\u0005O\u0001\t\u0005\t\u0015!\u0003P\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0011\u0015q\u0006\u0001\"\u0011`\u0011\u0015\t\b\u0001\"\u0003s\u0011\u0015!\b\u0001\"\u0003v\u0011\u00159\b\u0001\"\u0003y\u0011\u0015Q\b\u0001\"\u0003|\u0011\u0015i\b\u0001\"\u0003\u007f\u0011\u001d\t\t\u0001\u0001C\u0005\u0003\u0007AaA\u0018\u0001\u0005\n\u0005\u001d!A\u0006+fgR\u0014\u0016M\u001a;SKF,Xm\u001d;IC:$G.\u001a:\u000b\u0005A\t\u0012!\u0002;p_2\u001c(\"\u0001\n\u0002\u000b-\fgm[1\u0004\u0001M!\u0001!F\u000e\"!\t1\u0012$D\u0001\u0018\u0015\u0005A\u0012!B:dC2\f\u0017B\u0001\u000e\u0018\u0005\u0019\te.\u001f*fMB\u0011AdH\u0007\u0002;)\u0011a$E\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005\u0001j\"!E!qSJ+\u0017/^3ti\"\u000bg\u000e\u001a7feB\u0011!%J\u0007\u0002G)\u0011A%E\u0001\u0006kRLGn]\u0005\u0003M\r\u0012q\u0001T8hO&tw-A\u0006sC\u001a$X*\u00198bO\u0016\u0014\bGA\u00152!\rQSfL\u0007\u0002W)\u0011A&E\u0001\u0005e\u00064G/\u0003\u0002/W\tY!+\u00194u\u001b\u0006t\u0017mZ3s!\t\u0001\u0014\u0007\u0004\u0001\u0005\u0013I\n\u0011\u0011!A\u0001\u0006\u0003\u0019$aA0%cE\u0011Ag\u000e\t\u0003-UJ!AN\f\u0003\u000f9{G\u000f[5oOB\u0011a\u0003O\u0005\u0003s]\u00111!\u00118z\u00039\u0011X-];fgR\u001c\u0005.\u00198oK2\u0004\"\u0001P \u000e\u0003uR!AP\t\u0002\u000f9,Go^8sW&\u0011\u0001)\u0010\u0002\u000f%\u0016\fX/Z:u\u0007\"\fgN\\3m\u0003\u0011!\u0018.\\3\u0011\u0005\rcU\"\u0001#\u000b\u0005\u0011*%B\u0001$H\u0003\u0019\u0019w.\\7p]*\u0011!\u0003\u0013\u0006\u0003\u0013*\u000ba!\u00199bG\",'\"A&\u0002\u0007=\u0014x-\u0003\u0002N\t\n!A+[7f\u0003E\t\u0007/\u001b,feNLwN\\'b]\u0006<WM\u001d\t\u00039AK!!U\u000f\u0003#\u0005\u0003\u0018NV3sg&|g.T1oC\u001e,'/\u0001\u0004=S:LGO\u0010\u000b\u0006)Z[F,\u0018\t\u0003+\u0002i\u0011a\u0004\u0005\u0006O\u0015\u0001\ra\u0016\u0019\u00031j\u00032AK\u0017Z!\t\u0001$\fB\u00053-\u0006\u0005\t\u0011!B\u0001g!)!(\u0002a\u0001w!)\u0011)\u0002a\u0001\u0005\")a*\u0002a\u0001\u001f\u00061\u0001.\u00198eY\u0016$2\u0001Y2m!\t1\u0012-\u0003\u0002c/\t!QK\\5u\u0011\u0015!g\u00011\u0001f\u0003\u001d\u0011X-];fgR\u0004\"AZ5\u000f\u0005q:\u0017B\u00015>\u00039\u0011V-];fgR\u001c\u0005.\u00198oK2L!A[6\u0003\u000fI+\u0017/^3ti*\u0011\u0001.\u0010\u0005\u0006[\u001a\u0001\rA\\\u0001\re\u0016\fX/Z:u\u0019>\u001c\u0017\r\u001c\t\u00039=L!\u0001]\u000f\u0003\u0019I+\u0017/^3ti2{7-\u00197\u0002#!\fg\u000e\u001a7f\u0003BLg+\u001a:tS>t7\u000f\u0006\u0002ag\")Am\u0002a\u0001K\u0006Q\u0001.\u00198eY\u00164v\u000e^3\u0015\u0005\u00014\b\"\u00023\t\u0001\u0004)\u0017A\u00065b]\u0012dWMQ3hS:\fVo\u001c:v[\u0016\u0003xn\u00195\u0015\u0005\u0001L\b\"\u00023\n\u0001\u0004)\u0017\u0001\u00065b]\u0012dW-\u00128e#V|'/^7Fa>\u001c\u0007\u000e\u0006\u0002ay\")AM\u0003a\u0001K\u0006Y\u0001.\u00198eY\u00164U\r^2i)\t\u0001w\u0010C\u0003e\u0017\u0001\u0007Q-A\niC:$G.\u001a$fi\u000eD7K\\1qg\"|G\u000fF\u0002a\u0003\u000bAQ\u0001\u001a\u0007A\u0002\u0015$R\u0001YA\u0005\u0003\u0017AQ\u0001Z\u0007A\u0002\u0015Dq!!\u0004\u000e\u0001\u0004\ty!A\u0007ck&dGMU3ta>t7/\u001a\t\b-\u0005E\u0011QCA\u0011\u0013\r\t\u0019b\u0006\u0002\n\rVt7\r^5p]F\u0002B!a\u0006\u0002\u001e5\u0011\u0011\u0011\u0004\u0006\u0004\u00037)\u0015\u0001\u00039s_R|7m\u001c7\n\t\u0005}\u0011\u0011\u0004\u0002\u000b\u0003BLW*Z:tC\u001e,\u0007\u0003BA\u0012\u0003Si!!!\n\u000b\u0007\u0005\u001dR)\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\tY#!\n\u0003!\u0005\u00137\u000f\u001e:bGR\u0014Vm\u001d9p]N,\u0007")
public class TestRaftRequestHandler
implements ApiRequestHandler,
Logging {
    private final RaftManager<?> raftManager;
    private final RequestChannel requestChannel;
    private final Time time;
    private final ApiVersionManager apiVersionManager;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public void tryCompleteActions() {
        ApiRequestHandler.tryCompleteActions$(this);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public void handle(RequestChannel.Request request, RequestLocal requestLocal) {
        block13: {
            try {
                try {
                    this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(31).append("Handling request:").append(request.requestDesc(true)).append(" with context ").append(request.context()).toString());
                    ApiKeys apiKeys = request.header().apiKey();
                    if (ApiKeys.API_VERSIONS.equals(apiKeys)) {
                        this.handleApiVersions(request);
                        break block13;
                    }
                    if (ApiKeys.VOTE.equals(apiKeys)) {
                        this.handleVote(request);
                        break block13;
                    }
                    if (ApiKeys.BEGIN_QUORUM_EPOCH.equals(apiKeys)) {
                        this.handleBeginQuorumEpoch(request);
                        break block13;
                    }
                    if (ApiKeys.END_QUORUM_EPOCH.equals(apiKeys)) {
                        this.handleEndQuorumEpoch(request);
                        break block13;
                    }
                    if (ApiKeys.FETCH.equals(apiKeys)) {
                        this.handleFetch(request);
                        break block13;
                    }
                    if (ApiKeys.FETCH_SNAPSHOT.equals(apiKeys)) {
                        this.handleFetchSnapshot(request);
                        break block13;
                    }
                    throw new IllegalArgumentException(new StringBuilder(21).append("Unsupported api key: ").append(request.header().apiKey()).toString());
                }
                catch (FatalExitError fatalExitError) {
                    throw fatalExitError;
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Unexpected error handling request ").append(request.requestDesc(true)).append(" ").append("with context ").append(request.context()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                    AbstractResponse errorResponse = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl())).getErrorResponse(e);
                    this.requestChannel.sendResponse(request, errorResponse, (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
                }
            }
            finally {
                if (request.apiLocalCompleteTimeNanos() < 0L) {
                    request.apiLocalCompleteTimeNanos_$eq(this.time.nanoseconds());
                }
            }
        }
    }

    private void handleApiVersions(RequestChannel.Request request) {
        this.requestChannel.sendResponse(request, (AbstractResponse)this.apiVersionManager.apiVersionResponse(0), (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
    }

    private void handleVote(RequestChannel.Request request) {
        Function1 & Serializable handle_buildResponse = (Function1 & Serializable)response -> new VoteResponse((VoteResponseData)response);
        Object handle_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.raftManager.handleRequest(request.header(), handle_requestBody.data(), this.time.milliseconds()).whenComplete((response, exception) -> {
            AbstractResponse res = exception != null ? handle_requestBody.getErrorResponse(exception) : (AbstractResponse)handle_buildResponse.apply(response);
            $this.requestChannel.sendResponse(request, res, (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
        });
    }

    private void handleBeginQuorumEpoch(RequestChannel.Request request) {
        Function1 & Serializable handle_buildResponse = (Function1 & Serializable)response -> new BeginQuorumEpochResponse((BeginQuorumEpochResponseData)response);
        Object handle_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.raftManager.handleRequest(request.header(), handle_requestBody.data(), this.time.milliseconds()).whenComplete((response, exception) -> {
            AbstractResponse res = exception != null ? handle_requestBody.getErrorResponse(exception) : (AbstractResponse)handle_buildResponse.apply(response);
            $this.requestChannel.sendResponse(request, res, (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
        });
    }

    private void handleEndQuorumEpoch(RequestChannel.Request request) {
        Function1 & Serializable handle_buildResponse = (Function1 & Serializable)response -> new EndQuorumEpochResponse((EndQuorumEpochResponseData)response);
        Object handle_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.raftManager.handleRequest(request.header(), handle_requestBody.data(), this.time.milliseconds()).whenComplete((response, exception) -> {
            AbstractResponse res = exception != null ? handle_requestBody.getErrorResponse(exception) : (AbstractResponse)handle_buildResponse.apply(response);
            $this.requestChannel.sendResponse(request, res, (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
        });
    }

    private void handleFetch(RequestChannel.Request request) {
        Function1 & Serializable handle_buildResponse = (Function1 & Serializable)response -> new FetchResponse((FetchResponseData)response);
        Object handle_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.raftManager.handleRequest(request.header(), handle_requestBody.data(), this.time.milliseconds()).whenComplete((response, exception) -> {
            AbstractResponse res = exception != null ? handle_requestBody.getErrorResponse(exception) : (AbstractResponse)handle_buildResponse.apply(response);
            $this.requestChannel.sendResponse(request, res, (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
        });
    }

    private void handleFetchSnapshot(RequestChannel.Request request) {
        Function1 & Serializable handle_buildResponse = (Function1 & Serializable)response -> new FetchSnapshotResponse((FetchSnapshotResponseData)response);
        Object handle_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.raftManager.handleRequest(request.header(), handle_requestBody.data(), this.time.milliseconds()).whenComplete((response, exception) -> {
            AbstractResponse res = exception != null ? handle_requestBody.getErrorResponse(exception) : (AbstractResponse)handle_buildResponse.apply(response);
            $this.requestChannel.sendResponse(request, res, (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
        });
    }

    private void handle(RequestChannel.Request request, Function1<ApiMessage, AbstractResponse> buildResponse) {
        Object requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.raftManager.handleRequest(request.header(), requestBody.data(), this.time.milliseconds()).whenComplete((response, exception) -> {
            AbstractResponse res = exception != null ? handle_requestBody.getErrorResponse(exception) : (AbstractResponse)handle_buildResponse.apply(response);
            $this.requestChannel.sendResponse(request, res, (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
        });
    }

    public TestRaftRequestHandler(RaftManager<?> raftManager, RequestChannel requestChannel, Time time, ApiVersionManager apiVersionManager) {
        this.raftManager = raftManager;
        this.requestChannel = requestChannel;
        this.time = time;
        this.apiVersionManager = apiVersionManager;
    }
}

