/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.design;

import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.charts.JRXyDataset;
import net.sf.jasperreports.charts.JRXySeries;
import net.sf.jasperreports.engine.JRChartDataset;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.design.JRDesignChartDataset;
import net.sf.jasperreports.engine.design.JRVerifier;

public class JRDesignXyDataset
extends JRDesignChartDataset
implements JRXyDataset {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_XY_SERIES = "xySeries";
    private List xySeriesList = new ArrayList();

    public JRDesignXyDataset(JRChartDataset dataset) {
        super(dataset);
    }

    public JRXySeries[] getSeries() {
        JRXySeries[] xySeriesArray = new JRXySeries[this.xySeriesList.size()];
        this.xySeriesList.toArray(xySeriesArray);
        return xySeriesArray;
    }

    public List getSeriesList() {
        return this.xySeriesList;
    }

    public void addXySeries(JRXySeries xySeries) {
        this.xySeriesList.add(xySeries);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_XY_SERIES, xySeries, this.xySeriesList.size() - 1);
    }

    public JRXySeries removeXySeries(JRXySeries xySeries) {
        int idx;
        if (xySeries != null && (idx = this.xySeriesList.indexOf(xySeries)) >= 0) {
            this.xySeriesList.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_XY_SERIES, xySeries, idx);
        }
        return xySeries;
    }

    public byte getDatasetType() {
        return 3;
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    public void validate(JRVerifier verifier) {
        verifier.verify(this);
    }

    public Object clone() {
        JRDesignXyDataset clone = (JRDesignXyDataset)super.clone();
        if (this.xySeriesList != null) {
            clone.xySeriesList = new ArrayList(this.xySeriesList.size());
            for (int i = 0; i < this.xySeriesList.size(); ++i) {
                clone.xySeriesList.add(((JRXySeries)this.xySeriesList.get(i)).clone());
            }
        }
        return clone;
    }
}

