/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.crypto.ec.CurveFactory;
import de.rub.nds.tlsattacker.core.crypto.ec.Point;
import de.rub.nds.tlsattacker.core.crypto.ec.PointFormatter;
import de.rub.nds.tlsattacker.core.crypto.ec.RFC7748Curve;
import de.rub.nds.tlsattacker.core.protocol.handler.ClientKeyExchangeHandler;
import de.rub.nds.tlsattacker.core.protocol.message.ECDHClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.ECDHClientKeyExchangeParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.ECDHClientKeyExchangePreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.ECDHClientKeyExchangeSerializer;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ECDHClientKeyExchangeHandler
extends ClientKeyExchangeHandler<ECDHClientKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public ECDHClientKeyExchangeHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public ECDHClientKeyExchangeParser getParser(byte[] message, int pointer) {
        return new ECDHClientKeyExchangeParser(pointer, message, this.tlsContext.getChooser().getLastRecordVersion(), this.tlsContext.getConfig());
    }

    public ECDHClientKeyExchangePreparator getPreparator(ECDHClientKeyExchangeMessage message) {
        return new ECDHClientKeyExchangePreparator<ECDHClientKeyExchangeMessage>(this.tlsContext.getChooser(), message);
    }

    public ECDHClientKeyExchangeSerializer getSerializer(ECDHClientKeyExchangeMessage message) {
        return new ECDHClientKeyExchangeSerializer<ECDHClientKeyExchangeMessage>(message, this.tlsContext.getChooser().getSelectedProtocolVersion());
    }

    @Override
    public void adjustTLSContext(ECDHClientKeyExchangeMessage message) {
        this.adjustPremasterSecret(message);
        this.adjustMasterSecret(message);
        this.adjustClientPublicKey(message);
        this.setRecordCipher();
        this.spawnNewSession();
    }

    private void adjustClientPublicKey(ECDHClientKeyExchangeMessage message) {
        byte[] serializedPoint = (byte[])message.getPublicKey().getValue();
        NamedGroup usedGroup = this.tlsContext.getChooser().getSelectedNamedGroup();
        if (usedGroup == NamedGroup.ECDH_X25519 || usedGroup == NamedGroup.ECDH_X448) {
            LOGGER.debug("Adjusting Montgomery EC PublicKey");
            RFC7748Curve curve = (RFC7748Curve)CurveFactory.getCurve(usedGroup);
            if (serializedPoint.length != 0) {
                BigInteger xCoordinate = new BigInteger(serializedPoint);
            } else {
                LOGGER.warn("Encoding 0 length byte-array");
                BigInteger xCoordinate = BigInteger.ZERO;
            }
            this.tlsContext.setClientEcPublicKey(curve.createAPointOnCurve(new BigInteger(serializedPoint)));
        } else {
            LOGGER.debug("Adjusting EC Point");
            Point publicKey = PointFormatter.formatFromByteArray(usedGroup, serializedPoint);
            this.tlsContext.setClientEcPublicKey(publicKey);
        }
    }
}

