/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import de.rub.nds.tlsattacker.core.constants.AlgorithmResolver;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.crypto.ec.CurveFactory;
import de.rub.nds.tlsattacker.core.crypto.ec.EllipticCurve;
import de.rub.nds.tlsattacker.core.crypto.ec.FieldElementF2m;
import de.rub.nds.tlsattacker.core.crypto.ec.Point;
import de.rub.nds.tlsattacker.core.crypto.ec.PointFormatter;
import de.rub.nds.tlsattacker.core.protocol.handler.ServerKeyExchangeHandler;
import de.rub.nds.tlsattacker.core.protocol.message.ECDHEServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.ECDHEServerKeyExchangeParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.ECDHEServerKeyExchangePreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.ECDHEServerKeyExchangeSerializer;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ECDHEServerKeyExchangeHandler<T extends ECDHEServerKeyExchangeMessage>
extends ServerKeyExchangeHandler<T> {
    private static final Logger LOGGER = LogManager.getLogger();

    public ECDHEServerKeyExchangeHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public ECDHEServerKeyExchangeParser getParser(byte[] message, int pointer) {
        return new ECDHEServerKeyExchangeParser(pointer, message, this.tlsContext.getChooser().getLastRecordVersion(), AlgorithmResolver.getKeyExchangeAlgorithm(this.tlsContext.getChooser().getSelectedCipherSuite()), this.tlsContext.getConfig());
    }

    public ECDHEServerKeyExchangePreparator getPreparator(ECDHEServerKeyExchangeMessage message) {
        return new ECDHEServerKeyExchangePreparator<ECDHEServerKeyExchangeMessage>(this.tlsContext.getChooser(), message);
    }

    public ECDHEServerKeyExchangeSerializer getSerializer(ECDHEServerKeyExchangeMessage message) {
        return new ECDHEServerKeyExchangeSerializer<ECDHEServerKeyExchangeMessage>(message, this.tlsContext.getChooser().getSelectedProtocolVersion());
    }

    @Override
    public void adjustTLSContext(ECDHEServerKeyExchangeMessage message) {
        this.adjustECParameter(message);
        if (message.getComputations() != null) {
            this.tlsContext.setServerEcPrivateKey((BigInteger)message.getComputations().getPrivateKey().getValue());
        }
    }

    protected void adjustECParameter(ECDHEServerKeyExchangeMessage message) {
        NamedGroup group = NamedGroup.getNamedGroup((byte[])message.getNamedGroup().getValue());
        if (group != null) {
            LOGGER.debug("Adjusting selected named group: " + group.name());
            this.tlsContext.setSelectedGroup(group);
        }
        if (group == NamedGroup.ECDH_X448 || group == NamedGroup.ECDH_X25519) {
            LOGGER.debug("Adjusting Montgomery EC Point");
            EllipticCurve curve = CurveFactory.getCurve(group);
            this.tlsContext.setServerEcPublicKey(new Point(new FieldElementF2m(new BigInteger((byte[])message.getPublicKey().getValue()), curve.getModulus()), new FieldElementF2m(new BigInteger((byte[])message.getPublicKey().getValue()), curve.getModulus())));
        } else if (group != null) {
            LOGGER.debug("Adjusting EC Point");
            Point publicKeyPoint = PointFormatter.formatFromByteArray(group, (byte[])message.getPublicKey().getValue());
            this.tlsContext.setServerEcPublicKey(publicKeyPoint);
        } else {
            LOGGER.warn("Could not adjust server public key, named group is unknown.");
        }
    }
}

