/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.tlsattacker.core.exceptions.ParserException;
import de.rub.nds.tlsattacker.core.protocol.message.extension.CachedInfoExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.cachedinfo.CachedObject;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.CachedObjectParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParser;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.util.LinkedList;
import java.util.List;

public class CachedInfoExtensionParser
extends ExtensionParser<CachedInfoExtensionMessage> {
    private List<CachedObject> cachedObjectList;

    public CachedInfoExtensionParser(int startposition, byte[] array) {
        super(startposition, array);
    }

    @Override
    public void parseExtensionMessageContent(CachedInfoExtensionMessage msg) {
        msg.setCachedInfoLength(this.parseIntField(2));
        msg.setCachedInfoBytes(this.parseByteArrayField((Integer)msg.getCachedInfoLength().getValue()));
        int position = 0;
        ConnectionEndType connectionEndType = ConnectionEndType.CLIENT;
        this.cachedObjectList = new LinkedList<CachedObject>();
        if ((Integer)msg.getCachedInfoLength().getValue() <= 2) {
            connectionEndType = ConnectionEndType.SERVER;
        }
        while (position < (Integer)msg.getCachedInfoLength().getValue()) {
            CachedObjectParser parser = new CachedObjectParser(position, (byte[])msg.getCachedInfoBytes().getValue(), connectionEndType);
            this.cachedObjectList.add(parser.parse());
            if (position == parser.getPointer()) {
                throw new ParserException("Ran into infinite Loop while parsing CachedObjects");
            }
            position = parser.getPointer();
        }
        msg.setCachedInfo(this.cachedObjectList);
    }

    @Override
    protected CachedInfoExtensionMessage createExtensionMessage() {
        return new CachedInfoExtensionMessage();
    }
}

