/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.util;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class ReflectionHelper {
    public static List<Field> getFieldsUpTo(Class<?> startClass, Class<?> exclusiveParent, Class<?> filterClass) {
        List<Field> currentClassFields = ReflectionHelper.filterFieldList(Arrays.asList(startClass.getDeclaredFields()), filterClass);
        Class<?> parentClass = startClass.getSuperclass();
        if (!(parentClass == null || exclusiveParent != null && parentClass.equals(exclusiveParent))) {
            List<Field> parentClassFields = ReflectionHelper.getFieldsUpTo(parentClass, exclusiveParent, filterClass);
            currentClassFields.addAll(parentClassFields);
        }
        return currentClassFields;
    }

    private static List<Field> filterFieldList(List<Field> fields, Class<?> filterClass) {
        LinkedList<Field> filteredFields = new LinkedList<Field>();
        for (Field f : fields) {
            if (filterClass != null && !filterClass.isAssignableFrom(f.getType())) continue;
            filteredFields.add(f);
        }
        return filteredFields;
    }

    public static List<Object> getValuesFromFieldList(Object object, List<Field> fields) throws IllegalAccessException {
        LinkedList<Object> list = new LinkedList<Object>();
        for (Field f : fields) {
            f.setAccessible(true);
            list.add(f.get(object));
        }
        return list;
    }

    public static Type[] getParameterizedTypes(Object object) {
        Type superclassType = object.getClass().getGenericSuperclass();
        if (!ParameterizedType.class.isAssignableFrom(superclassType.getClass())) {
            return null;
        }
        return ((ParameterizedType)superclassType).getActualTypeArguments();
    }
}

