/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.util.pool;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.mariadb.jdbc.UrlParser;
import org.mariadb.jdbc.internal.util.pool.Pool;
import org.mariadb.jdbc.internal.util.scheduler.MariaDbThreadFactory;

public class Pools {
    private static final AtomicInteger poolIndex = new AtomicInteger();
    private static final Map<UrlParser, Pool> poolMap = new ConcurrentHashMap<UrlParser, Pool>();
    private static ScheduledThreadPoolExecutor poolExecutor = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pool retrievePool(UrlParser urlParser) {
        if (!poolMap.containsKey(urlParser)) {
            Map<UrlParser, Pool> map = poolMap;
            synchronized (map) {
                if (!poolMap.containsKey(urlParser)) {
                    if (poolExecutor == null) {
                        poolExecutor = new ScheduledThreadPoolExecutor(1, new MariaDbThreadFactory("MariaDbPool-maxTimeoutIdle-checker"));
                    }
                    Pool pool = new Pool(urlParser, poolIndex.incrementAndGet(), poolExecutor);
                    poolMap.put(urlParser, pool);
                    return pool;
                }
            }
        }
        return poolMap.get(urlParser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(Pool pool) {
        if (poolMap.containsKey(pool.getUrlParser())) {
            Map<UrlParser, Pool> map = poolMap;
            synchronized (map) {
                if (poolMap.containsKey(pool.getUrlParser())) {
                    poolMap.remove(pool.getUrlParser());
                    if (poolMap.isEmpty()) {
                        Pools.shutdownExecutor();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close() {
        Map<UrlParser, Pool> map = poolMap;
        synchronized (map) {
            for (Pool pool : poolMap.values()) {
                try {
                    pool.close();
                }
                catch (InterruptedException interruptedException) {}
            }
            Pools.shutdownExecutor();
            poolMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close(String poolName) {
        if (poolName == null) {
            return;
        }
        Map<UrlParser, Pool> map = poolMap;
        synchronized (map) {
            for (Pool pool : poolMap.values()) {
                if (!poolName.equals(pool.getUrlParser().getOptions().poolName)) continue;
                try {
                    pool.close();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return;
            }
        }
    }

    private static void shutdownExecutor() {
        poolExecutor.shutdown();
        try {
            poolExecutor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        poolExecutor = null;
    }
}

