"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.modelRouter = void 0;
var _configSchema = require("@osd/config-schema");
var _common = require("../../common");
var _services = require("../services");
var _constants = require("./constants");
var _utils = require("./utils");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const modelSortQuerySchema = _configSchema.schema.oneOf([_configSchema.schema.literal('name-asc'), _configSchema.schema.literal('name-desc'), _configSchema.schema.literal('model_state-asc'), _configSchema.schema.literal('model_state-desc'), _configSchema.schema.literal('id-asc'), _configSchema.schema.literal('id-desc')]);
const modelStateSchema = _configSchema.schema.oneOf([_configSchema.schema.literal(_common.MODEL_STATE.loadFailed), _configSchema.schema.literal(_common.MODEL_STATE.loaded), _configSchema.schema.literal(_common.MODEL_STATE.loading), _configSchema.schema.literal(_common.MODEL_STATE.partiallyLoaded), _configSchema.schema.literal(_common.MODEL_STATE.trained), _configSchema.schema.literal(_common.MODEL_STATE.uploaded), _configSchema.schema.literal(_common.MODEL_STATE.unloaded), _configSchema.schema.literal(_common.MODEL_STATE.uploading)]);
const modelRouter = router => {
  router.get({
    path: _constants.MODEL_API_ENDPOINT,
    validate: {
      query: _configSchema.schema.object({
        from: _configSchema.schema.number({
          min: 0
        }),
        size: _configSchema.schema.number({
          max: 50
        }),
        sort: _configSchema.schema.maybe(_configSchema.schema.oneOf([modelSortQuerySchema, _configSchema.schema.arrayOf(modelSortQuerySchema)])),
        states: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.arrayOf(modelStateSchema), modelStateSchema])),
        nameOrId: _configSchema.schema.maybe(_configSchema.schema.string()),
        extra_query: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any())),
        data_source_id: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }
  }, async (context, request, response) => {
    const {
      from,
      size,
      sort,
      states,
      nameOrId,
      extra_query: extraQuery,
      data_source_id: dataSourceId
    } = request.query;
    try {
      const payload = await _services.ModelService.search({
        transport: await (0, _utils.getOpenSearchClientTransport)({
          dataSourceId,
          context
        }),
        from,
        size,
        sort: typeof sort === 'string' ? [sort] : sort,
        states: typeof states === 'string' ? [states] : states,
        nameOrId,
        extraQuery
      });
      return response.ok({
        body: payload
      });
    } catch (err) {
      return response.badRequest({
        body: err.message
      });
    }
  });
};
exports.modelRouter = modelRouter;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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