/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.epubcheck.util.microsyntax;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import java.nio.CharBuffer;
import java.util.List;
import java.util.regex.Pattern;
import org.w3c.epubcheck.util.infra.InfraUtil;

public class ViewportMeta {
    private static Pattern VIEWPORT_HEIGHT_REGEX = Pattern.compile("\\d+(\\.\\d+)?|device-height");
    private static Pattern VIEWPORT_WIDTH_REGEX = Pattern.compile("\\d+(\\.\\d+)?|device-width");
    private final ImmutableListMultimap<String, String> properties;

    public static ViewportMeta parse(String string, ErrorHandler errorHandler) {
        return new Parser(errorHandler).parse(string);
    }

    public static boolean isValidProperty(String name, String value) {
        Preconditions.checkNotNull((Object)value);
        switch ((String)Preconditions.checkNotNull((Object)name)) {
            case "width": {
                return VIEWPORT_WIDTH_REGEX.matcher(value).matches();
            }
            case "height": {
                return VIEWPORT_HEIGHT_REGEX.matcher(value).matches();
            }
        }
        return true;
    }

    private ViewportMeta(Builder builder) {
        this.properties = builder.properties.build();
    }

    public boolean hasProperty(String name) {
        return this.properties.containsKey((Object)name);
    }

    public List<String> getValues(String name) {
        return this.properties.get((Object)name);
    }

    public ListMultimap<String, String> asMultimap() {
        return this.properties;
    }

    private static final class Builder {
        public ImmutableListMultimap.Builder<String, String> properties = ImmutableListMultimap.builder();

        private Builder() {
        }

        public ViewportMeta build() {
            return new ViewportMeta(this);
        }

        public void withProperty(String name, String value) {
            Preconditions.checkArgument((name != null ? 1 : 0) != 0);
            Preconditions.checkArgument((value != null ? 1 : 0) != 0);
            this.properties.put((Object)name, (Object)value);
        }
    }

    private static final class Parser {
        private final ErrorHandler errorHandler;

        public Parser(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
        }

        private void error(ParseError code, int position) {
            if (this.errorHandler != null) {
                this.errorHandler.error(code, position);
            }
        }

        public ViewportMeta parse(CharSequence string) {
            Builder builder = new Builder();
            if (string == null || string.length() == 0) {
                this.error(ParseError.NULL_OR_EMPTY, -1);
                return builder.build();
            }
            CharBuffer input = CharBuffer.wrap(string);
            StringBuilder name = new StringBuilder();
            StringBuilder value = new StringBuilder();
            State state = State.NAME;
            boolean consume = true;
            char c = ' ';
            while (!consume || input.hasRemaining()) {
                if (consume) {
                    c = input.get();
                } else {
                    consume = true;
                }
                switch (state.ordinal()) {
                    case 0: {
                        if (InfraUtil.isASCIIWhitespace(c) && name.length() == 0) break;
                        if (c == '=' || InfraUtil.isASCIIWhitespace(c)) {
                            state = State.ASSIGN;
                            consume = false;
                            break;
                        }
                        if (c == ',' || c == ';') {
                            state = State.SEPARATOR;
                            consume = false;
                            break;
                        }
                        name.append(c);
                        break;
                    }
                    case 1: {
                        if (name.length() == 0) {
                            this.error(ParseError.NAME_EMPTY, input.position());
                            return builder.build();
                        }
                        if (InfraUtil.isASCIIWhitespace(c)) break;
                        if (c == '=') {
                            state = State.VALUE;
                            break;
                        }
                        if (c == ',' || c == ';') {
                            state = State.SEPARATOR;
                            consume = false;
                            break;
                        }
                        this.error(ParseError.VALUE_EMPTY, input.position());
                        return builder.build();
                    }
                    case 2: {
                        if (InfraUtil.isASCIIWhitespace(c) && value.length() == 0) break;
                        if (c == ',' || c == ';' || InfraUtil.isASCIIWhitespace(c)) {
                            if (value.length() == 0) {
                                this.error(ParseError.VALUE_EMPTY, input.position());
                                return builder.build();
                            }
                            state = State.SPACE_OR_SEPARATOR;
                            consume = false;
                            break;
                        }
                        if (c == '=') {
                            this.error(ParseError.ASSIGN_UNEXPECTED, input.position());
                            return builder.build();
                        }
                        value.append(c);
                        break;
                    }
                    case 4: {
                        if (!InfraUtil.isASCIIWhitespace(c)) {
                            state = State.SEPARATOR;
                            consume = false;
                        }
                    }
                    case 3: {
                        if (name.length() == 0) {
                            this.error(ParseError.LEADING_SEPARATOR, input.position());
                            return builder.build();
                        }
                        if (c == ',' || c == ';' || InfraUtil.isASCIIWhitespace(c)) break;
                        builder.withProperty(name.toString(), value.toString());
                        name = new StringBuilder();
                        value = new StringBuilder();
                        state = State.NAME;
                        consume = false;
                    }
                }
            }
            if (state == State.VALUE && value.length() == 0) {
                this.error(ParseError.VALUE_EMPTY, input.position());
            } else {
                builder.withProperty(name.toString(), value.toString());
            }
            if (state == State.SEPARATOR) {
                this.error(ParseError.TRAILING_SEPARATOR, input.position());
            }
            return builder.build();
        }

        private static enum State {
            NAME,
            ASSIGN,
            VALUE,
            SEPARATOR,
            SPACE_OR_SEPARATOR;

        }
    }

    public static interface ErrorHandler {
        public void error(ParseError var1, int var2);
    }

    public static enum ParseError {
        NULL_OR_EMPTY,
        NAME_EMPTY,
        VALUE_EMPTY,
        LEADING_SEPARATOR,
        TRAILING_SEPARATOR,
        ASSIGN_UNEXPECTED;

    }
}

