/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openstreetmap.josm.tools.I18n;

public final class User {
    private static long uidCounter;
    private static Map<Long, User> userMap;
    private static final User ANONYMOUS;
    private static User lastUser;
    private final LinkedHashSet<String> names = new LinkedHashSet();
    private final long uid;

    private static long getNextLocalUid() {
        return --uidCounter;
    }

    public static synchronized User createLocalUser(String name) {
        for (long i = -1L; i >= uidCounter; --i) {
            User olduser = User.getById(i);
            if (olduser == null || !olduser.hasName(name)) continue;
            return olduser;
        }
        User user = new User(User.getNextLocalUid(), name);
        userMap.put(user.getId(), user);
        return user;
    }

    public static synchronized User createOsmUser(long uid, String name) {
        if (lastUser != null && lastUser.getId() == uid) {
            if (name != null) {
                lastUser.setPreferredName(name);
            }
            return lastUser;
        }
        User user = userMap.computeIfAbsent(uid, k -> new User(uid, name));
        if (name != null) {
            user.addName(name);
        }
        lastUser = user;
        return user;
    }

    public static synchronized void clearUserMap() {
        userMap.clear();
        lastUser = null;
    }

    public static synchronized User getById(long uid) {
        return userMap.get(uid);
    }

    public static synchronized List<User> getByName(String name) {
        if (name == null) {
            name = "";
        }
        ArrayList<User> ret = new ArrayList<User>();
        for (User user : userMap.values()) {
            if (!user.hasName(name)) continue;
            ret.add(user);
        }
        return ret;
    }

    public static User getAnonymous() {
        return ANONYMOUS;
    }

    public String getName() {
        return this.names.isEmpty() ? "" : (String)this.names.iterator().next();
    }

    public List<String> getNames() {
        return new ArrayList<String>(this.names);
    }

    public void addName(String name) {
        this.names.add(Objects.requireNonNull(name, "name"));
    }

    public void setPreferredName(String name) {
        if (this.names.size() == 1 && this.names.contains(name)) {
            return;
        }
        LinkedHashSet<String> allNames = new LinkedHashSet<String>(this.names);
        this.names.clear();
        this.names.add(Objects.requireNonNull(name, "name"));
        this.names.addAll(allNames);
    }

    public boolean hasName(String name) {
        return this.names.contains(name);
    }

    public long getId() {
        return this.uid;
    }

    private User(long uid, String name) {
        this.uid = uid;
        if (name != null) {
            this.addName(name);
        }
    }

    public boolean isOsmUser() {
        return this.uid > 0L;
    }

    public boolean isLocalUser() {
        return this.uid < 0L;
    }

    public int hashCode() {
        return Objects.hash(this.uid);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        User user = (User)obj;
        return this.uid == user.uid;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("id:").append(this.uid);
        if (this.names.size() == 1) {
            s.append(" name:").append(this.getName());
        } else if (this.names.size() > 1) {
            s.append(String.format(" %d names:%s", this.names.size(), this.getName()));
        }
        return s.toString();
    }

    static {
        userMap = new HashMap<Long, User>();
        ANONYMOUS = User.createLocalUser(I18n.tr("<anonymous>", new Object[0]));
    }
}

