/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto.eddsa.math.bigint;

import java.math.BigInteger;
import net.i2p.crypto.eddsa.math.Field;
import net.i2p.crypto.eddsa.math.ScalarOps;
import net.i2p.crypto.eddsa.math.bigint.BigIntegerLittleEndianEncoding;

public class BigIntegerScalarOps
implements ScalarOps {
    private final BigInteger l;
    private final BigIntegerLittleEndianEncoding enc;

    public BigIntegerScalarOps(Field field, BigInteger bigInteger) {
        this.l = bigInteger;
        this.enc = new BigIntegerLittleEndianEncoding();
        this.enc.setField(field);
    }

    @Override
    public byte[] reduce(byte[] byArray) {
        return this.enc.encode(this.enc.toBigInteger(byArray).mod(this.l));
    }

    @Override
    public byte[] multiplyAndAdd(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return this.enc.encode(this.enc.toBigInteger(byArray).multiply(this.enc.toBigInteger(byArray2)).add(this.enc.toBigInteger(byArray3)).mod(this.l));
    }
}

