/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.oasis;

import java.awt.Color;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRBoxContainer;
import net.sf.jasperreports.engine.JRCommonGraphicElement;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.export.oasis.CellStyle;
import net.sf.jasperreports.engine.export.oasis.FrameStyle;
import net.sf.jasperreports.engine.export.oasis.GraphicStyle;
import net.sf.jasperreports.engine.export.oasis.ParagraphStyle;
import net.sf.jasperreports.engine.util.JRColorUtil;

public class StyleCache {
    private Writer styleWriter = null;
    private Map fontMap = null;
    private Set fontFaces = new HashSet();
    private Map frameStyles = new HashMap();
    private int frameStylesCounter = 0;
    private Map cellStyles = new HashMap();
    private int cellStylesCounter = 0;
    private Map graphicStyles = new HashMap();
    private int graphicStylesCounter = 0;
    private Map paragraphStyles = new HashMap();
    private int paragraphStylesCounter = 0;
    private Map textSpanStyles = new HashMap();
    private int textSpanStylesCounter = 0;

    public StyleCache(Writer styleWriter, Map fontMap) {
        this.styleWriter = styleWriter;
        this.fontMap = fontMap;
    }

    public Collection getFontFaces() {
        return this.fontFaces;
    }

    public String getFrameStyle(JRPrintText text) throws IOException {
        FrameStyle frameStyle = new FrameStyle(this.styleWriter, text);
        frameStyle.setBox(text.getLineBox());
        String frameStyleId = frameStyle.getId();
        String frameStyleName = (String)this.frameStyles.get(frameStyleId);
        if (frameStyleName == null) {
            frameStyleName = "F" + this.frameStylesCounter++;
            this.frameStyles.put(frameStyleId, frameStyleName);
            frameStyle.write(frameStyleName);
        }
        return frameStyleName;
    }

    public String getFrameStyle(JRPrintElement element) throws IOException {
        FrameStyle frameStyle = new FrameStyle(this.styleWriter, element);
        String frameStyleId = frameStyle.getId();
        String frameStyleName = (String)this.frameStyles.get(frameStyleId);
        if (frameStyleName == null) {
            frameStyleName = "F" + this.frameStylesCounter++;
            this.frameStyles.put(frameStyleId, frameStyleName);
            frameStyle.write(frameStyleName);
        }
        return frameStyleName;
    }

    public String getGraphicStyle(JRPrintGraphicElement element) throws IOException {
        GraphicStyle graphicStyle = new GraphicStyle(this.styleWriter, element);
        String graphicStyleId = graphicStyle.getId();
        String graphicStyleName = (String)this.cellStyles.get(graphicStyleId);
        if (graphicStyleName == null) {
            graphicStyleName = "G" + this.graphicStylesCounter++;
            this.graphicStyles.put(graphicStyleId, graphicStyleName);
            graphicStyle.write(graphicStyleName);
        }
        return graphicStyleName;
    }

    public String getCellStyle(JRPrintElement element) throws IOException {
        String cellStyleId;
        String cellStyleName;
        CellStyle cellStyle = new CellStyle(this.styleWriter, element);
        if (element instanceof JRBoxContainer) {
            cellStyle.setBox(((JRBoxContainer)((Object)element)).getLineBox());
        }
        if (element instanceof JRCommonGraphicElement) {
            cellStyle.setPen(((JRCommonGraphicElement)((Object)element)).getLinePen());
        }
        if ((cellStyleName = (String)this.cellStyles.get(cellStyleId = cellStyle.getId())) == null) {
            cellStyleName = "C" + this.cellStylesCounter++;
            this.cellStyles.put(cellStyleId, cellStyleName);
            cellStyle.write(cellStyleName);
        }
        return cellStyleName;
    }

    public String getParagraphStyle(JRPrintText text) throws IOException {
        ParagraphStyle paragraphStyle = new ParagraphStyle(this.styleWriter, text);
        String paragraphStyleId = paragraphStyle.getId();
        String paragraphStyleName = (String)this.paragraphStyles.get(paragraphStyleId);
        if (paragraphStyleName == null) {
            paragraphStyleName = "P" + this.paragraphStylesCounter++;
            this.paragraphStyles.put(paragraphStyleId, paragraphStyleName);
            paragraphStyle.write(paragraphStyleName);
        }
        return paragraphStyleName;
    }

    public String getTextSpanStyle(Map attributes, String text) throws IOException {
        String textSpanStyleId;
        String textSpanStyleName;
        String fontFamilyAttr = (String)attributes.get(TextAttribute.FAMILY);
        String fontFamily = this.fontMap != null && this.fontMap.containsKey(fontFamilyAttr) ? (String)this.fontMap.get(fontFamilyAttr) : fontFamilyAttr;
        this.fontFaces.add(fontFamily);
        StringBuffer textSpanStyleIdBuffer = new StringBuffer();
        textSpanStyleIdBuffer.append(fontFamily);
        String forecolorHexa = null;
        Color forecolor = (Color)attributes.get(TextAttribute.FOREGROUND);
        if (!Color.black.equals(forecolor)) {
            forecolorHexa = JRColorUtil.getColorHexa(forecolor);
            textSpanStyleIdBuffer.append(forecolorHexa);
        }
        String backcolorHexa = null;
        Color runBackcolor = (Color)attributes.get(TextAttribute.BACKGROUND);
        if (runBackcolor != null) {
            backcolorHexa = JRColorUtil.getColorHexa(runBackcolor);
            textSpanStyleIdBuffer.append(backcolorHexa);
        }
        String size = String.valueOf(attributes.get(TextAttribute.SIZE));
        textSpanStyleIdBuffer.append(size);
        String weight = null;
        if (TextAttribute.WEIGHT_BOLD.equals(attributes.get(TextAttribute.WEIGHT))) {
            weight = "bold";
            textSpanStyleIdBuffer.append(weight);
        }
        String posture = null;
        if (TextAttribute.POSTURE_OBLIQUE.equals(attributes.get(TextAttribute.POSTURE))) {
            posture = "italic";
            textSpanStyleIdBuffer.append(posture);
        }
        String underline = null;
        if (TextAttribute.UNDERLINE_ON.equals(attributes.get(TextAttribute.UNDERLINE))) {
            underline = "single";
            textSpanStyleIdBuffer.append(underline);
        }
        String strikeThrough = null;
        if (TextAttribute.STRIKETHROUGH_ON.equals(attributes.get(TextAttribute.STRIKETHROUGH))) {
            strikeThrough = "single";
            textSpanStyleIdBuffer.append(strikeThrough);
        }
        if ((textSpanStyleName = (String)this.textSpanStyles.get(textSpanStyleId = textSpanStyleIdBuffer.toString())) == null) {
            textSpanStyleName = "T" + this.textSpanStylesCounter++;
            this.textSpanStyles.put(textSpanStyleId, textSpanStyleName);
            this.styleWriter.write("<style:style style:name=\"" + textSpanStyleName + "\"");
            this.styleWriter.write(" style:family=\"text\">\n");
            this.styleWriter.write("<style:text-properties");
            if (forecolorHexa != null) {
                this.styleWriter.write(" fo:color=\"#" + forecolorHexa + "\"");
            }
            this.styleWriter.write(" style:font-name=\"" + fontFamily + "\"");
            this.styleWriter.write(" fo:font-size=\"" + size + "pt\"");
            if (posture != null) {
                this.styleWriter.write(" fo:font-style=\"" + posture + "\"");
            }
            if (weight != null) {
                this.styleWriter.write(" fo:font-weight=\"" + weight + "\"");
            }
            if (backcolorHexa != null) {
                this.styleWriter.write(" fo:background-color=\"#" + backcolorHexa + "\"");
            }
            if (underline != null) {
                this.styleWriter.write(" style:text-underline-type=\"" + underline + "\"");
            }
            if (strikeThrough != null) {
                this.styleWriter.write(" style:text-line-through-type=\"" + strikeThrough + "\"");
            }
            this.styleWriter.write(">\n");
            this.styleWriter.write("</style:text-properties>\n");
            this.styleWriter.write("</style:style>\n");
        }
        return textSpanStyleName;
    }
}

