/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.record.cipher;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.AlgorithmResolver;
import de.rub.nds.tlsattacker.core.constants.CipherAlgorithm;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.ExtensionType;
import de.rub.nds.tlsattacker.core.crypto.cipher.CipherWrapper;
import de.rub.nds.tlsattacker.core.crypto.mac.MacWrapper;
import de.rub.nds.tlsattacker.core.crypto.mac.WrappedMac;
import de.rub.nds.tlsattacker.core.exceptions.CryptoException;
import de.rub.nds.tlsattacker.core.protocol.parser.Parser;
import de.rub.nds.tlsattacker.core.record.BlobRecord;
import de.rub.nds.tlsattacker.core.record.Record;
import de.rub.nds.tlsattacker.core.record.RecordCryptoComputations;
import de.rub.nds.tlsattacker.core.record.cipher.RecordCipher;
import de.rub.nds.tlsattacker.core.record.cipher.cryptohelper.KeySet;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class RecordBlockCipher
extends RecordCipher {
    private static final Logger LOGGER = LogManager.getLogger();
    private boolean useExplicitIv;
    private WrappedMac readMac;
    private WrappedMac writeMac;

    public RecordBlockCipher(TlsContext context, KeySet keySet) {
        super(context, keySet);
        ConnectionEndType localConEndType = context.getConnection().getLocalConnectionEndType();
        try {
            this.encryptCipher = CipherWrapper.getEncryptionCipher(this.cipherSuite, localConEndType, this.getKeySet());
            this.decryptCipher = CipherWrapper.getDecryptionCipher(this.cipherSuite, localConEndType, this.getKeySet());
            this.readMac = MacWrapper.getMac(this.version, this.cipherSuite, this.getKeySet().getReadMacSecret(localConEndType));
            this.writeMac = MacWrapper.getMac(this.version, this.cipherSuite, this.getKeySet().getWriteMacSecret(localConEndType));
            if (this.version.usesExplicitIv()) {
                this.useExplicitIv = true;
            } else {
                this.useExplicitIv = false;
                this.encryptCipher.setIv(keySet.getWriteIv(localConEndType));
                this.decryptCipher.setIv(keySet.getReadIv(localConEndType));
            }
        }
        catch (NoSuchAlgorithmException E) {
            throw new UnsupportedOperationException("Unsupported Ciphersuite:" + this.cipherSuite.name(), E);
        }
    }

    private byte[] calculateMac(byte[] data, ConnectionEndType connectionEndType) {
        LOGGER.debug("The MAC was calculated over the following data: {}", (Object)ArrayConverter.bytesToHexString((byte[])data));
        byte[] result = connectionEndType == this.context.getChooser().getConnectionEndType() ? this.writeMac.calculateMac(data) : this.readMac.calculateMac(data);
        LOGGER.debug("MAC: {}", (Object)ArrayConverter.bytesToHexString((byte[])result));
        return result;
    }

    private byte[] encrypt(byte[] plaintext, byte[] iv) throws CryptoException {
        byte[] expandedPlaintext = this.expandToBlocksize(plaintext);
        byte[] ciphertext = this.encryptCipher.encrypt(iv, expandedPlaintext);
        if (!this.useExplicitIv) {
            this.encryptCipher.setIv(this.extractNextEncryptIv(ciphertext));
        }
        LOGGER.debug("EncryptIv: " + ArrayConverter.bytesToHexString((byte[])this.encryptCipher.getIv()));
        return ciphertext;
    }

    private byte[] extractNextEncryptIv(byte[] ciphertext) {
        return Arrays.copyOfRange(ciphertext, ciphertext.length - this.encryptCipher.getBlocksize(), ciphertext.length);
    }

    private byte[] expandToBlocksize(byte[] plaintext) {
        byte[] expandedPlaintext = plaintext;
        int blocksize = this.encryptCipher.getBlocksize();
        if (plaintext != null && blocksize > 0 && plaintext.length % blocksize != 0) {
            int numberOfBlocks = plaintext.length / blocksize + 1;
            expandedPlaintext = new byte[numberOfBlocks * blocksize];
            System.arraycopy(plaintext, 0, expandedPlaintext, 0, plaintext.length);
        }
        return expandedPlaintext;
    }

    public byte[] calculatePadding(int paddingLength) {
        paddingLength = Math.abs(paddingLength);
        byte[] padding = new byte[paddingLength];
        for (int i = 0; i < paddingLength; ++i) {
            padding[i] = (byte)(paddingLength - 1);
        }
        return padding;
    }

    public int calculatePaddingLength(Record record, int dataLength) {
        int additionalPadding = this.context.getConfig().getDefaultAdditionalPadding();
        if (additionalPadding > 256) {
            LOGGER.warn("Additional padding is too big. setting it to max possible value");
            additionalPadding = 256;
        } else if (additionalPadding < 0) {
            LOGGER.warn("Additional padding is negative, setting it to 0");
            additionalPadding = 0;
        }
        record.getComputations().setAdditionalPaddingLength(additionalPadding);
        additionalPadding = (Integer)record.getComputations().getAdditionalPaddingLength().getValue();
        if (additionalPadding % this.encryptCipher.getBlocksize() != 0) {
            LOGGER.warn("Additional padding is not a multiple of the blocksize");
        }
        return this.encryptCipher.getBlocksize() - dataLength % this.encryptCipher.getBlocksize() + additionalPadding;
    }

    public byte[] getEncryptionIV() {
        if (this.useExplicitIv) {
            LOGGER.debug("Using explict IV");
            CipherAlgorithm cipherAlgorithm = AlgorithmResolver.getCipher(this.cipherSuite);
            byte[] iv = new byte[cipherAlgorithm.getNonceBytesFromHandshake()];
            this.context.getRandom().nextBytes(iv);
            return iv;
        }
        LOGGER.debug("Using implicit IV");
        byte[] tempIv = this.encryptCipher.getIv();
        if (tempIv == null) {
            LOGGER.debug("First IV - using from Keyblock");
            ConnectionEndType localConEndType = this.context.getConnection().getLocalConnectionEndType();
            return this.getKeySet().getWriteIv(localConEndType);
        }
        return tempIv;
    }

    @Override
    public void encrypt(Record record) throws CryptoException {
        if (record.getComputations() == null) {
            LOGGER.warn("Record computations are not prepared.");
            record.prepareComputations();
        }
        LOGGER.debug("Encrypting Record:");
        RecordCryptoComputations computations = record.getComputations();
        record.getComputations().setMacKey(this.getKeySet().getWriteMacSecret(this.context.getChooser().getConnectionEndType()));
        record.getComputations().setCipherKey(this.getKeySet().getWriteKey(this.context.getChooser().getConnectionEndType()));
        byte[] iv = this.getEncryptionIV();
        record.getComputations().setCbcInitialisationVector(iv);
        iv = (byte[])record.getComputations().getCbcInitialisationVector().getValue();
        byte[] cleanBytes = (byte[])record.getCleanProtocolMessageBytes().getValue();
        if (this.context.isExtensionNegotiated(ExtensionType.ENCRYPT_THEN_MAC)) {
            computations.setPadding(this.calculatePadding(this.calculatePaddingLength(record, cleanBytes.length)));
            computations.setPlainRecordBytes(ArrayConverter.concatenate((byte[][])new byte[][]{cleanBytes, (byte[])computations.getPadding().getValue()}));
            byte[] ciphertext = this.encrypt((byte[])computations.getPlainRecordBytes().getValue(), iv);
            computations.setCiphertext(ciphertext);
            if (this.useExplicitIv) {
                computations.setAuthenticatedNonMetaData(ArrayConverter.concatenate((byte[][])new byte[][]{iv, (byte[])record.getComputations().getCiphertext().getValue()}));
            } else {
                computations.setAuthenticatedNonMetaData((byte[])record.getComputations().getCiphertext().getValue());
            }
            computations.setAuthenticatedMetaData(this.collectAdditionalAuthenticatedData(record, this.version));
            computations.setMac(this.calculateMac(ArrayConverter.concatenate((byte[][])new byte[][]{(byte[])computations.getAuthenticatedMetaData().getValue(), (byte[])computations.getAuthenticatedNonMetaData().getValue()}), this.context.getConnection().getLocalConnectionEndType()));
            if (this.useExplicitIv) {
                record.setProtocolMessageBytes(ArrayConverter.concatenate((byte[][])new byte[][]{iv, (byte[])computations.getCiphertext().getValue(), (byte[])computations.getMac().getValue()}));
            } else {
                record.setProtocolMessageBytes(ArrayConverter.concatenate((byte[][])new byte[][]{(byte[])computations.getCiphertext().getValue(), (byte[])computations.getMac().getValue()}));
            }
        } else {
            computations.setAuthenticatedNonMetaData(cleanBytes);
            computations.setAuthenticatedMetaData(this.collectAdditionalAuthenticatedData(record, this.version));
            computations.setMac(this.calculateMac(ArrayConverter.concatenate((byte[][])new byte[][]{(byte[])computations.getAuthenticatedMetaData().getValue(), (byte[])computations.getAuthenticatedNonMetaData().getValue()}), this.context.getConnection().getLocalConnectionEndType()));
            computations.setPadding(this.calculatePadding(this.calculatePaddingLength(record, cleanBytes.length + ((byte[])computations.getMac().getValue()).length)));
            record.getComputations().setPlainRecordBytes(ArrayConverter.concatenate((byte[][])new byte[][]{cleanBytes, (byte[])computations.getMac().getValue(), (byte[])computations.getPadding().getValue()}));
            computations.setCiphertext(this.encrypt((byte[])record.getComputations().getPlainRecordBytes().getValue(), iv));
            if (this.useExplicitIv) {
                record.setProtocolMessageBytes(ArrayConverter.concatenate((byte[][])new byte[][]{iv, (byte[])computations.getCiphertext().getValue()}));
            } else {
                record.setProtocolMessageBytes(computations.getCiphertext());
            }
        }
        computations.setPaddingValid(true);
        computations.setMacValid(true);
    }

    @Override
    public void decrypt(Record record) throws CryptoException {
        byte[] iv;
        if (record.getComputations() == null) {
            LOGGER.warn("Record computations are not preapred.");
            record.prepareComputations();
        }
        LOGGER.debug("Decrypting Record");
        RecordCryptoComputations computations = record.getComputations();
        computations.setMacKey(this.getKeySet().getReadMacSecret(this.context.getChooser().getConnectionEndType()));
        computations.setCipherKey(this.getKeySet().getReadKey(this.context.getChooser().getConnectionEndType()));
        byte[] plaintext = (byte[])record.getProtocolMessageBytes().getValue();
        DecryptionParser parser = new DecryptionParser(0, plaintext);
        CipherSuite cipherSuite = this.context.getChooser().getSelectedCipherSuite();
        if (this.useExplicitIv) {
            LOGGER.debug("Using explicit IV");
            CipherAlgorithm cipherAlgorithm = AlgorithmResolver.getCipher(cipherSuite);
            iv = parser.parseByteArrayField(cipherAlgorithm.getNonceBytesFromHandshake());
        } else {
            LOGGER.debug("Using implicit IV");
            iv = this.decryptCipher.getIv();
        }
        LOGGER.debug("Using IV:" + ArrayConverter.bytesToHexString((byte[])iv));
        record.getComputations().setCbcInitialisationVector(iv);
        if (this.context.isExtensionNegotiated(ExtensionType.ENCRYPT_THEN_MAC)) {
            int macLength = this.readMac.getMacLength();
            int toParseCiphertextLenght = parser.getBytesLeft() - macLength;
            if (toParseCiphertextLenght < 0) {
                throw new CryptoException("Record too small");
            }
            byte[] ciphertext = parser.parseByteArrayField(toParseCiphertextLenght);
            computations.setCiphertext(ciphertext);
            byte[] hmac = parser.parseByteArrayField(macLength);
            computations.setMac(hmac);
            byte[] plainData = this.decryptCipher.decrypt(iv, ciphertext);
            computations.setPlainRecordBytes(plainData);
            plainData = (byte[])computations.getPlainRecordBytes().getValue();
            LOGGER.info(ArrayConverter.bytesToHexString((byte[])plainData));
            parser = new DecryptionParser(0, plainData);
            byte[] cleanProtocolBytes = parser.parseByteArrayField(plainData.length - (plainData[plainData.length - 1] + 1));
            record.setCleanProtocolMessageBytes(cleanProtocolBytes);
            if (this.useExplicitIv) {
                computations.setAuthenticatedNonMetaData(ArrayConverter.concatenate((byte[][])new byte[][]{(byte[])record.getComputations().getCbcInitialisationVector().getValue(), (byte[])record.getComputations().getCiphertext().getValue()}));
            } else {
                computations.setAuthenticatedNonMetaData((byte[])record.getComputations().getCiphertext().getValue());
            }
            computations.setAuthenticatedMetaData(this.collectAdditionalAuthenticatedData(record, this.version));
            byte[] padding = parser.parseByteArrayField(plainData[plainData.length - 1] + 1);
            computations.setPadding(padding);
            computations.setPaddingValid(this.isPaddingValid(padding));
            byte[] calculatedHMAC = this.calculateMac(ArrayConverter.concatenate((byte[][])new byte[][]{(byte[])computations.getAuthenticatedMetaData().getValue(), (byte[])computations.getAuthenticatedNonMetaData().getValue()}), this.context.getConnection().getLocalConnectionEndType().getPeer());
            computations.setMacValid(Arrays.equals(calculatedHMAC, (byte[])computations.getMac().getValue()));
        } else {
            byte[] ciphertext = parser.parseByteArrayField(parser.getBytesLeft());
            computations.setCiphertext(ciphertext);
            ciphertext = (byte[])computations.getCiphertext().getValue();
            byte[] plainData = this.decryptCipher.decrypt(iv, ciphertext);
            computations.setPlainRecordBytes(plainData);
            plainData = (byte[])computations.getPlainRecordBytes().getValue();
            parser = new DecryptionParser(0, plainData);
            byte[] cleanProtocolBytes = parser.parseByteArrayField(plainData.length - this.readMac.getMacLength() - (plainData[plainData.length - 1] + 1));
            record.setCleanProtocolMessageBytes(cleanProtocolBytes);
            byte[] hmac = parser.parseByteArrayField(this.readMac.getMacLength());
            record.getComputations().setMac(hmac);
            byte[] padding = parser.parseByteArrayField(plainData[plainData.length - 1] + 1);
            computations.setPadding(padding);
            computations.setAuthenticatedNonMetaData(cleanProtocolBytes);
            computations.setAuthenticatedMetaData(this.collectAdditionalAuthenticatedData(record, this.version));
            computations.setPaddingValid(this.isPaddingValid(padding));
            byte[] calculatedHMAC = this.calculateMac(ArrayConverter.concatenate((byte[][])new byte[][]{(byte[])computations.getAuthenticatedMetaData().getValue(), (byte[])computations.getAuthenticatedNonMetaData().getValue()}), this.context.getConnection().getLocalConnectionEndType().getPeer());
            computations.setMacValid(Arrays.equals(calculatedHMAC, (byte[])computations.getMac().getValue()));
        }
    }

    private boolean isPaddingValid(byte[] padding) {
        if (this.context.getChooser().getSelectedProtocolVersion().isSSL()) {
            return padding.length == padding[padding.length - 1] + 1;
        }
        for (int i = 0; i < padding.length; ++i) {
            if (padding[i] == padding.length - 1) continue;
            LOGGER.debug("Padding is invalid");
            return false;
        }
        LOGGER.debug("Padding is valid");
        return true;
    }

    @Override
    public void encrypt(BlobRecord br) throws CryptoException {
        LOGGER.debug("Encrypting BlobRecord");
        br.setProtocolMessageBytes(this.encryptCipher.encrypt((byte[])br.getCleanProtocolMessageBytes().getValue()));
    }

    @Override
    public void decrypt(BlobRecord br) throws CryptoException {
        LOGGER.debug("Derypting BlobRecord");
        br.setCleanProtocolMessageBytes(this.decryptCipher.decrypt((byte[])br.getProtocolMessageBytes().getValue()));
    }

    class DecryptionParser
    extends Parser<Object> {
        public DecryptionParser(int startposition, byte[] array) {
            super(startposition, array);
        }

        @Override
        public Object parse() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public byte[] parseByteArrayField(int length) {
            return super.parseByteArrayField(length);
        }

        @Override
        public int getBytesLeft() {
            return super.getBytesLeft();
        }

        @Override
        public int getPointer() {
            return super.getPointer();
        }
    }
}

