/* $OpenBSD$ */
/* ====================================================================
 * Copyright (c) 2001-2002 The OpenSSL Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by the OpenSSL Project
 *    for use in the OpenSSL Toolkit. (http://www.openssl.org/)"
 *
 * 4. The names "OpenSSL Toolkit" and "OpenSSL Project" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission. For written permission, please contact
 *    openssl-core@openssl.org.
 *
 * 5. Products derived from this software may not be called "OpenSSL"
 *    nor may "OpenSSL" appear in their names without prior written
 *    permission of the OpenSSL Project.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by the OpenSSL Project
 *    for use in the OpenSSL Toolkit (http://www.openssl.org/)"
 *
 * THIS SOFTWARE IS PROVIDED BY THE OpenSSL PROJECT ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE OpenSSL PROJECT OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * This product includes cryptographic software written by Eric Young
 * (eay@cryptsoft.com).  This product includes software written by Tim
 * Hudson (tjh@cryptsoft.com).
 *
 */

#include <string.h>

#include <openssl/ui_compat.h>

#include "ui_locl.h"

int
UI_UTIL_read_pw_string(char *buf, int length, const char *prompt, int verify)
{
	char buff[BUFSIZ];
	int ret;

	ret = UI_UTIL_read_pw(buf, buff, (length > BUFSIZ) ? BUFSIZ : length,
	    prompt, verify);
	OPENSSL_cleanse(buff, BUFSIZ);
	return (ret);
}

int
UI_UTIL_read_pw(char *buf, char *buff, int size, const char *prompt, int verify)
{
	int ok = 0;
	UI *ui;

	if (size < 1)
		return -1;

	ui = UI_new();
	if (ui) {
		ok = UI_add_input_string(ui, prompt, 0, buf, 0, size - 1);
		if (ok >= 0 && verify)
			ok = UI_add_verify_string(ui, prompt, 0, buff, 0,
			    size - 1, buf);
		if (ok >= 0)
			ok = UI_process(ui);
		UI_free(ui);
	}
	if (ok > 0)
		ok = 0;
	return (ok);
}

/*
 * Old compatibility glue - see comment in ui_compat.h.
 */
int
_ossl_old_des_read_pw_string(char *buf, int length, const char *prompt, int verify)
{
	return UI_UTIL_read_pw_string(buf, length, prompt, verify);
}

int
_ossl_old_des_read_pw(char *buf, char *buff, int size, const char *prompt, int verify)
{
	return UI_UTIL_read_pw(buf, buff, size, prompt, verify);
}
