/* $OpenBSD: evp.h,v 1.6 2024/08/31 10:38:49 tb Exp $ */
/*
 * Copyright (c) 2024 Bob Beck <beck@openbsd.org>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef _LIBCRYPTO_EVP_H
#define _LIBCRYPTO_EVP_H

#ifndef _MSC_VER
#include_next <openssl/evp.h>
#else
#include "../include/openssl/evp.h"
#endif
#include "crypto_namespace.h"

LCRYPTO_USED(EVP_MD_type);
LCRYPTO_USED(EVP_MD_pkey_type);
LCRYPTO_USED(EVP_MD_size);
LCRYPTO_USED(EVP_MD_block_size);
LCRYPTO_USED(EVP_MD_flags);
LCRYPTO_USED(EVP_MD_CTX_md);
LCRYPTO_USED(EVP_MD_CTX_md_data);
LCRYPTO_USED(EVP_MD_CTX_pkey_ctx);
LCRYPTO_USED(EVP_MD_CTX_set_pkey_ctx);
LCRYPTO_USED(EVP_CIPHER_nid);
LCRYPTO_USED(EVP_CIPHER_block_size);
LCRYPTO_USED(EVP_CIPHER_key_length);
LCRYPTO_USED(EVP_CIPHER_iv_length);
LCRYPTO_USED(EVP_CIPHER_flags);
LCRYPTO_USED(EVP_CIPHER_CTX_cipher);
LCRYPTO_USED(EVP_CIPHER_CTX_encrypting);
LCRYPTO_USED(EVP_CIPHER_CTX_nid);
LCRYPTO_USED(EVP_CIPHER_CTX_block_size);
LCRYPTO_USED(EVP_CIPHER_CTX_key_length);
LCRYPTO_USED(EVP_CIPHER_CTX_iv_length);
LCRYPTO_USED(EVP_CIPHER_CTX_get_iv);
LCRYPTO_USED(EVP_CIPHER_CTX_set_iv);
LCRYPTO_USED(EVP_CIPHER_CTX_copy);
LCRYPTO_USED(EVP_CIPHER_CTX_get_app_data);
LCRYPTO_USED(EVP_CIPHER_CTX_set_app_data);
LCRYPTO_USED(EVP_CIPHER_CTX_get_cipher_data);
LCRYPTO_USED(EVP_CIPHER_CTX_set_cipher_data);
LCRYPTO_USED(EVP_CIPHER_CTX_buf_noconst);
LCRYPTO_USED(EVP_CIPHER_CTX_flags);
LCRYPTO_USED(EVP_CIPHER_meth_new);
LCRYPTO_USED(EVP_CIPHER_meth_dup);
LCRYPTO_USED(EVP_CIPHER_meth_free);
LCRYPTO_USED(EVP_CIPHER_meth_set_iv_length);
LCRYPTO_USED(EVP_CIPHER_meth_set_flags);
LCRYPTO_USED(EVP_CIPHER_meth_set_impl_ctx_size);
LCRYPTO_USED(EVP_CIPHER_meth_set_init);
LCRYPTO_USED(EVP_CIPHER_meth_set_do_cipher);
LCRYPTO_USED(EVP_CIPHER_meth_set_cleanup);
LCRYPTO_USED(EVP_CIPHER_meth_set_set_asn1_params);
LCRYPTO_USED(EVP_CIPHER_meth_set_get_asn1_params);
LCRYPTO_USED(EVP_CIPHER_meth_set_ctrl);
LCRYPTO_USED(EVP_PKEY_new_raw_private_key);
LCRYPTO_USED(EVP_PKEY_new_raw_public_key);
LCRYPTO_USED(EVP_PKEY_get_raw_private_key);
LCRYPTO_USED(EVP_PKEY_get_raw_public_key);
LCRYPTO_USED(EVP_Cipher);
LCRYPTO_USED(EVP_MD_CTX_new);
LCRYPTO_USED(EVP_MD_CTX_free);
LCRYPTO_USED(EVP_MD_CTX_reset);
LCRYPTO_USED(EVP_MD_CTX_create);
LCRYPTO_USED(EVP_MD_CTX_destroy);
LCRYPTO_USED(EVP_MD_CTX_cleanup);
LCRYPTO_USED(EVP_MD_CTX_copy_ex);
LCRYPTO_USED(EVP_MD_CTX_set_flags);
LCRYPTO_USED(EVP_MD_CTX_clear_flags);
LCRYPTO_USED(EVP_MD_CTX_ctrl);
LCRYPTO_USED(EVP_MD_CTX_test_flags);
LCRYPTO_USED(EVP_DigestInit_ex);
LCRYPTO_USED(EVP_DigestUpdate);
LCRYPTO_USED(EVP_DigestFinal_ex);
LCRYPTO_USED(EVP_Digest);
LCRYPTO_USED(EVP_MD_CTX_copy);
LCRYPTO_USED(EVP_DigestInit);
LCRYPTO_USED(EVP_DigestFinal);
LCRYPTO_USED(EVP_read_pw_string);
LCRYPTO_USED(EVP_read_pw_string_min);
LCRYPTO_USED(EVP_set_pw_prompt);
LCRYPTO_USED(EVP_get_pw_prompt);
LCRYPTO_USED(EVP_BytesToKey);
LCRYPTO_USED(EVP_CIPHER_CTX_set_flags);
LCRYPTO_USED(EVP_CIPHER_CTX_clear_flags);
LCRYPTO_USED(EVP_CIPHER_CTX_test_flags);
LCRYPTO_USED(EVP_EncryptInit);
LCRYPTO_USED(EVP_EncryptInit_ex);
LCRYPTO_USED(EVP_EncryptUpdate);
LCRYPTO_USED(EVP_EncryptFinal_ex);
LCRYPTO_USED(EVP_DecryptInit);
LCRYPTO_USED(EVP_DecryptInit_ex);
LCRYPTO_USED(EVP_DecryptUpdate);
LCRYPTO_USED(EVP_DecryptFinal_ex);
LCRYPTO_USED(EVP_CipherInit);
LCRYPTO_USED(EVP_CipherInit_ex);
LCRYPTO_USED(EVP_CipherUpdate);
LCRYPTO_USED(EVP_CipherFinal_ex);
LCRYPTO_USED(EVP_SignFinal);
LCRYPTO_USED(EVP_VerifyFinal);
LCRYPTO_USED(EVP_DigestSignInit);
LCRYPTO_USED(EVP_DigestSignFinal);
LCRYPTO_USED(EVP_DigestSign);
LCRYPTO_USED(EVP_DigestVerifyInit);
LCRYPTO_USED(EVP_DigestVerifyFinal);
LCRYPTO_USED(EVP_DigestVerify);
LCRYPTO_USED(EVP_OpenInit);
LCRYPTO_USED(EVP_OpenFinal);
LCRYPTO_USED(EVP_SealInit);
LCRYPTO_USED(EVP_SealFinal);
LCRYPTO_USED(EVP_ENCODE_CTX_new);
LCRYPTO_USED(EVP_ENCODE_CTX_free);
LCRYPTO_USED(EVP_EncodeInit);
LCRYPTO_USED(EVP_EncodeUpdate);
LCRYPTO_USED(EVP_EncodeFinal);
LCRYPTO_USED(EVP_EncodeBlock);
LCRYPTO_USED(EVP_DecodeInit);
LCRYPTO_USED(EVP_DecodeUpdate);
LCRYPTO_USED(EVP_DecodeFinal);
LCRYPTO_USED(EVP_DecodeBlock);
LCRYPTO_USED(EVP_CIPHER_CTX_cleanup);
LCRYPTO_USED(EVP_CIPHER_CTX_new);
LCRYPTO_USED(EVP_CIPHER_CTX_free);
LCRYPTO_USED(EVP_CIPHER_CTX_reset);
LCRYPTO_USED(EVP_CIPHER_CTX_set_key_length);
LCRYPTO_USED(EVP_CIPHER_CTX_set_padding);
LCRYPTO_USED(EVP_CIPHER_CTX_ctrl);
LCRYPTO_USED(EVP_CIPHER_CTX_rand_key);
LCRYPTO_USED(BIO_f_md);
LCRYPTO_USED(BIO_f_base64);
LCRYPTO_USED(BIO_f_cipher);
LCRYPTO_USED(BIO_set_cipher);
LCRYPTO_USED(EVP_md_null);
LCRYPTO_USED(EVP_md4);
LCRYPTO_USED(EVP_md5);
LCRYPTO_USED(EVP_md5_sha1);
LCRYPTO_USED(EVP_sha1);
LCRYPTO_USED(EVP_sha224);
LCRYPTO_USED(EVP_sha256);
LCRYPTO_USED(EVP_sha384);
LCRYPTO_USED(EVP_sha512);
LCRYPTO_USED(EVP_sha512_224);
LCRYPTO_USED(EVP_sha512_256);
LCRYPTO_USED(EVP_sha3_224);
LCRYPTO_USED(EVP_sha3_256);
LCRYPTO_USED(EVP_sha3_384);
LCRYPTO_USED(EVP_sha3_512);
LCRYPTO_USED(EVP_sm3);
LCRYPTO_USED(EVP_ripemd160);
LCRYPTO_USED(EVP_enc_null);
LCRYPTO_USED(EVP_des_ecb);
LCRYPTO_USED(EVP_des_ede);
LCRYPTO_USED(EVP_des_ede3);
LCRYPTO_USED(EVP_des_ede_ecb);
LCRYPTO_USED(EVP_des_ede3_ecb);
LCRYPTO_USED(EVP_des_cfb64);
LCRYPTO_USED(EVP_des_cfb1);
LCRYPTO_USED(EVP_des_cfb8);
LCRYPTO_USED(EVP_des_ede_cfb64);
LCRYPTO_USED(EVP_des_ede3_cfb64);
LCRYPTO_USED(EVP_des_ede3_cfb1);
LCRYPTO_USED(EVP_des_ede3_cfb8);
LCRYPTO_USED(EVP_des_ofb);
LCRYPTO_USED(EVP_des_ede_ofb);
LCRYPTO_USED(EVP_des_ede3_ofb);
LCRYPTO_USED(EVP_des_cbc);
LCRYPTO_USED(EVP_des_ede_cbc);
LCRYPTO_USED(EVP_des_ede3_cbc);
LCRYPTO_USED(EVP_desx_cbc);
LCRYPTO_USED(EVP_rc4);
LCRYPTO_USED(EVP_rc4_40);
LCRYPTO_USED(EVP_idea_ecb);
LCRYPTO_USED(EVP_idea_cfb64);
LCRYPTO_USED(EVP_idea_ofb);
LCRYPTO_USED(EVP_idea_cbc);
LCRYPTO_USED(EVP_rc2_ecb);
LCRYPTO_USED(EVP_rc2_cbc);
LCRYPTO_USED(EVP_rc2_40_cbc);
LCRYPTO_USED(EVP_rc2_64_cbc);
LCRYPTO_USED(EVP_rc2_cfb64);
LCRYPTO_USED(EVP_rc2_ofb);
LCRYPTO_USED(EVP_bf_ecb);
LCRYPTO_USED(EVP_bf_cbc);
LCRYPTO_USED(EVP_bf_cfb64);
LCRYPTO_USED(EVP_bf_ofb);
LCRYPTO_USED(EVP_cast5_ecb);
LCRYPTO_USED(EVP_cast5_cbc);
LCRYPTO_USED(EVP_cast5_cfb64);
LCRYPTO_USED(EVP_cast5_ofb);
LCRYPTO_USED(EVP_aes_128_ecb);
LCRYPTO_USED(EVP_aes_128_cbc);
LCRYPTO_USED(EVP_aes_128_cfb1);
LCRYPTO_USED(EVP_aes_128_cfb8);
LCRYPTO_USED(EVP_aes_128_cfb128);
LCRYPTO_USED(EVP_aes_128_ofb);
LCRYPTO_USED(EVP_aes_128_ctr);
LCRYPTO_USED(EVP_aes_128_ccm);
LCRYPTO_USED(EVP_aes_128_gcm);
LCRYPTO_USED(EVP_aes_128_wrap);
LCRYPTO_USED(EVP_aes_128_xts);
LCRYPTO_USED(EVP_aes_192_ecb);
LCRYPTO_USED(EVP_aes_192_cbc);
LCRYPTO_USED(EVP_aes_192_cfb1);
LCRYPTO_USED(EVP_aes_192_cfb8);
LCRYPTO_USED(EVP_aes_192_cfb128);
LCRYPTO_USED(EVP_aes_192_ofb);
LCRYPTO_USED(EVP_aes_192_ctr);
LCRYPTO_USED(EVP_aes_192_ccm);
LCRYPTO_USED(EVP_aes_192_gcm);
LCRYPTO_USED(EVP_aes_192_wrap);
LCRYPTO_USED(EVP_aes_256_ecb);
LCRYPTO_USED(EVP_aes_256_cbc);
LCRYPTO_USED(EVP_aes_256_cfb1);
LCRYPTO_USED(EVP_aes_256_cfb8);
LCRYPTO_USED(EVP_aes_256_cfb128);
LCRYPTO_USED(EVP_aes_256_ofb);
LCRYPTO_USED(EVP_aes_256_ctr);
LCRYPTO_USED(EVP_aes_256_ccm);
LCRYPTO_USED(EVP_aes_256_gcm);
LCRYPTO_USED(EVP_aes_256_wrap);
LCRYPTO_USED(EVP_aes_256_xts);
LCRYPTO_USED(EVP_chacha20_poly1305);
LCRYPTO_USED(EVP_camellia_128_ecb);
LCRYPTO_USED(EVP_camellia_128_cbc);
LCRYPTO_USED(EVP_camellia_128_cfb1);
LCRYPTO_USED(EVP_camellia_128_cfb8);
LCRYPTO_USED(EVP_camellia_128_cfb128);
LCRYPTO_USED(EVP_camellia_128_ofb);
LCRYPTO_USED(EVP_camellia_192_ecb);
LCRYPTO_USED(EVP_camellia_192_cbc);
LCRYPTO_USED(EVP_camellia_192_cfb1);
LCRYPTO_USED(EVP_camellia_192_cfb8);
LCRYPTO_USED(EVP_camellia_192_cfb128);
LCRYPTO_USED(EVP_camellia_192_ofb);
LCRYPTO_USED(EVP_camellia_256_ecb);
LCRYPTO_USED(EVP_camellia_256_cbc);
LCRYPTO_USED(EVP_camellia_256_cfb1);
LCRYPTO_USED(EVP_camellia_256_cfb8);
LCRYPTO_USED(EVP_camellia_256_cfb128);
LCRYPTO_USED(EVP_camellia_256_ofb);
LCRYPTO_USED(EVP_chacha20);
LCRYPTO_USED(EVP_sm4_ecb);
LCRYPTO_USED(EVP_sm4_cbc);
LCRYPTO_USED(EVP_sm4_cfb128);
LCRYPTO_USED(EVP_sm4_ofb);
LCRYPTO_USED(EVP_sm4_ctr);
LCRYPTO_USED(OPENSSL_add_all_algorithms_noconf);
LCRYPTO_USED(OPENSSL_add_all_algorithms_conf);
LCRYPTO_USED(OpenSSL_add_all_ciphers);
LCRYPTO_USED(OpenSSL_add_all_digests);
LCRYPTO_USED(EVP_get_cipherbyname);
LCRYPTO_USED(EVP_get_digestbyname);
LCRYPTO_USED(EVP_cleanup);
LCRYPTO_USED(EVP_CIPHER_do_all);
LCRYPTO_USED(EVP_CIPHER_do_all_sorted);
LCRYPTO_USED(EVP_MD_do_all);
LCRYPTO_USED(EVP_MD_do_all_sorted);
LCRYPTO_USED(EVP_PKEY_decrypt_old);
LCRYPTO_USED(EVP_PKEY_encrypt_old);
LCRYPTO_USED(EVP_PKEY_type);
LCRYPTO_USED(EVP_PKEY_id);
LCRYPTO_USED(EVP_PKEY_base_id);
LCRYPTO_USED(EVP_PKEY_bits);
LCRYPTO_USED(EVP_PKEY_security_bits);
LCRYPTO_USED(EVP_PKEY_size);
LCRYPTO_USED(EVP_PKEY_set_type);
LCRYPTO_USED(EVP_PKEY_set_type_str);
LCRYPTO_USED(EVP_PKEY_assign);
LCRYPTO_USED(EVP_PKEY_get0);
LCRYPTO_USED(EVP_PKEY_get0_hmac);
LCRYPTO_USED(EVP_PKEY_get0_RSA);
LCRYPTO_USED(EVP_PKEY_get1_RSA);
LCRYPTO_USED(EVP_PKEY_set1_RSA);
LCRYPTO_USED(EVP_PKEY_get0_DSA);
LCRYPTO_USED(EVP_PKEY_get1_DSA);
LCRYPTO_USED(EVP_PKEY_set1_DSA);
LCRYPTO_USED(EVP_PKEY_get0_DH);
LCRYPTO_USED(EVP_PKEY_get1_DH);
LCRYPTO_USED(EVP_PKEY_set1_DH);
LCRYPTO_USED(EVP_PKEY_get0_EC_KEY);
LCRYPTO_USED(EVP_PKEY_get1_EC_KEY);
LCRYPTO_USED(EVP_PKEY_set1_EC_KEY);
LCRYPTO_USED(EVP_PKEY_new);
LCRYPTO_USED(EVP_PKEY_free);
LCRYPTO_USED(EVP_PKEY_up_ref);
LCRYPTO_USED(d2i_PublicKey);
LCRYPTO_USED(i2d_PublicKey);
LCRYPTO_USED(d2i_PrivateKey);
LCRYPTO_USED(d2i_AutoPrivateKey);
LCRYPTO_USED(i2d_PrivateKey);
LCRYPTO_USED(EVP_PKEY_copy_parameters);
LCRYPTO_USED(EVP_PKEY_missing_parameters);
LCRYPTO_USED(EVP_PKEY_save_parameters);
LCRYPTO_USED(EVP_PKEY_cmp_parameters);
LCRYPTO_USED(EVP_PKEY_cmp);
LCRYPTO_USED(EVP_PKEY_print_public);
LCRYPTO_USED(EVP_PKEY_print_private);
LCRYPTO_USED(EVP_PKEY_print_params);
LCRYPTO_USED(EVP_PKEY_get_default_digest_nid);
LCRYPTO_USED(EVP_CIPHER_type);
LCRYPTO_USED(PKCS5_PBKDF2_HMAC_SHA1);
LCRYPTO_USED(PKCS5_PBKDF2_HMAC);
LCRYPTO_USED(EVP_PKEY_asn1_get_count);
LCRYPTO_USED(EVP_PKEY_asn1_get0);
LCRYPTO_USED(EVP_PKEY_asn1_find);
LCRYPTO_USED(EVP_PKEY_asn1_find_str);
LCRYPTO_USED(EVP_PKEY_asn1_get0_info);
LCRYPTO_USED(EVP_PKEY_get0_asn1);
LCRYPTO_USED(EVP_PKEY_CTX_new);
LCRYPTO_USED(EVP_PKEY_CTX_new_id);
LCRYPTO_USED(EVP_PKEY_CTX_dup);
LCRYPTO_USED(EVP_PKEY_CTX_free);
LCRYPTO_USED(EVP_PKEY_CTX_ctrl);
LCRYPTO_USED(EVP_PKEY_CTX_ctrl_str);
LCRYPTO_USED(EVP_PKEY_CTX_get_operation);
LCRYPTO_USED(EVP_PKEY_CTX_set0_keygen_info);
LCRYPTO_USED(EVP_PKEY_new_mac_key);
LCRYPTO_USED(EVP_PKEY_new_CMAC_key);
LCRYPTO_USED(EVP_PKEY_CTX_set_data);
LCRYPTO_USED(EVP_PKEY_CTX_get_data);
LCRYPTO_USED(EVP_PKEY_CTX_get0_pkey);
LCRYPTO_USED(EVP_PKEY_CTX_get0_peerkey);
LCRYPTO_USED(EVP_PKEY_CTX_set_app_data);
LCRYPTO_USED(EVP_PKEY_CTX_get_app_data);
LCRYPTO_USED(EVP_PKEY_sign_init);
LCRYPTO_USED(EVP_PKEY_sign);
LCRYPTO_USED(EVP_PKEY_verify_init);
LCRYPTO_USED(EVP_PKEY_verify);
LCRYPTO_USED(EVP_PKEY_verify_recover_init);
LCRYPTO_USED(EVP_PKEY_verify_recover);
LCRYPTO_USED(EVP_PKEY_encrypt_init);
LCRYPTO_USED(EVP_PKEY_encrypt);
LCRYPTO_USED(EVP_PKEY_decrypt_init);
LCRYPTO_USED(EVP_PKEY_decrypt);
LCRYPTO_USED(EVP_PKEY_derive_init);
LCRYPTO_USED(EVP_PKEY_derive_set_peer);
LCRYPTO_USED(EVP_PKEY_derive);
LCRYPTO_USED(EVP_PKEY_paramgen_init);
LCRYPTO_USED(EVP_PKEY_paramgen);
LCRYPTO_USED(EVP_PKEY_keygen_init);
LCRYPTO_USED(EVP_PKEY_keygen);
LCRYPTO_USED(EVP_PKEY_CTX_set_cb);
LCRYPTO_USED(EVP_PKEY_CTX_get_cb);
LCRYPTO_USED(EVP_PKEY_CTX_get_keygen_info);
LCRYPTO_USED(EVP_aead_aes_128_gcm);
LCRYPTO_USED(EVP_aead_aes_256_gcm);
LCRYPTO_USED(EVP_aead_chacha20_poly1305);
LCRYPTO_USED(EVP_aead_xchacha20_poly1305);
LCRYPTO_USED(EVP_AEAD_key_length);
LCRYPTO_USED(EVP_AEAD_nonce_length);
LCRYPTO_USED(EVP_AEAD_max_overhead);
LCRYPTO_USED(EVP_AEAD_max_tag_len);
LCRYPTO_USED(EVP_AEAD_CTX_new);
LCRYPTO_USED(EVP_AEAD_CTX_free);
LCRYPTO_USED(EVP_AEAD_CTX_init);
LCRYPTO_USED(EVP_AEAD_CTX_cleanup);
LCRYPTO_USED(EVP_AEAD_CTX_seal);
LCRYPTO_USED(EVP_AEAD_CTX_open);
LCRYPTO_USED(ERR_load_EVP_strings);
LCRYPTO_UNUSED(EVP_MD_CTX_init);
LCRYPTO_UNUSED(EVP_EncryptFinal);
LCRYPTO_UNUSED(EVP_DecryptFinal);
LCRYPTO_UNUSED(EVP_CipherFinal);
LCRYPTO_UNUSED(EVP_CIPHER_CTX_init);

#endif /* _LIBCRYPTO_EVP_H */
