untrusted comment: signature from openbsd 5.9 base secret key
RWQJVNompF3pwZEuYNt/1hFHo7uyoR6y3/ai8fO8d2UkWXkJchJZNm3bEa1JVbO1sgu4+am9WTLC2G4bC5n07XT4BpSrsrRZOQ4=

OpenBSD 5.9 errata 23, Aug 02, 2016:

Missing overflow checks in uvm may result in panics.

Apply by doing:
    signify -Vep /etc/signify/openbsd-59-base.pub -x 023_uvmisavail.patch.sig \
	-m - | (cd /usr/src && patch -p0)

And then rebuild and install a kernel:
    cd /usr/src/sys/arch/`machine`/conf
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    config $KK
    cd ../compile/$KK
    make
    make install

Index: sys/uvm/uvm_map.c
===================================================================
RCS file: /cvs/src/sys/uvm/uvm_map.c,v
retrieving revision 1.205
diff -u -p -r1.205 uvm_map.c
--- sys/uvm/uvm_map.c	16 Dec 2015 14:22:21 -0000	1.205
+++ sys/uvm/uvm_map.c	1 Aug 2016 19:19:31 -0000
@@ -785,6 +785,9 @@ uvm_map_isavail(struct vm_map *map, stru
 	struct uvm_map_addr *atree;
 	struct vm_map_entry *i, *i_end;
 
+	if (addr + sz < addr)
+		return 0;
+
 	/*
 	 * Kernel memory above uvm_maxkaddr is considered unavailable.
 	 */
@@ -1047,6 +1050,12 @@ uvm_mapanon(struct vm_map *map, vaddr_t 
 			goto unlock;
 	}
 
+	/* Check if selected address doesn't cause overflow. */
+	if (*addr + sz < *addr) {
+		error = ENOMEM;
+		goto unlock;
+	}
+
 	/* If we only want a query, return now. */
 	if (flags & UVM_FLAG_QUERY) {
 		error = 0;
@@ -1290,6 +1299,12 @@ uvm_map(struct vm_map *map, vaddr_t *add
 
 		if (error != 0)
 			goto unlock;
+	}
+
+	/* Check if selected address doesn't cause overflow. */
+	if (*addr + sz < *addr) {
+		error = ENOMEM;
+		goto unlock;
 	}
 
 	KASSERT((map->flags & VM_MAP_ISVMSPACE) == VM_MAP_ISVMSPACE ||
