untrusted comment: verify with openbsd-64-base.pub
RWQq6XmS4eDAca3K6MI+Xp29f8Pr9aieRyJXMGBw+wHR8IZqJtJuFrzcV7osrn79PJgzmDYi3AjyVLNjMfvS62aU3VuJ/+mkKQw=

OpenBSD 6.4 errata 019, July 25, 2019:

By creating long chains of TCP SACK holes an attacker could possibly
slow down the system temporarily.

Apply by doing:
    signify -Vep /etc/signify/openbsd-64-base.pub -x 019_tcpsack.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/netinet/tcp_input.c
===================================================================
RCS file: /cvs/src/sys/netinet/tcp_input.c,v
retrieving revision 1.359
diff -u -p -r1.359 tcp_input.c
--- sys/netinet/tcp_input.c	17 Sep 2018 14:07:48 -0000	1.359
+++ sys/netinet/tcp_input.c	22 Jul 2019 12:14:14 -0000
@@ -2360,6 +2360,8 @@ tcp_update_sack_list(struct tcpcb *tp, t
 	return;
 }
 
+#define	TCP_SACKHOLE_LIMIT 128	/* SACK holes per connection at receiver side */
+
 /*
  * Process the TCP SACK option.  tp->snd_holes is an ordered list
  * of holes (oldest to newest, in terms of the sequence space).
@@ -2492,6 +2494,8 @@ tcp_sack_option(struct tcpcb *tp, struct
 				 * ACKs some data in middle of a hole; need to
 				 * split current hole
 				 */
+				if (tp->snd_numholes >= TCP_SACKHOLE_LIMIT)
+					goto done;
 				temp = (struct sackhole *)
 				    pool_get(&sackhl_pool, PR_NOWAIT);
 				if (temp == NULL)
@@ -2519,6 +2523,8 @@ tcp_sack_option(struct tcpcb *tp, struct
 			 * Need to append new hole at end.
 			 * Last hole is p (and it's not NULL).
 			 */
+			if (tp->snd_numholes >= TCP_SACKHOLE_LIMIT)
+				goto done;
 			temp = (struct sackhole *)
 			    pool_get(&sackhl_pool, PR_NOWAIT);
 			if (temp == NULL)
