/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.stat;

import java.io.IOException;
import java.io.OutputStream;
import java.text.Collator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.I2PAppContext;
import net.i2p.stat.FrequencyStat;
import net.i2p.stat.RateStat;
import net.i2p.util.Log;

public class StatManager {
    private final I2PAppContext _context;
    private final Log _log;
    private final ConcurrentHashMap<String, FrequencyStat> _frequencyStats;
    private final ConcurrentHashMap<String, RateStat> _rateStats;
    private int coalesceCounter;
    private static final int FREQ_COALESCE_RATE = 9;
    public static final String PROP_STAT_FULL = "stat.full";

    public StatManager(I2PAppContext context) {
        this._context = context;
        this._log = context.logManager().getLog(this.getClass());
        this._frequencyStats = new ConcurrentHashMap(8);
        this._rateStats = new ConcurrentHashMap(128);
    }

    public synchronized void shutdown() {
        this._frequencyStats.clear();
        this._rateStats.clear();
    }

    public void createFrequencyStat(String name, String description, String group, long[] periods) {
        if (this.ignoreStat(name)) {
            return;
        }
        this.createRequiredFrequencyStat(name, description, group, periods);
    }

    public void createRequiredFrequencyStat(String name, String description, String group, long[] periods) {
        if (this._frequencyStats.containsKey(name)) {
            return;
        }
        this._frequencyStats.putIfAbsent(name, new FrequencyStat(name, description, group, periods));
    }

    public void createRateStat(String name, String description, String group, long[] periods) {
        if (this.ignoreStat(name)) {
            return;
        }
        this.createRequiredRateStat(name, description, group, periods);
    }

    public void createRequiredRateStat(String name, String description, String group, long[] periods) {
        if (this._rateStats.containsKey(name)) {
            return;
        }
        RateStat rs = new RateStat(name, description, group, periods);
        this._rateStats.putIfAbsent(name, rs);
    }

    public void removeRateStat(String name) {
        this._rateStats.remove(name);
    }

    public void updateFrequency(String name) {
        FrequencyStat freq = this._frequencyStats.get(name);
        if (freq != null) {
            freq.eventOccurred();
        } else if (this._log.shouldLog(10)) {
            this._log.debug("Invalid frequency stat : " + name);
        }
    }

    public void addRateData(String name, long data, long eventDuration) {
        RateStat stat = this._rateStats.get(name);
        if (stat != null) {
            stat.addData(data, eventDuration);
        } else if (this._log.shouldLog(10)) {
            this._log.debug("Invalid rate stat : " + name);
        }
    }

    public void addRateData(String name, long data) {
        RateStat stat = this._rateStats.get(name);
        if (stat != null) {
            stat.addData(data);
        } else if (this._log.shouldLog(10)) {
            this._log.debug("Invalid rate stat : " + name);
        }
    }

    public synchronized void coalesceStats() {
        if (++this.coalesceCounter % 9 == 0) {
            for (FrequencyStat frequencyStat : this._frequencyStats.values()) {
                if (frequencyStat == null) continue;
                frequencyStat.coalesceStats();
            }
        }
        for (RateStat rateStat : this._rateStats.values()) {
            rateStat.coalesceStats();
        }
    }

    public FrequencyStat getFrequency(String name) {
        return this._frequencyStats.get(name);
    }

    public RateStat getRate(String name) {
        return this._rateStats.get(name);
    }

    public Set<String> getFrequencyNames() {
        return new HashSet<String>(this._frequencyStats.keySet());
    }

    public Set<String> getRateNames() {
        return new HashSet<String>(this._rateStats.keySet());
    }

    public boolean isRate(String statName) {
        return this._rateStats.containsKey(statName);
    }

    public boolean isFrequency(String statName) {
        return this._frequencyStats.containsKey(statName);
    }

    public Map<String, SortedSet<String>> getStatsByGroup() {
        SortedSet<Object> names;
        String gname;
        HashMap<String, SortedSet<String>> groups = new HashMap<String, SortedSet<String>>(32);
        for (FrequencyStat frequencyStat : this._frequencyStats.values()) {
            gname = frequencyStat.getGroupName();
            names = (TreeSet<Object>)groups.get(gname);
            if (names == null) {
                names = new TreeSet<Object>(Collator.getInstance());
                groups.put(gname, names);
            }
            names.add(frequencyStat.getName());
        }
        for (RateStat rateStat : this._rateStats.values()) {
            gname = rateStat.getGroupName();
            names = (SortedSet)groups.get(gname);
            if (names == null) {
                names = new TreeSet<Object>(Collator.getInstance());
                groups.put(gname, names);
            }
            names.add(rateStat.getName());
        }
        return groups;
    }

    public boolean ignoreStat(String statName) {
        return this._context.isRouterContext() && !this._context.getBooleanProperty(PROP_STAT_FULL);
    }

    public void store(OutputStream out, String prefix) throws IOException {
        for (FrequencyStat fs : this._frequencyStats.values()) {
            fs.store(out, prefix);
        }
        for (RateStat rs : this._rateStats.values()) {
            rs.store(out, prefix);
        }
    }
}

