/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.jitsimeet;

import org.apache.commons.lang3.StringUtils;
import org.jitsi.xmpp.extensions.SafeParseIqProvider;
import org.jitsi.xmpp.extensions.jitsimeet.LoginUrlIq;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.impl.JidCreate;

public class LoginUrlIqProvider
extends SafeParseIqProvider<LoginUrlIq> {
    public LoginUrlIqProvider() {
        ProviderManager.addIQProvider("login-url", "http://jitsi.org/protocol/focus", this);
    }

    @Override
    protected LoginUrlIq doParse(XmlPullParser parser2, int initialDepth, IqData data, XmlEnvironment xmlEnvironment) throws Exception {
        LoginUrlIq authUrlIQ;
        String namespace = parser2.getNamespace();
        if (!"http://jitsi.org/protocol/focus".equals(namespace)) {
            return null;
        }
        String rootElement = parser2.getName();
        if ("login-url".equals(rootElement)) {
            String machineUID;
            String popup;
            String room;
            authUrlIQ = new LoginUrlIq();
            String url = parser2.getAttributeValue("", "url");
            if (StringUtils.isNotEmpty(url)) {
                authUrlIQ.setUrl(url);
            }
            if (StringUtils.isNotEmpty(room = parser2.getAttributeValue("", "room"))) {
                EntityBareJid roomJid = JidCreate.entityBareFrom(room);
                authUrlIQ.setRoom(roomJid);
            }
            if (StringUtils.isNotEmpty(popup = parser2.getAttributeValue("", "popup"))) {
                Boolean popupBool = Boolean.parseBoolean(popup);
                authUrlIQ.setPopup(popupBool);
            }
            if (StringUtils.isNotEmpty(machineUID = parser2.getAttributeValue("", "machine-uid"))) {
                authUrlIQ.setMachineUID(machineUID);
            }
        } else {
            return null;
        }
        ParserUtils.forwardToEndTagOfDepth(parser2, initialDepth);
        return authUrlIQ;
    }
}

