/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.websocket.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.websocket.Decoder;
import javax.websocket.DeploymentException;
import javax.websocket.Encoder;
import javax.websocket.Extension;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpointConfig;
import org.ops4j.pax.web.service.spi.model.elements.ContainerInitializerModel;
import org.ops4j.pax.web.service.spi.model.elements.ContainerInitializerModelAware;
import org.ops4j.pax.web.service.spi.model.elements.WebSocketModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaxWebWebSocketsServletContainerInitializer
implements ServletContainerInitializer,
ContainerInitializerModelAware {
    public static final Logger LOG = LoggerFactory.getLogger(PaxWebWebSocketsServletContainerInitializer.class);
    private ContainerInitializerModel model;

    public void onStartup(Set<Class<?>> c, ServletContext ctx) throws ServletException {
        ServerContainer wsContainer = (ServerContainer)ctx.getAttribute(ServerContainer.class.getName());
        if (wsContainer == null) {
            LOG.warn("No javax.websocket.server.ServerContainer available in servlet context. Skipping WebSocket registration.");
            return;
        }
        if (this.model == null) {
            LOG.warn("[dev error] No ContainerInitializerModel available with WebSocket endpoints to register.");
            return;
        }
        ArrayList<Class> annotatedEndpointClasses = new ArrayList<Class>();
        LinkedHashMap<WebSocketModel, Object> annotatedEndpointInstances = new LinkedHashMap<WebSocketModel, Object>();
        for (WebSocketModel webSocketModel : this.model.getRelatedWebSocketModels()) {
            if (webSocketModel.getWebSocketEndpoint() != null) {
                annotatedEndpointInstances.put(webSocketModel, webSocketModel.getWebSocketEndpoint());
                continue;
            }
            if (webSocketModel.getElementSupplier() != null) {
                annotatedEndpointInstances.put(webSocketModel, webSocketModel.getElementSupplier().get());
                continue;
            }
            if (webSocketModel.getElementReference() != null && webSocketModel.getRegisteringBundle().getBundleContext() != null) {
                Object endpoint = webSocketModel.getRegisteringBundle().getBundleContext().getService(webSocketModel.getElementReference());
                annotatedEndpointInstances.put(webSocketModel, endpoint);
                continue;
            }
            annotatedEndpointClasses.add(webSocketModel.getWebSocketEndpointClass());
        }
        if (!annotatedEndpointClasses.isEmpty()) {
            for (Class clazz : annotatedEndpointClasses) {
                try {
                    wsContainer.addEndpoint(clazz);
                }
                catch (DeploymentException e) {
                    LOG.error("Problem deploying annontated Web Socket endpoint {}: {}", new Object[]{clazz, e.getMessage(), e});
                }
            }
        }
        if (!annotatedEndpointInstances.isEmpty()) {
            for (Map.Entry entry : annotatedEndpointInstances.entrySet()) {
                WebSocketModel wsm = (WebSocketModel)entry.getKey();
                Object instance = entry.getValue();
                DynamicEndpointConfig config = new DynamicEndpointConfig(wsm, instance);
                try {
                    wsContainer.addEndpoint((ServerEndpointConfig)config);
                }
                catch (DeploymentException ex) {
                    LOG.error("Problem deploying Web Socket endpoint {}: {}", new Object[]{this.model, ex.getMessage(), ex});
                }
            }
        }
    }

    public void setContainerInitializerModel(ContainerInitializerModel model) {
        this.model = model;
    }

    public ContainerInitializerModel getContainerInitializerModel() {
        return this.model;
    }

    private static class DynamicEndpointConfig
    implements ServerEndpointConfig {
        private final WebSocketModel wsm;
        private final Object instance;
        private final Map<String, Object> userProperties = new HashMap<String, Object>();

        DynamicEndpointConfig(WebSocketModel wsm, Object instance) {
            this.wsm = wsm;
            this.instance = instance;
        }

        public Class<?> getEndpointClass() {
            return this.wsm.getWebSocketEndpointClassResolved();
        }

        public String getPath() {
            return this.wsm.getMappedPath();
        }

        public List<String> getSubprotocols() {
            return Arrays.asList(this.wsm.getSubprotocols());
        }

        public List<Extension> getExtensions() {
            return Collections.emptyList();
        }

        public ServerEndpointConfig.Configurator getConfigurator() {
            return new ServerEndpointConfig.Configurator(){

                public <T> T getEndpointInstance(Class<T> endpointClass) {
                    return endpointClass.cast(instance);
                }
            };
        }

        public List<Class<? extends Encoder>> getEncoders() {
            return Arrays.asList(this.wsm.getEncoderClasses());
        }

        public List<Class<? extends Decoder>> getDecoders() {
            return Arrays.asList(this.wsm.getDecoderClasses());
        }

        public Map<String, Object> getUserProperties() {
            return this.userProperties;
        }
    }
}

