/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.helper;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ConcurrentWeakValueMap<K, V> {
    private final Map<K, WeakValue<K, V>> map = new ConcurrentHashMap<K, WeakValue<K, V>>();
    private final ReferenceQueue<V> queue = new ReferenceQueue();

    public V get(K key) {
        this.expunge();
        WeakValue<K, V> reference = this.map.get(key);
        return reference == null ? null : (V)reference.get();
    }

    public void put(K key, V value) {
        this.expunge();
        this.map.put(key, new WeakValue<K, V>(key, value, this.queue));
    }

    public V remove(K key) {
        this.expunge();
        WeakValue<K, V> reference = this.map.remove(key);
        return reference == null ? null : (V)reference.get();
    }

    private void expunge() {
        WeakValue reference;
        while ((reference = (WeakValue)this.queue.poll()) != null) {
            this.map.remove(reference.key, reference);
        }
    }

    private static final class WeakValue<K, V>
    extends WeakReference<V> {
        private final K key;

        WeakValue(K key, V value, ReferenceQueue<? super V> q) {
            super(value, q);
            this.key = key;
        }
    }
}

