/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.profiler;

import java.util.prefs.Preferences;
import org.graalvm.visualvm.lib.jfluid.global.Platform;
import org.graalvm.visualvm.profiler.JavaInfo;
import org.openide.util.NbPreferences;

final class JavaPlatformCache {
    static void setBinary(String java, String arch, String binary) {
        JavaPlatformCache.preferences().put(java + arch, binary);
    }

    static String getBinary(String java, String arch) {
        String binary = JavaPlatformCache.preferences().get(java + arch, null);
        if (binary == null && arch == null && (binary = JavaPlatformCache.getBinary(java, "64")) == null) {
            binary = JavaPlatformCache.getBinary(java, "32");
        }
        if (binary == null && (arch == null || arch.equals(Integer.toString(Platform.getSystemArchitecture()))) && Platform.getJDKVersionString().equals(java)) {
            binary = JavaInfo.getCurrentJDKExecutable();
        }
        return binary;
    }

    static void clearBinary(String java, String arch) {
        JavaPlatformCache.preferences().remove(java + arch);
    }

    private static Preferences preferences() {
        return NbPreferences.forModule(JavaPlatformCache.class);
    }

    private JavaPlatformCache() {
    }
}

