/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.getsubfolders;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.getsubfolders.GetSubFolders;
import org.pentaho.di.trans.steps.getsubfolders.GetSubFoldersData;
import org.pentaho.di.trans.steps.getsubfolders.Messages;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetSubFoldersMeta
extends BaseStepMeta
implements StepMetaInterface {
    public static final String[] RequiredFoldersDesc = new String[]{Messages.getString("System.Combo.No"), Messages.getString("System.Combo.Yes")};
    public static final String[] RequiredFoldersCode = new String[]{"N", "Y"};
    public static final String NO = "N";
    private String[] folderName;
    private String[] folderRequired;
    private boolean includeRowNumber;
    private String rowNumberField;
    private String dynamicFoldernameField;
    private boolean isFoldernameDynamic;
    private long rowLimit;

    public String getRequiredFilesDesc(String tt) {
        if (Const.isEmpty((String)tt)) {
            return RequiredFoldersDesc[0];
        }
        if (tt.equalsIgnoreCase(RequiredFoldersCode[1])) {
            return RequiredFoldersDesc[1];
        }
        return RequiredFoldersDesc[0];
    }

    public String getRowNumberField() {
        return this.rowNumberField;
    }

    public void setDynamicFoldernameField(String dynamicFoldernameField) {
        this.dynamicFoldernameField = dynamicFoldernameField;
    }

    public void setRowNumberField(String rowNumberField) {
        this.rowNumberField = rowNumberField;
    }

    public String getDynamicFoldernameField() {
        return this.dynamicFoldernameField;
    }

    public boolean includeRowNumber() {
        return this.includeRowNumber;
    }

    public boolean isFoldernameDynamic() {
        return this.isFoldernameDynamic;
    }

    public void setFolderField(boolean isFoldernameDynamic) {
        this.isFoldernameDynamic = isFoldernameDynamic;
    }

    public void setIncludeRowNumber(boolean includeRowNumber) {
        this.includeRowNumber = includeRowNumber;
    }

    public String[] getFolderRequired() {
        return this.folderRequired;
    }

    public String getRequiredFoldersCode(String tt) {
        if (tt == null) {
            return RequiredFoldersCode[0];
        }
        if (tt.equals(RequiredFoldersDesc[1])) {
            return RequiredFoldersCode[1];
        }
        return RequiredFoldersCode[0];
    }

    public void setFolderRequired(String[] folderRequiredin) {
        for (int i = 0; i < folderRequiredin.length; ++i) {
            this.folderRequired[i] = this.getRequiredFoldersCode(folderRequiredin[i]);
        }
    }

    public String[] getFolderName() {
        return this.folderName;
    }

    public void setFolderName(String[] folderName) {
        this.folderName = folderName;
    }

    public long getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(long rowLimit) {
        this.rowLimit = rowLimit;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        GetSubFoldersMeta retval = (GetSubFoldersMeta)super.clone();
        int nrfiles = this.folderName.length;
        retval.allocate(nrfiles);
        for (int i = 0; i < nrfiles; ++i) {
            retval.folderName[i] = this.folderName[i];
            retval.folderRequired[i] = this.folderRequired[i];
        }
        return retval;
    }

    public void allocate(int nrfiles) {
        this.folderName = new String[nrfiles];
        this.folderRequired = new String[nrfiles];
    }

    @Override
    public void setDefault() {
        int nrfiles = 0;
        this.isFoldernameDynamic = false;
        this.includeRowNumber = false;
        this.rowNumberField = "";
        this.dynamicFoldernameField = "";
        this.allocate(nrfiles);
        for (int i = 0; i < nrfiles; ++i) {
            this.folderName[i] = "folderName" + (i + 1);
            this.folderRequired[i] = NO;
        }
    }

    @Override
    public void getFields(RowMetaInterface row, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        ValueMeta folderName = new ValueMeta("folderName", 2);
        folderName.setLength(500);
        folderName.setPrecision(-1);
        folderName.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)folderName);
        ValueMeta short_folderName = new ValueMeta("short_folderName", 2);
        short_folderName.setLength(500);
        short_folderName.setPrecision(-1);
        short_folderName.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)short_folderName);
        ValueMeta path = new ValueMeta("path", 2);
        path.setLength(500);
        path.setPrecision(-1);
        path.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)path);
        ValueMeta ishidden = new ValueMeta("ishidden", 4);
        ishidden.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)ishidden);
        ValueMeta isreadable = new ValueMeta("isreadable", 4);
        isreadable.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)isreadable);
        ValueMeta iswriteable = new ValueMeta("iswriteable", 4);
        iswriteable.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)iswriteable);
        ValueMeta lastmodifiedtime = new ValueMeta("lastmodifiedtime", 3);
        lastmodifiedtime.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)lastmodifiedtime);
        ValueMeta uri = new ValueMeta("uri", 2);
        uri.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)uri);
        ValueMeta rooturi = new ValueMeta("rooturi", 2);
        rooturi.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)rooturi);
        ValueMeta childrens = new ValueMeta(space.environmentSubstitute("childrens"), 5);
        childrens.setLength(10, 0);
        childrens.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)childrens);
        if (this.includeRowNumber) {
            ValueMeta v = new ValueMeta(space.environmentSubstitute(this.rowNumberField), 5);
            v.setLength(10, 0);
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append("    ").append(XMLHandler.addTagValue((String)"rownum", (boolean)this.includeRowNumber));
        retval.append("    ").append(XMLHandler.addTagValue((String)"foldername_dynamic", (boolean)this.isFoldernameDynamic));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rownum_field", (String)this.rowNumberField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"foldername_field", (String)this.dynamicFoldernameField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"limit", (long)this.rowLimit));
        retval.append("    <file>").append(Const.CR);
        for (int i = 0; i < this.folderName.length; ++i) {
            retval.append("      ").append(XMLHandler.addTagValue((String)"name", (String)this.folderName[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"file_required", (String)this.folderRequired[i]));
        }
        retval.append("    </file>").append(Const.CR);
        return retval.toString();
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.includeRowNumber = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"rownum"));
            this.isFoldernameDynamic = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"foldername_dynamic"));
            this.rowNumberField = XMLHandler.getTagValue((Node)stepnode, (String)"rownum_field");
            this.dynamicFoldernameField = XMLHandler.getTagValue((Node)stepnode, (String)"foldername_Field");
            this.rowLimit = Const.toLong((String)XMLHandler.getTagValue((Node)stepnode, (String)"limit"), (long)0L);
            Node filenode = XMLHandler.getSubNode((Node)stepnode, (String)"file");
            int nrfiles = XMLHandler.countNodes((Node)filenode, (String)"name");
            this.allocate(nrfiles);
            for (int i = 0; i < nrfiles; ++i) {
                Node folderNamenode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"name", (int)i);
                Node folderRequirednode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"file_required", (int)i);
                this.folderName[i] = XMLHandler.getNodeValue((Node)folderNamenode);
                this.folderRequired[i] = XMLHandler.getNodeValue((Node)folderRequirednode);
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            int nrfiles = rep.countNrStepAttributes(id_step, "file_name");
            this.dynamicFoldernameField = rep.getStepAttributeString(id_step, "foldername_Field");
            this.includeRowNumber = rep.getStepAttributeBoolean(id_step, "rownum");
            this.isFoldernameDynamic = rep.getStepAttributeBoolean(id_step, "foldername_dynamic");
            this.rowNumberField = rep.getStepAttributeString(id_step, "rownum_field");
            this.rowLimit = rep.getStepAttributeInteger(id_step, "limit");
            this.allocate(nrfiles);
            for (int i = 0; i < nrfiles; ++i) {
                this.folderName[i] = rep.getStepAttributeString(id_step, i, "file_name");
                this.folderRequired[i] = rep.getStepAttributeString(id_step, i, "file_required");
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "rownum", this.includeRowNumber);
            rep.saveStepAttribute(id_transformation, id_step, "foldername_dynamic", this.isFoldernameDynamic);
            rep.saveStepAttribute(id_transformation, id_step, "foldername_field", this.dynamicFoldernameField);
            rep.saveStepAttribute(id_transformation, id_step, "rownum_field", this.rowNumberField);
            rep.saveStepAttribute(id_transformation, id_step, "limit", this.rowLimit);
            for (int i = 0; i < this.folderName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "file_name", this.folderName[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "file_required", this.folderRequired[i]);
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    public FileInputList getFolderList(VariableSpace space) {
        return FileInputList.createFolderList((VariableSpace)space, (String[])this.folderName, (String[])this.folderRequired);
    }

    public FileInputList getDynamicFolderList(VariableSpace space, String[] folderName, String[] folderRequired) {
        return FileInputList.createFolderList((VariableSpace)space, (String[])folderName, (String[])folderRequired);
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepinfo, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        if (this.isFoldernameDynamic) {
            CheckResult cr = input.length > 0 ? new CheckResult(1, Messages.getString("GetSubFoldersMeta.CheckResult.InputOk"), (CheckResultSourceInterface)stepinfo) : new CheckResult(4, Messages.getString("GetSubFoldersMeta.CheckResult.InputErrorKo"), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
            cr = Const.isEmpty((String)this.dynamicFoldernameField) ? new CheckResult(4, Messages.getString("GetSubFoldersMeta.CheckResult.FolderFieldnameMissing"), (CheckResultSourceInterface)stepinfo) : new CheckResult(1, Messages.getString("GetSubFoldersMeta.CheckResult.FolderFieldnameOk"), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            CheckResult cr = input.length > 0 ? new CheckResult(4, Messages.getString("GetSubFoldersMeta.CheckResult.NoInputError"), (CheckResultSourceInterface)stepinfo) : new CheckResult(1, Messages.getString("GetSubFoldersMeta.CheckResult.NoInputOk"), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
            FileInputList fileList = this.getFolderList(transMeta);
            if (fileList.nrOfFiles() == 0) {
                cr = new CheckResult(4, Messages.getString("GetSubFoldersMeta.CheckResult.ExpectedFoldersError"), (CheckResultSourceInterface)stepinfo);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, Messages.getString("GetSubFoldersMeta.CheckResult.ExpectedFilesOk", "" + fileList.nrOfFiles()), (CheckResultSourceInterface)stepinfo);
                remarks.add((CheckResultInterface)cr);
            }
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new GetSubFolders(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new GetSubFoldersData();
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository) throws KettleException {
        try {
            FileInputList fileList;
            ArrayList<FileObject> newFilenames = new ArrayList<FileObject>();
            if (!this.isFoldernameDynamic && (fileList = this.getFolderList(space)).getFiles().size() > 0) {
                for (FileObject fileObject : fileList.getFiles()) {
                    if (!fileObject.exists()) continue;
                    newFilenames.add(fileObject);
                }
                this.folderName = new String[newFilenames.size()];
                this.folderRequired = new String[newFilenames.size()];
                for (int i = 0; i < newFilenames.size(); ++i) {
                    FileObject fileObject;
                    fileObject = (FileObject)newFilenames.get(i);
                    this.folderName[i] = resourceNamingInterface.nameResource(fileObject.getName().getBaseName(), fileObject.getParent().getName().getPath(), space.toString(), ResourceNamingInterface.FileNamingType.DATA_FILE);
                    this.folderRequired[i] = "Y";
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }
}

