/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import net.sf.mpxj.CustomFieldContainer;
import net.sf.mpxj.CustomFieldValueDataType;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.ByteArrayHelper;
import net.sf.mpxj.mpp.FixedData;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.Props;
import net.sf.mpxj.mpp.Var2Data;
import net.sf.mpxj.mpp.VarMeta;

public abstract class CustomFieldValueReader {
    protected final ProjectProperties m_properties;
    protected final CustomFieldContainer m_container;
    protected final VarMeta m_outlineCodeVarMeta;
    protected final Var2Data m_outlineCodeVarData;
    protected final FixedData m_outlineCodeFixedData;
    protected final FixedData m_outlineCodeFixedData2;
    protected final Props m_taskProps;
    public static final Integer VALUE_LIST_VALUE = 22;
    public static final Integer VALUE_LIST_DESCRIPTION = 8;
    public static final Integer VALUE_LIST_UNKNOWN = 23;

    public CustomFieldValueReader(ProjectProperties properties, CustomFieldContainer container, VarMeta outlineCodeVarMeta, Var2Data outlineCodeVarData, FixedData outlineCodeFixedData, FixedData outlineCodeFixedData2, Props taskProps) {
        this.m_properties = properties;
        this.m_container = container;
        this.m_outlineCodeVarMeta = outlineCodeVarMeta;
        this.m_outlineCodeVarData = outlineCodeVarData;
        this.m_outlineCodeFixedData = outlineCodeFixedData;
        this.m_outlineCodeFixedData2 = outlineCodeFixedData2;
        this.m_taskProps = taskProps;
    }

    public abstract void process();

    protected Object getTypedValue(CustomFieldValueDataType type, byte[] value) {
        Object result;
        if (type == null) {
            result = this.valueAsString(value);
        } else {
            switch (type) {
                case DATE: 
                case FINISH_DATE: {
                    result = MPPUtility.getTimestamp(value, 0);
                    break;
                }
                case DURATION: {
                    TimeUnit units = MPPUtility.getDurationTimeUnits(MPPUtility.getShort(value, 4), this.m_properties.getDefaultDurationUnits());
                    result = MPPUtility.getAdjustedDuration(this.m_properties, MPPUtility.getInt(value, 0), units);
                    break;
                }
                case COST: {
                    result = MPPUtility.getDouble(value, 0) / 100.0;
                    break;
                }
                case NUMBER: {
                    result = MPPUtility.getDouble(value, 0);
                    break;
                }
                case TEXT: {
                    result = MPPUtility.getUnicodeString(value, 0);
                    break;
                }
                default: {
                    result = this.valueAsString(value);
                }
            }
        }
        return result;
    }

    private String valueAsString(byte[] value) {
        String result;
        try {
            result = MPPUtility.getUnicodeString(value, 0);
        }
        catch (Exception ex) {
            result = ByteArrayHelper.hexdump(value, false);
        }
        return result;
    }
}

