/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.dom;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.echosvg.css.dom.CSSOMSVGColor;
import io.sf.carte.echosvg.css.engine.value.AbstractValueModificationHandler;
import io.sf.carte.echosvg.css.engine.value.ColorValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueModificationHandler;
import org.w3c.dom.DOMException;

public class CSSOMSVGPaint
extends CSSOMSVGColor {
    public CSSOMSVGPaint(CSSOMSVGColor.ValueProvider vp) {
        super(vp);
    }

    @Override
    public void setModificationHandler(ValueModificationHandler h) {
        if (!(h instanceof PaintModificationHandler)) {
            throw new IllegalArgumentException();
        }
        super.setModificationHandler(h);
    }

    @Override
    public short getColorType() {
        throw new DOMException(15, "");
    }

    public short getPaintType() {
        Value value = this.valueProvider.getValue();
        block0 : switch (value.getCssValueType()) {
            case TYPED: {
                switch (value.getPrimitiveType()) {
                    case IDENT: {
                        String str = value.getIdentifierValue();
                        if (str.equalsIgnoreCase("none")) {
                            return 101;
                        }
                        if (str.equalsIgnoreCase("currentcolor")) {
                            return 102;
                        }
                        return 1;
                    }
                    case COLOR: {
                        ColorValue color = value.getColorValue();
                        switch (color.getCSSColorSpace()) {
                            case "rgb": {
                                return 1;
                            }
                        }
                        break block0;
                    }
                    case URI: {
                        return 107;
                    }
                }
                break;
            }
            case LIST: {
                Value v0 = value.item(0);
                Value v1 = value.item(1);
                switch (v0.getPrimitiveType()) {
                    case IDENT: {
                        return 2;
                    }
                    case URI: {
                        if (v1.getCssValueType() == CSSValue.CssType.LIST) {
                            return 106;
                        }
                        switch (v1.getPrimitiveType()) {
                            case IDENT: {
                                String str = v1.getIdentifierValue();
                                if (str.equalsIgnoreCase("none")) {
                                    return 103;
                                }
                                if (str.equalsIgnoreCase("currentcolor")) {
                                    return 104;
                                }
                                return 105;
                            }
                            case COLOR: {
                                ColorValue color = v1.getColorValue();
                                switch (color.getCSSColorSpace()) {
                                    case "rgb": {
                                        return 105;
                                    }
                                }
                            }
                        }
                        break block0;
                    }
                    case COLOR: {
                        ColorValue color = v0.getColorValue();
                        switch (color.getCSSColorSpace()) {
                            case "rgb": {
                                return 2;
                            }
                        }
                    }
                }
            }
        }
        return 0;
    }

    @Override
    public String getURIValue() throws DOMException {
        return this.getUri();
    }

    public String getUri() {
        switch (this.getPaintType()) {
            case 107: {
                return this.valueProvider.getValue().getURIValue();
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                return this.valueProvider.getValue().item(0).getStringValue();
            }
        }
        throw new InternalError();
    }

    public void setUri(String uri) {
        if (this.handler == null) {
            throw new DOMException(7, "");
        }
        ((PaintModificationHandler)this.handler).uriValueChanged(uri);
    }

    public void setPaint(short paintType, String uri, String rgbColor, String iccColor) {
        if (this.handler == null) {
            throw new DOMException(7, "");
        }
        ((PaintModificationHandler)this.handler).paintChanged(paintType, uri, rgbColor, iccColor);
    }

    public static interface PaintModificationHandler
    extends ValueModificationHandler {
        public void uriValueChanged(String var1);

        public void paintChanged(short var1, String var2, String var3, String var4);
    }

    public abstract class AbstractModificationHandler
    extends AbstractValueModificationHandler
    implements PaintModificationHandler {
        @Override
        public void uriValueChanged(String uri) {
            this.setPropertyText("url(" + uri + ") none");
        }

        @Override
        public void paintChanged(short type, String uri, String rgb, String icc) {
            switch (type) {
                case 101: {
                    this.setPropertyText("none");
                    break;
                }
                case 102: {
                    this.setPropertyText("currentcolor");
                    break;
                }
                case 1: {
                    this.setPropertyText(rgb);
                    break;
                }
                case 2: {
                    this.setPropertyText(rgb + ' ' + icc);
                    break;
                }
                case 107: {
                    this.setPropertyText("url(" + uri + ')');
                    break;
                }
                case 103: {
                    this.setPropertyText("url(" + uri + ") none");
                    break;
                }
                case 104: {
                    this.setPropertyText("url(" + uri + ") currentcolor");
                    break;
                }
                case 105: {
                    this.setPropertyText("url(" + uri + ") " + rgb);
                    break;
                }
                case 106: {
                    this.setPropertyText("url(" + uri + ") " + rgb + ' ' + icc);
                }
            }
        }
    }
}

