/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing.workspaceModel;

import com.intellij.openapi.util.io.FileUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.StandardMavenModuleType;
import org.jetbrains.idea.maven.importing.workspaceModel.ContentRootCollector$collectSingleModule$lambda$0$;
import org.jetbrains.idea.maven.importing.workspaceModel.ContentRootCollector$collectSplitModule$lambda$0$;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0010\b\u00c7\u0002\u0018\u00002\u00020\u0001:\r\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001cB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ&\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\t\u001a\u0004\u0018\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J&\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\t\u001a\u0004\u0018\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/idea/maven/importing/workspaceModel/ContentRootCollector;", "", "<init>", "()V", "collect", "", "Lorg/jetbrains/idea/maven/importing/workspaceModel/ContentRootCollector$ContentRootResult;", "moduleType", "Lorg/jetbrains/idea/maven/importing/StandardMavenModuleType;", "projectRoot", "Lorg/jetbrains/idea/maven/importing/workspaceModel/ContentRootCollector$ProjectRootFolder;", "folders", "", "Lorg/jetbrains/idea/maven/importing/workspaceModel/ContentRootCollector$ImportedFolder;", "collectSplitModule", "collectSingleModule", "ContentRootWithFolders", "ImportedFolderBase", "ImportedFolder", "UserOrGeneratedSourceFolder", "BaseExcludedFolder", "ProjectRootFolder", "SourceFolder", "ExcludedFolderAndPreventSubfolders", "GeneratedSourceFolder", "ExcludedFolder", "ContentRootResult", "SourceFolderResult", "ExcludedFolderResult", "intellij.maven"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nContentRootCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContentRootCollector.kt\norg/jetbrains/idea/maven/importing/workspaceModel/ContentRootCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,345:1\n1563#2:346\n1634#2,2:347\n1636#2:351\n1563#2:352\n1634#2,2:353\n1636#2:357\n477#3:349\n477#3:350\n477#3:355\n477#3:356\n*S KotlinDebug\n*F\n+ 1 ContentRootCollector.kt\norg/jetbrains/idea/maven/importing/workspaceModel/ContentRootCollector\n*L\n134#1:346\n134#1:347,2\n134#1:351\n257#1:352\n257#1:353,2\n257#1:357\n135#1:349\n138#1:350\n258#1:355\n261#1:356\n*E\n"})
public final class ContentRootCollector {
    @NotNull
    public static final ContentRootCollector INSTANCE = new ContentRootCollector();

    private ContentRootCollector() {
    }

    @NotNull
    public final Collection<ContentRootResult> collect(@NotNull StandardMavenModuleType moduleType, @Nullable ProjectRootFolder projectRoot, @NotNull List<? extends ImportedFolder> folders) {
        Intrinsics.checkNotNullParameter((Object)moduleType, (String)"moduleType");
        Intrinsics.checkNotNullParameter(folders, (String)"folders");
        ProjectRootFolder projectRootFolder = projectRoot;
        Object[] objectArray = new Object[]{folders};
        MavenLog.LOG.debug("collecting content roots in " + (projectRootFolder != null ? projectRootFolder.getPath() : null) + ", module type " + moduleType + ", folders = ", objectArray);
        Collection<ContentRootResult> collectedRoots = moduleType == StandardMavenModuleType.MAIN_ONLY || moduleType == StandardMavenModuleType.MAIN_ONLY_ADDITIONAL || moduleType == StandardMavenModuleType.TEST_ONLY ? this.collectSplitModule(projectRoot, folders) : this.collectSingleModule(projectRoot, folders);
        Object[] objectArray2 = new Object[]{collectedRoots};
        MavenLog.LOG.debug("collected content roots = ", objectArray2);
        return collectedRoots;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<ContentRootResult> collectSplitModule(ProjectRootFolder projectRoot, List<? extends ImportedFolder> folders) {
        void $this$mapTo$iv$iv;
        Object curr;
        List result2 = new ArrayList();
        ContentRootWithFolders nearestRoot = null;
        ImportedFolderBase nearestRootFolder = null;
        for (ImportedFolder importedFolder : folders) {
            ImportedFolder prev;
            if (nearestRoot != null && projectRoot != null && nearestRootFolder instanceof SourceFolder && (((SourceFolder)nearestRootFolder).getType() instanceof JavaResourceRootType || ((SourceFolder)nearestRootFolder).getType() instanceof JavaSourceRootType) && FileUtil.isAncestor((String)((SourceFolder)nearestRootFolder).getPath(), (String)projectRoot.getPath(), (boolean)true)) {
                result2.removeLast();
                nearestRoot.getFolders().remove(nearestRootFolder);
                nearestRootFolder = importedFolder;
                nearestRoot = new ContentRootWithFolders(importedFolder.getPath(), nearestRoot.getFolders());
                result2.add(nearestRoot);
            }
            if (nearestRoot != null && FileUtil.isAncestor((String)nearestRoot.getPath(), (String)importedFolder.getPath(), (boolean)false)) {
                if (importedFolder instanceof ExcludedFolder && FileUtil.pathsEqual((String)nearestRoot.getPath(), (String)importedFolder.getPath())) {
                    continue;
                }
            } else {
                if (importedFolder instanceof ExcludedFolder) continue;
                nearestRootFolder = importedFolder;
                nearestRoot = new ContentRootWithFolders(importedFolder.getPath(), null, 2, null);
                result2.add(nearestRoot);
                ProjectRootFolder projectRootFolder = projectRoot;
                if (FileUtil.pathsEqual((String)importedFolder.getPath(), (String)(projectRootFolder != null ? projectRootFolder.getPath() : null))) continue;
            }
            if ((prev = (ImportedFolder)CollectionsKt.lastOrNull(nearestRoot.getFolders())) != null && FileUtil.pathsEqual((String)prev.getPath(), (String)importedFolder.getPath()) && prev.getRank$intellij_maven() <= importedFolder.getRank$intellij_maven()) continue;
            if (prev != null && FileUtil.isAncestor((String)prev.getPath(), (String)importedFolder.getPath(), (boolean)true)) {
                if (prev instanceof SourceFolder && importedFolder instanceof UserOrGeneratedSourceFolder) {
                    if (((SourceFolder)prev).getRootTypeRank() <= ((UserOrGeneratedSourceFolder)importedFolder).getRootTypeRank()) continue;
                    nearestRoot.getFolders().removeLast();
                } else if (prev instanceof GeneratedSourceFolder && importedFolder instanceof UserOrGeneratedSourceFolder) {
                    if (importedFolder instanceof GeneratedSourceFolder && ((GeneratedSourceFolder)importedFolder).isAnnotationFolder()) continue;
                    nearestRoot.getFolders().removeLast();
                } else if (prev instanceof ExcludedFolderAndPreventSubfolders && importedFolder instanceof UserOrGeneratedSourceFolder || prev.getRank$intellij_maven() == importedFolder.getRank$intellij_maven()) continue;
            }
            nearestRoot.getFolders().add(importedFolder);
        }
        for (ContentRootWithFolders contentRootWithFolders : result2) {
            Iterator<ImportedFolder> folderIterator = contentRootWithFolders.getFolders().iterator();
            Object prev = null;
            while (folderIterator.hasNext()) {
                curr = folderIterator.next();
                if (prev instanceof BaseExcludedFolder && curr instanceof BaseExcludedFolder && FileUtil.isAncestor((String)((BaseExcludedFolder)prev).getPath(), (String)((ImportedFolderBase)curr).getPath(), (boolean)false)) {
                    folderIterator.remove();
                    continue;
                }
                prev = curr;
            }
        }
        Iterable $this$map$iv = result2;
        boolean $i$f$map = false;
        curr = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void root;
            ContentRootWithFolders contentRootWithFolders = (ContentRootWithFolders)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)root.getFolders());
            boolean $i$f$filterIsInstance = false;
            Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)collectSplitModule$lambda$0$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            Sequence sourceFolders = SequencesKt.map((Sequence)sequence, ContentRootCollector::collectSplitModule$lambda$0$0);
            Sequence $this$filterIsInstance$iv2 = CollectionsKt.asSequence((Iterable)root.getFolders());
            boolean $i$f$filterIsInstance2 = false;
            Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv2, (Function1)collectSplitModule$lambda$0$$inlined$filterIsInstance$2.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            Sequence excludeFolders = SequencesKt.map((Sequence)sequence2, ContentRootCollector::collectSplitModule$lambda$0$1);
            collection.add(new ContentRootResult(root.getPath(), SequencesKt.toList((Sequence)sourceFolders), SequencesKt.toList((Sequence)excludeFolders)));
        }
        List list = (List)destination$iv$iv;
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<ContentRootResult> collectSingleModule(ProjectRootFolder projectRoot, List<? extends ImportedFolder> folders) {
        void $this$mapTo$iv$iv;
        Object curr;
        List result2 = new ArrayList();
        ContentRootWithFolders nearestRoot = null;
        ImportedFolderBase nearestRootFolder = null;
        List allFolders = CollectionsKt.sorted((Iterable)CollectionsKt.plus((Collection)folders, (Iterable)CollectionsKt.listOfNotNull((Object)projectRoot)));
        for (ImportedFolderBase curr2 : allFolders) {
            ImportedFolder prev;
            if (nearestRoot != null && curr2 instanceof ProjectRootFolder && nearestRootFolder instanceof SourceFolder && (((SourceFolder)nearestRootFolder).getType() instanceof JavaResourceRootType || ((SourceFolder)nearestRootFolder).getType() instanceof JavaSourceRootType) && FileUtil.isAncestor((String)((SourceFolder)nearestRootFolder).getPath(), (String)curr2.getPath(), (boolean)true)) {
                result2.removeLast();
                nearestRoot.getFolders().remove(nearestRootFolder);
                nearestRootFolder = curr2;
                nearestRoot = new ContentRootWithFolders(curr2.getPath(), nearestRoot.getFolders());
                result2.add(nearestRoot);
            }
            if (nearestRoot != null && FileUtil.isAncestor((String)nearestRoot.getPath(), (String)curr2.getPath(), (boolean)false)) {
                if (curr2 instanceof ProjectRootFolder || curr2 instanceof ExcludedFolder && FileUtil.pathsEqual((String)nearestRoot.getPath(), (String)curr2.getPath())) {
                    continue;
                }
            } else {
                if (curr2 instanceof ExcludedFolder) continue;
                nearestRootFolder = curr2;
                nearestRoot = new ContentRootWithFolders(curr2.getPath(), null, 2, null);
                result2.add(nearestRoot);
                if (curr2 instanceof ProjectRootFolder) continue;
            }
            if ((prev = (ImportedFolder)CollectionsKt.lastOrNull(nearestRoot.getFolders())) != null && FileUtil.pathsEqual((String)prev.getPath(), (String)curr2.getPath()) && prev.getRank$intellij_maven() <= curr2.getRank$intellij_maven()) continue;
            if (prev != null && FileUtil.isAncestor((String)prev.getPath(), (String)curr2.getPath(), (boolean)true)) {
                if (prev instanceof SourceFolder && curr2 instanceof UserOrGeneratedSourceFolder) {
                    if (((SourceFolder)prev).getRootTypeRank() <= ((UserOrGeneratedSourceFolder)curr2).getRootTypeRank()) continue;
                    nearestRoot.getFolders().removeLast();
                } else if (prev instanceof GeneratedSourceFolder && curr2 instanceof UserOrGeneratedSourceFolder) {
                    if (curr2 instanceof GeneratedSourceFolder && ((GeneratedSourceFolder)curr2).isAnnotationFolder()) continue;
                    nearestRoot.getFolders().removeLast();
                } else if (prev instanceof ExcludedFolderAndPreventSubfolders && curr2 instanceof UserOrGeneratedSourceFolder || prev.getRank$intellij_maven() == curr2.getRank$intellij_maven()) continue;
            }
            if (!(curr2 instanceof ImportedFolder)) continue;
            nearestRoot.getFolders().add((ImportedFolder)curr2);
        }
        for (ContentRootWithFolders root : result2) {
            Iterator<ImportedFolder> folderIterator = root.getFolders().iterator();
            Object prev = null;
            while (folderIterator.hasNext()) {
                curr = folderIterator.next();
                if (prev instanceof BaseExcludedFolder && curr instanceof BaseExcludedFolder && FileUtil.isAncestor((String)((BaseExcludedFolder)prev).getPath(), (String)((ImportedFolderBase)curr).getPath(), (boolean)false)) {
                    folderIterator.remove();
                    continue;
                }
                prev = curr;
            }
        }
        Iterable $this$map$iv = result2;
        boolean $i$f$map = false;
        curr = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void root;
            ContentRootWithFolders contentRootWithFolders = (ContentRootWithFolders)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)root.getFolders());
            boolean $i$f$filterIsInstance = false;
            Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)collectSingleModule$lambda$0$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            Sequence sourceFolders = SequencesKt.map((Sequence)sequence, ContentRootCollector::collectSingleModule$lambda$0$0);
            Sequence $this$filterIsInstance$iv2 = CollectionsKt.asSequence((Iterable)root.getFolders());
            boolean $i$f$filterIsInstance2 = false;
            Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv2, (Function1)collectSingleModule$lambda$0$$inlined$filterIsInstance$2.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            Sequence excludeFolders = SequencesKt.map((Sequence)sequence2, ContentRootCollector::collectSingleModule$lambda$0$1);
            collection.add(new ContentRootResult(root.getPath(), SequencesKt.toList((Sequence)sourceFolders), SequencesKt.toList((Sequence)excludeFolders)));
        }
        List collectedRoots = (List)destination$iv$iv;
        return collectedRoots;
    }

    private static final SourceFolderResult collectSplitModule$lambda$0$0(UserOrGeneratedSourceFolder folder) {
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        return new SourceFolderResult(folder.getPath(), folder.getType(), folder instanceof GeneratedSourceFolder);
    }

    private static final ExcludedFolderResult collectSplitModule$lambda$0$1(BaseExcludedFolder folder) {
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        return new ExcludedFolderResult(folder.getPath());
    }

    private static final SourceFolderResult collectSingleModule$lambda$0$0(UserOrGeneratedSourceFolder folder) {
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        return new SourceFolderResult(folder.getPath(), folder.getType(), folder instanceof GeneratedSourceFolder);
    }

    private static final ExcludedFolderResult collectSingleModule$lambda$0$1(BaseExcludedFolder folder) {
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        return new ExcludedFolderResult(folder.getPath());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/idea/maven/importing/workspaceModel/ContentRootCollector$BaseExcludedFolder;", "Lorg/jetbrains/idea/maven/importing/workspaceModel/ContentRootCollector$ImportedFolder;", "path", "", "rank", "", "<init>", "(Ljava/lang/String;I)V", "intellij.maven"})
    public static abstract class BaseExcludedFolder
    extends ImportedFolder {
        public BaseExcludedFolder(@NotNull String path, int rank) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            super(path, rank);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0010\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/idea/maven/importing/workspaceModel/ContentRootCollector$ContentRootResult;", "", "path", "", "sourceFolders", "", "Lorg/jetbrains/idea/maven/importing/workspaceModel/ContentRootCollector$SourceFolderResult;", "excludeFolders", "Lorg/jetbrains/idea/maven/importing/workspaceModel/ContentRootCollector$ExcludedFolderResult;", "<init>", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "getPath", "()Ljava/lang/String;", "getSourceFolders", "()Ljava/util/List;", "getExcludeFolders", "toString", "intellij.maven"})
    public static final class ContentRootResult {
        @NotNull
        private final String path;
        @NotNull
        private final List<SourceFolderResult> sourceFolders;
        @NotNull
        private final List<ExcludedFolderResult> excludeFolders;

        public ContentRootResult(@NotNull String path, @NotNull List<SourceFolderResult> sourceFolders, @NotNull List<ExcludedFolderResult> excludeFolders) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter(sourceFolders, (String)"sourceFolders");
            Intrinsics.checkNotNullParameter(excludeFolders, (String)"excludeFolders");
            this.path = path;
            this.sourceFolders = sourceFolders;
            this.excludeFolders = excludeFolders;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final List<SourceFolderResult> getSourceFolders() {
            return this.sourceFolders;
        }

        @NotNull
        public final List<ExcludedFolderResult> getExcludeFolders() {
            return this.excludeFolders;
        }

        @NotNull
        public String toString() {
            return "path='" + this.path + "', sourceFolders=" + this.sourceFolders + ", excludeFolders=" + this.excludeFolders;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/idea/maven/importing/workspaceModel/ContentRootCollector$ContentRootWithFolders;", "", "path", "", "folders", "", "Lorg/jetbrains/idea/maven/importing/workspaceModel/ContentRootCollector$ImportedFolder;", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "getPath", "()Ljava/lang/String;", "getFolders", "()Ljava/util/List;", "intellij.maven"})
    private static final class ContentRootWithFolders {
        @NotNull
        private final String path;
        @NotNull
        private final List<ImportedFolder> folders;

        public ContentRootWithFolders(@NotNull String path, @NotNull List<ImportedFolder> folders) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter(folders, (String)"folders");
            this.path = path;
            this.folders = folders;
        }

        public /* synthetic */ ContentRootWithFolders(String string, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                list = new ArrayList();
            }
            this(string, list);
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final List<ImportedFolder> getFolders() {
            return this.folders;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0003H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/idea/maven/importing/workspaceModel/ContentRootCollector$ExcludedFolder;", "Lorg/jetbrains/idea/maven/importing/workspaceModel/ContentRootCollector$BaseExcludedFolder;", "path", "", "<init>", "(Ljava/lang/String;)V", "toString", "intellij.maven"})
    public static final class ExcludedFolder
    extends BaseExcludedFolder {
        public ExcludedFolder(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            super(path, 4);
        }

        @Override
        @NotNull
        public String toString() {
            return this.getPath() + " exclude";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0003H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/idea/maven/importing/workspaceModel/ContentRootCollector$ExcludedFolderAndPreventSubfolders;", "Lorg/jetbrains/idea/maven/importing/workspaceModel/ContentRootCollector$BaseExcludedFolder;", "path", "", "<init>", "(Ljava/lang/String;)V", "toString", "intellij.maven"})
    public static final class ExcludedFolderAndPreventSubfolders
    extends BaseExcludedFolder {
        public ExcludedFolderAndPreventSubfolders(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            super(path, 2);
        }

        @Override
        @NotNull
        public String toString() {
            return this.getPath() + " exclude with subfolders";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/idea/maven/importing/workspaceModel/ContentRootCollector$ExcludedFolderResult;", "", "path", "", "<init>", "(Ljava/lang/String;)V", "getPath", "()Ljava/lang/String;", "toString", "intellij.maven"})
    public static final class ExcludedFolderResult {
        @NotNull
        private final String path;

        public ExcludedFolderResult(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.path = path;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public String toString() {
            return this.path;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/idea/maven/importing/workspaceModel/ContentRootCollector$GeneratedSourceFolder;", "Lorg/jetbrains/idea/maven/importing/workspaceModel/ContentRootCollector$UserOrGeneratedSourceFolder;", "path", "", "type", "Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;", "isAnnotationFolder", "", "<init>", "(Ljava/lang/String;Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;Z)V", "()Z", "intellij.maven"})
    public static final class GeneratedSourceFolder
    extends UserOrGeneratedSourceFolder {
        private final boolean isAnnotationFolder;

        public GeneratedSourceFolder(@NotNull String path, @NotNull JpsModuleSourceRootType<?> type, boolean isAnnotationFolder) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter(type, (String)"type");
            super(path, type, 3);
            this.isAnnotationFolder = isAnnotationFolder;
        }

        public /* synthetic */ GeneratedSourceFolder(String string, JpsModuleSourceRootType jpsModuleSourceRootType, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = false;
            }
            this(string, jpsModuleSourceRootType, bl);
        }

        public final boolean isAnnotationFolder() {
            return this.isAnnotationFolder;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/idea/maven/importing/workspaceModel/ContentRootCollector$ImportedFolder;", "Lorg/jetbrains/idea/maven/importing/workspaceModel/ContentRootCollector$ImportedFolderBase;", "path", "", "rank", "", "<init>", "(Ljava/lang/String;I)V", "intellij.maven"})
    public static abstract non-sealed class ImportedFolder
    extends ImportedFolderBase {
        public ImportedFolder(@NotNull String path, int rank) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            super(path, rank, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0019\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0011\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0000H\u0096\u0002J\b\u0010\u000e\u001a\u00020\u0003H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u0082\u0001\u0002\u000f\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/idea/maven/importing/workspaceModel/ContentRootCollector$ImportedFolderBase;", "", "path", "", "rank", "", "<init>", "(Ljava/lang/String;I)V", "getRank$intellij_maven", "()I", "getPath", "()Ljava/lang/String;", "compareTo", "other", "toString", "Lorg/jetbrains/idea/maven/importing/workspaceModel/ContentRootCollector$ImportedFolder;", "Lorg/jetbrains/idea/maven/importing/workspaceModel/ContentRootCollector$ProjectRootFolder;", "intellij.maven"})
    public static abstract sealed class ImportedFolderBase
    implements Comparable<ImportedFolderBase>
    permits ImportedFolder, ProjectRootFolder {
        private final int rank;
        @NotNull
        private final String path;

        private ImportedFolderBase(String path, int rank) {
            this.rank = rank;
            String string = FileUtil.toCanonicalPath((String)path);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toCanonicalPath(...)");
            this.path = string;
        }

        public final int getRank$intellij_maven() {
            return this.rank;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @Override
        public int compareTo(@NotNull ImportedFolderBase other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            int result2 = FileUtil.comparePaths((String)this.path, (String)other.path);
            if (result2 != 0) {
                return result2;
            }
            return Intrinsics.compare((int)this.rank, (int)other.rank);
        }

        @NotNull
        public String toString() {
            return this.path;
        }

        public /* synthetic */ ImportedFolderBase(String path, int rank, DefaultConstructorMarker $constructor_marker) {
            this(path, rank);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0003H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/idea/maven/importing/workspaceModel/ContentRootCollector$ProjectRootFolder;", "Lorg/jetbrains/idea/maven/importing/workspaceModel/ContentRootCollector$ImportedFolderBase;", "path", "", "<init>", "(Ljava/lang/String;)V", "toString", "intellij.maven"})
    public static final class ProjectRootFolder
    extends ImportedFolderBase {
        public ProjectRootFolder(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            super(path, 0, null);
        }

        @Override
        @NotNull
        public String toString() {
            return this.getPath() + " root";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/idea/maven/importing/workspaceModel/ContentRootCollector$SourceFolder;", "Lorg/jetbrains/idea/maven/importing/workspaceModel/ContentRootCollector$UserOrGeneratedSourceFolder;", "path", "", "type", "Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;", "<init>", "(Ljava/lang/String;Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;)V", "intellij.maven"})
    public static final class SourceFolder
    extends UserOrGeneratedSourceFolder {
        public SourceFolder(@NotNull String path, @NotNull JpsModuleSourceRootType<?> type) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter(type, (String)"type");
            super(path, type, 1);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000f\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/idea/maven/importing/workspaceModel/ContentRootCollector$SourceFolderResult;", "", "path", "", "type", "Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;", "isGenerated", "", "<init>", "(Ljava/lang/String;Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;Z)V", "getPath", "()Ljava/lang/String;", "getType", "()Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;", "()Z", "toString", "intellij.maven"})
    public static final class SourceFolderResult {
        @NotNull
        private final String path;
        @NotNull
        private final JpsModuleSourceRootType<?> type;
        private final boolean isGenerated;

        public SourceFolderResult(@NotNull String path, @NotNull JpsModuleSourceRootType<?> type, boolean isGenerated) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter(type, (String)"type");
            this.path = path;
            this.type = type;
            this.isGenerated = isGenerated;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final JpsModuleSourceRootType<?> getType() {
            return this.type;
        }

        public final boolean isGenerated() {
            return this.isGenerated;
        }

        @NotNull
        public String toString() {
            return this.path + " " + (this.isGenerated ? "generated" : "") + " rootType='" + (this.type.isForTests() ? "test" : "main") + "  " + this.type.getClass().getSimpleName() + "'";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0011\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0003H\u0016R\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u000f\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/idea/maven/importing/workspaceModel/ContentRootCollector$UserOrGeneratedSourceFolder;", "Lorg/jetbrains/idea/maven/importing/workspaceModel/ContentRootCollector$ImportedFolder;", "path", "", "type", "Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;", "rank", "", "<init>", "(Ljava/lang/String;Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;I)V", "getType", "()Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;", "compareTo", "other", "Lorg/jetbrains/idea/maven/importing/workspaceModel/ContentRootCollector$ImportedFolderBase;", "rootTypeRank", "getRootTypeRank", "()I", "toString", "intellij.maven"})
    public static abstract class UserOrGeneratedSourceFolder
    extends ImportedFolder {
        @NotNull
        private final JpsModuleSourceRootType<?> type;

        public UserOrGeneratedSourceFolder(@NotNull String path, @NotNull JpsModuleSourceRootType<?> type, int rank) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter(type, (String)"type");
            super(path, rank);
            this.type = type;
        }

        @NotNull
        public final JpsModuleSourceRootType<?> getType() {
            return this.type;
        }

        @Override
        public int compareTo(@NotNull ImportedFolderBase other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            int result2 = super.compareTo(other);
            if (result2 != 0 || !(other instanceof UserOrGeneratedSourceFolder)) {
                return result2;
            }
            return Intrinsics.compare((int)this.getRootTypeRank(), (int)((UserOrGeneratedSourceFolder)other).getRootTypeRank());
        }

        public final int getRootTypeRank() {
            int n;
            JpsModuleSourceRootType<?> jpsModuleSourceRootType = this.type;
            if (Intrinsics.areEqual(jpsModuleSourceRootType, (Object)JavaSourceRootType.SOURCE)) {
                n = 0;
            } else if (Intrinsics.areEqual(jpsModuleSourceRootType, (Object)JavaSourceRootType.TEST_SOURCE)) {
                n = 1;
            } else if (Intrinsics.areEqual(jpsModuleSourceRootType, (Object)JavaResourceRootType.RESOURCE)) {
                n = 2;
            } else if (Intrinsics.areEqual(jpsModuleSourceRootType, (Object)JavaResourceRootType.TEST_RESOURCE)) {
                n = 3;
            } else {
                throw new IllegalStateException((this.type + " not match to maven root item").toString());
            }
            return n;
        }

        @Override
        @NotNull
        public String toString() {
            return this.getPath() + " rootType='" + (this.type.isForTests() ? "test" : "main") + " " + this.type.getClass().getSimpleName() + "'";
        }
    }
}

