/*
 * Decompiled with CFR 0.152.
 */
package com.agafua.syslog;

import com.agafua.syslog.Facility;
import com.agafua.syslog.Severity;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.LogRecord;

class Adaptor {
    private static final String[] MONTH_NAMES = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

    Adaptor() {
    }

    public String adaptPriority(LogRecord logRecord, Facility facility) {
        int code = (facility.getId() << 3) + this.adaptSeverity(logRecord);
        return String.format("<%d>", code);
    }

    public int adaptSeverity(LogRecord logRecord) {
        Level level = logRecord.getLevel();
        if (level.intValue() >= Level.SEVERE.intValue()) {
            return Severity.ERROR.getLevel();
        }
        if (level.intValue() >= Level.WARNING.intValue()) {
            return Severity.WARNING.getLevel();
        }
        if (level.intValue() >= Level.INFO.intValue()) {
            return Severity.INFO.getLevel();
        }
        return Severity.DEBUG.getLevel();
    }

    public String adaptTimeStamp(LogRecord logRecord) {
        long millis = logRecord.getMillis();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(millis);
        int month = Adaptor.limit(calendar.get(2), 0, 11);
        String mmm = MONTH_NAMES[month];
        int day = Adaptor.limit(calendar.get(5), 1, 31);
        String dd = Adaptor.indent("" + day, 2, ' ');
        int hour = Adaptor.limit(calendar.get(11), 0, 23);
        String hh = Adaptor.indent("" + hour, 2, '0');
        int minute = Adaptor.limit(calendar.get(12), 0, 59);
        String mm = Adaptor.indent("" + minute, 2, '0');
        int second = Adaptor.limit(calendar.get(13), 0, 59);
        String ss = Adaptor.indent("" + second, 2, '0');
        return String.format("%s %s %s:%s:%s", mmm, dd, hh, mm, ss);
    }

    private static String indent(String s2, int requiredLength, char identChar) {
        while (s2.length() < requiredLength) {
            s2 = identChar + s2;
        }
        return s2;
    }

    private static int limit(int value2, int min, int max) {
        if (value2 < min) {
            return min;
        }
        if (value2 > max) {
            return max;
        }
        return value2;
    }
}

