/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.sm.provider;

import java.io.IOException;
import java.util.ArrayList;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.packet.StanzaErrorTextElement;
import org.jivesoftware.smack.sm.packet.StreamManagement;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;

public class ParseStreamManagement {
    public static StreamManagement.Enabled enabled(XmlPullParser parser2) throws XmlPullParserException, IOException {
        ParserUtils.assertAtStartTag(parser2);
        boolean resume = ParserUtils.getBooleanAttribute(parser2, "resume", false);
        String id = parser2.getAttributeValue("", "id");
        String location = parser2.getAttributeValue("", "location");
        int max = ParserUtils.getIntegerAttribute(parser2, "max", -1);
        parser2.next();
        ParserUtils.assertAtEndTag(parser2);
        return new StreamManagement.Enabled(id, resume, location, max);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static StreamManagement.Failed failed(XmlPullParser parser2) throws XmlPullParserException, IOException {
        ParserUtils.assertAtStartTag(parser2);
        StanzaError.Condition condition = null;
        ArrayList<StanzaErrorTextElement> textElements = new ArrayList<StanzaErrorTextElement>(4);
        block4: while (true) {
            XmlPullParser.Event event = parser2.next();
            switch (event) {
                case START_ELEMENT: {
                    String name = parser2.getName();
                    String namespace = parser2.getNamespace();
                    if (!"urn:ietf:params:xml:ns:xmpp-stanzas".equals(namespace)) break;
                    if (name.equals("text")) {
                        String lang = ParserUtils.getXmlLang(parser2);
                        String text = parser2.nextText();
                        StanzaErrorTextElement stanzaErrorTextElement = new StanzaErrorTextElement(text, lang);
                        textElements.add(stanzaErrorTextElement);
                        break;
                    }
                    condition = StanzaError.Condition.fromString(name);
                    break;
                }
                case END_ELEMENT: {
                    String name = parser2.getName();
                    if ("failed".equals(name)) break block4;
                }
            }
        }
        ParserUtils.assertAtEndTag(parser2);
        return new StreamManagement.Failed(condition, textElements);
    }

    public static StreamManagement.Resumed resumed(XmlPullParser parser2) throws XmlPullParserException, IOException {
        ParserUtils.assertAtStartTag(parser2);
        long h2 = ParserUtils.getLongAttribute(parser2, "h");
        String previd = parser2.getAttributeValue("", "previd");
        parser2.next();
        ParserUtils.assertAtEndTag(parser2);
        return new StreamManagement.Resumed(h2, previd);
    }

    public static StreamManagement.AckAnswer ackAnswer(XmlPullParser parser2) throws XmlPullParserException, IOException {
        ParserUtils.assertAtStartTag(parser2);
        long h2 = ParserUtils.getLongAttribute(parser2, "h");
        parser2.next();
        ParserUtils.assertAtEndTag(parser2);
        return new StreamManagement.AckAnswer(h2);
    }

    public static StreamManagement.AckRequest ackRequest(XmlPullParser parser2) throws XmlPullParserException, IOException {
        ParserUtils.assertAtStartTag(parser2);
        parser2.next();
        ParserUtils.assertAtEndTag(parser2);
        return StreamManagement.AckRequest.INSTANCE;
    }
}

