/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.util.Collection;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.AbstractFileChooser;
import org.openstreetmap.josm.gui.widgets.FileChooserManager;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public abstract class DiskAccessAction
extends JosmAction {
    protected DiskAccessAction(String name, String iconName, String tooltip, Shortcut shortcut) {
        super(name, iconName, tooltip, shortcut, true);
    }

    protected DiskAccessAction(String name, String iconName, String tooltip, Shortcut shortcut, boolean register, String toolbarId, boolean installAdapters) {
        super(name, iconName, tooltip, shortcut, register, toolbarId, installAdapters);
    }

    public static AbstractFileChooser createAndOpenFileChooser(boolean open, boolean multiple, String title) {
        return DiskAccessAction.createAndOpenFileChooser(open, multiple, title, null);
    }

    public static AbstractFileChooser createAndOpenFileChooser(boolean open, boolean multiple, String title, String extension) {
        return DiskAccessAction.createAndOpenFileChooser(open, multiple, title, extension, 0, true, null);
    }

    public static AbstractFileChooser createAndOpenFileChooser(boolean open, boolean multiple, String title, String extension, int selectionMode, boolean allTypes, String lastDirProperty) {
        return new FileChooserManager(open, lastDirProperty).createFileChooser(multiple, title, extension, allTypes, selectionMode).openFileChooser();
    }

    public static AbstractFileChooser createAndOpenFileChooser(boolean open, boolean multiple, String title, FileFilter filter, int selectionMode, String lastDirProperty) {
        return new FileChooserManager(open, lastDirProperty).createFileChooser(multiple, title, filter, selectionMode).openFileChooser();
    }

    public static AbstractFileChooser createAndOpenFileChooser(boolean open, boolean multiple, String title, Collection<? extends FileFilter> filters, FileFilter defaultFilter, int selectionMode, String lastDirProperty) {
        return new FileChooserManager(open, lastDirProperty).createFileChooser(multiple, title, filters, defaultFilter, selectionMode).openFileChooser();
    }

    protected static Notification showSavingNotification(String filename) {
        Notification savingNotification = new Notification(I18n.tr("Saving file {0}...", filename)).setIcon(ImageProvider.get("save"));
        GuiHelper.runInEDT(savingNotification::show);
        return savingNotification;
    }

    protected static Notification showSavedNotification(Notification savingNotification, String filename) {
        Notification doneNotification = new Notification(I18n.tr("Successfully saved file {0}", filename)).setIcon(ImageProvider.get("save"));
        GuiHelper.runInEDT(() -> doneNotification.replaceExisting(savingNotification));
        return doneNotification;
    }
}

