/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social.facebook;

import com.fasterxml.jackson.databind.JsonNode;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import org.keycloak.broker.oidc.AbstractOAuth2IdentityProvider;
import org.keycloak.broker.oidc.mappers.AbstractJsonUserAttributeMapper;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.provider.UserAuthenticationIdentityProvider;
import org.keycloak.broker.social.SocialIdentityProvider;
import org.keycloak.events.EventBuilder;
import org.keycloak.http.simple.SimpleHttp;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.TokenExchangeContext;
import org.keycloak.saml.common.util.StringUtil;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.social.facebook.FacebookIdentityProviderConfig;

public class FacebookIdentityProvider
extends AbstractOAuth2IdentityProvider<FacebookIdentityProviderConfig>
implements SocialIdentityProvider<FacebookIdentityProviderConfig> {
    public static final String AUTH_URL = "https://graph.facebook.com/oauth/authorize";
    public static final String TOKEN_URL = "https://graph.facebook.com/oauth/access_token";
    public static final String PROFILE_URL = "https://graph.facebook.com/me?fields=id,name,email,first_name,last_name";
    public static final String DEBUG_TOKEN_URL = "https://graph.facebook.com/debug_token";
    public static final String DEFAULT_SCOPE = "email";
    protected static final String PROFILE_URL_FIELDS_SEPARATOR = ",";

    public FacebookIdentityProvider(KeycloakSession session, FacebookIdentityProviderConfig config) {
        super(session, config);
        config.setAuthorizationUrl(AUTH_URL);
        config.setTokenUrl(TOKEN_URL);
        config.setUserInfoUrl(PROFILE_URL);
    }

    @Override
    protected BrokeredIdentityContext doGetFederatedIdentity(String accessToken) {
        try {
            String fetchedFields = ((FacebookIdentityProviderConfig)this.getConfig()).getFetchedFields();
            String url = StringUtil.isNotNull((String)fetchedFields) ? String.join((CharSequence)PROFILE_URL_FIELDS_SEPARATOR, PROFILE_URL, fetchedFields) : PROFILE_URL;
            JsonNode profile = SimpleHttp.create((KeycloakSession)this.session).doGet(url).header("Authorization", "Bearer " + accessToken).asJson();
            return this.extractIdentityFromProfile(null, profile);
        }
        catch (Exception e) {
            throw new IdentityBrokerException("Could not obtain user profile from facebook.", (Throwable)e);
        }
    }

    private void verifyToken(String accessToken) throws IOException {
        JsonNode response = SimpleHttp.create((KeycloakSession)this.session).doGet(DEBUG_TOKEN_URL).header("Authorization", "Bearer " + ((FacebookIdentityProviderConfig)this.getConfig()).getClientId() + "|" + ((FacebookIdentityProviderConfig)this.getConfig()).getClientSecret()).param("input_token", accessToken).asJson();
        JsonNode errorNode = response.get("error");
        if (errorNode != null) {
            String errorMessage = this.getJsonProperty(errorNode, "message");
            throw new RuntimeException("Error message:  " + errorMessage);
        }
        JsonNode dataNode = response.get("data");
        if (dataNode == null || dataNode.isNull()) {
            throw new RuntimeException("Invalid token debug response: 'data' field is missing.");
        }
        String appId = this.getJsonProperty(dataNode, "app_id");
        if (!((FacebookIdentityProviderConfig)this.getConfig()).getClientId().equals(appId)) {
            throw new RuntimeException("Client ID does not match the app_id in the access token debug response.");
        }
    }

    @Override
    protected boolean supportsExternalExchange() {
        return true;
    }

    @Override
    protected String getProfileEndpointForValidation(EventBuilder event) {
        return PROFILE_URL;
    }

    @Override
    protected BrokeredIdentityContext extractIdentityFromProfile(EventBuilder event, JsonNode profile) {
        String id = this.getJsonProperty(profile, "id");
        BrokeredIdentityContext user = new BrokeredIdentityContext(id, this.getConfig());
        String email = this.getJsonProperty(profile, DEFAULT_SCOPE);
        user.setEmail(email);
        String username = this.getJsonProperty(profile, "username");
        if (username == null) {
            username = email != null ? email : id;
        }
        user.setUsername(username);
        String firstName = this.getJsonProperty(profile, "first_name");
        String lastName = this.getJsonProperty(profile, "last_name");
        if (lastName == null) {
            lastName = "";
        }
        user.setFirstName(firstName);
        user.setLastName(lastName);
        user.setIdp((UserAuthenticationIdentityProvider)this);
        AbstractJsonUserAttributeMapper.storeUserProfileForMapper(user, profile, ((FacebookIdentityProviderConfig)this.getConfig()).getAlias());
        return user;
    }

    @Override
    protected BrokeredIdentityContext exchangeExternalTokenV2Impl(TokenExchangeContext tokenExchangeContext) {
        String subjectToken = (String)tokenExchangeContext.getFormParams().getFirst((Object)"subject_token");
        if (subjectToken == null) {
            throw new ErrorResponseException("invalid_token", "token not set", Response.Status.BAD_REQUEST);
        }
        try {
            this.verifyToken(subjectToken);
            return this.doGetFederatedIdentity(subjectToken);
        }
        catch (Exception e) {
            throw new ErrorResponseException("invalid_token", e.getMessage(), Response.Status.BAD_REQUEST);
        }
    }

    @Override
    protected String getDefaultScopes() {
        return DEFAULT_SCOPE;
    }
}

