/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.module.script.providersupport.shared;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.module.script.providersupport.internal.ProviderRegistry;
import org.openhab.core.automation.module.script.providersupport.shared.ScriptedMetadataProvider;
import org.openhab.core.common.registry.Identifiable;
import org.openhab.core.common.registry.RegistryChangeListener;
import org.openhab.core.items.Metadata;
import org.openhab.core.items.MetadataKey;
import org.openhab.core.items.MetadataPredicates;
import org.openhab.core.items.MetadataRegistry;

@NonNullByDefault
public class ProviderMetadataRegistryDelegate
implements MetadataRegistry,
ProviderRegistry {
    private final MetadataRegistry metadataRegistry;
    private final Set<MetadataKey> metadataKeys = new HashSet<MetadataKey>();
    private final ScriptedMetadataProvider scriptedProvider;

    public ProviderMetadataRegistryDelegate(MetadataRegistry metadataRegistry, ScriptedMetadataProvider scriptedProvider) {
        this.metadataRegistry = metadataRegistry;
        this.scriptedProvider = scriptedProvider;
    }

    public void addRegistryChangeListener(RegistryChangeListener<Metadata> listener) {
        this.metadataRegistry.addRegistryChangeListener(listener);
    }

    public Collection<Metadata> getAll() {
        return this.metadataRegistry.getAll();
    }

    public Stream<Metadata> stream() {
        return this.metadataRegistry.stream();
    }

    public @Nullable Metadata get(MetadataKey key) {
        return (Metadata)this.metadataRegistry.get((Object)key);
    }

    public void removeRegistryChangeListener(RegistryChangeListener<Metadata> listener) {
        this.metadataRegistry.removeRegistryChangeListener(listener);
    }

    public Metadata add(Metadata element) {
        MetadataKey key = element.getUID();
        if (this.get(key) != null) {
            throw new IllegalArgumentException("Cannot add metadata, because metadata with same name (" + String.valueOf(key) + ") already exists.");
        }
        this.scriptedProvider.add(element);
        this.metadataKeys.add(key);
        return element;
    }

    public Metadata addPermanent(Metadata element) {
        return (Metadata)this.metadataRegistry.add((Identifiable)element);
    }

    public @Nullable Metadata update(Metadata element) {
        if (this.metadataKeys.contains(element.getUID())) {
            return this.scriptedProvider.update(element);
        }
        return (Metadata)this.metadataRegistry.update((Identifiable)element);
    }

    public @Nullable Metadata remove(MetadataKey key) {
        if (this.metadataKeys.contains(key)) {
            return this.scriptedProvider.remove(key);
        }
        return (Metadata)this.metadataRegistry.remove((Object)key);
    }

    public boolean isInternalNamespace(String namespace) {
        return this.metadataRegistry.isInternalNamespace(namespace);
    }

    public Collection<String> getAllNamespaces(String itemname) {
        return this.metadataRegistry.getAllNamespaces(itemname);
    }

    public void removeItemMetadata(String itemname) {
        if (this.scriptedProvider.getAll().stream().anyMatch(MetadataPredicates.ofItem((String)itemname))) {
            this.scriptedProvider.removeItemMetadata(itemname);
            return;
        }
        this.metadataRegistry.removeItemMetadata(itemname);
    }

    @Override
    public void removeAllAddedByScript() {
        for (MetadataKey key : this.metadataKeys) {
            this.scriptedProvider.remove(key);
        }
        this.metadataKeys.clear();
    }
}

