/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.rest.internal;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Locale;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.dto.ActionTypeDTOMapper;
import org.openhab.core.automation.dto.ConditionTypeDTOMapper;
import org.openhab.core.automation.dto.ModuleTypeDTO;
import org.openhab.core.automation.dto.TriggerTypeDTOMapper;
import org.openhab.core.automation.type.ActionType;
import org.openhab.core.automation.type.CompositeActionType;
import org.openhab.core.automation.type.CompositeConditionType;
import org.openhab.core.automation.type.CompositeTriggerType;
import org.openhab.core.automation.type.ConditionType;
import org.openhab.core.automation.type.ModuleType;
import org.openhab.core.automation.type.ModuleTypeRegistry;
import org.openhab.core.automation.type.TriggerType;
import org.openhab.core.io.rest.LocaleService;
import org.openhab.core.io.rest.RESTResource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JSONRequired;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsApplicationSelect;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsName;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;

@Path(value="module-types")
@Tag(name="module-types")
@Component
@JaxrsResource
@JaxrsName(value="module-types")
@JaxrsApplicationSelect(value="(osgi.jaxrs.name=openhab)")
@JSONRequired
@NonNullByDefault
public class ModuleTypeResource
implements RESTResource {
    public static final String PATH_MODULE_TYPES = "module-types";
    private final LocaleService localeService;
    private final ModuleTypeRegistry moduleTypeRegistry;

    @Activate
    public ModuleTypeResource(@Reference LocaleService localeService, @Reference ModuleTypeRegistry moduleTypeRegistry) {
        this.localeService = localeService;
        this.moduleTypeRegistry = moduleTypeRegistry;
    }

    @GET
    @Produces(value={"application/json"})
    @Operation(operationId="getModuleTypes", summary="Get all available module types.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ModuleTypeDTO.class)))})})
    public Response getAll(@HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language, @QueryParam(value="tags") @Parameter(description="tags for filtering") @Nullable String tagList, @QueryParam(value="type") @Parameter(description="filtering by action, condition or trigger") @Nullable String type, @QueryParam(value="asMap") @Parameter(description="returns an object of arrays by type instead of a mixed array") @Nullable Boolean asMap) {
        Locale locale = this.localeService.getLocale(language);
        String[] tags = tagList != null ? tagList.split(",") : new String[]{};
        LinkedHashMap modulesMap = null;
        ArrayList modules = null;
        if (asMap == null || !asMap.booleanValue()) {
            modules = new ArrayList();
        } else {
            modulesMap = new LinkedHashMap();
        }
        if (type == null || "trigger".equals(type)) {
            if (modules != null) {
                modules.addAll(TriggerTypeDTOMapper.map((Collection)this.moduleTypeRegistry.getTriggers(locale, tags)));
            } else if (modulesMap != null) {
                modulesMap.put("triggers", new ArrayList(TriggerTypeDTOMapper.map((Collection)this.moduleTypeRegistry.getTriggers(locale, tags))));
            }
        }
        if (type == null || "condition".equals(type)) {
            if (modules != null) {
                modules.addAll(ConditionTypeDTOMapper.map((Collection)this.moduleTypeRegistry.getConditions(locale, tags)));
            } else if (modulesMap != null) {
                modulesMap.put("conditions", new ArrayList(ConditionTypeDTOMapper.map((Collection)this.moduleTypeRegistry.getConditions(locale, tags))));
            }
        }
        if (type == null || "action".equals(type)) {
            if (modules != null) {
                modules.addAll(ActionTypeDTOMapper.map((Collection)this.moduleTypeRegistry.getActions(locale, tags)));
            } else if (modulesMap != null) {
                modulesMap.put("actions", new ArrayList(ActionTypeDTOMapper.map((Collection)this.moduleTypeRegistry.getActions(locale, tags))));
            }
        }
        return Response.ok(modules != null ? modules : modulesMap).build();
    }

    @GET
    @Path(value="/{moduleTypeUID}")
    @Produces(value={"application/json"})
    @Operation(operationId="getModuleTypeById", summary="Gets a module type corresponding to the given UID.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ModuleTypeDTO.class))}), @ApiResponse(responseCode="404", description="Module Type corresponding to the given UID does not found.")})
    public Response getByUID(@HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language, @PathParam(value="moduleTypeUID") @Parameter(description="moduleTypeUID") String moduleTypeUID) {
        Locale locale = this.localeService.getLocale(language);
        ModuleType moduleType = this.moduleTypeRegistry.get(moduleTypeUID, locale);
        if (moduleType != null) {
            return Response.ok((Object)this.getModuleTypeDTO(moduleType)).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    private ModuleTypeDTO getModuleTypeDTO(ModuleType moduleType) {
        if (moduleType instanceof ActionType) {
            ActionType actionType = (ActionType)moduleType;
            if (moduleType instanceof CompositeActionType) {
                CompositeActionType compositeActionType = (CompositeActionType)moduleType;
                return ActionTypeDTOMapper.map((CompositeActionType)compositeActionType);
            }
            return ActionTypeDTOMapper.map((ActionType)actionType);
        }
        if (moduleType instanceof ConditionType) {
            ConditionType conditionType = (ConditionType)moduleType;
            if (moduleType instanceof CompositeConditionType) {
                CompositeConditionType compositeConditionType = (CompositeConditionType)moduleType;
                return ConditionTypeDTOMapper.map((CompositeConditionType)compositeConditionType);
            }
            return ConditionTypeDTOMapper.map((ConditionType)conditionType);
        }
        if (moduleType instanceof TriggerType) {
            TriggerType triggerType = (TriggerType)moduleType;
            if (moduleType instanceof CompositeTriggerType) {
                CompositeTriggerType compositeTriggerType = (CompositeTriggerType)moduleType;
                return TriggerTypeDTOMapper.map((CompositeTriggerType)compositeTriggerType);
            }
            return TriggerTypeDTOMapper.map((TriggerType)triggerType);
        }
        throw new IllegalArgumentException(String.format("Cannot handle given module type class (%s)", moduleType.getClass()));
    }
}

