# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("cabinet.dll")
prototypes = \
    {
        #
        'FCICreate': SimTypeFunction([SimTypePointer(SimStruct({"erfOper": SimTypeInt(signed=True, label="Int32"), "erfType": SimTypeInt(signed=True, label="Int32"), "fError": SimTypeInt(signed=True, label="Int32")}, name="ERF", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"cb": SimTypeInt(signed=False, label="UInt32"), "cbFolderThresh": SimTypeInt(signed=False, label="UInt32"), "cbReserveCFHeader": SimTypeInt(signed=False, label="UInt32"), "cbReserveCFFolder": SimTypeInt(signed=False, label="UInt32"), "cbReserveCFData": SimTypeInt(signed=False, label="UInt32"), "iCab": SimTypeInt(signed=True, label="Int32"), "iDisk": SimTypeInt(signed=True, label="Int32"), "fFailOnIncompressible": SimTypeInt(signed=True, label="Int32"), "setID": SimTypeShort(signed=False, label="UInt16"), "szDisk": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256), "szCab": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256), "szCabPath": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256)}, name="CCAB", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pccab", "pszFile", "cbFile", "fContinuation", "pv"]), offset=0), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["cb"]), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["memory"]), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["pszFile", "oflag", "pmode", "err", "pv"]), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hf", "memory", "cb", "err", "pv"]), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hf", "memory", "cb", "err", "pv"]), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hf", "err", "pv"]), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hf", "dist", "seektype", "err", "pv"]), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszFile", "err", "pv"]), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszTempName", "cbTempName", "pv"]), offset=0), SimTypePointer(SimStruct({"cb": SimTypeInt(signed=False, label="UInt32"), "cbFolderThresh": SimTypeInt(signed=False, label="UInt32"), "cbReserveCFHeader": SimTypeInt(signed=False, label="UInt32"), "cbReserveCFFolder": SimTypeInt(signed=False, label="UInt32"), "cbReserveCFData": SimTypeInt(signed=False, label="UInt32"), "iCab": SimTypeInt(signed=True, label="Int32"), "iDisk": SimTypeInt(signed=True, label="Int32"), "fFailOnIncompressible": SimTypeInt(signed=True, label="Int32"), "setID": SimTypeShort(signed=False, label="UInt16"), "szDisk": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256), "szCab": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256), "szCabPath": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256)}, name="CCAB", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["perf", "pfnfcifp", "pfna", "pfnf", "pfnopen", "pfnread", "pfnwrite", "pfnclose", "pfnseek", "pfndelete", "pfnfcigtf", "pccab", "pv"]),
        #
        'FCIAddFile': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"cb": SimTypeInt(signed=False, label="UInt32"), "cbFolderThresh": SimTypeInt(signed=False, label="UInt32"), "cbReserveCFHeader": SimTypeInt(signed=False, label="UInt32"), "cbReserveCFFolder": SimTypeInt(signed=False, label="UInt32"), "cbReserveCFData": SimTypeInt(signed=False, label="UInt32"), "iCab": SimTypeInt(signed=True, label="Int32"), "iDisk": SimTypeInt(signed=True, label="Int32"), "fFailOnIncompressible": SimTypeInt(signed=True, label="Int32"), "setID": SimTypeShort(signed=False, label="UInt16"), "szDisk": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256), "szCab": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256), "szCabPath": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256)}, name="CCAB", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pccab", "cbPrevCab", "pv"]), offset=0), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["typeStatus", "cb1", "cb2", "pv"]), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["pszName", "pdate", "ptime", "pattribs", "err", "pv"]), offset=0), SimTypeShort(signed=False, label="UInt16")], SimTypeInt(signed=True, label="Int32"), arg_names=["hfci", "pszSourceFile", "pszFileName", "fExecute", "pfnfcignc", "pfnfcis", "pfnfcigoi", "typeCompress"]),
        #
        'FCIFlushCabinet': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"cb": SimTypeInt(signed=False, label="UInt32"), "cbFolderThresh": SimTypeInt(signed=False, label="UInt32"), "cbReserveCFHeader": SimTypeInt(signed=False, label="UInt32"), "cbReserveCFFolder": SimTypeInt(signed=False, label="UInt32"), "cbReserveCFData": SimTypeInt(signed=False, label="UInt32"), "iCab": SimTypeInt(signed=True, label="Int32"), "iDisk": SimTypeInt(signed=True, label="Int32"), "fFailOnIncompressible": SimTypeInt(signed=True, label="Int32"), "setID": SimTypeShort(signed=False, label="UInt16"), "szDisk": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256), "szCab": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256), "szCabPath": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256)}, name="CCAB", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pccab", "cbPrevCab", "pv"]), offset=0), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["typeStatus", "cb1", "cb2", "pv"]), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hfci", "fGetNextCab", "pfnfcignc", "pfnfcis"]),
        #
        'FCIFlushFolder': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"cb": SimTypeInt(signed=False, label="UInt32"), "cbFolderThresh": SimTypeInt(signed=False, label="UInt32"), "cbReserveCFHeader": SimTypeInt(signed=False, label="UInt32"), "cbReserveCFFolder": SimTypeInt(signed=False, label="UInt32"), "cbReserveCFData": SimTypeInt(signed=False, label="UInt32"), "iCab": SimTypeInt(signed=True, label="Int32"), "iDisk": SimTypeInt(signed=True, label="Int32"), "fFailOnIncompressible": SimTypeInt(signed=True, label="Int32"), "setID": SimTypeShort(signed=False, label="UInt16"), "szDisk": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256), "szCab": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256), "szCabPath": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256)}, name="CCAB", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pccab", "cbPrevCab", "pv"]), offset=0), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["typeStatus", "cb1", "cb2", "pv"]), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hfci", "pfnfcignc", "pfnfcis"]),
        #
        'FCIDestroy': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hfci"]),
        #
        'FDICreate': SimTypeFunction([SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["cb"]), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pv"]), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["pszFile", "oflag", "pmode"]), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hf", "pv", "cb"]), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hf", "pv", "cb"]), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hf"]), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hf", "dist", "seektype"]), offset=0), SimTypeInt(signed=False, label="FDICREATE_CPU_TYPE"), SimTypePointer(SimStruct({"erfOper": SimTypeInt(signed=True, label="Int32"), "erfType": SimTypeInt(signed=True, label="Int32"), "fError": SimTypeInt(signed=True, label="Int32")}, name="ERF", pack=False, align=None), offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["pfnalloc", "pfnfree", "pfnopen", "pfnread", "pfnwrite", "pfnclose", "pfnseek", "cpuType", "perf"]),
        #
        'FDIIsCabinet': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbCabinet": SimTypeInt(signed=True, label="Int32"), "cFolders": SimTypeShort(signed=False, label="UInt16"), "cFiles": SimTypeShort(signed=False, label="UInt16"), "setID": SimTypeShort(signed=False, label="UInt16"), "iCabinet": SimTypeShort(signed=False, label="UInt16"), "fReserve": SimTypeInt(signed=True, label="Int32"), "hasprev": SimTypeInt(signed=True, label="Int32"), "hasnext": SimTypeInt(signed=True, label="Int32")}, name="FDICABINETINFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hfdi", "hf", "pfdici"]),
        #
        'FDICopy': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="FDINOTIFICATIONTYPE"), SimTypePointer(SimStruct({"cb": SimTypeInt(signed=True, label="Int32"), "psz1": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "psz2": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "psz3": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hf": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "date": SimTypeShort(signed=False, label="UInt16"), "time": SimTypeShort(signed=False, label="UInt16"), "attribs": SimTypeShort(signed=False, label="UInt16"), "setID": SimTypeShort(signed=False, label="UInt16"), "iCabinet": SimTypeShort(signed=False, label="UInt16"), "iFolder": SimTypeShort(signed=False, label="UInt16"), "fdie": SimTypeInt(signed=False, label="FDIERROR")}, name="FDINOTIFICATION", pack=False, align=None), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["fdint", "pfdin"]), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"fdidt": SimTypeInt(signed=False, label="FDIDECRYPTTYPE"), "pvUser": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Anonymous": SimUnion({"cabinet": SimStruct({"pHeaderReserve": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cbHeaderReserve": SimTypeShort(signed=False, label="UInt16"), "setID": SimTypeShort(signed=False, label="UInt16"), "iCabinet": SimTypeInt(signed=True, label="Int32")}, name="_cabinet_e__Struct", pack=False, align=None), "folder": SimStruct({"pFolderReserve": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cbFolderReserve": SimTypeShort(signed=False, label="UInt16"), "iFolder": SimTypeShort(signed=False, label="UInt16")}, name="_folder_e__Struct", pack=False, align=None), "decrypt": SimStruct({"pDataReserve": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cbDataReserve": SimTypeShort(signed=False, label="UInt16"), "pbData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cbData": SimTypeShort(signed=False, label="UInt16"), "fSplit": SimTypeInt(signed=True, label="Int32"), "cbPartial": SimTypeShort(signed=False, label="UInt16")}, name="_decrypt_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="FDIDECRYPT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pfdid"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hfdi", "pszCabinet", "pszCabPath", "flags", "pfnfdin", "pfnfdid", "pvUser"]),
        #
        'FDIDestroy': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hfdi"]),
        #
        'FDITruncateCabinet': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeShort(signed=False, label="UInt16")], SimTypeInt(signed=True, label="Int32"), arg_names=["hfdi", "pszCabinetName", "iFolderToDelete"]),
        #
        'CreateCompressor': SimTypeFunction([SimTypeInt(signed=False, label="COMPRESS_ALGORITHM"), SimTypePointer(SimStruct({"Allocate": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["UserContext", "Size"]), offset=0), "Free": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["UserContext", "Memory"]), offset=0), "UserContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="COMPRESS_ALLOCATION_ROUTINES", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Algorithm", "AllocationRoutines", "CompressorHandle"]),
        #
        'SetCompressorInformation': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="COMPRESS_INFORMATION_CLASS"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["CompressorHandle", "CompressInformationClass", "CompressInformation", "CompressInformationSize"]),
        #
        'QueryCompressorInformation': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="COMPRESS_INFORMATION_CLASS"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["CompressorHandle", "CompressInformationClass", "CompressInformation", "CompressInformationSize"]),
        #
        'Compress': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["CompressorHandle", "UncompressedData", "UncompressedDataSize", "CompressedBuffer", "CompressedBufferSize", "CompressedDataSize"]),
        #
        'ResetCompressor': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["CompressorHandle"]),
        #
        'CloseCompressor': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["CompressorHandle"]),
        #
        'CreateDecompressor': SimTypeFunction([SimTypeInt(signed=False, label="COMPRESS_ALGORITHM"), SimTypePointer(SimStruct({"Allocate": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["UserContext", "Size"]), offset=0), "Free": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["UserContext", "Memory"]), offset=0), "UserContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="COMPRESS_ALLOCATION_ROUTINES", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Algorithm", "AllocationRoutines", "DecompressorHandle"]),
        #
        'SetDecompressorInformation': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="COMPRESS_INFORMATION_CLASS"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["DecompressorHandle", "CompressInformationClass", "CompressInformation", "CompressInformationSize"]),
        #
        'QueryDecompressorInformation': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="COMPRESS_INFORMATION_CLASS"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["DecompressorHandle", "CompressInformationClass", "CompressInformation", "CompressInformationSize"]),
        #
        'Decompress': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["DecompressorHandle", "CompressedData", "CompressedDataSize", "UncompressedBuffer", "UncompressedBufferSize", "UncompressedDataSize"]),
        #
        'ResetDecompressor': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["DecompressorHandle"]),
        #
        'CloseDecompressor': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["DecompressorHandle"]),
    }

lib.set_prototypes(prototypes)
