# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("fwpuclnt.dll")
prototypes = \
    {
        #
        'WSASetSocketSecurity': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"SecurityProtocol": SimTypeInt(signed=False, label="SOCKET_SECURITY_PROTOCOL"), "SecurityFlags": SimTypeInt(signed=False, label="UInt32")}, name="SOCKET_SECURITY_SETTINGS", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="OVERLAPPED"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["dwError", "cbTransferred", "lpOverlapped", "dwFlags"]), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Socket", "SecuritySettings", "SecuritySettingsLen", "Overlapped", "CompletionRoutine"]),
        #
        'WSAQuerySocketSecurity': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"SecurityProtocol": SimTypeInt(signed=False, label="SOCKET_SECURITY_PROTOCOL"), "PeerAddress": SimStruct({"ss_family": SimTypeShort(signed=False, label="UInt16"), "__ss_pad1": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 6), "__ss_align": SimTypeLongLong(signed=True, label="Int64"), "__ss_pad2": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 112)}, name="SOCKADDR_STORAGE", pack=False, align=None), "PeerTokenAccessMask": SimTypeInt(signed=False, label="UInt32")}, name="SOCKET_SECURITY_QUERY_TEMPLATE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"SecurityProtocol": SimTypeInt(signed=False, label="SOCKET_SECURITY_PROTOCOL"), "Flags": SimTypeInt(signed=False, label="UInt32"), "PeerApplicationAccessTokenHandle": SimTypeLongLong(signed=False, label="UInt64"), "PeerMachineAccessTokenHandle": SimTypeLongLong(signed=False, label="UInt64")}, name="SOCKET_SECURITY_QUERY_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="OVERLAPPED"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["dwError", "cbTransferred", "lpOverlapped", "dwFlags"]), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Socket", "SecurityQueryTemplate", "SecurityQueryTemplateLen", "SecurityQueryInfo", "SecurityQueryInfoLen", "Overlapped", "CompletionRoutine"]),
        #
        'WSASetSocketPeerTargetName': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"SecurityProtocol": SimTypeInt(signed=False, label="SOCKET_SECURITY_PROTOCOL"), "PeerAddress": SimStruct({"ss_family": SimTypeShort(signed=False, label="UInt16"), "__ss_pad1": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 6), "__ss_align": SimTypeLongLong(signed=True, label="Int64"), "__ss_pad2": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 112)}, name="SOCKADDR_STORAGE", pack=False, align=None), "PeerTargetNameStringLen": SimTypeInt(signed=False, label="UInt32"), "AllStrings": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="SOCKET_PEER_TARGET_NAME", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="OVERLAPPED"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["dwError", "cbTransferred", "lpOverlapped", "dwFlags"]), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Socket", "PeerTargetName", "PeerTargetNameLen", "Overlapped", "CompletionRoutine"]),
        #
        'WSADeleteSocketPeerTargetName': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="OVERLAPPED"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["dwError", "cbTransferred", "lpOverlapped", "dwFlags"]), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Socket", "PeerAddr", "PeerAddrLen", "Overlapped", "CompletionRoutine"]),
        #
        'WSAImpersonateSocketPeer': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["Socket", "PeerAddr", "PeerAddrLen"]),
        #
        'WSARevertImpersonation': SimTypeFunction([], SimTypeInt(signed=True, label="Int32")),
        #
        'FwpmFreeMemory0': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeBottom(label="Void"), arg_names=["p"]),
        #
        'FwpmEngineOpen0': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"User": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "UserLength": SimTypeInt(signed=False, label="UInt32"), "Domain": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "DomainLength": SimTypeInt(signed=False, label="UInt32"), "Password": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "PasswordLength": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="SEC_WINNT_AUTH_IDENTITY")}, name="SEC_WINNT_AUTH_IDENTITY_W", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"sessionKey": SimTypeBottom(label="Guid"), "displayData": SimStruct({"name": SimTypePointer(SimTypeChar(label="Char"), offset=0), "description": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="FWPM_DISPLAY_DATA0", pack=False, align=None), "flags": SimTypeInt(signed=False, label="UInt32"), "txnWaitTimeoutInMSec": SimTypeInt(signed=False, label="UInt32"), "processId": SimTypeInt(signed=False, label="UInt32"), "sid": SimTypePointer(SimTypeBottom(label="SID"), offset=0), "username": SimTypePointer(SimTypeChar(label="Char"), offset=0), "kernelMode": SimTypeInt(signed=True, label="Int32")}, name="FWPM_SESSION0", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["serverName", "authnService", "authIdentity", "session", "engineHandle"]),
        #
        'FwpmEngineClose0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["engineHandle"]),
        #
        'FwpmEngineGetOption0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="FWPM_ENGINE_OPTION"), SimTypePointer(SimTypePointer(SimStruct({"type": SimTypeInt(signed=False, label="FWP_DATA_TYPE"), "Anonymous": SimUnion({"uint8": SimTypeChar(label="Byte"), "uint16": SimTypeShort(signed=False, label="UInt16"), "uint32": SimTypeInt(signed=False, label="UInt32"), "uint64": SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), "int8": SimTypeChar(label="SByte"), "int16": SimTypeShort(signed=True, label="Int16"), "int32": SimTypeInt(signed=True, label="Int32"), "int64": SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0), "float32": SimTypeFloat(size=32), "double64": SimTypePointer(SimTypeFloat(size=64), offset=0), "byteArray16": SimTypePointer(SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), offset=0), "byteBlob": SimTypePointer(SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), offset=0), "sid": SimTypePointer(SimTypeBottom(label="SID"), offset=0), "sd": SimTypePointer(SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), offset=0), "tokenInformation": SimTypePointer(SimStruct({"sidCount": SimTypeInt(signed=False, label="UInt32"), "sids": SimTypePointer(SimTypeBottom(label="SID_AND_ATTRIBUTES"), offset=0), "restrictedSidCount": SimTypeInt(signed=False, label="UInt32"), "restrictedSids": SimTypePointer(SimTypeBottom(label="SID_AND_ATTRIBUTES"), offset=0)}, name="FWP_TOKEN_INFORMATION", pack=False, align=None), offset=0), "tokenAccessInformation": SimTypePointer(SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), offset=0), "unicodeString": SimTypePointer(SimTypeChar(label="Char"), offset=0), "byteArray6": SimTypePointer(SimStruct({"byteArray6": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 6)}, name="FWP_BYTE_ARRAY6", pack=False, align=None), offset=0), "bitmapArray64": SimTypePointer(SimStruct({"bitmapArray64": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 8)}, name="FWP_BITMAP_ARRAY64_", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="FWP_VALUE0", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["engineHandle", "option", "value"]),
        #
        'FwpmEngineSetOption0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="FWPM_ENGINE_OPTION"), SimTypePointer(SimStruct({"type": SimTypeInt(signed=False, label="FWP_DATA_TYPE"), "Anonymous": SimUnion({"uint8": SimTypeChar(label="Byte"), "uint16": SimTypeShort(signed=False, label="UInt16"), "uint32": SimTypeInt(signed=False, label="UInt32"), "uint64": SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), "int8": SimTypeChar(label="SByte"), "int16": SimTypeShort(signed=True, label="Int16"), "int32": SimTypeInt(signed=True, label="Int32"), "int64": SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0), "float32": SimTypeFloat(size=32), "double64": SimTypePointer(SimTypeFloat(size=64), offset=0), "byteArray16": SimTypePointer(SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), offset=0), "byteBlob": SimTypePointer(SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), offset=0), "sid": SimTypePointer(SimTypeBottom(label="SID"), offset=0), "sd": SimTypePointer(SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), offset=0), "tokenInformation": SimTypePointer(SimStruct({"sidCount": SimTypeInt(signed=False, label="UInt32"), "sids": SimTypePointer(SimTypeBottom(label="SID_AND_ATTRIBUTES"), offset=0), "restrictedSidCount": SimTypeInt(signed=False, label="UInt32"), "restrictedSids": SimTypePointer(SimTypeBottom(label="SID_AND_ATTRIBUTES"), offset=0)}, name="FWP_TOKEN_INFORMATION", pack=False, align=None), offset=0), "tokenAccessInformation": SimTypePointer(SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), offset=0), "unicodeString": SimTypePointer(SimTypeChar(label="Char"), offset=0), "byteArray6": SimTypePointer(SimStruct({"byteArray6": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 6)}, name="FWP_BYTE_ARRAY6", pack=False, align=None), offset=0), "bitmapArray64": SimTypePointer(SimStruct({"bitmapArray64": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 8)}, name="FWP_BITMAP_ARRAY64_", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="FWP_VALUE0", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["engineHandle", "option", "newValue"]),
        #
        'FwpmEngineGetSecurityInfo0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["engineHandle", "securityInfo", "sidOwner", "sidGroup", "dacl", "sacl", "securityDescriptor"]),
        #
        'FwpmEngineSetSecurityInfo0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "SubAuthorityCount": SimTypeChar(label="Byte"), "IdentifierAuthority": SimStruct({"Value": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 6)}, name="SID_IDENTIFIER_AUTHORITY", pack=False, align=None), "SubAuthority": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="SID", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "SubAuthorityCount": SimTypeChar(label="Byte"), "IdentifierAuthority": SimStruct({"Value": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 6)}, name="SID_IDENTIFIER_AUTHORITY", pack=False, align=None), "SubAuthority": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="SID", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["engineHandle", "securityInfo", "sidOwner", "sidGroup", "dacl", "sacl"]),
        #
        'FwpmSessionCreateEnumHandle0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"reserved": SimTypeLongLong(signed=False, label="UInt64")}, name="FWPM_SESSION_ENUM_TEMPLATE0", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["engineHandle", "enumTemplate", "enumHandle"]),
        #
        'FwpmSessionEnum0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypePointer(SimStruct({"sessionKey": SimTypeBottom(label="Guid"), "displayData": SimStruct({"name": SimTypePointer(SimTypeChar(label="Char"), offset=0), "description": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="FWPM_DISPLAY_DATA0", pack=False, align=None), "flags": SimTypeInt(signed=False, label="UInt32"), "txnWaitTimeoutInMSec": SimTypeInt(signed=False, label="UInt32"), "processId": SimTypeInt(signed=False, label="UInt32"), "sid": SimTypePointer(SimTypeBottom(label="SID"), offset=0), "username": SimTypePointer(SimTypeChar(label="Char"), offset=0), "kernelMode": SimTypeInt(signed=True, label="Int32")}, name="FWPM_SESSION0", pack=False, align=None), offset=0), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["engineHandle", "enumHandle", "numEntriesRequested", "entries", "numEntriesReturned"]),
        #
        'FwpmSessionDestroyEnumHandle0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["engineHandle", "enumHandle"]),
        #
        'FwpmTransactionBegin0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["engineHandle", "flags"]),
        #
        'FwpmTransactionCommit0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["engineHandle"]),
        #
        'FwpmTransactionAbort0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["engineHandle"]),
        #
        'FwpmProviderAdd0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"providerKey": SimTypeBottom(label="Guid"), "displayData": SimStruct({"name": SimTypePointer(SimTypeChar(label="Char"), offset=0), "description": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="FWPM_DISPLAY_DATA0", pack=False, align=None), "flags": SimTypeInt(signed=False, label="UInt32"), "providerData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "serviceName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="FWPM_PROVIDER0", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["engineHandle", "provider", "sd"]),
        #
        'FwpmProviderDeleteByKey0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["engineHandle", "key"]),
        #
        'FwpmProviderGetByKey0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"providerKey": SimTypeBottom(label="Guid"), "displayData": SimStruct({"name": SimTypePointer(SimTypeChar(label="Char"), offset=0), "description": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="FWPM_DISPLAY_DATA0", pack=False, align=None), "flags": SimTypeInt(signed=False, label="UInt32"), "providerData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "serviceName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="FWPM_PROVIDER0", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["engineHandle", "key", "provider"]),
        #
        'FwpmProviderCreateEnumHandle0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"reserved": SimTypeLongLong(signed=False, label="UInt64")}, name="FWPM_PROVIDER_ENUM_TEMPLATE0", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["engineHandle", "enumTemplate", "enumHandle"]),
        #
        'FwpmProviderEnum0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypePointer(SimStruct({"providerKey": SimTypeBottom(label="Guid"), "displayData": SimStruct({"name": SimTypePointer(SimTypeChar(label="Char"), offset=0), "description": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="FWPM_DISPLAY_DATA0", pack=False, align=None), "flags": SimTypeInt(signed=False, label="UInt32"), "providerData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "serviceName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="FWPM_PROVIDER0", pack=False, align=None), offset=0), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["engineHandle", "enumHandle", "numEntriesRequested", "entries", "numEntriesReturned"]),
        #
        'FwpmProviderDestroyEnumHandle0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["engineHandle", "enumHandle"]),
        #
        'FwpmProviderGetSecurityInfoByKey0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["engineHandle", "key", "securityInfo", "sidOwner", "sidGroup", "dacl", "sacl", "securityDescriptor"]),
        #
        'FwpmProviderSetSecurityInfoByKey0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "SubAuthorityCount": SimTypeChar(label="Byte"), "IdentifierAuthority": SimStruct({"Value": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 6)}, name="SID_IDENTIFIER_AUTHORITY", pack=False, align=None), "SubAuthority": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="SID", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "SubAuthorityCount": SimTypeChar(label="Byte"), "IdentifierAuthority": SimStruct({"Value": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 6)}, name="SID_IDENTIFIER_AUTHORITY", pack=False, align=None), "SubAuthority": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="SID", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["engineHandle", "key", "securityInfo", "sidOwner", "sidGroup", "dacl", "sacl"]),
        #
        'FwpmProviderSubscribeChanges0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"enumTemplate": SimTypePointer(SimStruct({"reserved": SimTypeLongLong(signed=False, label="UInt64")}, name="FWPM_PROVIDER_ENUM_TEMPLATE0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32"), "sessionKey": SimTypeBottom(label="Guid")}, name="FWPM_PROVIDER_SUBSCRIPTION0", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"changeType": SimTypeInt(signed=False, label="FWPM_CHANGE_TYPE"), "providerKey": SimTypeBottom(label="Guid")}, name="FWPM_PROVIDER_CHANGE0", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["context", "change"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["engineHandle", "subscription", "callback", "context", "changeHandle"]),
        #
        'FwpmProviderUnsubscribeChanges0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["engineHandle", "changeHandle"]),
        #
        'FwpmProviderSubscriptionsGet0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypePointer(SimStruct({"enumTemplate": SimTypePointer(SimStruct({"reserved": SimTypeLongLong(signed=False, label="UInt64")}, name="FWPM_PROVIDER_ENUM_TEMPLATE0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32"), "sessionKey": SimTypeBottom(label="Guid")}, name="FWPM_PROVIDER_SUBSCRIPTION0", pack=False, align=None), offset=0), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["engineHandle", "entries", "numEntries"]),
        #
        'FwpmProviderContextAdd0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"providerContextKey": SimTypeBottom(label="Guid"), "displayData": SimStruct({"name": SimTypePointer(SimTypeChar(label="Char"), offset=0), "description": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="FWPM_DISPLAY_DATA0", pack=False, align=None), "flags": SimTypeInt(signed=False, label="UInt32"), "providerKey": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "providerData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "type": SimTypeInt(signed=False, label="FWPM_PROVIDER_CONTEXT_TYPE"), "Anonymous": SimUnion({"keyingPolicy": SimTypePointer(SimStruct({"numKeyMods": SimTypeInt(signed=False, label="UInt32"), "keyModKeys": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_KEYING_POLICY0", pack=False, align=None), offset=0), "ikeQmTransportPolicy": SimTypePointer(SimStruct({"numIpsecProposals": SimTypeInt(signed=False, label="UInt32"), "ipsecProposals": SimTypePointer(SimStruct({"lifetime": SimStruct({"lifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "lifetimeKilobytes": SimTypeInt(signed=False, label="UInt32"), "lifetimePackets": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_LIFETIME0", pack=False, align=None), "numSaTransforms": SimTypeInt(signed=False, label="UInt32"), "saTransforms": SimTypePointer(SimStruct({"ipsecTransformType": SimTypeInt(signed=False, label="IPSEC_TRANSFORM_TYPE"), "Anonymous": SimUnion({"ahTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espAuthTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espCipherTransform": SimTypePointer(SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthAndCipherTransform": SimTypePointer(SimStruct({"authTransform": SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), "cipherTransform": SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None)}, name="IPSEC_AUTH_AND_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthFwTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="IPSEC_SA_TRANSFORM0", pack=False, align=None), offset=0), "pfsGroup": SimTypeInt(signed=False, label="IPSEC_PFS_GROUP")}, name="IPSEC_PROPOSAL0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="IPSEC_POLICY_FLAG"), "ndAllowClearTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "saIdleTimeout": SimStruct({"idleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "idleTimeoutSecondsFailOver": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_IDLE_TIMEOUT0", pack=False, align=None), "emPolicy": SimTypePointer(SimStruct({"numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION0", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH")}, name="IKEEXT_CERTIFICATE_AUTHENTICATION0", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS")}, name="IKEEXT_KERBEROS_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH")}, name="IKEEXT_CERTIFICATE_AUTHENTICATION0", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD0", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE")}, name="IKEEXT_EM_POLICY0", pack=False, align=None), offset=0)}, name="IPSEC_TRANSPORT_POLICY0", pack=False, align=None), offset=0), "ikeQmTunnelPolicy": SimTypePointer(SimStruct({"flags": SimTypeInt(signed=False, label="IPSEC_POLICY_FLAG"), "numIpsecProposals": SimTypeInt(signed=False, label="UInt32"), "ipsecProposals": SimTypePointer(SimStruct({"lifetime": SimStruct({"lifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "lifetimeKilobytes": SimTypeInt(signed=False, label="UInt32"), "lifetimePackets": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_LIFETIME0", pack=False, align=None), "numSaTransforms": SimTypeInt(signed=False, label="UInt32"), "saTransforms": SimTypePointer(SimStruct({"ipsecTransformType": SimTypeInt(signed=False, label="IPSEC_TRANSFORM_TYPE"), "Anonymous": SimUnion({"ahTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espAuthTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espCipherTransform": SimTypePointer(SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthAndCipherTransform": SimTypePointer(SimStruct({"authTransform": SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), "cipherTransform": SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None)}, name="IPSEC_AUTH_AND_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthFwTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="IPSEC_SA_TRANSFORM0", pack=False, align=None), offset=0), "pfsGroup": SimTypeInt(signed=False, label="IPSEC_PFS_GROUP")}, name="IPSEC_PROPOSAL0", pack=False, align=None), offset=0), "tunnelEndpoints": SimStruct({"ipVersion": SimTypeInt(signed=False, label="FWP_IP_VERSION"), "Anonymous1": SimUnion({"localV4Address": SimTypeInt(signed=False, label="UInt32"), "localV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"remoteV4Address": SimTypeInt(signed=False, label="UInt32"), "remoteV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="IPSEC_TUNNEL_ENDPOINTS0", pack=False, align=None), "saIdleTimeout": SimStruct({"idleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "idleTimeoutSecondsFailOver": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_IDLE_TIMEOUT0", pack=False, align=None), "emPolicy": SimTypePointer(SimStruct({"numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION0", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH")}, name="IKEEXT_CERTIFICATE_AUTHENTICATION0", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS")}, name="IKEEXT_KERBEROS_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH")}, name="IKEEXT_CERTIFICATE_AUTHENTICATION0", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD0", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE")}, name="IKEEXT_EM_POLICY0", pack=False, align=None), offset=0)}, name="IPSEC_TUNNEL_POLICY0", pack=False, align=None), offset=0), "authipQmTransportPolicy": SimTypePointer(SimStruct({"numIpsecProposals": SimTypeInt(signed=False, label="UInt32"), "ipsecProposals": SimTypePointer(SimStruct({"lifetime": SimStruct({"lifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "lifetimeKilobytes": SimTypeInt(signed=False, label="UInt32"), "lifetimePackets": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_LIFETIME0", pack=False, align=None), "numSaTransforms": SimTypeInt(signed=False, label="UInt32"), "saTransforms": SimTypePointer(SimStruct({"ipsecTransformType": SimTypeInt(signed=False, label="IPSEC_TRANSFORM_TYPE"), "Anonymous": SimUnion({"ahTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espAuthTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espCipherTransform": SimTypePointer(SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthAndCipherTransform": SimTypePointer(SimStruct({"authTransform": SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), "cipherTransform": SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None)}, name="IPSEC_AUTH_AND_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthFwTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="IPSEC_SA_TRANSFORM0", pack=False, align=None), offset=0), "pfsGroup": SimTypeInt(signed=False, label="IPSEC_PFS_GROUP")}, name="IPSEC_PROPOSAL0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="IPSEC_POLICY_FLAG"), "ndAllowClearTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "saIdleTimeout": SimStruct({"idleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "idleTimeoutSecondsFailOver": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_IDLE_TIMEOUT0", pack=False, align=None), "emPolicy": SimTypePointer(SimStruct({"numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION0", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH")}, name="IKEEXT_CERTIFICATE_AUTHENTICATION0", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS")}, name="IKEEXT_KERBEROS_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH")}, name="IKEEXT_CERTIFICATE_AUTHENTICATION0", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD0", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE")}, name="IKEEXT_EM_POLICY0", pack=False, align=None), offset=0)}, name="IPSEC_TRANSPORT_POLICY0", pack=False, align=None), offset=0), "authipQmTunnelPolicy": SimTypePointer(SimStruct({"flags": SimTypeInt(signed=False, label="IPSEC_POLICY_FLAG"), "numIpsecProposals": SimTypeInt(signed=False, label="UInt32"), "ipsecProposals": SimTypePointer(SimStruct({"lifetime": SimStruct({"lifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "lifetimeKilobytes": SimTypeInt(signed=False, label="UInt32"), "lifetimePackets": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_LIFETIME0", pack=False, align=None), "numSaTransforms": SimTypeInt(signed=False, label="UInt32"), "saTransforms": SimTypePointer(SimStruct({"ipsecTransformType": SimTypeInt(signed=False, label="IPSEC_TRANSFORM_TYPE"), "Anonymous": SimUnion({"ahTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espAuthTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espCipherTransform": SimTypePointer(SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthAndCipherTransform": SimTypePointer(SimStruct({"authTransform": SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), "cipherTransform": SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None)}, name="IPSEC_AUTH_AND_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthFwTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="IPSEC_SA_TRANSFORM0", pack=False, align=None), offset=0), "pfsGroup": SimTypeInt(signed=False, label="IPSEC_PFS_GROUP")}, name="IPSEC_PROPOSAL0", pack=False, align=None), offset=0), "tunnelEndpoints": SimStruct({"ipVersion": SimTypeInt(signed=False, label="FWP_IP_VERSION"), "Anonymous1": SimUnion({"localV4Address": SimTypeInt(signed=False, label="UInt32"), "localV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"remoteV4Address": SimTypeInt(signed=False, label="UInt32"), "remoteV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="IPSEC_TUNNEL_ENDPOINTS0", pack=False, align=None), "saIdleTimeout": SimStruct({"idleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "idleTimeoutSecondsFailOver": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_IDLE_TIMEOUT0", pack=False, align=None), "emPolicy": SimTypePointer(SimStruct({"numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION0", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH")}, name="IKEEXT_CERTIFICATE_AUTHENTICATION0", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS")}, name="IKEEXT_KERBEROS_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH")}, name="IKEEXT_CERTIFICATE_AUTHENTICATION0", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD0", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE")}, name="IKEEXT_EM_POLICY0", pack=False, align=None), offset=0)}, name="IPSEC_TUNNEL_POLICY0", pack=False, align=None), offset=0), "ikeMmPolicy": SimTypePointer(SimStruct({"softExpirationTime": SimTypeInt(signed=False, label="UInt32"), "numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION0", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH")}, name="IKEEXT_CERTIFICATE_AUTHENTICATION0", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS")}, name="IKEEXT_KERBEROS_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH")}, name="IKEEXT_CERTIFICATE_AUTHENTICATION0", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD0", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE"), "numIkeProposals": SimTypeInt(signed=False, label="UInt32"), "ikeProposals": SimTypePointer(SimStruct({"cipherAlgorithm": SimStruct({"algoIdentifier": SimTypeInt(signed=False, label="IKEEXT_CIPHER_TYPE"), "keyLen": SimTypeInt(signed=False, label="UInt32"), "rounds": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CIPHER_ALGORITHM0", pack=False, align=None), "integrityAlgorithm": SimStruct({"algoIdentifier": SimTypeInt(signed=False, label="IKEEXT_INTEGRITY_TYPE")}, name="IKEEXT_INTEGRITY_ALGORITHM0", pack=False, align=None), "maxLifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "dhGroup": SimTypeInt(signed=False, label="IKEEXT_DH_GROUP"), "quickModeLimit": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_PROPOSAL0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="IKEEXT_POLICY_FLAG"), "maxDynamicFilters": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_POLICY0", pack=False, align=None), offset=0), "authIpMmPolicy": SimTypePointer(SimStruct({"softExpirationTime": SimTypeInt(signed=False, label="UInt32"), "numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION0", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH")}, name="IKEEXT_CERTIFICATE_AUTHENTICATION0", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS")}, name="IKEEXT_KERBEROS_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH")}, name="IKEEXT_CERTIFICATE_AUTHENTICATION0", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD0", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE"), "numIkeProposals": SimTypeInt(signed=False, label="UInt32"), "ikeProposals": SimTypePointer(SimStruct({"cipherAlgorithm": SimStruct({"algoIdentifier": SimTypeInt(signed=False, label="IKEEXT_CIPHER_TYPE"), "keyLen": SimTypeInt(signed=False, label="UInt32"), "rounds": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CIPHER_ALGORITHM0", pack=False, align=None), "integrityAlgorithm": SimStruct({"algoIdentifier": SimTypeInt(signed=False, label="IKEEXT_INTEGRITY_TYPE")}, name="IKEEXT_INTEGRITY_ALGORITHM0", pack=False, align=None), "maxLifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "dhGroup": SimTypeInt(signed=False, label="IKEEXT_DH_GROUP"), "quickModeLimit": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_PROPOSAL0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="IKEEXT_POLICY_FLAG"), "maxDynamicFilters": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_POLICY0", pack=False, align=None), offset=0), "dataBuffer": SimTypePointer(SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), offset=0), "classifyOptions": SimTypePointer(SimStruct({"numOptions": SimTypeInt(signed=False, label="UInt32"), "options": SimTypePointer(SimStruct({"type": SimTypeInt(signed=False, label="FWP_CLASSIFY_OPTION_TYPE"), "value": SimStruct({"type": SimTypeInt(signed=False, label="FWP_DATA_TYPE"), "Anonymous": SimUnion({"uint8": SimTypeChar(label="Byte"), "uint16": SimTypeShort(signed=False, label="UInt16"), "uint32": SimTypeInt(signed=False, label="UInt32"), "uint64": SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), "int8": SimTypeChar(label="SByte"), "int16": SimTypeShort(signed=True, label="Int16"), "int32": SimTypeInt(signed=True, label="Int32"), "int64": SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0), "float32": SimTypeFloat(size=32), "double64": SimTypePointer(SimTypeFloat(size=64), offset=0), "byteArray16": SimTypePointer(SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), offset=0), "byteBlob": SimTypePointer(SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), offset=0), "sid": SimTypePointer(SimTypeBottom(label="SID"), offset=0), "sd": SimTypePointer(SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), offset=0), "tokenInformation": SimTypePointer(SimStruct({"sidCount": SimTypeInt(signed=False, label="UInt32"), "sids": SimTypePointer(SimTypeBottom(label="SID_AND_ATTRIBUTES"), offset=0), "restrictedSidCount": SimTypeInt(signed=False, label="UInt32"), "restrictedSids": SimTypePointer(SimTypeBottom(label="SID_AND_ATTRIBUTES"), offset=0)}, name="FWP_TOKEN_INFORMATION", pack=False, align=None), offset=0), "tokenAccessInformation": SimTypePointer(SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), offset=0), "unicodeString": SimTypePointer(SimTypeChar(label="Char"), offset=0), "byteArray6": SimTypePointer(SimStruct({"byteArray6": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 6)}, name="FWP_BYTE_ARRAY6", pack=False, align=None), offset=0), "bitmapArray64": SimTypePointer(SimStruct({"bitmapArray64": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 8)}, name="FWP_BITMAP_ARRAY64_", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="FWP_VALUE0", pack=False, align=None)}, name="FWPM_CLASSIFY_OPTION0", pack=False, align=None), offset=0)}, name="FWPM_CLASSIFY_OPTIONS0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "providerContextId": SimTypeLongLong(signed=False, label="UInt64")}, name="FWPM_PROVIDER_CONTEXT0", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["engineHandle", "providerContext", "sd", "id"]),
        #
        'FwpmProviderContextAdd1': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"providerContextKey": SimTypeBottom(label="Guid"), "displayData": SimStruct({"name": SimTypePointer(SimTypeChar(label="Char"), offset=0), "description": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="FWPM_DISPLAY_DATA0", pack=False, align=None), "flags": SimTypeInt(signed=False, label="UInt32"), "providerKey": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "providerData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "type": SimTypeInt(signed=False, label="FWPM_PROVIDER_CONTEXT_TYPE"), "Anonymous": SimUnion({"keyingPolicy": SimTypePointer(SimStruct({"numKeyMods": SimTypeInt(signed=False, label="UInt32"), "keyModKeys": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_KEYING_POLICY0", pack=False, align=None), offset=0), "ikeQmTransportPolicy": SimTypePointer(SimStruct({"numIpsecProposals": SimTypeInt(signed=False, label="UInt32"), "ipsecProposals": SimTypePointer(SimStruct({"lifetime": SimStruct({"lifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "lifetimeKilobytes": SimTypeInt(signed=False, label="UInt32"), "lifetimePackets": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_LIFETIME0", pack=False, align=None), "numSaTransforms": SimTypeInt(signed=False, label="UInt32"), "saTransforms": SimTypePointer(SimStruct({"ipsecTransformType": SimTypeInt(signed=False, label="IPSEC_TRANSFORM_TYPE"), "Anonymous": SimUnion({"ahTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espAuthTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espCipherTransform": SimTypePointer(SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthAndCipherTransform": SimTypePointer(SimStruct({"authTransform": SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), "cipherTransform": SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None)}, name="IPSEC_AUTH_AND_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthFwTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="IPSEC_SA_TRANSFORM0", pack=False, align=None), offset=0), "pfsGroup": SimTypeInt(signed=False, label="IPSEC_PFS_GROUP")}, name="IPSEC_PROPOSAL0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="IPSEC_POLICY_FLAG"), "ndAllowClearTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "saIdleTimeout": SimStruct({"idleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "idleTimeoutSecondsFailOver": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_IDLE_TIMEOUT0", pack=False, align=None), "emPolicy": SimTypePointer(SimStruct({"numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_PRESHARED_KEY_AUTHENTICATION_FLAGS")}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION1", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION1", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS")}, name="IKEEXT_KERBEROS_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION1", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None), "eapAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_EAP_AUTHENTICATION_FLAGS")}, name="IKEEXT_EAP_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD1", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE")}, name="IKEEXT_EM_POLICY1", pack=False, align=None), offset=0)}, name="IPSEC_TRANSPORT_POLICY1", pack=False, align=None), offset=0), "ikeQmTunnelPolicy": SimTypePointer(SimStruct({"flags": SimTypeInt(signed=False, label="IPSEC_POLICY_FLAG"), "numIpsecProposals": SimTypeInt(signed=False, label="UInt32"), "ipsecProposals": SimTypePointer(SimStruct({"lifetime": SimStruct({"lifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "lifetimeKilobytes": SimTypeInt(signed=False, label="UInt32"), "lifetimePackets": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_LIFETIME0", pack=False, align=None), "numSaTransforms": SimTypeInt(signed=False, label="UInt32"), "saTransforms": SimTypePointer(SimStruct({"ipsecTransformType": SimTypeInt(signed=False, label="IPSEC_TRANSFORM_TYPE"), "Anonymous": SimUnion({"ahTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espAuthTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espCipherTransform": SimTypePointer(SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthAndCipherTransform": SimTypePointer(SimStruct({"authTransform": SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), "cipherTransform": SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None)}, name="IPSEC_AUTH_AND_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthFwTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="IPSEC_SA_TRANSFORM0", pack=False, align=None), offset=0), "pfsGroup": SimTypeInt(signed=False, label="IPSEC_PFS_GROUP")}, name="IPSEC_PROPOSAL0", pack=False, align=None), offset=0), "tunnelEndpoints": SimStruct({"ipVersion": SimTypeInt(signed=False, label="FWP_IP_VERSION"), "Anonymous1": SimUnion({"localV4Address": SimTypeInt(signed=False, label="UInt32"), "localV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"remoteV4Address": SimTypeInt(signed=False, label="UInt32"), "remoteV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), "localIfLuid": SimTypeLongLong(signed=False, label="UInt64")}, name="IPSEC_TUNNEL_ENDPOINTS1", pack=False, align=None), "saIdleTimeout": SimStruct({"idleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "idleTimeoutSecondsFailOver": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_IDLE_TIMEOUT0", pack=False, align=None), "emPolicy": SimTypePointer(SimStruct({"numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_PRESHARED_KEY_AUTHENTICATION_FLAGS")}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION1", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION1", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS")}, name="IKEEXT_KERBEROS_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION1", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None), "eapAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_EAP_AUTHENTICATION_FLAGS")}, name="IKEEXT_EAP_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD1", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE")}, name="IKEEXT_EM_POLICY1", pack=False, align=None), offset=0)}, name="IPSEC_TUNNEL_POLICY1", pack=False, align=None), offset=0), "authipQmTransportPolicy": SimTypePointer(SimStruct({"numIpsecProposals": SimTypeInt(signed=False, label="UInt32"), "ipsecProposals": SimTypePointer(SimStruct({"lifetime": SimStruct({"lifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "lifetimeKilobytes": SimTypeInt(signed=False, label="UInt32"), "lifetimePackets": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_LIFETIME0", pack=False, align=None), "numSaTransforms": SimTypeInt(signed=False, label="UInt32"), "saTransforms": SimTypePointer(SimStruct({"ipsecTransformType": SimTypeInt(signed=False, label="IPSEC_TRANSFORM_TYPE"), "Anonymous": SimUnion({"ahTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espAuthTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espCipherTransform": SimTypePointer(SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthAndCipherTransform": SimTypePointer(SimStruct({"authTransform": SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), "cipherTransform": SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None)}, name="IPSEC_AUTH_AND_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthFwTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="IPSEC_SA_TRANSFORM0", pack=False, align=None), offset=0), "pfsGroup": SimTypeInt(signed=False, label="IPSEC_PFS_GROUP")}, name="IPSEC_PROPOSAL0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="IPSEC_POLICY_FLAG"), "ndAllowClearTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "saIdleTimeout": SimStruct({"idleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "idleTimeoutSecondsFailOver": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_IDLE_TIMEOUT0", pack=False, align=None), "emPolicy": SimTypePointer(SimStruct({"numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_PRESHARED_KEY_AUTHENTICATION_FLAGS")}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION1", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION1", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS")}, name="IKEEXT_KERBEROS_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION1", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None), "eapAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_EAP_AUTHENTICATION_FLAGS")}, name="IKEEXT_EAP_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD1", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE")}, name="IKEEXT_EM_POLICY1", pack=False, align=None), offset=0)}, name="IPSEC_TRANSPORT_POLICY1", pack=False, align=None), offset=0), "authipQmTunnelPolicy": SimTypePointer(SimStruct({"flags": SimTypeInt(signed=False, label="IPSEC_POLICY_FLAG"), "numIpsecProposals": SimTypeInt(signed=False, label="UInt32"), "ipsecProposals": SimTypePointer(SimStruct({"lifetime": SimStruct({"lifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "lifetimeKilobytes": SimTypeInt(signed=False, label="UInt32"), "lifetimePackets": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_LIFETIME0", pack=False, align=None), "numSaTransforms": SimTypeInt(signed=False, label="UInt32"), "saTransforms": SimTypePointer(SimStruct({"ipsecTransformType": SimTypeInt(signed=False, label="IPSEC_TRANSFORM_TYPE"), "Anonymous": SimUnion({"ahTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espAuthTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espCipherTransform": SimTypePointer(SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthAndCipherTransform": SimTypePointer(SimStruct({"authTransform": SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), "cipherTransform": SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None)}, name="IPSEC_AUTH_AND_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthFwTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="IPSEC_SA_TRANSFORM0", pack=False, align=None), offset=0), "pfsGroup": SimTypeInt(signed=False, label="IPSEC_PFS_GROUP")}, name="IPSEC_PROPOSAL0", pack=False, align=None), offset=0), "tunnelEndpoints": SimStruct({"ipVersion": SimTypeInt(signed=False, label="FWP_IP_VERSION"), "Anonymous1": SimUnion({"localV4Address": SimTypeInt(signed=False, label="UInt32"), "localV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"remoteV4Address": SimTypeInt(signed=False, label="UInt32"), "remoteV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), "localIfLuid": SimTypeLongLong(signed=False, label="UInt64")}, name="IPSEC_TUNNEL_ENDPOINTS1", pack=False, align=None), "saIdleTimeout": SimStruct({"idleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "idleTimeoutSecondsFailOver": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_IDLE_TIMEOUT0", pack=False, align=None), "emPolicy": SimTypePointer(SimStruct({"numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_PRESHARED_KEY_AUTHENTICATION_FLAGS")}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION1", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION1", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS")}, name="IKEEXT_KERBEROS_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION1", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None), "eapAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_EAP_AUTHENTICATION_FLAGS")}, name="IKEEXT_EAP_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD1", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE")}, name="IKEEXT_EM_POLICY1", pack=False, align=None), offset=0)}, name="IPSEC_TUNNEL_POLICY1", pack=False, align=None), offset=0), "ikeMmPolicy": SimTypePointer(SimStruct({"softExpirationTime": SimTypeInt(signed=False, label="UInt32"), "numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_PRESHARED_KEY_AUTHENTICATION_FLAGS")}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION1", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION1", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS")}, name="IKEEXT_KERBEROS_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION1", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None), "eapAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_EAP_AUTHENTICATION_FLAGS")}, name="IKEEXT_EAP_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD1", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE"), "numIkeProposals": SimTypeInt(signed=False, label="UInt32"), "ikeProposals": SimTypePointer(SimStruct({"cipherAlgorithm": SimStruct({"algoIdentifier": SimTypeInt(signed=False, label="IKEEXT_CIPHER_TYPE"), "keyLen": SimTypeInt(signed=False, label="UInt32"), "rounds": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CIPHER_ALGORITHM0", pack=False, align=None), "integrityAlgorithm": SimStruct({"algoIdentifier": SimTypeInt(signed=False, label="IKEEXT_INTEGRITY_TYPE")}, name="IKEEXT_INTEGRITY_ALGORITHM0", pack=False, align=None), "maxLifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "dhGroup": SimTypeInt(signed=False, label="IKEEXT_DH_GROUP"), "quickModeLimit": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_PROPOSAL0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="IKEEXT_POLICY_FLAG"), "maxDynamicFilters": SimTypeInt(signed=False, label="UInt32"), "retransmitDurationSecs": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_POLICY1", pack=False, align=None), offset=0), "authIpMmPolicy": SimTypePointer(SimStruct({"softExpirationTime": SimTypeInt(signed=False, label="UInt32"), "numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_PRESHARED_KEY_AUTHENTICATION_FLAGS")}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION1", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION1", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS")}, name="IKEEXT_KERBEROS_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION1", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None), "eapAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_EAP_AUTHENTICATION_FLAGS")}, name="IKEEXT_EAP_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD1", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE"), "numIkeProposals": SimTypeInt(signed=False, label="UInt32"), "ikeProposals": SimTypePointer(SimStruct({"cipherAlgorithm": SimStruct({"algoIdentifier": SimTypeInt(signed=False, label="IKEEXT_CIPHER_TYPE"), "keyLen": SimTypeInt(signed=False, label="UInt32"), "rounds": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CIPHER_ALGORITHM0", pack=False, align=None), "integrityAlgorithm": SimStruct({"algoIdentifier": SimTypeInt(signed=False, label="IKEEXT_INTEGRITY_TYPE")}, name="IKEEXT_INTEGRITY_ALGORITHM0", pack=False, align=None), "maxLifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "dhGroup": SimTypeInt(signed=False, label="IKEEXT_DH_GROUP"), "quickModeLimit": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_PROPOSAL0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="IKEEXT_POLICY_FLAG"), "maxDynamicFilters": SimTypeInt(signed=False, label="UInt32"), "retransmitDurationSecs": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_POLICY1", pack=False, align=None), offset=0), "dataBuffer": SimTypePointer(SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), offset=0), "classifyOptions": SimTypePointer(SimStruct({"numOptions": SimTypeInt(signed=False, label="UInt32"), "options": SimTypePointer(SimStruct({"type": SimTypeInt(signed=False, label="FWP_CLASSIFY_OPTION_TYPE"), "value": SimStruct({"type": SimTypeInt(signed=False, label="FWP_DATA_TYPE"), "Anonymous": SimUnion({"uint8": SimTypeChar(label="Byte"), "uint16": SimTypeShort(signed=False, label="UInt16"), "uint32": SimTypeInt(signed=False, label="UInt32"), "uint64": SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), "int8": SimTypeChar(label="SByte"), "int16": SimTypeShort(signed=True, label="Int16"), "int32": SimTypeInt(signed=True, label="Int32"), "int64": SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0), "float32": SimTypeFloat(size=32), "double64": SimTypePointer(SimTypeFloat(size=64), offset=0), "byteArray16": SimTypePointer(SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), offset=0), "byteBlob": SimTypePointer(SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), offset=0), "sid": SimTypePointer(SimTypeBottom(label="SID"), offset=0), "sd": SimTypePointer(SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), offset=0), "tokenInformation": SimTypePointer(SimStruct({"sidCount": SimTypeInt(signed=False, label="UInt32"), "sids": SimTypePointer(SimTypeBottom(label="SID_AND_ATTRIBUTES"), offset=0), "restrictedSidCount": SimTypeInt(signed=False, label="UInt32"), "restrictedSids": SimTypePointer(SimTypeBottom(label="SID_AND_ATTRIBUTES"), offset=0)}, name="FWP_TOKEN_INFORMATION", pack=False, align=None), offset=0), "tokenAccessInformation": SimTypePointer(SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), offset=0), "unicodeString": SimTypePointer(SimTypeChar(label="Char"), offset=0), "byteArray6": SimTypePointer(SimStruct({"byteArray6": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 6)}, name="FWP_BYTE_ARRAY6", pack=False, align=None), offset=0), "bitmapArray64": SimTypePointer(SimStruct({"bitmapArray64": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 8)}, name="FWP_BITMAP_ARRAY64_", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="FWP_VALUE0", pack=False, align=None)}, name="FWPM_CLASSIFY_OPTION0", pack=False, align=None), offset=0)}, name="FWPM_CLASSIFY_OPTIONS0", pack=False, align=None), offset=0), "ikeV2QmTunnelPolicy": SimTypePointer(SimStruct({"flags": SimTypeInt(signed=False, label="IPSEC_POLICY_FLAG"), "numIpsecProposals": SimTypeInt(signed=False, label="UInt32"), "ipsecProposals": SimTypePointer(SimStruct({"lifetime": SimStruct({"lifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "lifetimeKilobytes": SimTypeInt(signed=False, label="UInt32"), "lifetimePackets": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_LIFETIME0", pack=False, align=None), "numSaTransforms": SimTypeInt(signed=False, label="UInt32"), "saTransforms": SimTypePointer(SimStruct({"ipsecTransformType": SimTypeInt(signed=False, label="IPSEC_TRANSFORM_TYPE"), "Anonymous": SimUnion({"ahTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espAuthTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espCipherTransform": SimTypePointer(SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthAndCipherTransform": SimTypePointer(SimStruct({"authTransform": SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), "cipherTransform": SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None)}, name="IPSEC_AUTH_AND_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthFwTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="IPSEC_SA_TRANSFORM0", pack=False, align=None), offset=0), "pfsGroup": SimTypeInt(signed=False, label="IPSEC_PFS_GROUP")}, name="IPSEC_PROPOSAL0", pack=False, align=None), offset=0), "tunnelEndpoints": SimStruct({"ipVersion": SimTypeInt(signed=False, label="FWP_IP_VERSION"), "Anonymous1": SimUnion({"localV4Address": SimTypeInt(signed=False, label="UInt32"), "localV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"remoteV4Address": SimTypeInt(signed=False, label="UInt32"), "remoteV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), "localIfLuid": SimTypeLongLong(signed=False, label="UInt64")}, name="IPSEC_TUNNEL_ENDPOINTS1", pack=False, align=None), "saIdleTimeout": SimStruct({"idleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "idleTimeoutSecondsFailOver": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_IDLE_TIMEOUT0", pack=False, align=None), "emPolicy": SimTypePointer(SimStruct({"numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_PRESHARED_KEY_AUTHENTICATION_FLAGS")}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION1", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION1", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS")}, name="IKEEXT_KERBEROS_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION1", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None), "eapAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_EAP_AUTHENTICATION_FLAGS")}, name="IKEEXT_EAP_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD1", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE")}, name="IKEEXT_EM_POLICY1", pack=False, align=None), offset=0)}, name="IPSEC_TUNNEL_POLICY1", pack=False, align=None), offset=0), "ikeV2MmPolicy": SimTypePointer(SimStruct({"softExpirationTime": SimTypeInt(signed=False, label="UInt32"), "numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_PRESHARED_KEY_AUTHENTICATION_FLAGS")}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION1", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION1", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS")}, name="IKEEXT_KERBEROS_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION1", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None), "eapAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_EAP_AUTHENTICATION_FLAGS")}, name="IKEEXT_EAP_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD1", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE"), "numIkeProposals": SimTypeInt(signed=False, label="UInt32"), "ikeProposals": SimTypePointer(SimStruct({"cipherAlgorithm": SimStruct({"algoIdentifier": SimTypeInt(signed=False, label="IKEEXT_CIPHER_TYPE"), "keyLen": SimTypeInt(signed=False, label="UInt32"), "rounds": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CIPHER_ALGORITHM0", pack=False, align=None), "integrityAlgorithm": SimStruct({"algoIdentifier": SimTypeInt(signed=False, label="IKEEXT_INTEGRITY_TYPE")}, name="IKEEXT_INTEGRITY_ALGORITHM0", pack=False, align=None), "maxLifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "dhGroup": SimTypeInt(signed=False, label="IKEEXT_DH_GROUP"), "quickModeLimit": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_PROPOSAL0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="IKEEXT_POLICY_FLAG"), "maxDynamicFilters": SimTypeInt(signed=False, label="UInt32"), "retransmitDurationSecs": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_POLICY1", pack=False, align=None), offset=0), "idpOptions": SimTypePointer(SimStruct({"stateIdleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "perIPRateLimitQueueIdleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "ipV6IPsecUnauthDscp": SimTypeChar(label="Byte"), "ipV6IPsecUnauthRateLimitBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "ipV6IPsecUnauthPerIPRateLimitBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "ipV6IPsecAuthDscp": SimTypeChar(label="Byte"), "ipV6IPsecAuthRateLimitBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "icmpV6Dscp": SimTypeChar(label="Byte"), "icmpV6RateLimitBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "ipV6FilterExemptDscp": SimTypeChar(label="Byte"), "ipV6FilterExemptRateLimitBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "defBlockExemptDscp": SimTypeChar(label="Byte"), "defBlockExemptRateLimitBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "maxStateEntries": SimTypeInt(signed=False, label="UInt32"), "maxPerIPRateLimitQueues": SimTypeInt(signed=False, label="UInt32"), "flags": SimTypeInt(signed=False, label="IPSEC_DOSP_FLAGS"), "numPublicIFLuids": SimTypeInt(signed=False, label="UInt32"), "publicIFLuids": SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), "numInternalIFLuids": SimTypeInt(signed=False, label="UInt32"), "internalIFLuids": SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), "publicV6AddrMask": SimStruct({"addr": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "prefixLength": SimTypeChar(label="Byte")}, name="FWP_V6_ADDR_AND_MASK", pack=False, align=None), "internalV6AddrMask": SimStruct({"addr": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "prefixLength": SimTypeChar(label="Byte")}, name="FWP_V6_ADDR_AND_MASK", pack=False, align=None)}, name="IPSEC_DOSP_OPTIONS0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "providerContextId": SimTypeLongLong(signed=False, label="UInt64")}, name="FWPM_PROVIDER_CONTEXT1", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["engineHandle", "providerContext", "sd", "id"]),
        #
        'FwpmProviderContextAdd2': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"providerContextKey": SimTypeBottom(label="Guid"), "displayData": SimStruct({"name": SimTypePointer(SimTypeChar(label="Char"), offset=0), "description": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="FWPM_DISPLAY_DATA0", pack=False, align=None), "flags": SimTypeInt(signed=False, label="UInt32"), "providerKey": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "providerData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "type": SimTypeInt(signed=False, label="FWPM_PROVIDER_CONTEXT_TYPE"), "Anonymous": SimUnion({"keyingPolicy": SimTypePointer(SimStruct({"numKeyMods": SimTypeInt(signed=False, label="UInt32"), "keyModKeys": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_KEYING_POLICY1", pack=False, align=None), offset=0), "ikeQmTransportPolicy": SimTypePointer(SimStruct({"numIpsecProposals": SimTypeInt(signed=False, label="UInt32"), "ipsecProposals": SimTypePointer(SimStruct({"lifetime": SimStruct({"lifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "lifetimeKilobytes": SimTypeInt(signed=False, label="UInt32"), "lifetimePackets": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_LIFETIME0", pack=False, align=None), "numSaTransforms": SimTypeInt(signed=False, label="UInt32"), "saTransforms": SimTypePointer(SimStruct({"ipsecTransformType": SimTypeInt(signed=False, label="IPSEC_TRANSFORM_TYPE"), "Anonymous": SimUnion({"ahTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espAuthTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espCipherTransform": SimTypePointer(SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthAndCipherTransform": SimTypePointer(SimStruct({"authTransform": SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), "cipherTransform": SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None)}, name="IPSEC_AUTH_AND_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthFwTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="IPSEC_SA_TRANSFORM0", pack=False, align=None), offset=0), "pfsGroup": SimTypeInt(signed=False, label="IPSEC_PFS_GROUP")}, name="IPSEC_PROPOSAL0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="IPSEC_POLICY_FLAG"), "ndAllowClearTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "saIdleTimeout": SimStruct({"idleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "idleTimeoutSecondsFailOver": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_IDLE_TIMEOUT0", pack=False, align=None), "emPolicy": SimTypePointer(SimStruct({"numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_PRESHARED_KEY_AUTHENTICATION_FLAGS")}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION1", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS"), "proxyServer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_KERBEROS_AUTHENTICATION1", pack=False, align=None), "reservedAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_RESERVED_AUTHENTICATION_FLAGS")}, name="IKEEXT_RESERVED_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None), "eapAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_EAP_AUTHENTICATION_FLAGS")}, name="IKEEXT_EAP_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD2", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE")}, name="IKEEXT_EM_POLICY2", pack=False, align=None), offset=0)}, name="IPSEC_TRANSPORT_POLICY2", pack=False, align=None), offset=0), "ikeQmTunnelPolicy": SimTypePointer(SimStruct({"flags": SimTypeInt(signed=False, label="IPSEC_POLICY_FLAG"), "numIpsecProposals": SimTypeInt(signed=False, label="UInt32"), "ipsecProposals": SimTypePointer(SimStruct({"lifetime": SimStruct({"lifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "lifetimeKilobytes": SimTypeInt(signed=False, label="UInt32"), "lifetimePackets": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_LIFETIME0", pack=False, align=None), "numSaTransforms": SimTypeInt(signed=False, label="UInt32"), "saTransforms": SimTypePointer(SimStruct({"ipsecTransformType": SimTypeInt(signed=False, label="IPSEC_TRANSFORM_TYPE"), "Anonymous": SimUnion({"ahTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espAuthTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espCipherTransform": SimTypePointer(SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthAndCipherTransform": SimTypePointer(SimStruct({"authTransform": SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), "cipherTransform": SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None)}, name="IPSEC_AUTH_AND_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthFwTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="IPSEC_SA_TRANSFORM0", pack=False, align=None), offset=0), "pfsGroup": SimTypeInt(signed=False, label="IPSEC_PFS_GROUP")}, name="IPSEC_PROPOSAL0", pack=False, align=None), offset=0), "tunnelEndpoints": SimStruct({"ipVersion": SimTypeInt(signed=False, label="FWP_IP_VERSION"), "Anonymous1": SimUnion({"localV4Address": SimTypeInt(signed=False, label="UInt32"), "localV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"remoteV4Address": SimTypeInt(signed=False, label="UInt32"), "remoteV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), "localIfLuid": SimTypeLongLong(signed=False, label="UInt64"), "remoteFqdn": SimTypePointer(SimTypeChar(label="Char"), offset=0), "numAddresses": SimTypeInt(signed=False, label="UInt32"), "remoteAddresses": SimTypePointer(SimStruct({"ipVersion": SimTypeInt(signed=False, label="FWP_IP_VERSION"), "Anonymous": SimUnion({"v4Address": SimTypeInt(signed=False, label="UInt32"), "v6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="IPSEC_TUNNEL_ENDPOINT0", pack=False, align=None), offset=0)}, name="IPSEC_TUNNEL_ENDPOINTS2", pack=False, align=None), "saIdleTimeout": SimStruct({"idleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "idleTimeoutSecondsFailOver": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_IDLE_TIMEOUT0", pack=False, align=None), "emPolicy": SimTypePointer(SimStruct({"numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_PRESHARED_KEY_AUTHENTICATION_FLAGS")}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION1", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS"), "proxyServer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_KERBEROS_AUTHENTICATION1", pack=False, align=None), "reservedAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_RESERVED_AUTHENTICATION_FLAGS")}, name="IKEEXT_RESERVED_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None), "eapAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_EAP_AUTHENTICATION_FLAGS")}, name="IKEEXT_EAP_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD2", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE")}, name="IKEEXT_EM_POLICY2", pack=False, align=None), offset=0), "fwdPathSaLifetime": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_TUNNEL_POLICY2", pack=False, align=None), offset=0), "authipQmTransportPolicy": SimTypePointer(SimStruct({"numIpsecProposals": SimTypeInt(signed=False, label="UInt32"), "ipsecProposals": SimTypePointer(SimStruct({"lifetime": SimStruct({"lifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "lifetimeKilobytes": SimTypeInt(signed=False, label="UInt32"), "lifetimePackets": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_LIFETIME0", pack=False, align=None), "numSaTransforms": SimTypeInt(signed=False, label="UInt32"), "saTransforms": SimTypePointer(SimStruct({"ipsecTransformType": SimTypeInt(signed=False, label="IPSEC_TRANSFORM_TYPE"), "Anonymous": SimUnion({"ahTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espAuthTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espCipherTransform": SimTypePointer(SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthAndCipherTransform": SimTypePointer(SimStruct({"authTransform": SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), "cipherTransform": SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None)}, name="IPSEC_AUTH_AND_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthFwTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="IPSEC_SA_TRANSFORM0", pack=False, align=None), offset=0), "pfsGroup": SimTypeInt(signed=False, label="IPSEC_PFS_GROUP")}, name="IPSEC_PROPOSAL0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="IPSEC_POLICY_FLAG"), "ndAllowClearTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "saIdleTimeout": SimStruct({"idleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "idleTimeoutSecondsFailOver": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_IDLE_TIMEOUT0", pack=False, align=None), "emPolicy": SimTypePointer(SimStruct({"numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_PRESHARED_KEY_AUTHENTICATION_FLAGS")}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION1", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS"), "proxyServer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_KERBEROS_AUTHENTICATION1", pack=False, align=None), "reservedAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_RESERVED_AUTHENTICATION_FLAGS")}, name="IKEEXT_RESERVED_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None), "eapAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_EAP_AUTHENTICATION_FLAGS")}, name="IKEEXT_EAP_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD2", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE")}, name="IKEEXT_EM_POLICY2", pack=False, align=None), offset=0)}, name="IPSEC_TRANSPORT_POLICY2", pack=False, align=None), offset=0), "authipQmTunnelPolicy": SimTypePointer(SimStruct({"flags": SimTypeInt(signed=False, label="IPSEC_POLICY_FLAG"), "numIpsecProposals": SimTypeInt(signed=False, label="UInt32"), "ipsecProposals": SimTypePointer(SimStruct({"lifetime": SimStruct({"lifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "lifetimeKilobytes": SimTypeInt(signed=False, label="UInt32"), "lifetimePackets": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_LIFETIME0", pack=False, align=None), "numSaTransforms": SimTypeInt(signed=False, label="UInt32"), "saTransforms": SimTypePointer(SimStruct({"ipsecTransformType": SimTypeInt(signed=False, label="IPSEC_TRANSFORM_TYPE"), "Anonymous": SimUnion({"ahTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espAuthTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espCipherTransform": SimTypePointer(SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthAndCipherTransform": SimTypePointer(SimStruct({"authTransform": SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), "cipherTransform": SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None)}, name="IPSEC_AUTH_AND_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthFwTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="IPSEC_SA_TRANSFORM0", pack=False, align=None), offset=0), "pfsGroup": SimTypeInt(signed=False, label="IPSEC_PFS_GROUP")}, name="IPSEC_PROPOSAL0", pack=False, align=None), offset=0), "tunnelEndpoints": SimStruct({"ipVersion": SimTypeInt(signed=False, label="FWP_IP_VERSION"), "Anonymous1": SimUnion({"localV4Address": SimTypeInt(signed=False, label="UInt32"), "localV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"remoteV4Address": SimTypeInt(signed=False, label="UInt32"), "remoteV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), "localIfLuid": SimTypeLongLong(signed=False, label="UInt64"), "remoteFqdn": SimTypePointer(SimTypeChar(label="Char"), offset=0), "numAddresses": SimTypeInt(signed=False, label="UInt32"), "remoteAddresses": SimTypePointer(SimStruct({"ipVersion": SimTypeInt(signed=False, label="FWP_IP_VERSION"), "Anonymous": SimUnion({"v4Address": SimTypeInt(signed=False, label="UInt32"), "v6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="IPSEC_TUNNEL_ENDPOINT0", pack=False, align=None), offset=0)}, name="IPSEC_TUNNEL_ENDPOINTS2", pack=False, align=None), "saIdleTimeout": SimStruct({"idleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "idleTimeoutSecondsFailOver": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_IDLE_TIMEOUT0", pack=False, align=None), "emPolicy": SimTypePointer(SimStruct({"numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_PRESHARED_KEY_AUTHENTICATION_FLAGS")}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION1", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS"), "proxyServer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_KERBEROS_AUTHENTICATION1", pack=False, align=None), "reservedAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_RESERVED_AUTHENTICATION_FLAGS")}, name="IKEEXT_RESERVED_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None), "eapAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_EAP_AUTHENTICATION_FLAGS")}, name="IKEEXT_EAP_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD2", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE")}, name="IKEEXT_EM_POLICY2", pack=False, align=None), offset=0), "fwdPathSaLifetime": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_TUNNEL_POLICY2", pack=False, align=None), offset=0), "ikeMmPolicy": SimTypePointer(SimStruct({"softExpirationTime": SimTypeInt(signed=False, label="UInt32"), "numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_PRESHARED_KEY_AUTHENTICATION_FLAGS")}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION1", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS"), "proxyServer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_KERBEROS_AUTHENTICATION1", pack=False, align=None), "reservedAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_RESERVED_AUTHENTICATION_FLAGS")}, name="IKEEXT_RESERVED_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None), "eapAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_EAP_AUTHENTICATION_FLAGS")}, name="IKEEXT_EAP_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD2", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE"), "numIkeProposals": SimTypeInt(signed=False, label="UInt32"), "ikeProposals": SimTypePointer(SimStruct({"cipherAlgorithm": SimStruct({"algoIdentifier": SimTypeInt(signed=False, label="IKEEXT_CIPHER_TYPE"), "keyLen": SimTypeInt(signed=False, label="UInt32"), "rounds": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CIPHER_ALGORITHM0", pack=False, align=None), "integrityAlgorithm": SimStruct({"algoIdentifier": SimTypeInt(signed=False, label="IKEEXT_INTEGRITY_TYPE")}, name="IKEEXT_INTEGRITY_ALGORITHM0", pack=False, align=None), "maxLifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "dhGroup": SimTypeInt(signed=False, label="IKEEXT_DH_GROUP"), "quickModeLimit": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_PROPOSAL0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="IKEEXT_POLICY_FLAG"), "maxDynamicFilters": SimTypeInt(signed=False, label="UInt32"), "retransmitDurationSecs": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_POLICY2", pack=False, align=None), offset=0), "authIpMmPolicy": SimTypePointer(SimStruct({"softExpirationTime": SimTypeInt(signed=False, label="UInt32"), "numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_PRESHARED_KEY_AUTHENTICATION_FLAGS")}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION1", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS"), "proxyServer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_KERBEROS_AUTHENTICATION1", pack=False, align=None), "reservedAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_RESERVED_AUTHENTICATION_FLAGS")}, name="IKEEXT_RESERVED_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None), "eapAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_EAP_AUTHENTICATION_FLAGS")}, name="IKEEXT_EAP_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD2", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE"), "numIkeProposals": SimTypeInt(signed=False, label="UInt32"), "ikeProposals": SimTypePointer(SimStruct({"cipherAlgorithm": SimStruct({"algoIdentifier": SimTypeInt(signed=False, label="IKEEXT_CIPHER_TYPE"), "keyLen": SimTypeInt(signed=False, label="UInt32"), "rounds": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CIPHER_ALGORITHM0", pack=False, align=None), "integrityAlgorithm": SimStruct({"algoIdentifier": SimTypeInt(signed=False, label="IKEEXT_INTEGRITY_TYPE")}, name="IKEEXT_INTEGRITY_ALGORITHM0", pack=False, align=None), "maxLifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "dhGroup": SimTypeInt(signed=False, label="IKEEXT_DH_GROUP"), "quickModeLimit": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_PROPOSAL0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="IKEEXT_POLICY_FLAG"), "maxDynamicFilters": SimTypeInt(signed=False, label="UInt32"), "retransmitDurationSecs": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_POLICY2", pack=False, align=None), offset=0), "dataBuffer": SimTypePointer(SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), offset=0), "classifyOptions": SimTypePointer(SimStruct({"numOptions": SimTypeInt(signed=False, label="UInt32"), "options": SimTypePointer(SimStruct({"type": SimTypeInt(signed=False, label="FWP_CLASSIFY_OPTION_TYPE"), "value": SimStruct({"type": SimTypeInt(signed=False, label="FWP_DATA_TYPE"), "Anonymous": SimUnion({"uint8": SimTypeChar(label="Byte"), "uint16": SimTypeShort(signed=False, label="UInt16"), "uint32": SimTypeInt(signed=False, label="UInt32"), "uint64": SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), "int8": SimTypeChar(label="SByte"), "int16": SimTypeShort(signed=True, label="Int16"), "int32": SimTypeInt(signed=True, label="Int32"), "int64": SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0), "float32": SimTypeFloat(size=32), "double64": SimTypePointer(SimTypeFloat(size=64), offset=0), "byteArray16": SimTypePointer(SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), offset=0), "byteBlob": SimTypePointer(SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), offset=0), "sid": SimTypePointer(SimTypeBottom(label="SID"), offset=0), "sd": SimTypePointer(SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), offset=0), "tokenInformation": SimTypePointer(SimStruct({"sidCount": SimTypeInt(signed=False, label="UInt32"), "sids": SimTypePointer(SimTypeBottom(label="SID_AND_ATTRIBUTES"), offset=0), "restrictedSidCount": SimTypeInt(signed=False, label="UInt32"), "restrictedSids": SimTypePointer(SimTypeBottom(label="SID_AND_ATTRIBUTES"), offset=0)}, name="FWP_TOKEN_INFORMATION", pack=False, align=None), offset=0), "tokenAccessInformation": SimTypePointer(SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), offset=0), "unicodeString": SimTypePointer(SimTypeChar(label="Char"), offset=0), "byteArray6": SimTypePointer(SimStruct({"byteArray6": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 6)}, name="FWP_BYTE_ARRAY6", pack=False, align=None), offset=0), "bitmapArray64": SimTypePointer(SimStruct({"bitmapArray64": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 8)}, name="FWP_BITMAP_ARRAY64_", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="FWP_VALUE0", pack=False, align=None)}, name="FWPM_CLASSIFY_OPTION0", pack=False, align=None), offset=0)}, name="FWPM_CLASSIFY_OPTIONS0", pack=False, align=None), offset=0), "ikeV2QmTunnelPolicy": SimTypePointer(SimStruct({"flags": SimTypeInt(signed=False, label="IPSEC_POLICY_FLAG"), "numIpsecProposals": SimTypeInt(signed=False, label="UInt32"), "ipsecProposals": SimTypePointer(SimStruct({"lifetime": SimStruct({"lifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "lifetimeKilobytes": SimTypeInt(signed=False, label="UInt32"), "lifetimePackets": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_LIFETIME0", pack=False, align=None), "numSaTransforms": SimTypeInt(signed=False, label="UInt32"), "saTransforms": SimTypePointer(SimStruct({"ipsecTransformType": SimTypeInt(signed=False, label="IPSEC_TRANSFORM_TYPE"), "Anonymous": SimUnion({"ahTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espAuthTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espCipherTransform": SimTypePointer(SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthAndCipherTransform": SimTypePointer(SimStruct({"authTransform": SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), "cipherTransform": SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None)}, name="IPSEC_AUTH_AND_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthFwTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="IPSEC_SA_TRANSFORM0", pack=False, align=None), offset=0), "pfsGroup": SimTypeInt(signed=False, label="IPSEC_PFS_GROUP")}, name="IPSEC_PROPOSAL0", pack=False, align=None), offset=0), "tunnelEndpoints": SimStruct({"ipVersion": SimTypeInt(signed=False, label="FWP_IP_VERSION"), "Anonymous1": SimUnion({"localV4Address": SimTypeInt(signed=False, label="UInt32"), "localV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"remoteV4Address": SimTypeInt(signed=False, label="UInt32"), "remoteV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), "localIfLuid": SimTypeLongLong(signed=False, label="UInt64"), "remoteFqdn": SimTypePointer(SimTypeChar(label="Char"), offset=0), "numAddresses": SimTypeInt(signed=False, label="UInt32"), "remoteAddresses": SimTypePointer(SimStruct({"ipVersion": SimTypeInt(signed=False, label="FWP_IP_VERSION"), "Anonymous": SimUnion({"v4Address": SimTypeInt(signed=False, label="UInt32"), "v6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="IPSEC_TUNNEL_ENDPOINT0", pack=False, align=None), offset=0)}, name="IPSEC_TUNNEL_ENDPOINTS2", pack=False, align=None), "saIdleTimeout": SimStruct({"idleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "idleTimeoutSecondsFailOver": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_IDLE_TIMEOUT0", pack=False, align=None), "emPolicy": SimTypePointer(SimStruct({"numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_PRESHARED_KEY_AUTHENTICATION_FLAGS")}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION1", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS"), "proxyServer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_KERBEROS_AUTHENTICATION1", pack=False, align=None), "reservedAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_RESERVED_AUTHENTICATION_FLAGS")}, name="IKEEXT_RESERVED_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None), "eapAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_EAP_AUTHENTICATION_FLAGS")}, name="IKEEXT_EAP_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD2", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE")}, name="IKEEXT_EM_POLICY2", pack=False, align=None), offset=0), "fwdPathSaLifetime": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_TUNNEL_POLICY2", pack=False, align=None), offset=0), "ikeV2QmTransportPolicy": SimTypePointer(SimStruct({"numIpsecProposals": SimTypeInt(signed=False, label="UInt32"), "ipsecProposals": SimTypePointer(SimStruct({"lifetime": SimStruct({"lifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "lifetimeKilobytes": SimTypeInt(signed=False, label="UInt32"), "lifetimePackets": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_LIFETIME0", pack=False, align=None), "numSaTransforms": SimTypeInt(signed=False, label="UInt32"), "saTransforms": SimTypePointer(SimStruct({"ipsecTransformType": SimTypeInt(signed=False, label="IPSEC_TRANSFORM_TYPE"), "Anonymous": SimUnion({"ahTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espAuthTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espCipherTransform": SimTypePointer(SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthAndCipherTransform": SimTypePointer(SimStruct({"authTransform": SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), "cipherTransform": SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None)}, name="IPSEC_AUTH_AND_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthFwTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="IPSEC_SA_TRANSFORM0", pack=False, align=None), offset=0), "pfsGroup": SimTypeInt(signed=False, label="IPSEC_PFS_GROUP")}, name="IPSEC_PROPOSAL0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="IPSEC_POLICY_FLAG"), "ndAllowClearTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "saIdleTimeout": SimStruct({"idleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "idleTimeoutSecondsFailOver": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_IDLE_TIMEOUT0", pack=False, align=None), "emPolicy": SimTypePointer(SimStruct({"numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_PRESHARED_KEY_AUTHENTICATION_FLAGS")}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION1", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS"), "proxyServer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_KERBEROS_AUTHENTICATION1", pack=False, align=None), "reservedAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_RESERVED_AUTHENTICATION_FLAGS")}, name="IKEEXT_RESERVED_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None), "eapAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_EAP_AUTHENTICATION_FLAGS")}, name="IKEEXT_EAP_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD2", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE")}, name="IKEEXT_EM_POLICY2", pack=False, align=None), offset=0)}, name="IPSEC_TRANSPORT_POLICY2", pack=False, align=None), offset=0), "ikeV2MmPolicy": SimTypePointer(SimStruct({"softExpirationTime": SimTypeInt(signed=False, label="UInt32"), "numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_PRESHARED_KEY_AUTHENTICATION_FLAGS")}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION1", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS"), "proxyServer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_KERBEROS_AUTHENTICATION1", pack=False, align=None), "reservedAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_RESERVED_AUTHENTICATION_FLAGS")}, name="IKEEXT_RESERVED_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None), "eapAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_EAP_AUTHENTICATION_FLAGS")}, name="IKEEXT_EAP_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD2", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE"), "numIkeProposals": SimTypeInt(signed=False, label="UInt32"), "ikeProposals": SimTypePointer(SimStruct({"cipherAlgorithm": SimStruct({"algoIdentifier": SimTypeInt(signed=False, label="IKEEXT_CIPHER_TYPE"), "keyLen": SimTypeInt(signed=False, label="UInt32"), "rounds": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CIPHER_ALGORITHM0", pack=False, align=None), "integrityAlgorithm": SimStruct({"algoIdentifier": SimTypeInt(signed=False, label="IKEEXT_INTEGRITY_TYPE")}, name="IKEEXT_INTEGRITY_ALGORITHM0", pack=False, align=None), "maxLifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "dhGroup": SimTypeInt(signed=False, label="IKEEXT_DH_GROUP"), "quickModeLimit": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_PROPOSAL0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="IKEEXT_POLICY_FLAG"), "maxDynamicFilters": SimTypeInt(signed=False, label="UInt32"), "retransmitDurationSecs": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_POLICY2", pack=False, align=None), offset=0), "idpOptions": SimTypePointer(SimStruct({"stateIdleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "perIPRateLimitQueueIdleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "ipV6IPsecUnauthDscp": SimTypeChar(label="Byte"), "ipV6IPsecUnauthRateLimitBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "ipV6IPsecUnauthPerIPRateLimitBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "ipV6IPsecAuthDscp": SimTypeChar(label="Byte"), "ipV6IPsecAuthRateLimitBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "icmpV6Dscp": SimTypeChar(label="Byte"), "icmpV6RateLimitBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "ipV6FilterExemptDscp": SimTypeChar(label="Byte"), "ipV6FilterExemptRateLimitBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "defBlockExemptDscp": SimTypeChar(label="Byte"), "defBlockExemptRateLimitBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "maxStateEntries": SimTypeInt(signed=False, label="UInt32"), "maxPerIPRateLimitQueues": SimTypeInt(signed=False, label="UInt32"), "flags": SimTypeInt(signed=False, label="IPSEC_DOSP_FLAGS"), "numPublicIFLuids": SimTypeInt(signed=False, label="UInt32"), "publicIFLuids": SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), "numInternalIFLuids": SimTypeInt(signed=False, label="UInt32"), "internalIFLuids": SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), "publicV6AddrMask": SimStruct({"addr": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "prefixLength": SimTypeChar(label="Byte")}, name="FWP_V6_ADDR_AND_MASK", pack=False, align=None), "internalV6AddrMask": SimStruct({"addr": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "prefixLength": SimTypeChar(label="Byte")}, name="FWP_V6_ADDR_AND_MASK", pack=False, align=None)}, name="IPSEC_DOSP_OPTIONS0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "providerContextId": SimTypeLongLong(signed=False, label="UInt64")}, name="FWPM_PROVIDER_CONTEXT2", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["engineHandle", "providerContext", "sd", "id"]),
        #
        'FwpmProviderContextAdd3': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"providerContextKey": SimTypeBottom(label="Guid"), "displayData": SimStruct({"name": SimTypePointer(SimTypeChar(label="Char"), offset=0), "description": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="FWPM_DISPLAY_DATA0", pack=False, align=None), "flags": SimTypeInt(signed=False, label="UInt32"), "providerKey": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "providerData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "type": SimTypeInt(signed=False, label="FWPM_PROVIDER_CONTEXT_TYPE"), "Anonymous": SimUnion({"keyingPolicy": SimTypePointer(SimStruct({"numKeyMods": SimTypeInt(signed=False, label="UInt32"), "keyModKeys": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_KEYING_POLICY1", pack=False, align=None), offset=0), "ikeQmTransportPolicy": SimTypePointer(SimStruct({"numIpsecProposals": SimTypeInt(signed=False, label="UInt32"), "ipsecProposals": SimTypePointer(SimStruct({"lifetime": SimStruct({"lifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "lifetimeKilobytes": SimTypeInt(signed=False, label="UInt32"), "lifetimePackets": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_LIFETIME0", pack=False, align=None), "numSaTransforms": SimTypeInt(signed=False, label="UInt32"), "saTransforms": SimTypePointer(SimStruct({"ipsecTransformType": SimTypeInt(signed=False, label="IPSEC_TRANSFORM_TYPE"), "Anonymous": SimUnion({"ahTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espAuthTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espCipherTransform": SimTypePointer(SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthAndCipherTransform": SimTypePointer(SimStruct({"authTransform": SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), "cipherTransform": SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None)}, name="IPSEC_AUTH_AND_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthFwTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="IPSEC_SA_TRANSFORM0", pack=False, align=None), offset=0), "pfsGroup": SimTypeInt(signed=False, label="IPSEC_PFS_GROUP")}, name="IPSEC_PROPOSAL0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="IPSEC_POLICY_FLAG"), "ndAllowClearTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "saIdleTimeout": SimStruct({"idleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "idleTimeoutSecondsFailOver": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_IDLE_TIMEOUT0", pack=False, align=None), "emPolicy": SimTypePointer(SimStruct({"numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_PRESHARED_KEY_AUTHENTICATION_FLAGS")}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION1", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS"), "proxyServer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_KERBEROS_AUTHENTICATION1", pack=False, align=None), "reservedAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_RESERVED_AUTHENTICATION_FLAGS")}, name="IKEEXT_RESERVED_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None), "eapAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_EAP_AUTHENTICATION_FLAGS")}, name="IKEEXT_EAP_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD2", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE")}, name="IKEEXT_EM_POLICY2", pack=False, align=None), offset=0)}, name="IPSEC_TRANSPORT_POLICY2", pack=False, align=None), offset=0), "ikeQmTunnelPolicy": SimTypePointer(SimStruct({"flags": SimTypeInt(signed=False, label="UInt32"), "numIpsecProposals": SimTypeInt(signed=False, label="UInt32"), "ipsecProposals": SimTypePointer(SimStruct({"lifetime": SimStruct({"lifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "lifetimeKilobytes": SimTypeInt(signed=False, label="UInt32"), "lifetimePackets": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_LIFETIME0", pack=False, align=None), "numSaTransforms": SimTypeInt(signed=False, label="UInt32"), "saTransforms": SimTypePointer(SimStruct({"ipsecTransformType": SimTypeInt(signed=False, label="IPSEC_TRANSFORM_TYPE"), "Anonymous": SimUnion({"ahTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espAuthTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espCipherTransform": SimTypePointer(SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthAndCipherTransform": SimTypePointer(SimStruct({"authTransform": SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), "cipherTransform": SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None)}, name="IPSEC_AUTH_AND_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthFwTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="IPSEC_SA_TRANSFORM0", pack=False, align=None), offset=0), "pfsGroup": SimTypeInt(signed=False, label="IPSEC_PFS_GROUP")}, name="IPSEC_PROPOSAL0", pack=False, align=None), offset=0), "tunnelEndpoints": SimStruct({"ipVersion": SimTypeInt(signed=False, label="FWP_IP_VERSION"), "Anonymous1": SimUnion({"localV4Address": SimTypeInt(signed=False, label="UInt32"), "localV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"remoteV4Address": SimTypeInt(signed=False, label="UInt32"), "remoteV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), "localIfLuid": SimTypeLongLong(signed=False, label="UInt64"), "remoteFqdn": SimTypePointer(SimTypeChar(label="Char"), offset=0), "numAddresses": SimTypeInt(signed=False, label="UInt32"), "remoteAddresses": SimTypePointer(SimStruct({"ipVersion": SimTypeInt(signed=False, label="FWP_IP_VERSION"), "Anonymous": SimUnion({"v4Address": SimTypeInt(signed=False, label="UInt32"), "v6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="IPSEC_TUNNEL_ENDPOINT0", pack=False, align=None), offset=0)}, name="IPSEC_TUNNEL_ENDPOINTS2", pack=False, align=None), "saIdleTimeout": SimStruct({"idleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "idleTimeoutSecondsFailOver": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_IDLE_TIMEOUT0", pack=False, align=None), "emPolicy": SimTypePointer(SimStruct({"numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_PRESHARED_KEY_AUTHENTICATION_FLAGS")}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION1", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS"), "proxyServer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_KERBEROS_AUTHENTICATION1", pack=False, align=None), "reservedAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_RESERVED_AUTHENTICATION_FLAGS")}, name="IKEEXT_RESERVED_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None), "eapAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_EAP_AUTHENTICATION_FLAGS")}, name="IKEEXT_EAP_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD2", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE")}, name="IKEEXT_EM_POLICY2", pack=False, align=None), offset=0), "fwdPathSaLifetime": SimTypeInt(signed=False, label="UInt32"), "compartmentId": SimTypeInt(signed=False, label="UInt32"), "numTrafficSelectorPolicy": SimTypeInt(signed=False, label="UInt32"), "trafficSelectorPolicies": SimTypePointer(SimStruct({"flags": SimTypeInt(signed=False, label="UInt32"), "numLocalTrafficSelectors": SimTypeInt(signed=False, label="UInt32"), "localTrafficSelectors": SimTypePointer(SimStruct({"protocolId": SimTypeChar(label="Byte"), "portStart": SimTypeShort(signed=False, label="UInt16"), "portEnd": SimTypeShort(signed=False, label="UInt16"), "ipVersion": SimTypeInt(signed=False, label="FWP_IP_VERSION"), "Anonymous1": SimUnion({"startV4Address": SimTypeInt(signed=False, label="UInt32"), "startV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"endV4Address": SimTypeInt(signed=False, label="UInt32"), "endV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="IPSEC_TRAFFIC_SELECTOR0_", pack=False, align=None), offset=0), "numRemoteTrafficSelectors": SimTypeInt(signed=False, label="UInt32"), "remoteTrafficSelectors": SimTypePointer(SimStruct({"protocolId": SimTypeChar(label="Byte"), "portStart": SimTypeShort(signed=False, label="UInt16"), "portEnd": SimTypeShort(signed=False, label="UInt16"), "ipVersion": SimTypeInt(signed=False, label="FWP_IP_VERSION"), "Anonymous1": SimUnion({"startV4Address": SimTypeInt(signed=False, label="UInt32"), "startV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"endV4Address": SimTypeInt(signed=False, label="UInt32"), "endV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="IPSEC_TRAFFIC_SELECTOR0_", pack=False, align=None), offset=0)}, name="IPSEC_TRAFFIC_SELECTOR_POLICY0_", pack=False, align=None), offset=0)}, name="IPSEC_TUNNEL_POLICY3_", pack=False, align=None), offset=0), "authipQmTransportPolicy": SimTypePointer(SimStruct({"numIpsecProposals": SimTypeInt(signed=False, label="UInt32"), "ipsecProposals": SimTypePointer(SimStruct({"lifetime": SimStruct({"lifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "lifetimeKilobytes": SimTypeInt(signed=False, label="UInt32"), "lifetimePackets": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_LIFETIME0", pack=False, align=None), "numSaTransforms": SimTypeInt(signed=False, label="UInt32"), "saTransforms": SimTypePointer(SimStruct({"ipsecTransformType": SimTypeInt(signed=False, label="IPSEC_TRANSFORM_TYPE"), "Anonymous": SimUnion({"ahTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espAuthTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espCipherTransform": SimTypePointer(SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthAndCipherTransform": SimTypePointer(SimStruct({"authTransform": SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), "cipherTransform": SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None)}, name="IPSEC_AUTH_AND_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthFwTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="IPSEC_SA_TRANSFORM0", pack=False, align=None), offset=0), "pfsGroup": SimTypeInt(signed=False, label="IPSEC_PFS_GROUP")}, name="IPSEC_PROPOSAL0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="IPSEC_POLICY_FLAG"), "ndAllowClearTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "saIdleTimeout": SimStruct({"idleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "idleTimeoutSecondsFailOver": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_IDLE_TIMEOUT0", pack=False, align=None), "emPolicy": SimTypePointer(SimStruct({"numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_PRESHARED_KEY_AUTHENTICATION_FLAGS")}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION1", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS"), "proxyServer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_KERBEROS_AUTHENTICATION1", pack=False, align=None), "reservedAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_RESERVED_AUTHENTICATION_FLAGS")}, name="IKEEXT_RESERVED_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None), "eapAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_EAP_AUTHENTICATION_FLAGS")}, name="IKEEXT_EAP_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD2", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE")}, name="IKEEXT_EM_POLICY2", pack=False, align=None), offset=0)}, name="IPSEC_TRANSPORT_POLICY2", pack=False, align=None), offset=0), "authipQmTunnelPolicy": SimTypePointer(SimStruct({"flags": SimTypeInt(signed=False, label="UInt32"), "numIpsecProposals": SimTypeInt(signed=False, label="UInt32"), "ipsecProposals": SimTypePointer(SimStruct({"lifetime": SimStruct({"lifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "lifetimeKilobytes": SimTypeInt(signed=False, label="UInt32"), "lifetimePackets": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_LIFETIME0", pack=False, align=None), "numSaTransforms": SimTypeInt(signed=False, label="UInt32"), "saTransforms": SimTypePointer(SimStruct({"ipsecTransformType": SimTypeInt(signed=False, label="IPSEC_TRANSFORM_TYPE"), "Anonymous": SimUnion({"ahTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espAuthTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espCipherTransform": SimTypePointer(SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthAndCipherTransform": SimTypePointer(SimStruct({"authTransform": SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), "cipherTransform": SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None)}, name="IPSEC_AUTH_AND_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthFwTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="IPSEC_SA_TRANSFORM0", pack=False, align=None), offset=0), "pfsGroup": SimTypeInt(signed=False, label="IPSEC_PFS_GROUP")}, name="IPSEC_PROPOSAL0", pack=False, align=None), offset=0), "tunnelEndpoints": SimStruct({"ipVersion": SimTypeInt(signed=False, label="FWP_IP_VERSION"), "Anonymous1": SimUnion({"localV4Address": SimTypeInt(signed=False, label="UInt32"), "localV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"remoteV4Address": SimTypeInt(signed=False, label="UInt32"), "remoteV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), "localIfLuid": SimTypeLongLong(signed=False, label="UInt64"), "remoteFqdn": SimTypePointer(SimTypeChar(label="Char"), offset=0), "numAddresses": SimTypeInt(signed=False, label="UInt32"), "remoteAddresses": SimTypePointer(SimStruct({"ipVersion": SimTypeInt(signed=False, label="FWP_IP_VERSION"), "Anonymous": SimUnion({"v4Address": SimTypeInt(signed=False, label="UInt32"), "v6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="IPSEC_TUNNEL_ENDPOINT0", pack=False, align=None), offset=0)}, name="IPSEC_TUNNEL_ENDPOINTS2", pack=False, align=None), "saIdleTimeout": SimStruct({"idleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "idleTimeoutSecondsFailOver": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_IDLE_TIMEOUT0", pack=False, align=None), "emPolicy": SimTypePointer(SimStruct({"numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_PRESHARED_KEY_AUTHENTICATION_FLAGS")}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION1", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS"), "proxyServer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_KERBEROS_AUTHENTICATION1", pack=False, align=None), "reservedAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_RESERVED_AUTHENTICATION_FLAGS")}, name="IKEEXT_RESERVED_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None), "eapAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_EAP_AUTHENTICATION_FLAGS")}, name="IKEEXT_EAP_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD2", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE")}, name="IKEEXT_EM_POLICY2", pack=False, align=None), offset=0), "fwdPathSaLifetime": SimTypeInt(signed=False, label="UInt32"), "compartmentId": SimTypeInt(signed=False, label="UInt32"), "numTrafficSelectorPolicy": SimTypeInt(signed=False, label="UInt32"), "trafficSelectorPolicies": SimTypePointer(SimStruct({"flags": SimTypeInt(signed=False, label="UInt32"), "numLocalTrafficSelectors": SimTypeInt(signed=False, label="UInt32"), "localTrafficSelectors": SimTypePointer(SimStruct({"protocolId": SimTypeChar(label="Byte"), "portStart": SimTypeShort(signed=False, label="UInt16"), "portEnd": SimTypeShort(signed=False, label="UInt16"), "ipVersion": SimTypeInt(signed=False, label="FWP_IP_VERSION"), "Anonymous1": SimUnion({"startV4Address": SimTypeInt(signed=False, label="UInt32"), "startV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"endV4Address": SimTypeInt(signed=False, label="UInt32"), "endV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="IPSEC_TRAFFIC_SELECTOR0_", pack=False, align=None), offset=0), "numRemoteTrafficSelectors": SimTypeInt(signed=False, label="UInt32"), "remoteTrafficSelectors": SimTypePointer(SimStruct({"protocolId": SimTypeChar(label="Byte"), "portStart": SimTypeShort(signed=False, label="UInt16"), "portEnd": SimTypeShort(signed=False, label="UInt16"), "ipVersion": SimTypeInt(signed=False, label="FWP_IP_VERSION"), "Anonymous1": SimUnion({"startV4Address": SimTypeInt(signed=False, label="UInt32"), "startV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"endV4Address": SimTypeInt(signed=False, label="UInt32"), "endV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="IPSEC_TRAFFIC_SELECTOR0_", pack=False, align=None), offset=0)}, name="IPSEC_TRAFFIC_SELECTOR_POLICY0_", pack=False, align=None), offset=0)}, name="IPSEC_TUNNEL_POLICY3_", pack=False, align=None), offset=0), "ikeMmPolicy": SimTypePointer(SimStruct({"softExpirationTime": SimTypeInt(signed=False, label="UInt32"), "numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_PRESHARED_KEY_AUTHENTICATION_FLAGS")}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION1", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS"), "proxyServer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_KERBEROS_AUTHENTICATION1", pack=False, align=None), "reservedAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_RESERVED_AUTHENTICATION_FLAGS")}, name="IKEEXT_RESERVED_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None), "eapAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_EAP_AUTHENTICATION_FLAGS")}, name="IKEEXT_EAP_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD2", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE"), "numIkeProposals": SimTypeInt(signed=False, label="UInt32"), "ikeProposals": SimTypePointer(SimStruct({"cipherAlgorithm": SimStruct({"algoIdentifier": SimTypeInt(signed=False, label="IKEEXT_CIPHER_TYPE"), "keyLen": SimTypeInt(signed=False, label="UInt32"), "rounds": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CIPHER_ALGORITHM0", pack=False, align=None), "integrityAlgorithm": SimStruct({"algoIdentifier": SimTypeInt(signed=False, label="IKEEXT_INTEGRITY_TYPE")}, name="IKEEXT_INTEGRITY_ALGORITHM0", pack=False, align=None), "maxLifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "dhGroup": SimTypeInt(signed=False, label="IKEEXT_DH_GROUP"), "quickModeLimit": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_PROPOSAL0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="IKEEXT_POLICY_FLAG"), "maxDynamicFilters": SimTypeInt(signed=False, label="UInt32"), "retransmitDurationSecs": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_POLICY2", pack=False, align=None), offset=0), "authIpMmPolicy": SimTypePointer(SimStruct({"softExpirationTime": SimTypeInt(signed=False, label="UInt32"), "numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_PRESHARED_KEY_AUTHENTICATION_FLAGS")}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION1", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS"), "proxyServer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_KERBEROS_AUTHENTICATION1", pack=False, align=None), "reservedAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_RESERVED_AUTHENTICATION_FLAGS")}, name="IKEEXT_RESERVED_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None), "eapAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_EAP_AUTHENTICATION_FLAGS")}, name="IKEEXT_EAP_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD2", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE"), "numIkeProposals": SimTypeInt(signed=False, label="UInt32"), "ikeProposals": SimTypePointer(SimStruct({"cipherAlgorithm": SimStruct({"algoIdentifier": SimTypeInt(signed=False, label="IKEEXT_CIPHER_TYPE"), "keyLen": SimTypeInt(signed=False, label="UInt32"), "rounds": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CIPHER_ALGORITHM0", pack=False, align=None), "integrityAlgorithm": SimStruct({"algoIdentifier": SimTypeInt(signed=False, label="IKEEXT_INTEGRITY_TYPE")}, name="IKEEXT_INTEGRITY_ALGORITHM0", pack=False, align=None), "maxLifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "dhGroup": SimTypeInt(signed=False, label="IKEEXT_DH_GROUP"), "quickModeLimit": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_PROPOSAL0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="IKEEXT_POLICY_FLAG"), "maxDynamicFilters": SimTypeInt(signed=False, label="UInt32"), "retransmitDurationSecs": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_POLICY2", pack=False, align=None), offset=0), "dataBuffer": SimTypePointer(SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), offset=0), "classifyOptions": SimTypePointer(SimStruct({"numOptions": SimTypeInt(signed=False, label="UInt32"), "options": SimTypePointer(SimStruct({"type": SimTypeInt(signed=False, label="FWP_CLASSIFY_OPTION_TYPE"), "value": SimStruct({"type": SimTypeInt(signed=False, label="FWP_DATA_TYPE"), "Anonymous": SimUnion({"uint8": SimTypeChar(label="Byte"), "uint16": SimTypeShort(signed=False, label="UInt16"), "uint32": SimTypeInt(signed=False, label="UInt32"), "uint64": SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), "int8": SimTypeChar(label="SByte"), "int16": SimTypeShort(signed=True, label="Int16"), "int32": SimTypeInt(signed=True, label="Int32"), "int64": SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0), "float32": SimTypeFloat(size=32), "double64": SimTypePointer(SimTypeFloat(size=64), offset=0), "byteArray16": SimTypePointer(SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), offset=0), "byteBlob": SimTypePointer(SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), offset=0), "sid": SimTypePointer(SimTypeBottom(label="SID"), offset=0), "sd": SimTypePointer(SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), offset=0), "tokenInformation": SimTypePointer(SimStruct({"sidCount": SimTypeInt(signed=False, label="UInt32"), "sids": SimTypePointer(SimTypeBottom(label="SID_AND_ATTRIBUTES"), offset=0), "restrictedSidCount": SimTypeInt(signed=False, label="UInt32"), "restrictedSids": SimTypePointer(SimTypeBottom(label="SID_AND_ATTRIBUTES"), offset=0)}, name="FWP_TOKEN_INFORMATION", pack=False, align=None), offset=0), "tokenAccessInformation": SimTypePointer(SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), offset=0), "unicodeString": SimTypePointer(SimTypeChar(label="Char"), offset=0), "byteArray6": SimTypePointer(SimStruct({"byteArray6": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 6)}, name="FWP_BYTE_ARRAY6", pack=False, align=None), offset=0), "bitmapArray64": SimTypePointer(SimStruct({"bitmapArray64": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 8)}, name="FWP_BITMAP_ARRAY64_", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="FWP_VALUE0", pack=False, align=None)}, name="FWPM_CLASSIFY_OPTION0", pack=False, align=None), offset=0)}, name="FWPM_CLASSIFY_OPTIONS0", pack=False, align=None), offset=0), "ikeV2QmTunnelPolicy": SimTypePointer(SimStruct({"flags": SimTypeInt(signed=False, label="UInt32"), "numIpsecProposals": SimTypeInt(signed=False, label="UInt32"), "ipsecProposals": SimTypePointer(SimStruct({"lifetime": SimStruct({"lifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "lifetimeKilobytes": SimTypeInt(signed=False, label="UInt32"), "lifetimePackets": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_LIFETIME0", pack=False, align=None), "numSaTransforms": SimTypeInt(signed=False, label="UInt32"), "saTransforms": SimTypePointer(SimStruct({"ipsecTransformType": SimTypeInt(signed=False, label="IPSEC_TRANSFORM_TYPE"), "Anonymous": SimUnion({"ahTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espAuthTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espCipherTransform": SimTypePointer(SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthAndCipherTransform": SimTypePointer(SimStruct({"authTransform": SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), "cipherTransform": SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None)}, name="IPSEC_AUTH_AND_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthFwTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="IPSEC_SA_TRANSFORM0", pack=False, align=None), offset=0), "pfsGroup": SimTypeInt(signed=False, label="IPSEC_PFS_GROUP")}, name="IPSEC_PROPOSAL0", pack=False, align=None), offset=0), "tunnelEndpoints": SimStruct({"ipVersion": SimTypeInt(signed=False, label="FWP_IP_VERSION"), "Anonymous1": SimUnion({"localV4Address": SimTypeInt(signed=False, label="UInt32"), "localV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"remoteV4Address": SimTypeInt(signed=False, label="UInt32"), "remoteV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), "localIfLuid": SimTypeLongLong(signed=False, label="UInt64"), "remoteFqdn": SimTypePointer(SimTypeChar(label="Char"), offset=0), "numAddresses": SimTypeInt(signed=False, label="UInt32"), "remoteAddresses": SimTypePointer(SimStruct({"ipVersion": SimTypeInt(signed=False, label="FWP_IP_VERSION"), "Anonymous": SimUnion({"v4Address": SimTypeInt(signed=False, label="UInt32"), "v6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="IPSEC_TUNNEL_ENDPOINT0", pack=False, align=None), offset=0)}, name="IPSEC_TUNNEL_ENDPOINTS2", pack=False, align=None), "saIdleTimeout": SimStruct({"idleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "idleTimeoutSecondsFailOver": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_IDLE_TIMEOUT0", pack=False, align=None), "emPolicy": SimTypePointer(SimStruct({"numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_PRESHARED_KEY_AUTHENTICATION_FLAGS")}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION1", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS"), "proxyServer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_KERBEROS_AUTHENTICATION1", pack=False, align=None), "reservedAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_RESERVED_AUTHENTICATION_FLAGS")}, name="IKEEXT_RESERVED_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None), "eapAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_EAP_AUTHENTICATION_FLAGS")}, name="IKEEXT_EAP_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD2", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE")}, name="IKEEXT_EM_POLICY2", pack=False, align=None), offset=0), "fwdPathSaLifetime": SimTypeInt(signed=False, label="UInt32"), "compartmentId": SimTypeInt(signed=False, label="UInt32"), "numTrafficSelectorPolicy": SimTypeInt(signed=False, label="UInt32"), "trafficSelectorPolicies": SimTypePointer(SimStruct({"flags": SimTypeInt(signed=False, label="UInt32"), "numLocalTrafficSelectors": SimTypeInt(signed=False, label="UInt32"), "localTrafficSelectors": SimTypePointer(SimStruct({"protocolId": SimTypeChar(label="Byte"), "portStart": SimTypeShort(signed=False, label="UInt16"), "portEnd": SimTypeShort(signed=False, label="UInt16"), "ipVersion": SimTypeInt(signed=False, label="FWP_IP_VERSION"), "Anonymous1": SimUnion({"startV4Address": SimTypeInt(signed=False, label="UInt32"), "startV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"endV4Address": SimTypeInt(signed=False, label="UInt32"), "endV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="IPSEC_TRAFFIC_SELECTOR0_", pack=False, align=None), offset=0), "numRemoteTrafficSelectors": SimTypeInt(signed=False, label="UInt32"), "remoteTrafficSelectors": SimTypePointer(SimStruct({"protocolId": SimTypeChar(label="Byte"), "portStart": SimTypeShort(signed=False, label="UInt16"), "portEnd": SimTypeShort(signed=False, label="UInt16"), "ipVersion": SimTypeInt(signed=False, label="FWP_IP_VERSION"), "Anonymous1": SimUnion({"startV4Address": SimTypeInt(signed=False, label="UInt32"), "startV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"endV4Address": SimTypeInt(signed=False, label="UInt32"), "endV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="IPSEC_TRAFFIC_SELECTOR0_", pack=False, align=None), offset=0)}, name="IPSEC_TRAFFIC_SELECTOR_POLICY0_", pack=False, align=None), offset=0)}, name="IPSEC_TUNNEL_POLICY3_", pack=False, align=None), offset=0), "ikeV2QmTransportPolicy": SimTypePointer(SimStruct({"numIpsecProposals": SimTypeInt(signed=False, label="UInt32"), "ipsecProposals": SimTypePointer(SimStruct({"lifetime": SimStruct({"lifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "lifetimeKilobytes": SimTypeInt(signed=False, label="UInt32"), "lifetimePackets": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_LIFETIME0", pack=False, align=None), "numSaTransforms": SimTypeInt(signed=False, label="UInt32"), "saTransforms": SimTypePointer(SimStruct({"ipsecTransformType": SimTypeInt(signed=False, label="IPSEC_TRANSFORM_TYPE"), "Anonymous": SimUnion({"ahTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espAuthTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espCipherTransform": SimTypePointer(SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthAndCipherTransform": SimTypePointer(SimStruct({"authTransform": SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), "cipherTransform": SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None)}, name="IPSEC_AUTH_AND_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthFwTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="IPSEC_SA_TRANSFORM0", pack=False, align=None), offset=0), "pfsGroup": SimTypeInt(signed=False, label="IPSEC_PFS_GROUP")}, name="IPSEC_PROPOSAL0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="IPSEC_POLICY_FLAG"), "ndAllowClearTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "saIdleTimeout": SimStruct({"idleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "idleTimeoutSecondsFailOver": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_IDLE_TIMEOUT0", pack=False, align=None), "emPolicy": SimTypePointer(SimStruct({"numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_PRESHARED_KEY_AUTHENTICATION_FLAGS")}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION1", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS"), "proxyServer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_KERBEROS_AUTHENTICATION1", pack=False, align=None), "reservedAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_RESERVED_AUTHENTICATION_FLAGS")}, name="IKEEXT_RESERVED_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None), "eapAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_EAP_AUTHENTICATION_FLAGS")}, name="IKEEXT_EAP_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD2", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE")}, name="IKEEXT_EM_POLICY2", pack=False, align=None), offset=0)}, name="IPSEC_TRANSPORT_POLICY2", pack=False, align=None), offset=0), "ikeV2MmPolicy": SimTypePointer(SimStruct({"softExpirationTime": SimTypeInt(signed=False, label="UInt32"), "numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_PRESHARED_KEY_AUTHENTICATION_FLAGS")}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION1", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS"), "proxyServer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_KERBEROS_AUTHENTICATION1", pack=False, align=None), "reservedAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_RESERVED_AUTHENTICATION_FLAGS")}, name="IKEEXT_RESERVED_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None), "eapAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_EAP_AUTHENTICATION_FLAGS")}, name="IKEEXT_EAP_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD2", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE"), "numIkeProposals": SimTypeInt(signed=False, label="UInt32"), "ikeProposals": SimTypePointer(SimStruct({"cipherAlgorithm": SimStruct({"algoIdentifier": SimTypeInt(signed=False, label="IKEEXT_CIPHER_TYPE"), "keyLen": SimTypeInt(signed=False, label="UInt32"), "rounds": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CIPHER_ALGORITHM0", pack=False, align=None), "integrityAlgorithm": SimStruct({"algoIdentifier": SimTypeInt(signed=False, label="IKEEXT_INTEGRITY_TYPE")}, name="IKEEXT_INTEGRITY_ALGORITHM0", pack=False, align=None), "maxLifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "dhGroup": SimTypeInt(signed=False, label="IKEEXT_DH_GROUP"), "quickModeLimit": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_PROPOSAL0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="IKEEXT_POLICY_FLAG"), "maxDynamicFilters": SimTypeInt(signed=False, label="UInt32"), "retransmitDurationSecs": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_POLICY2", pack=False, align=None), offset=0), "idpOptions": SimTypePointer(SimStruct({"stateIdleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "perIPRateLimitQueueIdleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "ipV6IPsecUnauthDscp": SimTypeChar(label="Byte"), "ipV6IPsecUnauthRateLimitBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "ipV6IPsecUnauthPerIPRateLimitBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "ipV6IPsecAuthDscp": SimTypeChar(label="Byte"), "ipV6IPsecAuthRateLimitBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "icmpV6Dscp": SimTypeChar(label="Byte"), "icmpV6RateLimitBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "ipV6FilterExemptDscp": SimTypeChar(label="Byte"), "ipV6FilterExemptRateLimitBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "defBlockExemptDscp": SimTypeChar(label="Byte"), "defBlockExemptRateLimitBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "maxStateEntries": SimTypeInt(signed=False, label="UInt32"), "maxPerIPRateLimitQueues": SimTypeInt(signed=False, label="UInt32"), "flags": SimTypeInt(signed=False, label="IPSEC_DOSP_FLAGS"), "numPublicIFLuids": SimTypeInt(signed=False, label="UInt32"), "publicIFLuids": SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), "numInternalIFLuids": SimTypeInt(signed=False, label="UInt32"), "internalIFLuids": SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), "publicV6AddrMask": SimStruct({"addr": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "prefixLength": SimTypeChar(label="Byte")}, name="FWP_V6_ADDR_AND_MASK", pack=False, align=None), "internalV6AddrMask": SimStruct({"addr": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "prefixLength": SimTypeChar(label="Byte")}, name="FWP_V6_ADDR_AND_MASK", pack=False, align=None)}, name="IPSEC_DOSP_OPTIONS0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "providerContextId": SimTypeLongLong(signed=False, label="UInt64")}, name="FWPM_PROVIDER_CONTEXT3_", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["engineHandle", "providerContext", "sd", "id"]),
        #
        'FwpmProviderContextDeleteById0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64")], SimTypeInt(signed=False, label="UInt32"), arg_names=["engineHandle", "id"]),
        #
        'FwpmProviderContextDeleteByKey0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["engineHandle", "key"]),
        #
        'FwpmProviderContextGetById0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypePointer(SimStruct({"providerContextKey": SimTypeBottom(label="Guid"), "displayData": SimStruct({"name": SimTypePointer(SimTypeChar(label="Char"), offset=0), "description": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="FWPM_DISPLAY_DATA0", pack=False, align=None), "flags": SimTypeInt(signed=False, label="UInt32"), "providerKey": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "providerData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "type": SimTypeInt(signed=False, label="FWPM_PROVIDER_CONTEXT_TYPE"), "Anonymous": SimUnion({"keyingPolicy": SimTypePointer(SimStruct({"numKeyMods": SimTypeInt(signed=False, label="UInt32"), "keyModKeys": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_KEYING_POLICY0", pack=False, align=None), offset=0), "ikeQmTransportPolicy": SimTypePointer(SimStruct({"numIpsecProposals": SimTypeInt(signed=False, label="UInt32"), "ipsecProposals": SimTypePointer(SimStruct({"lifetime": SimStruct({"lifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "lifetimeKilobytes": SimTypeInt(signed=False, label="UInt32"), "lifetimePackets": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_LIFETIME0", pack=False, align=None), "numSaTransforms": SimTypeInt(signed=False, label="UInt32"), "saTransforms": SimTypePointer(SimStruct({"ipsecTransformType": SimTypeInt(signed=False, label="IPSEC_TRANSFORM_TYPE"), "Anonymous": SimUnion({"ahTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espAuthTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espCipherTransform": SimTypePointer(SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthAndCipherTransform": SimTypePointer(SimStruct({"authTransform": SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), "cipherTransform": SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None)}, name="IPSEC_AUTH_AND_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthFwTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="IPSEC_SA_TRANSFORM0", pack=False, align=None), offset=0), "pfsGroup": SimTypeInt(signed=False, label="IPSEC_PFS_GROUP")}, name="IPSEC_PROPOSAL0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="IPSEC_POLICY_FLAG"), "ndAllowClearTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "saIdleTimeout": SimStruct({"idleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "idleTimeoutSecondsFailOver": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_IDLE_TIMEOUT0", pack=False, align=None), "emPolicy": SimTypePointer(SimStruct({"numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION0", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH")}, name="IKEEXT_CERTIFICATE_AUTHENTICATION0", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS")}, name="IKEEXT_KERBEROS_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH")}, name="IKEEXT_CERTIFICATE_AUTHENTICATION0", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD0", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE")}, name="IKEEXT_EM_POLICY0", pack=False, align=None), offset=0)}, name="IPSEC_TRANSPORT_POLICY0", pack=False, align=None), offset=0), "ikeQmTunnelPolicy": SimTypePointer(SimStruct({"flags": SimTypeInt(signed=False, label="IPSEC_POLICY_FLAG"), "numIpsecProposals": SimTypeInt(signed=False, label="UInt32"), "ipsecProposals": SimTypePointer(SimStruct({"lifetime": SimStruct({"lifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "lifetimeKilobytes": SimTypeInt(signed=False, label="UInt32"), "lifetimePackets": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_LIFETIME0", pack=False, align=None), "numSaTransforms": SimTypeInt(signed=False, label="UInt32"), "saTransforms": SimTypePointer(SimStruct({"ipsecTransformType": SimTypeInt(signed=False, label="IPSEC_TRANSFORM_TYPE"), "Anonymous": SimUnion({"ahTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espAuthTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espCipherTransform": SimTypePointer(SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthAndCipherTransform": SimTypePointer(SimStruct({"authTransform": SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), "cipherTransform": SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None)}, name="IPSEC_AUTH_AND_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthFwTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="IPSEC_SA_TRANSFORM0", pack=False, align=None), offset=0), "pfsGroup": SimTypeInt(signed=False, label="IPSEC_PFS_GROUP")}, name="IPSEC_PROPOSAL0", pack=False, align=None), offset=0), "tunnelEndpoints": SimStruct({"ipVersion": SimTypeInt(signed=False, label="FWP_IP_VERSION"), "Anonymous1": SimUnion({"localV4Address": SimTypeInt(signed=False, label="UInt32"), "localV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"remoteV4Address": SimTypeInt(signed=False, label="UInt32"), "remoteV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="IPSEC_TUNNEL_ENDPOINTS0", pack=False, align=None), "saIdleTimeout": SimStruct({"idleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "idleTimeoutSecondsFailOver": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_IDLE_TIMEOUT0", pack=False, align=None), "emPolicy": SimTypePointer(SimStruct({"numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION0", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH")}, name="IKEEXT_CERTIFICATE_AUTHENTICATION0", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS")}, name="IKEEXT_KERBEROS_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH")}, name="IKEEXT_CERTIFICATE_AUTHENTICATION0", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD0", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE")}, name="IKEEXT_EM_POLICY0", pack=False, align=None), offset=0)}, name="IPSEC_TUNNEL_POLICY0", pack=False, align=None), offset=0), "authipQmTransportPolicy": SimTypePointer(SimStruct({"numIpsecProposals": SimTypeInt(signed=False, label="UInt32"), "ipsecProposals": SimTypePointer(SimStruct({"lifetime": SimStruct({"lifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "lifetimeKilobytes": SimTypeInt(signed=False, label="UInt32"), "lifetimePackets": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_LIFETIME0", pack=False, align=None), "numSaTransforms": SimTypeInt(signed=False, label="UInt32"), "saTransforms": SimTypePointer(SimStruct({"ipsecTransformType": SimTypeInt(signed=False, label="IPSEC_TRANSFORM_TYPE"), "Anonymous": SimUnion({"ahTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espAuthTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espCipherTransform": SimTypePointer(SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthAndCipherTransform": SimTypePointer(SimStruct({"authTransform": SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), "cipherTransform": SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None)}, name="IPSEC_AUTH_AND_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthFwTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="IPSEC_SA_TRANSFORM0", pack=False, align=None), offset=0), "pfsGroup": SimTypeInt(signed=False, label="IPSEC_PFS_GROUP")}, name="IPSEC_PROPOSAL0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="IPSEC_POLICY_FLAG"), "ndAllowClearTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "saIdleTimeout": SimStruct({"idleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "idleTimeoutSecondsFailOver": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_IDLE_TIMEOUT0", pack=False, align=None), "emPolicy": SimTypePointer(SimStruct({"numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION0", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH")}, name="IKEEXT_CERTIFICATE_AUTHENTICATION0", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS")}, name="IKEEXT_KERBEROS_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH")}, name="IKEEXT_CERTIFICATE_AUTHENTICATION0", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD0", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE")}, name="IKEEXT_EM_POLICY0", pack=False, align=None), offset=0)}, name="IPSEC_TRANSPORT_POLICY0", pack=False, align=None), offset=0), "authipQmTunnelPolicy": SimTypePointer(SimStruct({"flags": SimTypeInt(signed=False, label="IPSEC_POLICY_FLAG"), "numIpsecProposals": SimTypeInt(signed=False, label="UInt32"), "ipsecProposals": SimTypePointer(SimStruct({"lifetime": SimStruct({"lifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "lifetimeKilobytes": SimTypeInt(signed=False, label="UInt32"), "lifetimePackets": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_LIFETIME0", pack=False, align=None), "numSaTransforms": SimTypeInt(signed=False, label="UInt32"), "saTransforms": SimTypePointer(SimStruct({"ipsecTransformType": SimTypeInt(signed=False, label="IPSEC_TRANSFORM_TYPE"), "Anonymous": SimUnion({"ahTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espAuthTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espCipherTransform": SimTypePointer(SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthAndCipherTransform": SimTypePointer(SimStruct({"authTransform": SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), "cipherTransform": SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None)}, name="IPSEC_AUTH_AND_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthFwTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="IPSEC_SA_TRANSFORM0", pack=False, align=None), offset=0), "pfsGroup": SimTypeInt(signed=False, label="IPSEC_PFS_GROUP")}, name="IPSEC_PROPOSAL0", pack=False, align=None), offset=0), "tunnelEndpoints": SimStruct({"ipVersion": SimTypeInt(signed=False, label="FWP_IP_VERSION"), "Anonymous1": SimUnion({"localV4Address": SimTypeInt(signed=False, label="UInt32"), "localV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"remoteV4Address": SimTypeInt(signed=False, label="UInt32"), "remoteV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="IPSEC_TUNNEL_ENDPOINTS0", pack=False, align=None), "saIdleTimeout": SimStruct({"idleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "idleTimeoutSecondsFailOver": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_IDLE_TIMEOUT0", pack=False, align=None), "emPolicy": SimTypePointer(SimStruct({"numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION0", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH")}, name="IKEEXT_CERTIFICATE_AUTHENTICATION0", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS")}, name="IKEEXT_KERBEROS_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH")}, name="IKEEXT_CERTIFICATE_AUTHENTICATION0", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD0", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE")}, name="IKEEXT_EM_POLICY0", pack=False, align=None), offset=0)}, name="IPSEC_TUNNEL_POLICY0", pack=False, align=None), offset=0), "ikeMmPolicy": SimTypePointer(SimStruct({"softExpirationTime": SimTypeInt(signed=False, label="UInt32"), "numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION0", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH")}, name="IKEEXT_CERTIFICATE_AUTHENTICATION0", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS")}, name="IKEEXT_KERBEROS_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH")}, name="IKEEXT_CERTIFICATE_AUTHENTICATION0", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD0", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE"), "numIkeProposals": SimTypeInt(signed=False, label="UInt32"), "ikeProposals": SimTypePointer(SimStruct({"cipherAlgorithm": SimStruct({"algoIdentifier": SimTypeInt(signed=False, label="IKEEXT_CIPHER_TYPE"), "keyLen": SimTypeInt(signed=False, label="UInt32"), "rounds": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CIPHER_ALGORITHM0", pack=False, align=None), "integrityAlgorithm": SimStruct({"algoIdentifier": SimTypeInt(signed=False, label="IKEEXT_INTEGRITY_TYPE")}, name="IKEEXT_INTEGRITY_ALGORITHM0", pack=False, align=None), "maxLifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "dhGroup": SimTypeInt(signed=False, label="IKEEXT_DH_GROUP"), "quickModeLimit": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_PROPOSAL0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="IKEEXT_POLICY_FLAG"), "maxDynamicFilters": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_POLICY0", pack=False, align=None), offset=0), "authIpMmPolicy": SimTypePointer(SimStruct({"softExpirationTime": SimTypeInt(signed=False, label="UInt32"), "numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION0", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH")}, name="IKEEXT_CERTIFICATE_AUTHENTICATION0", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS")}, name="IKEEXT_KERBEROS_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH")}, name="IKEEXT_CERTIFICATE_AUTHENTICATION0", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD0", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE"), "numIkeProposals": SimTypeInt(signed=False, label="UInt32"), "ikeProposals": SimTypePointer(SimStruct({"cipherAlgorithm": SimStruct({"algoIdentifier": SimTypeInt(signed=False, label="IKEEXT_CIPHER_TYPE"), "keyLen": SimTypeInt(signed=False, label="UInt32"), "rounds": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CIPHER_ALGORITHM0", pack=False, align=None), "integrityAlgorithm": SimStruct({"algoIdentifier": SimTypeInt(signed=False, label="IKEEXT_INTEGRITY_TYPE")}, name="IKEEXT_INTEGRITY_ALGORITHM0", pack=False, align=None), "maxLifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "dhGroup": SimTypeInt(signed=False, label="IKEEXT_DH_GROUP"), "quickModeLimit": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_PROPOSAL0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="IKEEXT_POLICY_FLAG"), "maxDynamicFilters": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_POLICY0", pack=False, align=None), offset=0), "dataBuffer": SimTypePointer(SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), offset=0), "classifyOptions": SimTypePointer(SimStruct({"numOptions": SimTypeInt(signed=False, label="UInt32"), "options": SimTypePointer(SimStruct({"type": SimTypeInt(signed=False, label="FWP_CLASSIFY_OPTION_TYPE"), "value": SimStruct({"type": SimTypeInt(signed=False, label="FWP_DATA_TYPE"), "Anonymous": SimUnion({"uint8": SimTypeChar(label="Byte"), "uint16": SimTypeShort(signed=False, label="UInt16"), "uint32": SimTypeInt(signed=False, label="UInt32"), "uint64": SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), "int8": SimTypeChar(label="SByte"), "int16": SimTypeShort(signed=True, label="Int16"), "int32": SimTypeInt(signed=True, label="Int32"), "int64": SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0), "float32": SimTypeFloat(size=32), "double64": SimTypePointer(SimTypeFloat(size=64), offset=0), "byteArray16": SimTypePointer(SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), offset=0), "byteBlob": SimTypePointer(SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), offset=0), "sid": SimTypePointer(SimTypeBottom(label="SID"), offset=0), "sd": SimTypePointer(SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), offset=0), "tokenInformation": SimTypePointer(SimStruct({"sidCount": SimTypeInt(signed=False, label="UInt32"), "sids": SimTypePointer(SimTypeBottom(label="SID_AND_ATTRIBUTES"), offset=0), "restrictedSidCount": SimTypeInt(signed=False, label="UInt32"), "restrictedSids": SimTypePointer(SimTypeBottom(label="SID_AND_ATTRIBUTES"), offset=0)}, name="FWP_TOKEN_INFORMATION", pack=False, align=None), offset=0), "tokenAccessInformation": SimTypePointer(SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), offset=0), "unicodeString": SimTypePointer(SimTypeChar(label="Char"), offset=0), "byteArray6": SimTypePointer(SimStruct({"byteArray6": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 6)}, name="FWP_BYTE_ARRAY6", pack=False, align=None), offset=0), "bitmapArray64": SimTypePointer(SimStruct({"bitmapArray64": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 8)}, name="FWP_BITMAP_ARRAY64_", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="FWP_VALUE0", pack=False, align=None)}, name="FWPM_CLASSIFY_OPTION0", pack=False, align=None), offset=0)}, name="FWPM_CLASSIFY_OPTIONS0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "providerContextId": SimTypeLongLong(signed=False, label="UInt64")}, name="FWPM_PROVIDER_CONTEXT0", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["engineHandle", "id", "providerContext"]),
        #
        'FwpmProviderContextGetById1': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypePointer(SimStruct({"providerContextKey": SimTypeBottom(label="Guid"), "displayData": SimStruct({"name": SimTypePointer(SimTypeChar(label="Char"), offset=0), "description": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="FWPM_DISPLAY_DATA0", pack=False, align=None), "flags": SimTypeInt(signed=False, label="UInt32"), "providerKey": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "providerData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "type": SimTypeInt(signed=False, label="FWPM_PROVIDER_CONTEXT_TYPE"), "Anonymous": SimUnion({"keyingPolicy": SimTypePointer(SimStruct({"numKeyMods": SimTypeInt(signed=False, label="UInt32"), "keyModKeys": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_KEYING_POLICY0", pack=False, align=None), offset=0), "ikeQmTransportPolicy": SimTypePointer(SimStruct({"numIpsecProposals": SimTypeInt(signed=False, label="UInt32"), "ipsecProposals": SimTypePointer(SimStruct({"lifetime": SimStruct({"lifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "lifetimeKilobytes": SimTypeInt(signed=False, label="UInt32"), "lifetimePackets": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_LIFETIME0", pack=False, align=None), "numSaTransforms": SimTypeInt(signed=False, label="UInt32"), "saTransforms": SimTypePointer(SimStruct({"ipsecTransformType": SimTypeInt(signed=False, label="IPSEC_TRANSFORM_TYPE"), "Anonymous": SimUnion({"ahTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espAuthTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espCipherTransform": SimTypePointer(SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthAndCipherTransform": SimTypePointer(SimStruct({"authTransform": SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), "cipherTransform": SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None)}, name="IPSEC_AUTH_AND_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthFwTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="IPSEC_SA_TRANSFORM0", pack=False, align=None), offset=0), "pfsGroup": SimTypeInt(signed=False, label="IPSEC_PFS_GROUP")}, name="IPSEC_PROPOSAL0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="IPSEC_POLICY_FLAG"), "ndAllowClearTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "saIdleTimeout": SimStruct({"idleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "idleTimeoutSecondsFailOver": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_IDLE_TIMEOUT0", pack=False, align=None), "emPolicy": SimTypePointer(SimStruct({"numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_PRESHARED_KEY_AUTHENTICATION_FLAGS")}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION1", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION1", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS")}, name="IKEEXT_KERBEROS_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION1", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None), "eapAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_EAP_AUTHENTICATION_FLAGS")}, name="IKEEXT_EAP_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD1", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE")}, name="IKEEXT_EM_POLICY1", pack=False, align=None), offset=0)}, name="IPSEC_TRANSPORT_POLICY1", pack=False, align=None), offset=0), "ikeQmTunnelPolicy": SimTypePointer(SimStruct({"flags": SimTypeInt(signed=False, label="IPSEC_POLICY_FLAG"), "numIpsecProposals": SimTypeInt(signed=False, label="UInt32"), "ipsecProposals": SimTypePointer(SimStruct({"lifetime": SimStruct({"lifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "lifetimeKilobytes": SimTypeInt(signed=False, label="UInt32"), "lifetimePackets": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_LIFETIME0", pack=False, align=None), "numSaTransforms": SimTypeInt(signed=False, label="UInt32"), "saTransforms": SimTypePointer(SimStruct({"ipsecTransformType": SimTypeInt(signed=False, label="IPSEC_TRANSFORM_TYPE"), "Anonymous": SimUnion({"ahTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espAuthTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espCipherTransform": SimTypePointer(SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthAndCipherTransform": SimTypePointer(SimStruct({"authTransform": SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), "cipherTransform": SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None)}, name="IPSEC_AUTH_AND_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthFwTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="IPSEC_SA_TRANSFORM0", pack=False, align=None), offset=0), "pfsGroup": SimTypeInt(signed=False, label="IPSEC_PFS_GROUP")}, name="IPSEC_PROPOSAL0", pack=False, align=None), offset=0), "tunnelEndpoints": SimStruct({"ipVersion": SimTypeInt(signed=False, label="FWP_IP_VERSION"), "Anonymous1": SimUnion({"localV4Address": SimTypeInt(signed=False, label="UInt32"), "localV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"remoteV4Address": SimTypeInt(signed=False, label="UInt32"), "remoteV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), "localIfLuid": SimTypeLongLong(signed=False, label="UInt64")}, name="IPSEC_TUNNEL_ENDPOINTS1", pack=False, align=None), "saIdleTimeout": SimStruct({"idleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "idleTimeoutSecondsFailOver": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_IDLE_TIMEOUT0", pack=False, align=None), "emPolicy": SimTypePointer(SimStruct({"numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_PRESHARED_KEY_AUTHENTICATION_FLAGS")}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION1", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION1", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS")}, name="IKEEXT_KERBEROS_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION1", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None), "eapAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_EAP_AUTHENTICATION_FLAGS")}, name="IKEEXT_EAP_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD1", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE")}, name="IKEEXT_EM_POLICY1", pack=False, align=None), offset=0)}, name="IPSEC_TUNNEL_POLICY1", pack=False, align=None), offset=0), "authipQmTransportPolicy": SimTypePointer(SimStruct({"numIpsecProposals": SimTypeInt(signed=False, label="UInt32"), "ipsecProposals": SimTypePointer(SimStruct({"lifetime": SimStruct({"lifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "lifetimeKilobytes": SimTypeInt(signed=False, label="UInt32"), "lifetimePackets": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_LIFETIME0", pack=False, align=None), "numSaTransforms": SimTypeInt(signed=False, label="UInt32"), "saTransforms": SimTypePointer(SimStruct({"ipsecTransformType": SimTypeInt(signed=False, label="IPSEC_TRANSFORM_TYPE"), "Anonymous": SimUnion({"ahTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espAuthTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espCipherTransform": SimTypePointer(SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthAndCipherTransform": SimTypePointer(SimStruct({"authTransform": SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), "cipherTransform": SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None)}, name="IPSEC_AUTH_AND_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthFwTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="IPSEC_SA_TRANSFORM0", pack=False, align=None), offset=0), "pfsGroup": SimTypeInt(signed=False, label="IPSEC_PFS_GROUP")}, name="IPSEC_PROPOSAL0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="IPSEC_POLICY_FLAG"), "ndAllowClearTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "saIdleTimeout": SimStruct({"idleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "idleTimeoutSecondsFailOver": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_IDLE_TIMEOUT0", pack=False, align=None), "emPolicy": SimTypePointer(SimStruct({"numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_PRESHARED_KEY_AUTHENTICATION_FLAGS")}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION1", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION1", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS")}, name="IKEEXT_KERBEROS_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION1", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None), "eapAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_EAP_AUTHENTICATION_FLAGS")}, name="IKEEXT_EAP_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD1", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE")}, name="IKEEXT_EM_POLICY1", pack=False, align=None), offset=0)}, name="IPSEC_TRANSPORT_POLICY1", pack=False, align=None), offset=0), "authipQmTunnelPolicy": SimTypePointer(SimStruct({"flags": SimTypeInt(signed=False, label="IPSEC_POLICY_FLAG"), "numIpsecProposals": SimTypeInt(signed=False, label="UInt32"), "ipsecProposals": SimTypePointer(SimStruct({"lifetime": SimStruct({"lifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "lifetimeKilobytes": SimTypeInt(signed=False, label="UInt32"), "lifetimePackets": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_LIFETIME0", pack=False, align=None), "numSaTransforms": SimTypeInt(signed=False, label="UInt32"), "saTransforms": SimTypePointer(SimStruct({"ipsecTransformType": SimTypeInt(signed=False, label="IPSEC_TRANSFORM_TYPE"), "Anonymous": SimUnion({"ahTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espAuthTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espCipherTransform": SimTypePointer(SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthAndCipherTransform": SimTypePointer(SimStruct({"authTransform": SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), "cipherTransform": SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None)}, name="IPSEC_AUTH_AND_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthFwTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="IPSEC_SA_TRANSFORM0", pack=False, align=None), offset=0), "pfsGroup": SimTypeInt(signed=False, label="IPSEC_PFS_GROUP")}, name="IPSEC_PROPOSAL0", pack=False, align=None), offset=0), "tunnelEndpoints": SimStruct({"ipVersion": SimTypeInt(signed=False, label="FWP_IP_VERSION"), "Anonymous1": SimUnion({"localV4Address": SimTypeInt(signed=False, label="UInt32"), "localV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"remoteV4Address": SimTypeInt(signed=False, label="UInt32"), "remoteV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), "localIfLuid": SimTypeLongLong(signed=False, label="UInt64")}, name="IPSEC_TUNNEL_ENDPOINTS1", pack=False, align=None), "saIdleTimeout": SimStruct({"idleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "idleTimeoutSecondsFailOver": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_IDLE_TIMEOUT0", pack=False, align=None), "emPolicy": SimTypePointer(SimStruct({"numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_PRESHARED_KEY_AUTHENTICATION_FLAGS")}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION1", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION1", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS")}, name="IKEEXT_KERBEROS_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION1", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None), "eapAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_EAP_AUTHENTICATION_FLAGS")}, name="IKEEXT_EAP_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD1", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE")}, name="IKEEXT_EM_POLICY1", pack=False, align=None), offset=0)}, name="IPSEC_TUNNEL_POLICY1", pack=False, align=None), offset=0), "ikeMmPolicy": SimTypePointer(SimStruct({"softExpirationTime": SimTypeInt(signed=False, label="UInt32"), "numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_PRESHARED_KEY_AUTHENTICATION_FLAGS")}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION1", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION1", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS")}, name="IKEEXT_KERBEROS_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION1", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None), "eapAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_EAP_AUTHENTICATION_FLAGS")}, name="IKEEXT_EAP_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD1", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE"), "numIkeProposals": SimTypeInt(signed=False, label="UInt32"), "ikeProposals": SimTypePointer(SimStruct({"cipherAlgorithm": SimStruct({"algoIdentifier": SimTypeInt(signed=False, label="IKEEXT_CIPHER_TYPE"), "keyLen": SimTypeInt(signed=False, label="UInt32"), "rounds": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CIPHER_ALGORITHM0", pack=False, align=None), "integrityAlgorithm": SimStruct({"algoIdentifier": SimTypeInt(signed=False, label="IKEEXT_INTEGRITY_TYPE")}, name="IKEEXT_INTEGRITY_ALGORITHM0", pack=False, align=None), "maxLifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "dhGroup": SimTypeInt(signed=False, label="IKEEXT_DH_GROUP"), "quickModeLimit": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_PROPOSAL0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="IKEEXT_POLICY_FLAG"), "maxDynamicFilters": SimTypeInt(signed=False, label="UInt32"), "retransmitDurationSecs": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_POLICY1", pack=False, align=None), offset=0), "authIpMmPolicy": SimTypePointer(SimStruct({"softExpirationTime": SimTypeInt(signed=False, label="UInt32"), "numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_PRESHARED_KEY_AUTHENTICATION_FLAGS")}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION1", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION1", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS")}, name="IKEEXT_KERBEROS_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION1", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None), "eapAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_EAP_AUTHENTICATION_FLAGS")}, name="IKEEXT_EAP_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD1", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE"), "numIkeProposals": SimTypeInt(signed=False, label="UInt32"), "ikeProposals": SimTypePointer(SimStruct({"cipherAlgorithm": SimStruct({"algoIdentifier": SimTypeInt(signed=False, label="IKEEXT_CIPHER_TYPE"), "keyLen": SimTypeInt(signed=False, label="UInt32"), "rounds": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CIPHER_ALGORITHM0", pack=False, align=None), "integrityAlgorithm": SimStruct({"algoIdentifier": SimTypeInt(signed=False, label="IKEEXT_INTEGRITY_TYPE")}, name="IKEEXT_INTEGRITY_ALGORITHM0", pack=False, align=None), "maxLifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "dhGroup": SimTypeInt(signed=False, label="IKEEXT_DH_GROUP"), "quickModeLimit": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_PROPOSAL0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="IKEEXT_POLICY_FLAG"), "maxDynamicFilters": SimTypeInt(signed=False, label="UInt32"), "retransmitDurationSecs": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_POLICY1", pack=False, align=None), offset=0), "dataBuffer": SimTypePointer(SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), offset=0), "classifyOptions": SimTypePointer(SimStruct({"numOptions": SimTypeInt(signed=False, label="UInt32"), "options": SimTypePointer(SimStruct({"type": SimTypeInt(signed=False, label="FWP_CLASSIFY_OPTION_TYPE"), "value": SimStruct({"type": SimTypeInt(signed=False, label="FWP_DATA_TYPE"), "Anonymous": SimUnion({"uint8": SimTypeChar(label="Byte"), "uint16": SimTypeShort(signed=False, label="UInt16"), "uint32": SimTypeInt(signed=False, label="UInt32"), "uint64": SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), "int8": SimTypeChar(label="SByte"), "int16": SimTypeShort(signed=True, label="Int16"), "int32": SimTypeInt(signed=True, label="Int32"), "int64": SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0), "float32": SimTypeFloat(size=32), "double64": SimTypePointer(SimTypeFloat(size=64), offset=0), "byteArray16": SimTypePointer(SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), offset=0), "byteBlob": SimTypePointer(SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), offset=0), "sid": SimTypePointer(SimTypeBottom(label="SID"), offset=0), "sd": SimTypePointer(SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), offset=0), "tokenInformation": SimTypePointer(SimStruct({"sidCount": SimTypeInt(signed=False, label="UInt32"), "sids": SimTypePointer(SimTypeBottom(label="SID_AND_ATTRIBUTES"), offset=0), "restrictedSidCount": SimTypeInt(signed=False, label="UInt32"), "restrictedSids": SimTypePointer(SimTypeBottom(label="SID_AND_ATTRIBUTES"), offset=0)}, name="FWP_TOKEN_INFORMATION", pack=False, align=None), offset=0), "tokenAccessInformation": SimTypePointer(SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), offset=0), "unicodeString": SimTypePointer(SimTypeChar(label="Char"), offset=0), "byteArray6": SimTypePointer(SimStruct({"byteArray6": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 6)}, name="FWP_BYTE_ARRAY6", pack=False, align=None), offset=0), "bitmapArray64": SimTypePointer(SimStruct({"bitmapArray64": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 8)}, name="FWP_BITMAP_ARRAY64_", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="FWP_VALUE0", pack=False, align=None)}, name="FWPM_CLASSIFY_OPTION0", pack=False, align=None), offset=0)}, name="FWPM_CLASSIFY_OPTIONS0", pack=False, align=None), offset=0), "ikeV2QmTunnelPolicy": SimTypePointer(SimStruct({"flags": SimTypeInt(signed=False, label="IPSEC_POLICY_FLAG"), "numIpsecProposals": SimTypeInt(signed=False, label="UInt32"), "ipsecProposals": SimTypePointer(SimStruct({"lifetime": SimStruct({"lifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "lifetimeKilobytes": SimTypeInt(signed=False, label="UInt32"), "lifetimePackets": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_LIFETIME0", pack=False, align=None), "numSaTransforms": SimTypeInt(signed=False, label="UInt32"), "saTransforms": SimTypePointer(SimStruct({"ipsecTransformType": SimTypeInt(signed=False, label="IPSEC_TRANSFORM_TYPE"), "Anonymous": SimUnion({"ahTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espAuthTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espCipherTransform": SimTypePointer(SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthAndCipherTransform": SimTypePointer(SimStruct({"authTransform": SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), "cipherTransform": SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None)}, name="IPSEC_AUTH_AND_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthFwTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="IPSEC_SA_TRANSFORM0", pack=False, align=None), offset=0), "pfsGroup": SimTypeInt(signed=False, label="IPSEC_PFS_GROUP")}, name="IPSEC_PROPOSAL0", pack=False, align=None), offset=0), "tunnelEndpoints": SimStruct({"ipVersion": SimTypeInt(signed=False, label="FWP_IP_VERSION"), "Anonymous1": SimUnion({"localV4Address": SimTypeInt(signed=False, label="UInt32"), "localV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"remoteV4Address": SimTypeInt(signed=False, label="UInt32"), "remoteV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), "localIfLuid": SimTypeLongLong(signed=False, label="UInt64")}, name="IPSEC_TUNNEL_ENDPOINTS1", pack=False, align=None), "saIdleTimeout": SimStruct({"idleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "idleTimeoutSecondsFailOver": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_IDLE_TIMEOUT0", pack=False, align=None), "emPolicy": SimTypePointer(SimStruct({"numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_PRESHARED_KEY_AUTHENTICATION_FLAGS")}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION1", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION1", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS")}, name="IKEEXT_KERBEROS_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION1", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None), "eapAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_EAP_AUTHENTICATION_FLAGS")}, name="IKEEXT_EAP_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD1", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE")}, name="IKEEXT_EM_POLICY1", pack=False, align=None), offset=0)}, name="IPSEC_TUNNEL_POLICY1", pack=False, align=None), offset=0), "ikeV2MmPolicy": SimTypePointer(SimStruct({"softExpirationTime": SimTypeInt(signed=False, label="UInt32"), "numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_PRESHARED_KEY_AUTHENTICATION_FLAGS")}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION1", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION1", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS")}, name="IKEEXT_KERBEROS_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "inboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "inboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootArray": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None), "outboundEnterpriseStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0), "outboundTrustedRootStoreConfig": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_FLAGS")}, name="IKEEXT_CERT_ROOT_CONFIG0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION1", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None), "eapAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_EAP_AUTHENTICATION_FLAGS")}, name="IKEEXT_EAP_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD1", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE"), "numIkeProposals": SimTypeInt(signed=False, label="UInt32"), "ikeProposals": SimTypePointer(SimStruct({"cipherAlgorithm": SimStruct({"algoIdentifier": SimTypeInt(signed=False, label="IKEEXT_CIPHER_TYPE"), "keyLen": SimTypeInt(signed=False, label="UInt32"), "rounds": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CIPHER_ALGORITHM0", pack=False, align=None), "integrityAlgorithm": SimStruct({"algoIdentifier": SimTypeInt(signed=False, label="IKEEXT_INTEGRITY_TYPE")}, name="IKEEXT_INTEGRITY_ALGORITHM0", pack=False, align=None), "maxLifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "dhGroup": SimTypeInt(signed=False, label="IKEEXT_DH_GROUP"), "quickModeLimit": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_PROPOSAL0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="IKEEXT_POLICY_FLAG"), "maxDynamicFilters": SimTypeInt(signed=False, label="UInt32"), "retransmitDurationSecs": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_POLICY1", pack=False, align=None), offset=0), "idpOptions": SimTypePointer(SimStruct({"stateIdleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "perIPRateLimitQueueIdleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "ipV6IPsecUnauthDscp": SimTypeChar(label="Byte"), "ipV6IPsecUnauthRateLimitBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "ipV6IPsecUnauthPerIPRateLimitBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "ipV6IPsecAuthDscp": SimTypeChar(label="Byte"), "ipV6IPsecAuthRateLimitBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "icmpV6Dscp": SimTypeChar(label="Byte"), "icmpV6RateLimitBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "ipV6FilterExemptDscp": SimTypeChar(label="Byte"), "ipV6FilterExemptRateLimitBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "defBlockExemptDscp": SimTypeChar(label="Byte"), "defBlockExemptRateLimitBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "maxStateEntries": SimTypeInt(signed=False, label="UInt32"), "maxPerIPRateLimitQueues": SimTypeInt(signed=False, label="UInt32"), "flags": SimTypeInt(signed=False, label="IPSEC_DOSP_FLAGS"), "numPublicIFLuids": SimTypeInt(signed=False, label="UInt32"), "publicIFLuids": SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), "numInternalIFLuids": SimTypeInt(signed=False, label="UInt32"), "internalIFLuids": SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), "publicV6AddrMask": SimStruct({"addr": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "prefixLength": SimTypeChar(label="Byte")}, name="FWP_V6_ADDR_AND_MASK", pack=False, align=None), "internalV6AddrMask": SimStruct({"addr": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "prefixLength": SimTypeChar(label="Byte")}, name="FWP_V6_ADDR_AND_MASK", pack=False, align=None)}, name="IPSEC_DOSP_OPTIONS0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "providerContextId": SimTypeLongLong(signed=False, label="UInt64")}, name="FWPM_PROVIDER_CONTEXT1", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["engineHandle", "id", "providerContext"]),
        #
        'FwpmProviderContextGetById2': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypePointer(SimStruct({"providerContextKey": SimTypeBottom(label="Guid"), "displayData": SimStruct({"name": SimTypePointer(SimTypeChar(label="Char"), offset=0), "description": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="FWPM_DISPLAY_DATA0", pack=False, align=None), "flags": SimTypeInt(signed=False, label="UInt32"), "providerKey": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "providerData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "type": SimTypeInt(signed=False, label="FWPM_PROVIDER_CONTEXT_TYPE"), "Anonymous": SimUnion({"keyingPolicy": SimTypePointer(SimStruct({"numKeyMods": SimTypeInt(signed=False, label="UInt32"), "keyModKeys": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_KEYING_POLICY1", pack=False, align=None), offset=0), "ikeQmTransportPolicy": SimTypePointer(SimStruct({"numIpsecProposals": SimTypeInt(signed=False, label="UInt32"), "ipsecProposals": SimTypePointer(SimStruct({"lifetime": SimStruct({"lifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "lifetimeKilobytes": SimTypeInt(signed=False, label="UInt32"), "lifetimePackets": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_LIFETIME0", pack=False, align=None), "numSaTransforms": SimTypeInt(signed=False, label="UInt32"), "saTransforms": SimTypePointer(SimStruct({"ipsecTransformType": SimTypeInt(signed=False, label="IPSEC_TRANSFORM_TYPE"), "Anonymous": SimUnion({"ahTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espAuthTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espCipherTransform": SimTypePointer(SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthAndCipherTransform": SimTypePointer(SimStruct({"authTransform": SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), "cipherTransform": SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None)}, name="IPSEC_AUTH_AND_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthFwTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="IPSEC_SA_TRANSFORM0", pack=False, align=None), offset=0), "pfsGroup": SimTypeInt(signed=False, label="IPSEC_PFS_GROUP")}, name="IPSEC_PROPOSAL0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="IPSEC_POLICY_FLAG"), "ndAllowClearTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "saIdleTimeout": SimStruct({"idleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "idleTimeoutSecondsFailOver": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_IDLE_TIMEOUT0", pack=False, align=None), "emPolicy": SimTypePointer(SimStruct({"numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_PRESHARED_KEY_AUTHENTICATION_FLAGS")}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION1", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS"), "proxyServer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_KERBEROS_AUTHENTICATION1", pack=False, align=None), "reservedAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_RESERVED_AUTHENTICATION_FLAGS")}, name="IKEEXT_RESERVED_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None), "eapAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_EAP_AUTHENTICATION_FLAGS")}, name="IKEEXT_EAP_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD2", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE")}, name="IKEEXT_EM_POLICY2", pack=False, align=None), offset=0)}, name="IPSEC_TRANSPORT_POLICY2", pack=False, align=None), offset=0), "ikeQmTunnelPolicy": SimTypePointer(SimStruct({"flags": SimTypeInt(signed=False, label="IPSEC_POLICY_FLAG"), "numIpsecProposals": SimTypeInt(signed=False, label="UInt32"), "ipsecProposals": SimTypePointer(SimStruct({"lifetime": SimStruct({"lifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "lifetimeKilobytes": SimTypeInt(signed=False, label="UInt32"), "lifetimePackets": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_LIFETIME0", pack=False, align=None), "numSaTransforms": SimTypeInt(signed=False, label="UInt32"), "saTransforms": SimTypePointer(SimStruct({"ipsecTransformType": SimTypeInt(signed=False, label="IPSEC_TRANSFORM_TYPE"), "Anonymous": SimUnion({"ahTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espAuthTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espCipherTransform": SimTypePointer(SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthAndCipherTransform": SimTypePointer(SimStruct({"authTransform": SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), "cipherTransform": SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None)}, name="IPSEC_AUTH_AND_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthFwTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="IPSEC_SA_TRANSFORM0", pack=False, align=None), offset=0), "pfsGroup": SimTypeInt(signed=False, label="IPSEC_PFS_GROUP")}, name="IPSEC_PROPOSAL0", pack=False, align=None), offset=0), "tunnelEndpoints": SimStruct({"ipVersion": SimTypeInt(signed=False, label="FWP_IP_VERSION"), "Anonymous1": SimUnion({"localV4Address": SimTypeInt(signed=False, label="UInt32"), "localV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"remoteV4Address": SimTypeInt(signed=False, label="UInt32"), "remoteV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), "localIfLuid": SimTypeLongLong(signed=False, label="UInt64"), "remoteFqdn": SimTypePointer(SimTypeChar(label="Char"), offset=0), "numAddresses": SimTypeInt(signed=False, label="UInt32"), "remoteAddresses": SimTypePointer(SimStruct({"ipVersion": SimTypeInt(signed=False, label="FWP_IP_VERSION"), "Anonymous": SimUnion({"v4Address": SimTypeInt(signed=False, label="UInt32"), "v6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="IPSEC_TUNNEL_ENDPOINT0", pack=False, align=None), offset=0)}, name="IPSEC_TUNNEL_ENDPOINTS2", pack=False, align=None), "saIdleTimeout": SimStruct({"idleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "idleTimeoutSecondsFailOver": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_IDLE_TIMEOUT0", pack=False, align=None), "emPolicy": SimTypePointer(SimStruct({"numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_PRESHARED_KEY_AUTHENTICATION_FLAGS")}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION1", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS"), "proxyServer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_KERBEROS_AUTHENTICATION1", pack=False, align=None), "reservedAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_RESERVED_AUTHENTICATION_FLAGS")}, name="IKEEXT_RESERVED_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None), "eapAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_EAP_AUTHENTICATION_FLAGS")}, name="IKEEXT_EAP_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD2", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE")}, name="IKEEXT_EM_POLICY2", pack=False, align=None), offset=0), "fwdPathSaLifetime": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_TUNNEL_POLICY2", pack=False, align=None), offset=0), "authipQmTransportPolicy": SimTypePointer(SimStruct({"numIpsecProposals": SimTypeInt(signed=False, label="UInt32"), "ipsecProposals": SimTypePointer(SimStruct({"lifetime": SimStruct({"lifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "lifetimeKilobytes": SimTypeInt(signed=False, label="UInt32"), "lifetimePackets": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_LIFETIME0", pack=False, align=None), "numSaTransforms": SimTypeInt(signed=False, label="UInt32"), "saTransforms": SimTypePointer(SimStruct({"ipsecTransformType": SimTypeInt(signed=False, label="IPSEC_TRANSFORM_TYPE"), "Anonymous": SimUnion({"ahTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espAuthTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espCipherTransform": SimTypePointer(SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthAndCipherTransform": SimTypePointer(SimStruct({"authTransform": SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), "cipherTransform": SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None)}, name="IPSEC_AUTH_AND_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthFwTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="IPSEC_SA_TRANSFORM0", pack=False, align=None), offset=0), "pfsGroup": SimTypeInt(signed=False, label="IPSEC_PFS_GROUP")}, name="IPSEC_PROPOSAL0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="IPSEC_POLICY_FLAG"), "ndAllowClearTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "saIdleTimeout": SimStruct({"idleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "idleTimeoutSecondsFailOver": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_IDLE_TIMEOUT0", pack=False, align=None), "emPolicy": SimTypePointer(SimStruct({"numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_PRESHARED_KEY_AUTHENTICATION_FLAGS")}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION1", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS"), "proxyServer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_KERBEROS_AUTHENTICATION1", pack=False, align=None), "reservedAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_RESERVED_AUTHENTICATION_FLAGS")}, name="IKEEXT_RESERVED_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None), "eapAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_EAP_AUTHENTICATION_FLAGS")}, name="IKEEXT_EAP_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD2", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE")}, name="IKEEXT_EM_POLICY2", pack=False, align=None), offset=0)}, name="IPSEC_TRANSPORT_POLICY2", pack=False, align=None), offset=0), "authipQmTunnelPolicy": SimTypePointer(SimStruct({"flags": SimTypeInt(signed=False, label="IPSEC_POLICY_FLAG"), "numIpsecProposals": SimTypeInt(signed=False, label="UInt32"), "ipsecProposals": SimTypePointer(SimStruct({"lifetime": SimStruct({"lifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "lifetimeKilobytes": SimTypeInt(signed=False, label="UInt32"), "lifetimePackets": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_LIFETIME0", pack=False, align=None), "numSaTransforms": SimTypeInt(signed=False, label="UInt32"), "saTransforms": SimTypePointer(SimStruct({"ipsecTransformType": SimTypeInt(signed=False, label="IPSEC_TRANSFORM_TYPE"), "Anonymous": SimUnion({"ahTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espAuthTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espCipherTransform": SimTypePointer(SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthAndCipherTransform": SimTypePointer(SimStruct({"authTransform": SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), "cipherTransform": SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None)}, name="IPSEC_AUTH_AND_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthFwTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="IPSEC_SA_TRANSFORM0", pack=False, align=None), offset=0), "pfsGroup": SimTypeInt(signed=False, label="IPSEC_PFS_GROUP")}, name="IPSEC_PROPOSAL0", pack=False, align=None), offset=0), "tunnelEndpoints": SimStruct({"ipVersion": SimTypeInt(signed=False, label="FWP_IP_VERSION"), "Anonymous1": SimUnion({"localV4Address": SimTypeInt(signed=False, label="UInt32"), "localV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"remoteV4Address": SimTypeInt(signed=False, label="UInt32"), "remoteV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), "localIfLuid": SimTypeLongLong(signed=False, label="UInt64"), "remoteFqdn": SimTypePointer(SimTypeChar(label="Char"), offset=0), "numAddresses": SimTypeInt(signed=False, label="UInt32"), "remoteAddresses": SimTypePointer(SimStruct({"ipVersion": SimTypeInt(signed=False, label="FWP_IP_VERSION"), "Anonymous": SimUnion({"v4Address": SimTypeInt(signed=False, label="UInt32"), "v6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="IPSEC_TUNNEL_ENDPOINT0", pack=False, align=None), offset=0)}, name="IPSEC_TUNNEL_ENDPOINTS2", pack=False, align=None), "saIdleTimeout": SimStruct({"idleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "idleTimeoutSecondsFailOver": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_IDLE_TIMEOUT0", pack=False, align=None), "emPolicy": SimTypePointer(SimStruct({"numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_PRESHARED_KEY_AUTHENTICATION_FLAGS")}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION1", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS"), "proxyServer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_KERBEROS_AUTHENTICATION1", pack=False, align=None), "reservedAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_RESERVED_AUTHENTICATION_FLAGS")}, name="IKEEXT_RESERVED_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None), "eapAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_EAP_AUTHENTICATION_FLAGS")}, name="IKEEXT_EAP_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD2", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE")}, name="IKEEXT_EM_POLICY2", pack=False, align=None), offset=0), "fwdPathSaLifetime": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_TUNNEL_POLICY2", pack=False, align=None), offset=0), "ikeMmPolicy": SimTypePointer(SimStruct({"softExpirationTime": SimTypeInt(signed=False, label="UInt32"), "numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_PRESHARED_KEY_AUTHENTICATION_FLAGS")}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION1", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS"), "proxyServer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_KERBEROS_AUTHENTICATION1", pack=False, align=None), "reservedAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_RESERVED_AUTHENTICATION_FLAGS")}, name="IKEEXT_RESERVED_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None), "eapAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_EAP_AUTHENTICATION_FLAGS")}, name="IKEEXT_EAP_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD2", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE"), "numIkeProposals": SimTypeInt(signed=False, label="UInt32"), "ikeProposals": SimTypePointer(SimStruct({"cipherAlgorithm": SimStruct({"algoIdentifier": SimTypeInt(signed=False, label="IKEEXT_CIPHER_TYPE"), "keyLen": SimTypeInt(signed=False, label="UInt32"), "rounds": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CIPHER_ALGORITHM0", pack=False, align=None), "integrityAlgorithm": SimStruct({"algoIdentifier": SimTypeInt(signed=False, label="IKEEXT_INTEGRITY_TYPE")}, name="IKEEXT_INTEGRITY_ALGORITHM0", pack=False, align=None), "maxLifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "dhGroup": SimTypeInt(signed=False, label="IKEEXT_DH_GROUP"), "quickModeLimit": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_PROPOSAL0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="IKEEXT_POLICY_FLAG"), "maxDynamicFilters": SimTypeInt(signed=False, label="UInt32"), "retransmitDurationSecs": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_POLICY2", pack=False, align=None), offset=0), "authIpMmPolicy": SimTypePointer(SimStruct({"softExpirationTime": SimTypeInt(signed=False, label="UInt32"), "numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_PRESHARED_KEY_AUTHENTICATION_FLAGS")}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION1", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS"), "proxyServer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_KERBEROS_AUTHENTICATION1", pack=False, align=None), "reservedAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_RESERVED_AUTHENTICATION_FLAGS")}, name="IKEEXT_RESERVED_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None), "eapAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_EAP_AUTHENTICATION_FLAGS")}, name="IKEEXT_EAP_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD2", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE"), "numIkeProposals": SimTypeInt(signed=False, label="UInt32"), "ikeProposals": SimTypePointer(SimStruct({"cipherAlgorithm": SimStruct({"algoIdentifier": SimTypeInt(signed=False, label="IKEEXT_CIPHER_TYPE"), "keyLen": SimTypeInt(signed=False, label="UInt32"), "rounds": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CIPHER_ALGORITHM0", pack=False, align=None), "integrityAlgorithm": SimStruct({"algoIdentifier": SimTypeInt(signed=False, label="IKEEXT_INTEGRITY_TYPE")}, name="IKEEXT_INTEGRITY_ALGORITHM0", pack=False, align=None), "maxLifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "dhGroup": SimTypeInt(signed=False, label="IKEEXT_DH_GROUP"), "quickModeLimit": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_PROPOSAL0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="IKEEXT_POLICY_FLAG"), "maxDynamicFilters": SimTypeInt(signed=False, label="UInt32"), "retransmitDurationSecs": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_POLICY2", pack=False, align=None), offset=0), "dataBuffer": SimTypePointer(SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), offset=0), "classifyOptions": SimTypePointer(SimStruct({"numOptions": SimTypeInt(signed=False, label="UInt32"), "options": SimTypePointer(SimStruct({"type": SimTypeInt(signed=False, label="FWP_CLASSIFY_OPTION_TYPE"), "value": SimStruct({"type": SimTypeInt(signed=False, label="FWP_DATA_TYPE"), "Anonymous": SimUnion({"uint8": SimTypeChar(label="Byte"), "uint16": SimTypeShort(signed=False, label="UInt16"), "uint32": SimTypeInt(signed=False, label="UInt32"), "uint64": SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), "int8": SimTypeChar(label="SByte"), "int16": SimTypeShort(signed=True, label="Int16"), "int32": SimTypeInt(signed=True, label="Int32"), "int64": SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0), "float32": SimTypeFloat(size=32), "double64": SimTypePointer(SimTypeFloat(size=64), offset=0), "byteArray16": SimTypePointer(SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), offset=0), "byteBlob": SimTypePointer(SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), offset=0), "sid": SimTypePointer(SimTypeBottom(label="SID"), offset=0), "sd": SimTypePointer(SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), offset=0), "tokenInformation": SimTypePointer(SimStruct({"sidCount": SimTypeInt(signed=False, label="UInt32"), "sids": SimTypePointer(SimTypeBottom(label="SID_AND_ATTRIBUTES"), offset=0), "restrictedSidCount": SimTypeInt(signed=False, label="UInt32"), "restrictedSids": SimTypePointer(SimTypeBottom(label="SID_AND_ATTRIBUTES"), offset=0)}, name="FWP_TOKEN_INFORMATION", pack=False, align=None), offset=0), "tokenAccessInformation": SimTypePointer(SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), offset=0), "unicodeString": SimTypePointer(SimTypeChar(label="Char"), offset=0), "byteArray6": SimTypePointer(SimStruct({"byteArray6": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 6)}, name="FWP_BYTE_ARRAY6", pack=False, align=None), offset=0), "bitmapArray64": SimTypePointer(SimStruct({"bitmapArray64": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 8)}, name="FWP_BITMAP_ARRAY64_", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="FWP_VALUE0", pack=False, align=None)}, name="FWPM_CLASSIFY_OPTION0", pack=False, align=None), offset=0)}, name="FWPM_CLASSIFY_OPTIONS0", pack=False, align=None), offset=0), "ikeV2QmTunnelPolicy": SimTypePointer(SimStruct({"flags": SimTypeInt(signed=False, label="IPSEC_POLICY_FLAG"), "numIpsecProposals": SimTypeInt(signed=False, label="UInt32"), "ipsecProposals": SimTypePointer(SimStruct({"lifetime": SimStruct({"lifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "lifetimeKilobytes": SimTypeInt(signed=False, label="UInt32"), "lifetimePackets": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_LIFETIME0", pack=False, align=None), "numSaTransforms": SimTypeInt(signed=False, label="UInt32"), "saTransforms": SimTypePointer(SimStruct({"ipsecTransformType": SimTypeInt(signed=False, label="IPSEC_TRANSFORM_TYPE"), "Anonymous": SimUnion({"ahTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espAuthTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espCipherTransform": SimTypePointer(SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthAndCipherTransform": SimTypePointer(SimStruct({"authTransform": SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), "cipherTransform": SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None)}, name="IPSEC_AUTH_AND_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthFwTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="IPSEC_SA_TRANSFORM0", pack=False, align=None), offset=0), "pfsGroup": SimTypeInt(signed=False, label="IPSEC_PFS_GROUP")}, name="IPSEC_PROPOSAL0", pack=False, align=None), offset=0), "tunnelEndpoints": SimStruct({"ipVersion": SimTypeInt(signed=False, label="FWP_IP_VERSION"), "Anonymous1": SimUnion({"localV4Address": SimTypeInt(signed=False, label="UInt32"), "localV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"remoteV4Address": SimTypeInt(signed=False, label="UInt32"), "remoteV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), "localIfLuid": SimTypeLongLong(signed=False, label="UInt64"), "remoteFqdn": SimTypePointer(SimTypeChar(label="Char"), offset=0), "numAddresses": SimTypeInt(signed=False, label="UInt32"), "remoteAddresses": SimTypePointer(SimStruct({"ipVersion": SimTypeInt(signed=False, label="FWP_IP_VERSION"), "Anonymous": SimUnion({"v4Address": SimTypeInt(signed=False, label="UInt32"), "v6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="IPSEC_TUNNEL_ENDPOINT0", pack=False, align=None), offset=0)}, name="IPSEC_TUNNEL_ENDPOINTS2", pack=False, align=None), "saIdleTimeout": SimStruct({"idleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "idleTimeoutSecondsFailOver": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_IDLE_TIMEOUT0", pack=False, align=None), "emPolicy": SimTypePointer(SimStruct({"numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_PRESHARED_KEY_AUTHENTICATION_FLAGS")}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION1", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS"), "proxyServer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_KERBEROS_AUTHENTICATION1", pack=False, align=None), "reservedAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_RESERVED_AUTHENTICATION_FLAGS")}, name="IKEEXT_RESERVED_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None), "eapAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_EAP_AUTHENTICATION_FLAGS")}, name="IKEEXT_EAP_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD2", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE")}, name="IKEEXT_EM_POLICY2", pack=False, align=None), offset=0), "fwdPathSaLifetime": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_TUNNEL_POLICY2", pack=False, align=None), offset=0), "ikeV2QmTransportPolicy": SimTypePointer(SimStruct({"numIpsecProposals": SimTypeInt(signed=False, label="UInt32"), "ipsecProposals": SimTypePointer(SimStruct({"lifetime": SimStruct({"lifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "lifetimeKilobytes": SimTypeInt(signed=False, label="UInt32"), "lifetimePackets": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_LIFETIME0", pack=False, align=None), "numSaTransforms": SimTypeInt(signed=False, label="UInt32"), "saTransforms": SimTypePointer(SimStruct({"ipsecTransformType": SimTypeInt(signed=False, label="IPSEC_TRANSFORM_TYPE"), "Anonymous": SimUnion({"ahTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espAuthTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espCipherTransform": SimTypePointer(SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthAndCipherTransform": SimTypePointer(SimStruct({"authTransform": SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), "cipherTransform": SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None)}, name="IPSEC_AUTH_AND_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthFwTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="IPSEC_SA_TRANSFORM0", pack=False, align=None), offset=0), "pfsGroup": SimTypeInt(signed=False, label="IPSEC_PFS_GROUP")}, name="IPSEC_PROPOSAL0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="IPSEC_POLICY_FLAG"), "ndAllowClearTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "saIdleTimeout": SimStruct({"idleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "idleTimeoutSecondsFailOver": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_IDLE_TIMEOUT0", pack=False, align=None), "emPolicy": SimTypePointer(SimStruct({"numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_PRESHARED_KEY_AUTHENTICATION_FLAGS")}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION1", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS"), "proxyServer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_KERBEROS_AUTHENTICATION1", pack=False, align=None), "reservedAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_RESERVED_AUTHENTICATION_FLAGS")}, name="IKEEXT_RESERVED_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None), "eapAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_EAP_AUTHENTICATION_FLAGS")}, name="IKEEXT_EAP_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD2", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE")}, name="IKEEXT_EM_POLICY2", pack=False, align=None), offset=0)}, name="IPSEC_TRANSPORT_POLICY2", pack=False, align=None), offset=0), "ikeV2MmPolicy": SimTypePointer(SimStruct({"softExpirationTime": SimTypeInt(signed=False, label="UInt32"), "numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_PRESHARED_KEY_AUTHENTICATION_FLAGS")}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION1", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS"), "proxyServer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_KERBEROS_AUTHENTICATION1", pack=False, align=None), "reservedAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_RESERVED_AUTHENTICATION_FLAGS")}, name="IKEEXT_RESERVED_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None), "eapAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_EAP_AUTHENTICATION_FLAGS")}, name="IKEEXT_EAP_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD2", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE"), "numIkeProposals": SimTypeInt(signed=False, label="UInt32"), "ikeProposals": SimTypePointer(SimStruct({"cipherAlgorithm": SimStruct({"algoIdentifier": SimTypeInt(signed=False, label="IKEEXT_CIPHER_TYPE"), "keyLen": SimTypeInt(signed=False, label="UInt32"), "rounds": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CIPHER_ALGORITHM0", pack=False, align=None), "integrityAlgorithm": SimStruct({"algoIdentifier": SimTypeInt(signed=False, label="IKEEXT_INTEGRITY_TYPE")}, name="IKEEXT_INTEGRITY_ALGORITHM0", pack=False, align=None), "maxLifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "dhGroup": SimTypeInt(signed=False, label="IKEEXT_DH_GROUP"), "quickModeLimit": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_PROPOSAL0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="IKEEXT_POLICY_FLAG"), "maxDynamicFilters": SimTypeInt(signed=False, label="UInt32"), "retransmitDurationSecs": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_POLICY2", pack=False, align=None), offset=0), "idpOptions": SimTypePointer(SimStruct({"stateIdleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "perIPRateLimitQueueIdleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "ipV6IPsecUnauthDscp": SimTypeChar(label="Byte"), "ipV6IPsecUnauthRateLimitBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "ipV6IPsecUnauthPerIPRateLimitBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "ipV6IPsecAuthDscp": SimTypeChar(label="Byte"), "ipV6IPsecAuthRateLimitBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "icmpV6Dscp": SimTypeChar(label="Byte"), "icmpV6RateLimitBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "ipV6FilterExemptDscp": SimTypeChar(label="Byte"), "ipV6FilterExemptRateLimitBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "defBlockExemptDscp": SimTypeChar(label="Byte"), "defBlockExemptRateLimitBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "maxStateEntries": SimTypeInt(signed=False, label="UInt32"), "maxPerIPRateLimitQueues": SimTypeInt(signed=False, label="UInt32"), "flags": SimTypeInt(signed=False, label="IPSEC_DOSP_FLAGS"), "numPublicIFLuids": SimTypeInt(signed=False, label="UInt32"), "publicIFLuids": SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), "numInternalIFLuids": SimTypeInt(signed=False, label="UInt32"), "internalIFLuids": SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), "publicV6AddrMask": SimStruct({"addr": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "prefixLength": SimTypeChar(label="Byte")}, name="FWP_V6_ADDR_AND_MASK", pack=False, align=None), "internalV6AddrMask": SimStruct({"addr": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "prefixLength": SimTypeChar(label="Byte")}, name="FWP_V6_ADDR_AND_MASK", pack=False, align=None)}, name="IPSEC_DOSP_OPTIONS0", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "providerContextId": SimTypeLongLong(signed=False, label="UInt64")}, name="FWPM_PROVIDER_CONTEXT2", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["engineHandle", "id", "providerContext"]),
        #
        'FwpmProviderContextGetById3': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypePointer(SimStruct({"providerContextKey": SimTypeBottom(label="Guid"), "displayData": SimStruct({"name": SimTypePointer(SimTypeChar(label="Char"), offset=0), "description": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="FWPM_DISPLAY_DATA0", pack=False, align=None), "flags": SimTypeInt(signed=False, label="UInt32"), "providerKey": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "providerData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "type": SimTypeInt(signed=False, label="FWPM_PROVIDER_CONTEXT_TYPE"), "Anonymous": SimUnion({"keyingPolicy": SimTypePointer(SimStruct({"numKeyMods": SimTypeInt(signed=False, label="UInt32"), "keyModKeys": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_KEYING_POLICY1", pack=False, align=None), offset=0), "ikeQmTransportPolicy": SimTypePointer(SimStruct({"numIpsecProposals": SimTypeInt(signed=False, label="UInt32"), "ipsecProposals": SimTypePointer(SimStruct({"lifetime": SimStruct({"lifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "lifetimeKilobytes": SimTypeInt(signed=False, label="UInt32"), "lifetimePackets": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_LIFETIME0", pack=False, align=None), "numSaTransforms": SimTypeInt(signed=False, label="UInt32"), "saTransforms": SimTypePointer(SimStruct({"ipsecTransformType": SimTypeInt(signed=False, label="IPSEC_TRANSFORM_TYPE"), "Anonymous": SimUnion({"ahTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espAuthTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espCipherTransform": SimTypePointer(SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthAndCipherTransform": SimTypePointer(SimStruct({"authTransform": SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), "cipherTransform": SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None)}, name="IPSEC_AUTH_AND_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthFwTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="IPSEC_SA_TRANSFORM0", pack=False, align=None), offset=0), "pfsGroup": SimTypeInt(signed=False, label="IPSEC_PFS_GROUP")}, name="IPSEC_PROPOSAL0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="IPSEC_POLICY_FLAG"), "ndAllowClearTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "saIdleTimeout": SimStruct({"idleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "idleTimeoutSecondsFailOver": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_IDLE_TIMEOUT0", pack=False, align=None), "emPolicy": SimTypePointer(SimStruct({"numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_PRESHARED_KEY_AUTHENTICATION_FLAGS")}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION1", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS"), "proxyServer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_KERBEROS_AUTHENTICATION1", pack=False, align=None), "reservedAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_RESERVED_AUTHENTICATION_FLAGS")}, name="IKEEXT_RESERVED_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None), "eapAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_EAP_AUTHENTICATION_FLAGS")}, name="IKEEXT_EAP_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD2", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE")}, name="IKEEXT_EM_POLICY2", pack=False, align=None), offset=0)}, name="IPSEC_TRANSPORT_POLICY2", pack=False, align=None), offset=0), "ikeQmTunnelPolicy": SimTypePointer(SimStruct({"flags": SimTypeInt(signed=False, label="UInt32"), "numIpsecProposals": SimTypeInt(signed=False, label="UInt32"), "ipsecProposals": SimTypePointer(SimStruct({"lifetime": SimStruct({"lifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "lifetimeKilobytes": SimTypeInt(signed=False, label="UInt32"), "lifetimePackets": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_LIFETIME0", pack=False, align=None), "numSaTransforms": SimTypeInt(signed=False, label="UInt32"), "saTransforms": SimTypePointer(SimStruct({"ipsecTransformType": SimTypeInt(signed=False, label="IPSEC_TRANSFORM_TYPE"), "Anonymous": SimUnion({"ahTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espAuthTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espCipherTransform": SimTypePointer(SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthAndCipherTransform": SimTypePointer(SimStruct({"authTransform": SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), "cipherTransform": SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None)}, name="IPSEC_AUTH_AND_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthFwTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="IPSEC_SA_TRANSFORM0", pack=False, align=None), offset=0), "pfsGroup": SimTypeInt(signed=False, label="IPSEC_PFS_GROUP")}, name="IPSEC_PROPOSAL0", pack=False, align=None), offset=0), "tunnelEndpoints": SimStruct({"ipVersion": SimTypeInt(signed=False, label="FWP_IP_VERSION"), "Anonymous1": SimUnion({"localV4Address": SimTypeInt(signed=False, label="UInt32"), "localV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"remoteV4Address": SimTypeInt(signed=False, label="UInt32"), "remoteV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), "localIfLuid": SimTypeLongLong(signed=False, label="UInt64"), "remoteFqdn": SimTypePointer(SimTypeChar(label="Char"), offset=0), "numAddresses": SimTypeInt(signed=False, label="UInt32"), "remoteAddresses": SimTypePointer(SimStruct({"ipVersion": SimTypeInt(signed=False, label="FWP_IP_VERSION"), "Anonymous": SimUnion({"v4Address": SimTypeInt(signed=False, label="UInt32"), "v6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="IPSEC_TUNNEL_ENDPOINT0", pack=False, align=None), offset=0)}, name="IPSEC_TUNNEL_ENDPOINTS2", pack=False, align=None), "saIdleTimeout": SimStruct({"idleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "idleTimeoutSecondsFailOver": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_IDLE_TIMEOUT0", pack=False, align=None), "emPolicy": SimTypePointer(SimStruct({"numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_PRESHARED_KEY_AUTHENTICATION_FLAGS")}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION1", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "kerberosAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_KERBEROS_AUTHENTICATION_FLAGS"), "proxyServer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_KERBEROS_AUTHENTICATION1", pack=False, align=None), "reservedAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_RESERVED_AUTHENTICATION_FLAGS")}, name="IKEEXT_RESERVED_AUTHENTICATION0", pack=False, align=None), "ntlmV2Authentication": SimStruct({"flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_NTLM_V2_AUTHENTICATION0", pack=False, align=None), "sslAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"outboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "flags": SimTypeInt(signed=False, label="IKEEXT_CERT_AUTH"), "localCertLocationUrl": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None)}, name="IKEEXT_CERTIFICATE_AUTHENTICATION2", pack=False, align=None), "cgaAuthentication": SimStruct({"keyContainerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cspType": SimTypeInt(signed=False, label="UInt32"), "cgaModifier": SimStruct({"byteArray16": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="FWP_BYTE_ARRAY16", pack=False, align=None), "cgaCollisionCount": SimTypeChar(label="Byte")}, name="IKEEXT_IPV6_CGA_AUTHENTICATION0", pack=False, align=None), "eapAuthentication": SimStruct({"flags": SimTypeInt(signed=False, label="IKEEXT_EAP_AUTHENTICATION_FLAGS")}, name="IKEEXT_EAP_AUTHENTICATION0", pack=False, align=None)}, name="<anon>", label="None")}, name="IKEEXT_AUTHENTICATION_METHOD2", pack=False, align=None), offset=0), "initiatorImpersonationType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_IMPERSONATION_TYPE")}, name="IKEEXT_EM_POLICY2", pack=False, align=None), offset=0), "fwdPathSaLifetime": SimTypeInt(signed=False, label="UInt32"), "compartmentId": SimTypeInt(signed=False, label="UInt32"), "numTrafficSelectorPolicy": SimTypeInt(signed=False, label="UInt32"), "trafficSelectorPolicies": SimTypePointer(SimStruct({"flags": SimTypeInt(signed=False, label="UInt32"), "numLocalTrafficSelectors": SimTypeInt(signed=False, label="UInt32"), "localTrafficSelectors": SimTypePointer(SimStruct({"protocolId": SimTypeChar(label="Byte"), "portStart": SimTypeShort(signed=False, label="UInt16"), "portEnd": SimTypeShort(signed=False, label="UInt16"), "ipVersion": SimTypeInt(signed=False, label="FWP_IP_VERSION"), "Anonymous1": SimUnion({"startV4Address": SimTypeInt(signed=False, label="UInt32"), "startV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"endV4Address": SimTypeInt(signed=False, label="UInt32"), "endV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="IPSEC_TRAFFIC_SELECTOR0_", pack=False, align=None), offset=0), "numRemoteTrafficSelectors": SimTypeInt(signed=False, label="UInt32"), "remoteTrafficSelectors": SimTypePointer(SimStruct({"protocolId": SimTypeChar(label="Byte"), "portStart": SimTypeShort(signed=False, label="UInt16"), "portEnd": SimTypeShort(signed=False, label="UInt16"), "ipVersion": SimTypeInt(signed=False, label="FWP_IP_VERSION"), "Anonymous1": SimUnion({"startV4Address": SimTypeInt(signed=False, label="UInt32"), "startV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"endV4Address": SimTypeInt(signed=False, label="UInt32"), "endV6Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="IPSEC_TRAFFIC_SELECTOR0_", pack=False, align=None), offset=0)}, name="IPSEC_TRAFFIC_SELECTOR_POLICY0_", pack=False, align=None), offset=0)}, name="IPSEC_TUNNEL_POLICY3_", pack=False, align=None), offset=0), "authipQmTransportPolicy": SimTypePointer(SimStruct({"numIpsecProposals": SimTypeInt(signed=False, label="UInt32"), "ipsecProposals": SimTypePointer(SimStruct({"lifetime": SimStruct({"lifetimeSeconds": SimTypeInt(signed=False, label="UInt32"), "lifetimeKilobytes": SimTypeInt(signed=False, label="UInt32"), "lifetimePackets": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_LIFETIME0", pack=False, align=None), "numSaTransforms": SimTypeInt(signed=False, label="UInt32"), "saTransforms": SimTypePointer(SimStruct({"ipsecTransformType": SimTypeInt(signed=False, label="IPSEC_TRANSFORM_TYPE"), "Anonymous": SimUnion({"ahTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espAuthTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0), "espCipherTransform": SimTypePointer(SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthAndCipherTransform": SimTypePointer(SimStruct({"authTransform": SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), "cipherTransform": SimStruct({"cipherTransformId": SimStruct({"cipherType": SimTypeInt(signed=False, label="IPSEC_CIPHER_TYPE"), "cipherConfig": SimTypeChar(label="Byte")}, name="IPSEC_CIPHER_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_CIPHER_TRANSFORM0", pack=False, align=None)}, name="IPSEC_AUTH_AND_CIPHER_TRANSFORM0", pack=False, align=None), offset=0), "espAuthFwTransform": SimTypePointer(SimStruct({"authTransformId": SimStruct({"authType": SimTypeInt(signed=False, label="IPSEC_AUTH_TYPE"), "authConfig": SimTypeChar(label="Byte")}, name="IPSEC_AUTH_TRANSFORM_ID0", pack=False, align=None), "cryptoModuleId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="IPSEC_AUTH_TRANSFORM0", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="IPSEC_SA_TRANSFORM0", pack=False, align=None), offset=0), "pfsGroup": SimTypeInt(signed=False, label="IPSEC_PFS_GROUP")}, name="IPSEC_PROPOSAL0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="IPSEC_POLICY_FLAG"), "ndAllowClearTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "saIdleTimeout": SimStruct({"idleTimeoutSeconds": SimTypeInt(signed=False, label="UInt32"), "idleTimeoutSecondsFailOver": SimTypeInt(signed=False, label="UInt32")}, name="IPSEC_SA_IDLE_TIMEOUT0", pack=False, align=None), "emPolicy": SimTypePointer(SimStruct({"numAuthenticationMethods": SimTypeInt(signed=False, label="UInt32"), "authenticationMethods": SimTypePointer(SimStruct({"authenticationMethodType": SimTypeInt(signed=False, label="IKEEXT_AUTHENTICATION_METHOD_TYPE"), "Anonymous": SimUnion({"presharedKeyAuthentication": SimStruct({"presharedKey": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "flags": SimTypeInt(signed=False, label="IKEEXT_PRESHARED_KEY_AUTHENTICATION_FLAGS")}, name="IKEEXT_PRESHARED_KEY_AUTHENTICATION1", pack=False, align=None), "certificateAuthentication": SimStruct({"inboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous1": SimUnion({"Anonymous1": SimStruct({"inboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"inboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous2_e__Struct", pack=False, align=None), "Anonymous3": SimStruct({"inboundRootStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "inboundTrustedRootStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous3_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "outboundConfigType": SimTypeInt(signed=False, label="IKEEXT_CERT_CONFIG_TYPE"), "Anonymous2": SimUnion({"Anonymous1": SimStruct({"outboundRootArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundRootCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "certHash": SimStruct({"size": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="FWP_BYTE_BLOB", pack=False, align=None), "eku": SimTypePointer(SimStruct({"numEku": SimTypeInt(signed=False, label="UInt32"), "eku": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="IKEEXT_CERT_EKUS0", pack=False, align=None), offset=0), "name": SimTypePointer(SimStruct({"nameType": SimTypeInt(signed=False, label="IKEEXT_CERT_CRITERIA_NAME_TYPE"), "certName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="IKEEXT_CERT_NAME0", pack=False, align=None), offset=0), "flags": SimTypeInt(signed=False, label="UInt32")}, name="IKEEXT_CERTIFICATE_CRITERIA0", pack=False, align=None), offset=0)}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"outboundEnterpriseStoreArraySize": SimTypeInt(signed=False, label="UInt32"), "outboundEnterpriseStoreCriteria": SimTypePointer(SimStruct({"certData": SimStruct({"size": Si