/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Connection;
import redis.clients.jedis.Endpoint;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.annots.Experimental;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisValidationException;
import redis.clients.jedis.mcf.ConnectionFailoverException;
import redis.clients.jedis.mcf.HealthCheckStrategy;
import redis.clients.jedis.mcf.PingStrategy;

@Experimental
public final class MultiDbConfig {
    private static final int RETRY_MAX_ATTEMPTS_DEFAULT = 3;
    private static final int RETRY_WAIT_DURATION_DEFAULT = 500;
    private static final int RETRY_WAIT_DURATION_EXPONENTIAL_BACKOFF_MULTIPLIER_DEFAULT = 2;
    private static final List<Class> RETRY_INCLUDED_EXCEPTIONS_DEFAULT = Arrays.asList(JedisConnectionException.class);
    private static final float CIRCUIT_BREAKER_FAILURE_RATE_THRESHOLD_DEFAULT = 10.0f;
    private static final int CIRCUITBREAKER_THRESHOLD_MIN_NUM_OF_FAILURES_DEFAULT = 1000;
    private static final int CIRCUIT_BREAKER_SLIDING_WINDOW_SIZE_DEFAULT = 2;
    private static final List<Class> CIRCUIT_BREAKER_INCLUDED_EXCEPTIONS_DEFAULT = Arrays.asList(JedisConnectionException.class);
    private static final List<Class<? extends Throwable>> FALLBACK_EXCEPTIONS_DEFAULT = Arrays.asList(CallNotPermittedException.class, ConnectionFailoverException.class);
    private static final long FAILBACK_CHECK_INTERVAL_DEFAULT = 120000L;
    private static final long GRACE_PERIOD_DEFAULT = 60000L;
    private static final int MAX_NUM_FAILOVER_ATTEMPTS_DEFAULT = 10;
    private static final int DELAY_IN_BETWEEN_FAILOVER_ATTEMPTS_DEFAULT = 12000;
    private final DatabaseConfig[] databaseConfigs;
    private RetryConfig commandRetry;
    private CircuitBreakerConfig failureDetector;
    private List<Class<? extends Throwable>> fallbackExceptionList;
    private boolean retryOnFailover;
    private boolean isFailbackSupported;
    private long failbackCheckInterval;
    private long gracePeriod;
    private boolean fastFailover;
    private int maxNumFailoverAttempts;
    private int delayInBetweenFailoverAttempts;

    public MultiDbConfig(DatabaseConfig[] databaseConfigs) {
        if (databaseConfigs == null || databaseConfigs.length < 1) {
            throw new JedisValidationException("DatabaseClientConfigs are required for MultiDbConnectionProvider");
        }
        for (DatabaseConfig databaseConfig : databaseConfigs) {
            if (databaseConfig != null) continue;
            throw new IllegalArgumentException("DatabaseClientConfigs must not contain null elements");
        }
        this.databaseConfigs = databaseConfigs;
    }

    public DatabaseConfig[] getDatabaseConfigs() {
        return this.databaseConfigs;
    }

    public RetryConfig getCommandRetry() {
        return this.commandRetry;
    }

    public CircuitBreakerConfig getFailureDetector() {
        return this.failureDetector;
    }

    public List<Class<? extends Throwable>> getFallbackExceptionList() {
        return this.fallbackExceptionList;
    }

    public boolean isRetryOnFailover() {
        return this.retryOnFailover;
    }

    public boolean isFailbackSupported() {
        return this.isFailbackSupported;
    }

    public long getFailbackCheckInterval() {
        return this.failbackCheckInterval;
    }

    public long getGracePeriod() {
        return this.gracePeriod;
    }

    public int getMaxNumFailoverAttempts() {
        return this.maxNumFailoverAttempts;
    }

    public int getDelayInBetweenFailoverAttempts() {
        return this.delayInBetweenFailoverAttempts;
    }

    public boolean isFastFailover() {
        return this.fastFailover;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DatabaseConfig[] databaseConfigs) {
        return new Builder(databaseConfigs);
    }

    public static Builder builder(List<DatabaseConfig> databaseConfigs) {
        return new Builder(databaseConfigs);
    }

    static /* synthetic */ List access$500() {
        return RETRY_INCLUDED_EXCEPTIONS_DEFAULT;
    }

    static /* synthetic */ List access$1200() {
        return CIRCUIT_BREAKER_INCLUDED_EXCEPTIONS_DEFAULT;
    }

    static /* synthetic */ List access$2000() {
        return FALLBACK_EXCEPTIONS_DEFAULT;
    }

    public static class Builder {
        private final List<DatabaseConfig> databaseConfigs = new ArrayList<DatabaseConfig>();
        private RetryConfig commandRetry = RetryConfig.builder().build();
        private CircuitBreakerConfig failureDetector = CircuitBreakerConfig.builder().build();
        private List<Class<? extends Throwable>> fallbackExceptionList = MultiDbConfig.access$2000();
        private boolean retryOnFailover = false;
        private boolean isFailbackSupported = true;
        private long failbackCheckInterval = 120000L;
        private long gracePeriod = 60000L;
        private boolean fastFailover = false;
        private int maxNumFailoverAttempts = 10;
        private int delayInBetweenFailoverAttempts = 12000;

        public Builder() {
        }

        public Builder(DatabaseConfig[] databaseConfigs) {
            this(Arrays.asList(databaseConfigs));
        }

        public Builder(List<DatabaseConfig> databaseConfigs) {
            this.databaseConfigs.addAll(databaseConfigs);
        }

        public Builder database(DatabaseConfig databaseConfig) {
            this.databaseConfigs.add(databaseConfig);
            return this;
        }

        public Builder database(Endpoint endpoint, float weight, JedisClientConfig clientConfig) {
            DatabaseConfig databaseConfig = DatabaseConfig.builder(endpoint, clientConfig).weight(weight).build();
            this.databaseConfigs.add(databaseConfig);
            return this;
        }

        public Builder commandRetry(RetryConfig commandRetry) {
            this.commandRetry = commandRetry;
            return this;
        }

        public Builder failureDetector(CircuitBreakerConfig failureDetector) {
            this.failureDetector = failureDetector;
            return this;
        }

        public Builder fallbackExceptionList(List<Class<? extends Throwable>> fallbackExceptionList) {
            this.fallbackExceptionList = fallbackExceptionList;
            return this;
        }

        public Builder retryOnFailover(boolean retryOnFailover) {
            this.retryOnFailover = retryOnFailover;
            return this;
        }

        public Builder failbackSupported(boolean supported) {
            this.isFailbackSupported = supported;
            return this;
        }

        public Builder failbackCheckInterval(long failbackCheckInterval) {
            this.failbackCheckInterval = failbackCheckInterval;
            return this;
        }

        public Builder gracePeriod(long gracePeriod) {
            this.gracePeriod = gracePeriod;
            return this;
        }

        public Builder fastFailover(boolean fastFailover) {
            this.fastFailover = fastFailover;
            return this;
        }

        public Builder maxNumFailoverAttempts(int maxNumFailoverAttempts) {
            this.maxNumFailoverAttempts = maxNumFailoverAttempts;
            return this;
        }

        public Builder delayInBetweenFailoverAttempts(int delayInBetweenFailoverAttempts) {
            this.delayInBetweenFailoverAttempts = delayInBetweenFailoverAttempts;
            return this;
        }

        public MultiDbConfig build() {
            MultiDbConfig config = new MultiDbConfig(this.databaseConfigs.toArray(new DatabaseConfig[0]));
            config.commandRetry = this.commandRetry;
            config.failureDetector = this.failureDetector;
            config.fallbackExceptionList = this.fallbackExceptionList;
            config.retryOnFailover = this.retryOnFailover;
            config.isFailbackSupported = this.isFailbackSupported;
            config.failbackCheckInterval = this.failbackCheckInterval;
            config.gracePeriod = this.gracePeriod;
            config.fastFailover = this.fastFailover;
            config.maxNumFailoverAttempts = this.maxNumFailoverAttempts;
            config.delayInBetweenFailoverAttempts = this.delayInBetweenFailoverAttempts;
            return config;
        }
    }

    public static class DatabaseConfig {
        private final Endpoint endpoint;
        private final JedisClientConfig jedisClientConfig;
        private GenericObjectPoolConfig<Connection> connectionPoolConfig;
        private float weight = 1.0f;
        private StrategySupplier healthCheckStrategySupplier;

        public DatabaseConfig(Endpoint endpoint, JedisClientConfig clientConfig) {
            this.endpoint = endpoint;
            this.jedisClientConfig = clientConfig;
        }

        public DatabaseConfig(Endpoint endpoint, JedisClientConfig clientConfig, GenericObjectPoolConfig<Connection> connectionPoolConfig) {
            this.endpoint = endpoint;
            this.jedisClientConfig = clientConfig;
            this.connectionPoolConfig = connectionPoolConfig;
        }

        private DatabaseConfig(Builder builder) {
            this.endpoint = builder.endpoint;
            this.jedisClientConfig = builder.jedisClientConfig;
            this.connectionPoolConfig = builder.connectionPoolConfig;
            this.weight = builder.weight;
            this.healthCheckStrategySupplier = builder.healthCheckStrategySupplier;
        }

        public Endpoint getEndpoint() {
            return this.endpoint;
        }

        public static Builder builder(Endpoint endpoint, JedisClientConfig clientConfig) {
            return new Builder(endpoint, clientConfig);
        }

        public JedisClientConfig getJedisClientConfig() {
            return this.jedisClientConfig;
        }

        public GenericObjectPoolConfig<Connection> getConnectionPoolConfig() {
            return this.connectionPoolConfig;
        }

        public float getWeight() {
            return this.weight;
        }

        public StrategySupplier getHealthCheckStrategySupplier() {
            return this.healthCheckStrategySupplier;
        }

        public static class Builder {
            private Endpoint endpoint;
            private JedisClientConfig jedisClientConfig;
            private GenericObjectPoolConfig<Connection> connectionPoolConfig;
            private float weight = 1.0f;
            private StrategySupplier healthCheckStrategySupplier = PingStrategy.DEFAULT;

            public Builder(Endpoint endpoint, JedisClientConfig clientConfig) {
                this.endpoint = endpoint;
                this.jedisClientConfig = clientConfig;
            }

            public Builder connectionPoolConfig(GenericObjectPoolConfig<Connection> connectionPoolConfig) {
                this.connectionPoolConfig = connectionPoolConfig;
                return this;
            }

            public Builder weight(float weight) {
                this.weight = weight;
                return this;
            }

            public Builder healthCheckStrategySupplier(StrategySupplier healthCheckStrategySupplier) {
                if (healthCheckStrategySupplier == null) {
                    throw new IllegalArgumentException("healthCheckStrategySupplier must not be null");
                }
                this.healthCheckStrategySupplier = healthCheckStrategySupplier;
                return this;
            }

            public Builder healthCheckStrategy(HealthCheckStrategy healthCheckStrategy) {
                if (healthCheckStrategy == null) {
                    throw new IllegalArgumentException("healthCheckStrategy must not be null");
                }
                this.healthCheckStrategySupplier = (hostAndPort, jedisClientConfig) -> healthCheckStrategy;
                return this;
            }

            public Builder healthCheckEnabled(boolean healthCheckEnabled) {
                if (!healthCheckEnabled) {
                    this.healthCheckStrategySupplier = null;
                } else if (this.healthCheckStrategySupplier == null) {
                    this.healthCheckStrategySupplier = PingStrategy.DEFAULT;
                }
                return this;
            }

            public DatabaseConfig build() {
                return new DatabaseConfig(this);
            }
        }
    }

    public static final class CircuitBreakerConfig {
        private final float failureRateThreshold;
        private final int slidingWindowSize;
        private final int minNumOfFailures;
        private final List<Class> includedExceptionList;
        private final List<Class> ignoreExceptionList;

        private CircuitBreakerConfig(Builder builder) {
            this.failureRateThreshold = builder.failureRateThreshold;
            this.slidingWindowSize = builder.slidingWindowSize;
            this.minNumOfFailures = builder.minNumOfFailures;
            this.includedExceptionList = builder.includedExceptionList;
            this.ignoreExceptionList = builder.ignoreExceptionList;
        }

        public float getFailureRateThreshold() {
            return this.failureRateThreshold;
        }

        public int getSlidingWindowSize() {
            return this.slidingWindowSize;
        }

        public int getMinNumOfFailures() {
            return this.minNumOfFailures;
        }

        public List<Class> getIncludedExceptionList() {
            return this.includedExceptionList;
        }

        public List<Class> getIgnoreExceptionList() {
            return this.ignoreExceptionList;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private float failureRateThreshold = 10.0f;
            private int slidingWindowSize = 2;
            private int minNumOfFailures = 1000;
            private List<Class> includedExceptionList = MultiDbConfig.access$1200();
            private List<Class> ignoreExceptionList = null;

            public Builder failureRateThreshold(float failureRateThreshold) {
                this.failureRateThreshold = failureRateThreshold;
                return this;
            }

            public Builder slidingWindowSize(int slidingWindowSize) {
                this.slidingWindowSize = slidingWindowSize;
                return this;
            }

            public Builder minNumOfFailures(int minNumOfFailures) {
                this.minNumOfFailures = minNumOfFailures;
                return this;
            }

            public Builder includedExceptionList(List<Class> includedExceptionList) {
                this.includedExceptionList = includedExceptionList;
                return this;
            }

            public Builder ignoreExceptionList(List<Class> ignoreExceptionList) {
                this.ignoreExceptionList = ignoreExceptionList;
                return this;
            }

            public CircuitBreakerConfig build() {
                return new CircuitBreakerConfig(this);
            }
        }
    }

    public static final class RetryConfig {
        private final int maxAttempts;
        private final Duration waitDuration;
        private final int exponentialBackoffMultiplier;
        private final List<Class> includedExceptionList;
        private final List<Class> ignoreExceptionList;

        private RetryConfig(Builder builder) {
            this.maxAttempts = builder.maxAttempts;
            this.waitDuration = Duration.ofMillis(builder.waitDuration);
            this.exponentialBackoffMultiplier = builder.exponentialBackoffMultiplier;
            this.includedExceptionList = builder.includedExceptionList;
            this.ignoreExceptionList = builder.ignoreExceptionList;
        }

        public int getMaxAttempts() {
            return this.maxAttempts;
        }

        public Duration getWaitDuration() {
            return this.waitDuration;
        }

        public int getExponentialBackoffMultiplier() {
            return this.exponentialBackoffMultiplier;
        }

        public List<Class> getIncludedExceptionList() {
            return this.includedExceptionList;
        }

        public List<Class> getIgnoreExceptionList() {
            return this.ignoreExceptionList;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private int maxAttempts = 3;
            private int waitDuration = 500;
            private int exponentialBackoffMultiplier = 2;
            private List<Class> includedExceptionList = MultiDbConfig.access$500();
            private List<Class> ignoreExceptionList = null;

            public Builder maxAttempts(int maxAttempts) {
                this.maxAttempts = maxAttempts;
                return this;
            }

            public Builder waitDuration(int waitDuration) {
                this.waitDuration = waitDuration;
                return this;
            }

            public Builder exponentialBackoffMultiplier(int exponentialBackoffMultiplier) {
                this.exponentialBackoffMultiplier = exponentialBackoffMultiplier;
                return this;
            }

            public Builder includedExceptionList(List<Class> includedExceptionList) {
                this.includedExceptionList = includedExceptionList;
                return this;
            }

            public Builder ignoreExceptionList(List<Class> ignoreExceptionList) {
                this.ignoreExceptionList = ignoreExceptionList;
                return this;
            }

            public RetryConfig build() {
                return new RetryConfig(this);
            }
        }
    }

    public static interface StrategySupplier {
        public HealthCheckStrategy get(HostAndPort var1, JedisClientConfig var2);
    }
}

