/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.IOException;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.Symbol;

public final class SynonymStream
extends Stream {
    final Symbol symbol;
    private static final Primitive MAKE_SYNONYM_STREAM = new pf_make_synonym_string();
    public static final Primitive SYNONYM_STREAM_SYMBOL = new pf_synonym_stream_symbol();

    SynonymStream(Symbol symbol) {
        super(Symbol.SYNONYM_STREAM);
        this.symbol = symbol;
    }

    @Override
    public boolean isInputStream() {
        return Lisp.checkStream(this.symbol.symbolValue()).isInputStream();
    }

    @Override
    public boolean isOutputStream() {
        return Lisp.checkStream(this.symbol.symbolValue()).isOutputStream();
    }

    @Override
    public boolean isCharacterInputStream() {
        return Lisp.checkStream(this.symbol.symbolValue()).isCharacterInputStream();
    }

    @Override
    public boolean isBinaryInputStream() {
        return Lisp.checkStream(this.symbol.symbolValue()).isBinaryInputStream();
    }

    @Override
    public boolean isCharacterOutputStream() {
        return Lisp.checkStream(this.symbol.symbolValue()).isCharacterOutputStream();
    }

    @Override
    public boolean isBinaryOutputStream() {
        return Lisp.checkStream(this.symbol.symbolValue()).isBinaryOutputStream();
    }

    @Override
    public LispObject typeOf() {
        return Symbol.SYNONYM_STREAM;
    }

    @Override
    public LispObject classOf() {
        return BuiltInClass.SYNONYM_STREAM;
    }

    @Override
    public LispObject typep(LispObject typeSpecifier) {
        if (typeSpecifier == Symbol.SYNONYM_STREAM) {
            return Lisp.T;
        }
        if (typeSpecifier == BuiltInClass.SYNONYM_STREAM) {
            return Lisp.T;
        }
        return super.typep(typeSpecifier);
    }

    @Override
    public LispObject getElementType() {
        return Lisp.checkStream(this.symbol.symbolValue()).getElementType();
    }

    @Override
    public LispObject listen() {
        return Lisp.checkStream(this.symbol.symbolValue()).listen();
    }

    @Override
    public LispObject fileLength() {
        return Lisp.checkStream(this.symbol.symbolValue()).fileLength();
    }

    @Override
    public LispObject fileStringLength(LispObject arg) {
        return Lisp.checkStream(this.symbol.symbolValue()).fileStringLength(arg);
    }

    @Override
    protected int _readChar() throws IOException {
        return Lisp.checkStream(this.symbol.symbolValue())._readChar();
    }

    @Override
    protected void _unreadChar(int n) throws IOException {
        Lisp.checkStream(this.symbol.symbolValue())._unreadChar(n);
    }

    @Override
    protected boolean _charReady() throws IOException {
        return Lisp.checkStream(this.symbol.symbolValue())._charReady();
    }

    @Override
    public void _writeChar(char c) {
        Lisp.checkStream(this.symbol.symbolValue())._writeChar(c);
    }

    @Override
    public void _writeChars(char[] chars, int start, int end) {
        Lisp.checkStream(this.symbol.symbolValue())._writeChars(chars, start, end);
    }

    @Override
    public void _writeString(String s) {
        Lisp.checkStream(this.symbol.symbolValue())._writeString(s);
    }

    @Override
    public void _writeLine(String s) {
        Lisp.checkStream(this.symbol.symbolValue())._writeLine(s);
    }

    @Override
    public int _readByte() {
        return Lisp.checkStream(this.symbol.symbolValue())._readByte();
    }

    @Override
    public void _writeByte(int n) {
        Lisp.checkStream(this.symbol.symbolValue())._writeByte(n);
    }

    @Override
    public void _finishOutput() {
        Lisp.checkStream(this.symbol.symbolValue())._finishOutput();
    }

    @Override
    public void _clearInput() {
        Lisp.checkStream(this.symbol.symbolValue())._clearInput();
    }

    @Override
    protected long _getFilePosition() {
        return Lisp.checkStream(this.symbol.symbolValue())._getFilePosition();
    }

    @Override
    protected boolean _setFilePosition(LispObject arg) {
        return Lisp.checkStream(this.symbol.symbolValue())._setFilePosition(arg);
    }

    @Override
    public void _close() {
        Lisp.checkStream(this.symbol.symbolValue())._close();
    }

    @Override
    public String printObject() {
        StringBuffer sb = new StringBuffer("SYNONYM-STREAM ");
        sb.append(this.symbol.printObject());
        return this.unreadableString(sb.toString());
    }

    private static final class pf_synonym_stream_symbol
    extends Primitive {
        pf_synonym_stream_symbol() {
            super("synonym-stream-symbol", Lisp.PACKAGE_CL, true, "synonym-stream");
        }

        @Override
        public LispObject execute(LispObject arg) {
            if (arg instanceof SynonymStream) {
                return ((SynonymStream)arg).symbol;
            }
            return Lisp.type_error(arg, Symbol.SYNONYM_STREAM);
        }
    }

    private static final class pf_make_synonym_string
    extends Primitive {
        pf_make_synonym_string() {
            super("make-synonym-stream", Lisp.PACKAGE_CL, true, "symbol");
        }

        @Override
        public LispObject execute(LispObject arg) {
            return new SynonymStream(Lisp.checkSymbol(arg));
        }
    }
}

