/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.util;

import ca.sqlpower.security.EmailNotification;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class Email {
    private String smtpHost;
    private List<EmailNotification.EmailRecipient> recipients = new ArrayList<EmailNotification.EmailRecipient>();
    private String fromName;
    private String fromEmail;
    private String emailSubject;
    private String emailBody = "";

    public Email(String smtpHost) {
        this.smtpHost = smtpHost;
    }

    public void sendMessage() throws MessagingException {
        Properties props = new Properties();
        props.put("mail.smtp.host", this.smtpHost);
        Session mailSession = Session.getInstance((Properties)props, null);
        MimeMessage message = new MimeMessage(mailSession);
        try {
            message.setFrom((Address)new InternetAddress(this.fromEmail, this.fromName));
            for (EmailNotification.EmailRecipient er : this.recipients) {
                message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(er.getEmail(), er.getName()));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
        message.setSubject(this.emailSubject);
        message.setText(this.emailBody);
        Transport.send((Message)message);
    }

    public String getEmailBody() {
        return this.emailBody;
    }

    public void setEmailBody(String emailBody) {
        this.emailBody = emailBody == null ? "" : emailBody;
    }

    public void appendToEmailBody(String emailBody) {
        StringBuilder body = new StringBuilder(this.emailBody);
        body.append(emailBody);
        this.emailBody = body.toString();
    }

    public String getEmailSubject() {
        return this.emailSubject;
    }

    public void setEmailSubject(String emailSubject) {
        this.emailSubject = emailSubject == null ? "" : emailSubject;
    }

    public String getFromEmail() {
        return this.fromEmail;
    }

    public void setFromEmail(String fromEmail) {
        this.fromEmail = fromEmail;
    }

    public String getFromName() {
        return this.fromName;
    }

    public void setFromName(String fromName) {
        this.fromName = fromName;
    }

    public String getRecipients() {
        StringBuilder result = new StringBuilder();
        for (EmailNotification.EmailRecipient er : this.recipients) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(er);
        }
        return result.toString();
    }

    public void addRecipient(EmailNotification.EmailRecipient er) {
        if (er != null && !this.recipients.contains(er)) {
            this.recipients.add(er);
        }
    }

    public void setRecipients(List<EmailNotification.EmailRecipient> recipients) {
        if (recipients == null) {
            this.recipients.clear();
        } else {
            this.recipients = recipients;
        }
    }

    public void addRecipients(List<EmailNotification.EmailRecipient> recipients) {
        if (recipients != null) {
            for (EmailNotification.EmailRecipient er : recipients) {
                this.addRecipient(er);
            }
        }
    }

    public void removeRecipient(EmailNotification.EmailRecipient er) {
        if (er != null) {
            this.recipients.remove(er);
        }
    }

    public String toString() {
        return "From: <" + this.getFromName() + "> " + this.getFromEmail() + "\r\n" + "To: " + this.getRecipients() + "\r\n" + "Subject: " + this.getEmailSubject() + "\r\n" + "\r\n" + this.getEmailBody() + "\r\n";
    }
}

