/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.plaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolTipUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.common.util.ImageUtils;

public class FreeColToolTipUI
extends BasicToolTipUI {
    private static final FreeColToolTipUI sharedInstance = new FreeColToolTipUI();
    private static final FontRenderContext frc = new FontRenderContext(null, true, false);
    private static final int margin = 5;
    private static int maximumWidth = 300;
    private static int fontSize = 11;
    private static final int LEADING = 5;
    private static final Pattern lineBreak = Pattern.compile("\n");

    private FreeColToolTipUI() {
    }

    public static ComponentUI createUI(JComponent c) {
        return sharedInstance;
    }

    public static void setFontScaling(float fontScaleFactor) {
        maximumWidth = (int)(300.0f * fontScaleFactor);
        fontSize = (int)(11.0f * fontScaleFactor);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            ImageUtils.drawTiledImage(ImageLibrary.getToolTipBackground(), g, c, null);
        }
        g.setColor(Color.BLACK);
        Graphics2D graphics = (Graphics2D)g;
        float x = 5.0f;
        float y = 5.0f;
        for (String line : lineBreak.split(((JToolTip)c).getTipText())) {
            if (line.isEmpty()) {
                y += 5.0f;
                continue;
            }
            AttributedString attributedString = new AttributedString(line);
            attributedString.addAttribute(TextAttribute.SIZE, fontSize);
            AttributedCharacterIterator styledText = attributedString.getIterator();
            LineBreakMeasurer measurer = new LineBreakMeasurer(styledText, frc);
            while (measurer.getPosition() < styledText.getEndIndex()) {
                TextLayout layout = measurer.nextLayout(maximumWidth);
                float dx = layout.isLeftToRight() ? 0.0f : (float)maximumWidth - layout.getAdvance();
                layout.draw(graphics, x + dx, y += layout.getAscent());
                y += layout.getDescent() + layout.getLeading();
            }
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        String tipText = ((JToolTip)c).getTipText();
        if (tipText == null || tipText.isEmpty()) {
            return new Dimension(0, 0);
        }
        float x = 0.0f;
        float y = 0.0f;
        for (String line : lineBreak.split(tipText)) {
            if (line.isEmpty()) {
                y += 5.0f;
                continue;
            }
            AttributedString attributedString = new AttributedString(line);
            attributedString.addAttribute(TextAttribute.SIZE, fontSize);
            AttributedCharacterIterator styledText = attributedString.getIterator();
            LineBreakMeasurer measurer = new LineBreakMeasurer(styledText, frc);
            while (measurer.getPosition() < styledText.getEndIndex()) {
                TextLayout layout = measurer.nextLayout(maximumWidth);
                x = Math.max(x, layout.getVisibleAdvance());
                y += layout.getAscent() + layout.getDescent() + layout.getLeading();
            }
        }
        return new Dimension((int)(x + 10.0f), (int)(y + 10.0f));
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }
}

