/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.TradeItem;
import net.sf.freecol.common.util.Utils;

public class ColonyTradeItem
extends TradeItem {
    public static final String TAG = "colonyTradeItem";
    private String colonyId;
    private String colonyName;
    private static final String COLONY_TAG = "colony";
    private static final String COLONY_NAME_TAG = "colonyName";

    public ColonyTradeItem(Game game, Player source, Player destination, Colony colony) {
        super(game, Messages.nameKey("model.tradeItem.colony"), source, destination);
        this.colonyId = colony.getId();
        this.colonyName = colony.getName();
        if (colony.getOwner() != source) {
            throw new IllegalArgumentException("Bad source for colony " + colony.getId());
        }
        if (destination == null || !destination.isEuropean()) {
            throw new IllegalArgumentException("Bad destination: " + destination);
        }
    }

    public ColonyTradeItem(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(game, xr);
    }

    protected String getColonyId() {
        return this.colonyId;
    }

    protected String getColonyName() {
        return this.colonyName;
    }

    @Override
    public boolean isValid() {
        return this.colonyId != null;
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public StringTemplate getLabel() {
        return StringTemplate.template(Messages.descriptionKey("model.tradeItem.colony")).addName("%colony%", this.colonyName);
    }

    @Override
    public Colony getColony(Game game) {
        return game.getFreeColGameObject(this.colonyId, Colony.class);
    }

    @Override
    public int evaluateFor(Player player) {
        Colony colony = this.getColony(player.getGame());
        if (colony == null || this.getSource() == player != player.owns(colony)) {
            return Integer.MIN_VALUE;
        }
        int value = colony.evaluateFor(player);
        if (value == Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return player.owns(colony) ? -value : value;
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        ColonyTradeItem o = this.copyInCast(other, ColonyTradeItem.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.colonyId = o.getColonyId();
        this.colonyName = o.getColonyName();
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(COLONY_TAG, this.colonyId);
        xw.writeAttribute(COLONY_NAME_TAG, this.colonyName);
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.colonyId = xr.getAttribute(COLONY_TAG, null);
        this.colonyName = xr.getAttribute(COLONY_NAME_TAG, null);
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ColonyTradeItem)) {
            return false;
        }
        ColonyTradeItem other = (ColonyTradeItem)o;
        return Utils.equals(this.colonyId, other.colonyId) && Utils.equals(this.colonyName, other.colonyName) && super.equals(other);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 37 * hash + Utils.hashCode(this.colonyId);
        return 37 * hash + Utils.hashCode(this.colonyName);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(16);
        sb.append('[').append(this.getId()).append(' ').append(this.colonyName).append(']');
        return sb.toString();
    }
}

