/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.CommonLogger;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.stack.HandshakeCompletedListenerImpl;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.TLSMessageChannel;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocket;

public class IOHandler {
    private static StackLogger logger = CommonLogger.getLogger(IOHandler.class);
    private SipStackImpl sipStack;
    private static final String TCP = "tcp";
    private static final String TLS = "tls";
    private final ConcurrentHashMap<String, Socket> socketTable = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Semaphore> socketCreationMap = new ConcurrentHashMap();

    protected static String makeKey(InetAddress addr, int port2) {
        return addr.getHostAddress() + ":" + port2;
    }

    protected static String makeKey(String addr, int port2) {
        return addr + ":" + port2;
    }

    protected IOHandler(SIPTransactionStack sipStack) {
        this.sipStack = (SipStackImpl)sipStack;
    }

    protected void putSocket(String key, Socket sock) {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("adding socket for key " + key);
        }
        this.socketTable.put(key, sock);
    }

    protected Socket getSocket(String key) {
        return this.socketTable.get(key);
    }

    protected void removeSocket(String key) {
        this.socketTable.remove(key);
        Semaphore s2 = this.socketCreationMap.remove(key);
        if (s2 != null) {
            s2.release();
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("removed Socket and Semaphore for key " + key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeChunks(OutputStream outputStream, byte[] bytes, int length) throws IOException {
        OutputStream outputStream2 = outputStream;
        synchronized (outputStream2) {
            int chunksize = 8192;
            for (int p = 0; p < length; p += chunksize) {
                int chunk = p + chunksize < length ? chunksize : length - p;
                outputStream.write(bytes, p, chunk);
            }
        }
        outputStream.flush();
    }

    public SocketAddress getLocalAddressForTcpDst(InetAddress dst, int dstPort, InetAddress localAddress, int localPort) throws IOException {
        String key = IOHandler.makeKey(dst, dstPort);
        Socket clientSock = this.getSocket(key);
        if (clientSock == null) {
            clientSock = this.sipStack.getNetworkLayer().createSocket(dst, dstPort, localAddress, localPort);
            this.putSocket(key, clientSock);
        }
        return clientSock.getLocalSocketAddress();
    }

    public SocketAddress getLocalAddressForTlsDst(InetAddress dst, int dstPort, InetAddress localAddress, TLSMessageChannel channel) throws IOException {
        String key = IOHandler.makeKey(dst, dstPort);
        Socket clientSock = this.getSocket(key);
        if (clientSock == null) {
            clientSock = this.sipStack.getNetworkLayer().createSSLSocket(dst, dstPort, localAddress);
            SSLSocket sslsock = (SSLSocket)clientSock;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("inaddr = " + dst);
                logger.logDebug("port = " + dstPort);
            }
            HandshakeCompletedListenerImpl listner = new HandshakeCompletedListenerImpl(channel, sslsock);
            channel.setHandshakeCompletedListener(listner);
            sslsock.addHandshakeCompletedListener(listner);
            sslsock.setEnabledProtocols(this.sipStack.getEnabledProtocols());
            sslsock.setEnabledCipherSuites(this.sipStack.getEnabledCipherSuites());
            listner.startHandshakeWatchdog();
            sslsock.startHandshake();
            channel.setHandshakeCompleted(true);
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Handshake passed");
            }
            try {
                this.sipStack.getTlsSecurityPolicy().enforceTlsPolicy(channel.getEncapsulatedClientTransaction());
            }
            catch (SecurityException ex) {
                throw new IOException(ex.getMessage());
            }
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("TLS Security policy passed");
            }
            this.putSocket(key, clientSock);
        }
        return clientSock.getLocalSocketAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket sendBytes(InetAddress senderAddress, InetAddress receiverAddress, int contactPort, String transport, byte[] bytes, boolean isClient, MessageChannel messageChannel) throws IOException {
        int retry_count = 0;
        int max_retry = isClient ? 2 : 1;
        int length = bytes.length;
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("sendBytes " + transport + " local inAddr " + senderAddress.getHostAddress() + " remote inAddr " + receiverAddress.getHostAddress() + " port = " + contactPort + " length = " + length + " isClient " + isClient);
        }
        if (logger.isLoggingEnabled(16) && this.sipStack.isLogStackTraceOnMessageSend()) {
            logger.logStackTrace(16);
        }
        if (transport.compareToIgnoreCase(TCP) == 0) {
            String key = IOHandler.makeKey(receiverAddress, contactPort);
            Socket clientSock = null;
            this.enterIOCriticalSection(key);
            try {
                clientSock = this.getSocket(key);
                while (retry_count < max_retry) {
                    if (clientSock == null) {
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("inaddr = " + receiverAddress);
                            logger.logDebug("port = " + contactPort);
                        }
                        try {
                            clientSock = this.sipStack.getNetworkLayer().createSocket(receiverAddress, contactPort, senderAddress);
                        }
                        catch (SocketException e) {
                            logger.logError("Problem connecting " + receiverAddress + " " + contactPort + " " + senderAddress + " for message " + new String(bytes, "UTF-8"));
                            this.removeSocket(key);
                            throw new SocketException(e.getClass() + " " + e.getMessage() + " " + e.getCause() + " Problem connecting " + receiverAddress + " " + contactPort + " " + senderAddress + " for message " + new String(bytes, "UTF-8"));
                        }
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("local inaddr = " + clientSock.getLocalAddress().getHostAddress());
                        }
                        OutputStream outputStream = clientSock.getOutputStream();
                        this.writeChunks(outputStream, bytes, length);
                        this.putSocket(key, clientSock);
                        break;
                    }
                    try {
                        OutputStream outputStream = clientSock.getOutputStream();
                        this.writeChunks(outputStream, bytes, length);
                        break;
                    }
                    catch (IOException ex) {
                        if (logger.isLoggingEnabled(8)) {
                            logger.logWarning("IOException occured retryCount " + retry_count);
                        }
                        try {
                            clientSock.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        clientSock = null;
                        ++retry_count;
                        if (!isClient) {
                            this.removeSocket(key);
                            throw ex;
                        }
                        if (retry_count >= max_retry) {
                            this.removeSocket(key);
                            continue;
                        }
                        this.socketTable.remove(key);
                    }
                }
            }
            catch (IOException ex) {
                if (logger.isLoggingEnabled(4)) {
                    logger.logError("Problem sending: sendBytes " + transport + " inAddr " + receiverAddress.getHostAddress() + " port = " + contactPort + " remoteHost " + messageChannel.getPeerAddress() + " remotePort " + messageChannel.getPeerPort() + " peerPacketPort " + messageChannel.getPeerPacketSourcePort() + " isClient " + isClient);
                }
                this.removeSocket(key);
            }
            finally {
                this.leaveIOCriticalSection(key);
            }
            if (clientSock == null) {
                if (logger.isLoggingEnabled(4)) {
                    logger.logError(this.socketTable.toString());
                    logger.logError("Could not connect to " + receiverAddress + ":" + contactPort);
                }
                throw new IOException("Could not connect to " + receiverAddress + ":" + contactPort);
            }
            return clientSock;
        }
        if (transport.compareToIgnoreCase(TLS) == 0) {
            String key = IOHandler.makeKey(receiverAddress, contactPort);
            Socket clientSock = null;
            this.enterIOCriticalSection(key);
            try {
                clientSock = this.getSocket(key);
                while (retry_count < max_retry) {
                    if (clientSock == null) {
                        clientSock = this.sipStack.getNetworkLayer().createSSLSocket(receiverAddress, contactPort, senderAddress);
                        SSLSocket sslsock = (SSLSocket)clientSock;
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("inaddr = " + receiverAddress);
                            logger.logDebug("port = " + contactPort);
                        }
                        HandshakeCompletedListenerImpl listner = new HandshakeCompletedListenerImpl((TLSMessageChannel)messageChannel, clientSock);
                        ((TLSMessageChannel)messageChannel).setHandshakeCompletedListener(listner);
                        sslsock.addHandshakeCompletedListener(listner);
                        sslsock.setEnabledProtocols(this.sipStack.getEnabledProtocols());
                        listner.startHandshakeWatchdog();
                        sslsock.startHandshake();
                        ((TLSMessageChannel)messageChannel).setHandshakeCompleted(true);
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("Handshake passed");
                        }
                        try {
                            this.sipStack.getTlsSecurityPolicy().enforceTlsPolicy(messageChannel.getEncapsulatedClientTransaction());
                        }
                        catch (SecurityException ex) {
                            throw new IOException(ex.getMessage());
                        }
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("TLS Security policy passed");
                        }
                        OutputStream outputStream = clientSock.getOutputStream();
                        this.writeChunks(outputStream, bytes, length);
                        this.putSocket(key, clientSock);
                        break;
                    }
                    try {
                        OutputStream outputStream = clientSock.getOutputStream();
                        this.writeChunks(outputStream, bytes, length);
                        break;
                    }
                    catch (IOException ex) {
                        if (logger.isLoggingEnabled()) {
                            logger.logException(ex);
                        }
                        this.removeSocket(key);
                        try {
                            logger.logDebug("Closing socket");
                            clientSock.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        clientSock = null;
                        ++retry_count;
                    }
                }
            }
            catch (SSLHandshakeException ex) {
                this.removeSocket(key);
                throw ex;
            }
            catch (IOException ex) {
                this.removeSocket(key);
            }
            finally {
                this.leaveIOCriticalSection(key);
            }
            if (clientSock == null) {
                throw new IOException("Could not connect to " + receiverAddress + ":" + contactPort);
            }
            return clientSock;
        }
        DatagramSocket datagramSock = this.sipStack.getNetworkLayer().createDatagramSocket();
        datagramSock.connect(receiverAddress, contactPort);
        DatagramPacket dgPacket = new DatagramPacket(bytes, 0, length, receiverAddress, contactPort);
        datagramSock.send(dgPacket);
        datagramSock.close();
        return null;
    }

    private void leaveIOCriticalSection(String key) {
        Semaphore creationSemaphore = this.socketCreationMap.get(key);
        if (creationSemaphore != null) {
            creationSemaphore.release();
        }
    }

    private void enterIOCriticalSection(String key) throws IOException {
        Semaphore newCreationSemaphore;
        Semaphore creationSemaphore = this.socketCreationMap.get(key);
        if (creationSemaphore == null && (creationSemaphore = this.socketCreationMap.putIfAbsent(key, newCreationSemaphore = new Semaphore(1, true))) == null) {
            creationSemaphore = newCreationSemaphore;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("new Semaphore added for key " + key);
            }
        }
        try {
            boolean retval = creationSemaphore.tryAcquire(10L, TimeUnit.SECONDS);
            if (!retval) {
                throw new IOException("Could not acquire IO Semaphore'" + key + "' after 10 seconds -- giving up ");
            }
        }
        catch (InterruptedException e) {
            throw new IOException("exception in acquiring sem");
        }
    }

    public void closeAll() {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Closing " + this.socketTable.size() + " sockets from IOHandler");
        }
        Enumeration<Socket> values2 = this.socketTable.elements();
        while (values2.hasMoreElements()) {
            Socket s2 = values2.nextElement();
            try {
                s2.close();
            }
            catch (IOException iOException) {}
        }
    }
}

