/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.transform.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.srtp.AbstractSrtpTransformer;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.transform.node.MultipleOutputTransformerNode;
import org.jitsi.srtp.SrtpErrorStatus;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00102\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00102\u0006\u0010\u0018\u001a\u00020\u000eH\u0014J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020 H\u0016R \u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jitsi/nlj/transform/node/SrtpTransformerNode;", "Lorg/jitsi/nlj/transform/node/MultipleOutputTransformerNode;", "name", "", "<init>", "(Ljava/lang/String;)V", "transformer", "Lorg/jitsi/nlj/srtp/AbstractSrtpTransformer;", "getTransformer", "()Lorg/jitsi/nlj/srtp/AbstractSrtpTransformer;", "setTransformer", "(Lorg/jitsi/nlj/srtp/AbstractSrtpTransformer;)V", "cachedPackets", "", "Lorg/jitsi/nlj/PacketInfo;", "transformList", "", "packetInfos", "firstPacketReceivedTimestamp", "", "firstPacketForwardedTimestamp", "numCachedPackets", "", "transform", "packetInfo", "numSrtpProcessed", "numSrtpFail", "numSrtpAuthFail", "numSrtpReplayFail", "numSrtpReplayOld", "numSrtpInvalidPacket", "countErrorStatus", "", "err", "Lorg/jitsi/srtp/SrtpErrorStatus;", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "stop", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nSrtpTransformerNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SrtpTransformerNode.kt\norg/jitsi/nlj/transform/node/SrtpTransformerNode\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,166:1\n1863#2,2:167\n1863#2,2:169\n*S KotlinDebug\n*F\n+ 1 SrtpTransformerNode.kt\norg/jitsi/nlj/transform/node/SrtpTransformerNode\n*L\n47#1:167,2\n145#1:169,2\n*E\n"})
public abstract class SrtpTransformerNode
extends MultipleOutputTransformerNode {
    @Nullable
    private AbstractSrtpTransformer<?> transformer;
    @NotNull
    private List<PacketInfo> cachedPackets;
    private long firstPacketReceivedTimestamp;
    private long firstPacketForwardedTimestamp;
    private int numCachedPackets;
    private int numSrtpProcessed;
    private int numSrtpFail;
    private int numSrtpAuthFail;
    private int numSrtpReplayFail;
    private int numSrtpReplayOld;
    private int numSrtpInvalidPacket;

    public SrtpTransformerNode(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        super(name);
        this.cachedPackets = new ArrayList();
        this.firstPacketReceivedTimestamp = -1L;
        this.firstPacketForwardedTimestamp = -1L;
    }

    @Nullable
    public final AbstractSrtpTransformer<?> getTransformer() {
        return this.transformer;
    }

    public final void setTransformer(@Nullable AbstractSrtpTransformer<?> abstractSrtpTransformer) {
        this.transformer = abstractSrtpTransformer;
    }

    private final List<PacketInfo> transformList(List<? extends PacketInfo> packetInfos, AbstractSrtpTransformer<?> transformer) {
        List transformedPackets = new ArrayList();
        Iterable $this$forEach$iv = packetInfos;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PacketInfo packetInfo = (PacketInfo)element$iv;
            boolean bl = false;
            SrtpErrorStatus err = transformer.transform(packetInfo);
            if (err == SrtpErrorStatus.OK) {
                transformedPackets.add(packetInfo);
            } else {
                this.packetDiscarded(packetInfo);
            }
            this.countErrorStatus(err);
        }
        return transformedPackets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected List<PacketInfo> transform(@NotNull PacketInfo packetInfo) {
        AbstractSrtpTransformer<?> abstractSrtpTransformer;
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        if (this.firstPacketReceivedTimestamp == -1L) {
            this.firstPacketReceivedTimestamp = System.currentTimeMillis();
        }
        if ((abstractSrtpTransformer = this.transformer) != null) {
            AbstractSrtpTransformer<?> transformer = abstractSrtpTransformer;
            boolean bl = false;
            if (this.firstPacketForwardedTimestamp == -1L) {
                this.firstPacketForwardedTimestamp = System.currentTimeMillis();
            }
            List<PacketInfo> outPackets = null;
            List<PacketInfo> list = this.cachedPackets;
            synchronized (list) {
                boolean $i$a$-synchronized-SrtpTransformerNode$transform$1$22 = false;
                if (!((Collection)this.cachedPackets).isEmpty()) {
                    this.cachedPackets.add(packetInfo);
                    outPackets = this.transformList(this.cachedPackets, transformer);
                    this.cachedPackets.clear();
                } else {
                    List<PacketInfo> list2;
                    SrtpErrorStatus err = transformer.transform(packetInfo);
                    this.countErrorStatus(err);
                    if (err == SrtpErrorStatus.OK) {
                        list2 = CollectionsKt.listOf(packetInfo);
                    } else {
                        this.packetDiscarded(packetInfo);
                        list2 = CollectionsKt.emptyList();
                    }
                    outPackets = list2;
                }
                Unit $i$a$-synchronized-SrtpTransformerNode$transform$1$22 = Unit.INSTANCE;
            }
            return outPackets;
        }
        SrtpTransformerNode $this$transform_u24lambda_u244 = this;
        boolean bl = false;
        int n = $this$transform_u24lambda_u244.numCachedPackets;
        $this$transform_u24lambda_u244.numCachedPackets = n + 1;
        List<PacketInfo> list = $this$transform_u24lambda_u244.cachedPackets;
        synchronized (list) {
            boolean bl2 = false;
            $this$transform_u24lambda_u244.cachedPackets.add(packetInfo);
            while ($this$transform_u24lambda_u244.cachedPackets.size() > 1024) {
                $this$transform_u24lambda_u244.packetDiscarded($this$transform_u24lambda_u244.cachedPackets.remove(0));
            }
            Unit unit = Unit.INSTANCE;
        }
        return CollectionsKt.emptyList();
    }

    private final void countErrorStatus(SrtpErrorStatus err) {
        switch (WhenMappings.$EnumSwitchMapping$0[err.ordinal()]) {
            case 1: {
                int n = this.numSrtpProcessed;
                this.numSrtpProcessed = n + 1;
                break;
            }
            case 2: {
                int n = this.numSrtpFail;
                this.numSrtpFail = n + 1;
                break;
            }
            case 3: {
                int n = this.numSrtpAuthFail;
                this.numSrtpAuthFail = n + 1;
                break;
            }
            case 4: {
                int n = this.numSrtpReplayFail;
                this.numSrtpReplayFail = n + 1;
                break;
            }
            case 5: {
                int n = this.numSrtpReplayOld;
                this.numSrtpReplayOld = n + 1;
                break;
            }
            case 6: {
                int n = this.numSrtpInvalidPacket;
                this.numSrtpInvalidPacket = n + 1;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Override
    @NotNull
    public NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u245 = nodeStatsBlock = super.getNodeStats();
        boolean bl = false;
        $this$getNodeStats_u24lambda_u245.addNumber("num_cached_packets", this.numCachedPackets);
        if (this.firstPacketReceivedTimestamp != -1L && this.firstPacketForwardedTimestamp != -1L) {
            long timeBetweenReceivedAndForwarded = this.firstPacketForwardedTimestamp - this.firstPacketReceivedTimestamp;
            $this$getNodeStats_u24lambda_u245.addNumber("time_initial_hold_ms", timeBetweenReceivedAndForwarded);
        } else {
            $this$getNodeStats_u24lambda_u245.addString("state", "hold_for_transformer");
        }
        $this$getNodeStats_u24lambda_u245.addNumber("num_srtp_processed", this.numSrtpProcessed);
        $this$getNodeStats_u24lambda_u245.addNumber("num_srtp_fail", this.numSrtpFail);
        $this$getNodeStats_u24lambda_u245.addNumber("num_srtp_auth_fail", this.numSrtpAuthFail);
        $this$getNodeStats_u24lambda_u245.addNumber("num_srtp_replay_fail", this.numSrtpReplayFail);
        $this$getNodeStats_u24lambda_u245.addNumber("num_srtp_replay_old", this.numSrtpReplayOld);
        $this$getNodeStats_u24lambda_u245.addNumber("num_srtp_invalid_packet", this.numSrtpInvalidPacket);
        return nodeStatsBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        super.stop();
        List<PacketInfo> list = this.cachedPackets;
        synchronized (list) {
            boolean bl = false;
            Iterable $this$forEach$iv = this.cachedPackets;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PacketInfo it = (PacketInfo)element$iv;
                boolean bl2 = false;
                this.packetDiscarded(it);
            }
            this.cachedPackets.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SrtpErrorStatus.values().length];
            try {
                nArray[SrtpErrorStatus.OK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SrtpErrorStatus.FAIL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SrtpErrorStatus.AUTH_FAIL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SrtpErrorStatus.REPLAY_FAIL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SrtpErrorStatus.REPLAY_OLD.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SrtpErrorStatus.INVALID_PACKET.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

