/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util.dns.javax;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.initializer.SmackInitializer;
import org.jivesoftware.smack.util.DNSUtil;
import org.jivesoftware.smack.util.dns.DNSResolver;
import org.jivesoftware.smack.util.rce.RemoteConnectionEndpointLookupFailure;
import org.minidns.dnsname.DnsName;
import org.minidns.record.SRV;

public class JavaxResolver
extends DNSResolver
implements SmackInitializer {
    private static JavaxResolver instance;
    private static DirContext dirContext;

    public static synchronized DNSResolver getInstance() {
        if (instance == null && JavaxResolver.isSupported()) {
            instance = new JavaxResolver();
        }
        return instance;
    }

    public static boolean isSupported() {
        return dirContext != null;
    }

    public static void setup() {
        DNSUtil.setDNSResolver(JavaxResolver.getInstance());
    }

    public JavaxResolver() {
        super(false);
    }

    protected List<SRV> lookupSrvRecords0(DnsName name, List<RemoteConnectionEndpointLookupFailure> lookupFailures, ConnectionConfiguration.DnssecMode dnssecMode) {
        Attribute srvAttribute;
        try {
            Attributes dnsLookup = dirContext.getAttributes(name.ace, new String[]{"SRV"});
            srvAttribute = dnsLookup.get("SRV");
            if (srvAttribute == null) {
                return null;
            }
        }
        catch (NameNotFoundException e) {
            LOGGER.log(Level.FINEST, "No DNS SRV RR found for " + name, e);
            return null;
        }
        catch (NamingException e) {
            RemoteConnectionEndpointLookupFailure.DnsLookupFailure failure = new RemoteConnectionEndpointLookupFailure.DnsLookupFailure(name, (Exception)e);
            lookupFailures.add(failure);
            return null;
        }
        ArrayList<SRV> res = new ArrayList<SRV>();
        try {
            NamingEnumeration<?> srvRecords = srvAttribute.getAll();
            while (srvRecords.hasMore()) {
                String srvRecordString = (String)srvRecords.next();
                String[] srvRecordEntries = srvRecordString.split(" ");
                int priority = Integer.parseInt(srvRecordEntries[srvRecordEntries.length - 4]);
                int port2 = Integer.parseInt(srvRecordEntries[srvRecordEntries.length - 2]);
                int weight = Integer.parseInt(srvRecordEntries[srvRecordEntries.length - 3]);
                String srvTarget = srvRecordEntries[srvRecordEntries.length - 1];
                if (srvTarget.length() > 0 && srvTarget.charAt(srvTarget.length() - 1) == '.') {
                    srvTarget = srvTarget.substring(0, srvTarget.length() - 1);
                }
                SRV srvRecord = new SRV(priority, weight, port2, srvTarget);
                res.add(srvRecord);
            }
        }
        catch (NamingException e) {
            RemoteConnectionEndpointLookupFailure.DnsLookupFailure failure = new RemoteConnectionEndpointLookupFailure.DnsLookupFailure(name, (Exception)e);
            lookupFailures.add(failure);
        }
        return res;
    }

    @Override
    public List<Exception> initialize() {
        JavaxResolver.setup();
        return null;
    }

    static {
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            dirContext = new InitialDirContext(env);
        }
        catch (NamingException e) {
            LOGGER.log(Level.SEVERE, "Could not construct InitialDirContext", e);
        }
        JavaxResolver.setup();
    }
}

