/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common.util;

import java.util.Base64;

public class Base64Url {
    public static final Base64.Encoder BASE64_URL_ENCODER_WITHOUT_PADDING = Base64.getUrlEncoder().withoutPadding();

    public static String encode(byte[] bytes) {
        return BASE64_URL_ENCODER_WITHOUT_PADDING.encodeToString(bytes);
    }

    public static byte[] decode(String s) {
        return Base64.getUrlDecoder().decode(Base64Url.encodeBase64ToBase64Url(s));
    }

    public static String encodeBase64ToBase64Url(String base64) {
        String s = base64.split("=")[0];
        s = s.replace('+', '-');
        s = s.replace('/', '_');
        return s;
    }

    @Deprecated
    public static String encodeBase64UrlToBase64(String base64Url) {
        String s = base64Url.replace('-', '+');
        s = s.replace('_', '/');
        switch (s.length() % 4) {
            case 0: {
                break;
            }
            case 2: {
                s = s + "==";
                break;
            }
            case 3: {
                s = s + "=";
                break;
            }
            default: {
                throw new RuntimeException("Illegal base64url string!");
            }
        }
        return s;
    }
}

