/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (+ ivec3(-36, 32, -88)) => ivec3(-36, 32, -88)
 * (+ ivec3(36, 32, 88)) => ivec3(36, 32, 88)
 * (+ ivec3(59, 77, 68)) => ivec3(59, 77, 68)
 */
#version 120

void main()
{
  float[all(equal((+ ivec3(-36, 32, -88)), ivec3(-36, 32, -88))) ? 1 : -1] array0;
  float[all(equal((+ ivec3(36, 32, 88)), ivec3(36, 32, 88))) ? 1 : -1] array1;
  float[all(equal((+ ivec3(59, 77, 68)), ivec3(59, 77, 68))) ? 1 : -1] array2;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length());
}
