/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.util;

import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;

public class StringUtils {
    public static String join(String delimiter, String ... strings) {
        if (strings == null || strings.length == 0) {
            return null;
        }
        StringBuilder result = new StringBuilder(strings[0]);
        for (int i = 1; i < strings.length; ++i) {
            result.append(delimiter);
            result.append(strings[i]);
        }
        return result.toString();
    }

    public static String join(String delimiter, Collection<String> strings) {
        return StringUtils.join(delimiter, strings.toArray(new String[0]));
    }

    public static String chop(String str, int maxLength) {
        return str.length() > maxLength ? str.substring(0, maxLength) : str;
    }

    public static String firstPart(String s, String delim) {
        int idx = s == null ? -1 : s.indexOf(delim);
        return idx >= 0 ? s.substring(0, idx) : s;
    }

    public static String lastPart(String s, String delim) {
        int idx = s == null ? -1 : s.lastIndexOf(delim);
        return idx >= 0 ? s.substring(idx + delim.length(), s.length()) : s;
    }

    public static String getEnumKey(Enum<?> value) {
        String base = StringUtils.downCase(value.toString());
        int len = base.length();
        StringBuilder sb = new StringBuilder(len);
        int from = 0;
        while (true) {
            int idx;
            if ((idx = base.indexOf(95, from)) < 0) {
                sb.append(base.substring(from));
                break;
            }
            sb.append(base.substring(from, idx));
            from = idx + 1;
            if (from >= len) break;
            char ch = base.charAt(from);
            if (!Character.isLetter(ch)) continue;
            sb.append(Character.toUpperCase(ch));
            ++from;
        }
        return sb.toString();
    }

    public static int getBreakingPoint(String string) {
        return StringUtils.getBreakingPoint(string, " ");
    }

    private static int getBreakingPoint(String string, String delim) {
        int center = string.length() / 2;
        for (int offset = 0; offset < center; ++offset) {
            if (delim.indexOf(string.charAt(center + offset)) >= 0) {
                return center + offset;
            }
            if (delim.indexOf(string.charAt(center - offset)) < 0) continue;
            return center - offset;
        }
        return -1;
    }

    public static List<String> splitText(String text, String delim, FontMetrics fontMetrics, int width) {
        ArrayList<String> result = new ArrayList<String>();
        int len = text.length();
        int i = 0;
        String top = "";
        Character d = null;
        while (true) {
            String t;
            if (i < len && delim.indexOf(text.charAt(i)) >= 0) {
                ++i;
                continue;
            }
            if (i >= len) break;
            int start = i;
            while (i < len && delim.indexOf(text.charAt(i)) < 0) {
                ++i;
            }
            String s = text.substring(start, i);
            String string = t = top.isEmpty() ? s : top + d + s;
            if (fontMetrics.stringWidth(t) > width) {
                if (top.isEmpty()) {
                    result.add(s);
                } else {
                    result.add(top);
                    top = s;
                }
            } else {
                top = t;
            }
            if (i >= len) {
                if (top.isEmpty()) break;
                result.add(top);
                break;
            }
            d = Character.valueOf(text.charAt(i));
        }
        return result;
    }

    public static String capitalize(String s) {
        return StringUtils.capitalize(s, Locale.US);
    }

    public static String capitalize(String s, Locale locale) {
        return s == null || s.length() == 0 ? s : StringUtils.upCase(s.substring(0, 1), locale) + s.substring(1);
    }

    public static String downCase(String s) {
        return StringUtils.downCase(s, Locale.US);
    }

    private static String downCase(String s, Locale locale) {
        return s == null || s.length() == 0 ? s : s.toLowerCase(locale);
    }

    public static String upCase(String s) {
        return StringUtils.upCase(s, Locale.US);
    }

    private static String upCase(String s, Locale locale) {
        return s == null || s.length() == 0 ? s : s.toUpperCase(locale);
    }
}

